/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.model.api.BPELElementsBuilder;
import org.netbeans.modules.bpel.model.api.BaseCorrelation;
import org.netbeans.modules.bpel.model.api.BaseScope;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Correlation;
import org.netbeans.modules.bpel.model.api.CorrelationContainer;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.CorrelationSetContainer;
import org.netbeans.modules.bpel.model.api.CorrelationsHolder;
import org.netbeans.modules.bpel.model.api.EventHandlers;
import org.netbeans.modules.bpel.model.api.Invoke;
import org.netbeans.modules.bpel.model.api.OnEvent;
import org.netbeans.modules.bpel.model.api.OnMessage;
import org.netbeans.modules.bpel.model.api.PatternedCorrelation;
import org.netbeans.modules.bpel.model.api.PatternedCorrelationContainer;
import org.netbeans.modules.bpel.model.api.Pick;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Receive;
import org.netbeans.modules.bpel.model.api.Reply;
import org.netbeans.modules.bpel.model.api.Requester;
import org.netbeans.modules.bpel.model.api.Responder;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.BpelReferenceable;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.Initiate;
import org.netbeans.modules.bpel.model.api.support.Pattern;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.properties.Util;
import org.netbeans.modules.bpel.properties.editors.CommonUtils;
import org.netbeans.modules.bpel.properties.editors.CorrelationWizardWSDLWrapper;
import org.netbeans.modules.bpel.properties.editors.TypesCompatibilityValidator;
import org.netbeans.modules.bpel.properties.editors.TypesCompatibilityValidatorImpl;
import org.netbeans.modules.bpel.properties.editors.WizardConstants;
import org.netbeans.modules.bpel.properties.editors.WizardProperties;
import org.netbeans.modules.bpel.properties.editors.WizardUtils;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.DefaultMapperContext;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.MapperContext;
import org.netbeans.modules.soa.mappercore.RightTree;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphSubset;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.TargetPin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.soa.ui.UserNotification;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.ComplexType;
import org.netbeans.modules.xml.schema.model.Element;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SimpleType;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.RequestResponseOperation;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.BPELQName;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.CorrelationProperty;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PropertyAlias;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Query;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.validation.ValidationUtil;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xpath.ext.schema.FindAllChildrenSchemaVisitor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefineCorrelationWizard
implements WizardProperties {
    private static final long serialVersionUID = 1L;
    private static final Dimension LEFT_DIMENSION_VALUE = new Dimension(200, 450);
    private static final Dimension PANEL_DIMENSION_VALUE = new Dimension(600, 450);
    private static final String[] WIZARD_STEP_NAMES = new String[]{NbBundle.getMessage(DefineCorrelationWizard.class, (String)"LBL_Wizard_Step_Select_Messaging_Activity"), NbBundle.getMessage(DefineCorrelationWizard.class, (String)"LBL_Wizard_Step_Define_Correlation")};
    private static Graph TMP_FAKE_GRAPH;
    private static final String IMAGE_FOLDER_NAME = "org/netbeans/modules/bpel/editors/api/nodes/images/";
    private static final String IMAGE_FILE_EXT = ".png";
    private static final String SIMPLE_TYPE_NAME_PATTERN;
    private static final String JBUTTON_TEXT_NEXT = "Next";
    private static final String JBUTTON_TEXT_FINISH = "Finish";
    private Map<Class, Icon> mapTreeNodeIcons;
    private WizardDescriptor wizardDescriptor;
    private BpelEntity correlatedActivity;
    private WizardDescriptor.Panel[] wizardPanels;
    private JButton buttonNext;
    private JButton buttonFinish;

    public DefineCorrelationWizard(BpelNode bpelNode) {
        Object t = bpelNode.getReference();
        if (t instanceof BpelEntity) {
            this.correlatedActivity = (BpelEntity)t;
        }
        this.mapTreeNodeIcons = this.createTreeNodeIconsMap();
        this.wizardPanels = this.getWizardPanelList().toArray(new WizardDescriptor.Panel[0]);
        this.wizardDescriptor = new WizardDescriptor(this.wizardPanels);
        this.wizardDescriptor.putProperty("WizardPanel_autoWizardStyle", (Object)true);
        this.wizardDescriptor.putProperty("WizardPanel_contentDisplayed", (Object)true);
        this.wizardDescriptor.putProperty("WizardPanel_contentNumbered", (Object)true);
        this.wizardDescriptor.putProperty("WizardPanel_helpDisplayed", (Object)false);
        this.wizardDescriptor.putProperty("WizardPanel_leftDimension", (Object)LEFT_DIMENSION_VALUE);
        this.wizardDescriptor.putProperty("WizardPanel_contentData", (Object)WIZARD_STEP_NAMES);
        this.wizardDescriptor.setTitleFormat(new MessageFormat(NbBundle.getMessage(DefineCorrelationWizard.class, (String)"LBL_DefineCorrelation_Wizard_Title_Format")));
        this.wizardDescriptor.setTitle(NbBundle.getMessage(DefineCorrelationWizard.class, (String)"LBL_DefineCorrelation_Wizard_Title"));
    }

    public void showWizardDialog() {
        String string = WizardUtils.validateActivity(this.correlatedActivity);
        if (string != null) {
            UserNotification.showMessage((String)string);
            return;
        }
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DefineCorrelationWizard.class, (String)"A11_DESCRIPTOR_DefineCorrelationWizardDialog"));
        dialog.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DefineCorrelationWizard.class, (String)"A11_NAME_DefineCorrelationWizardDialog"));
        this.findNextAndFinishButtons(dialog);
        dialog.setPreferredSize(new Dimension(DefineCorrelationWizard.LEFT_DIMENSION_VALUE.width + DefineCorrelationWizard.PANEL_DIMENSION_VALUE.width + 50, DefineCorrelationWizard.PANEL_DIMENSION_VALUE.height));
        dialog.pack();
        this.wizardPanels[0].isValid();
        dialog.setVisible(true);
    }

    private List<WizardDescriptor.Panel> getWizardPanelList() {
        ArrayList<WizardDescriptor.Panel> arrayList = new ArrayList<WizardDescriptor.Panel>(WIZARD_STEP_NAMES.length);
        arrayList.add((WizardDescriptor.Panel)new WizardSelectMessagingActivityPanel());
        arrayList.add((WizardDescriptor.Panel)new WizardDefineCorrelationPanel());
        for (int i = 0; i < arrayList.size(); ++i) {
            ((WizardAbstractPanel)arrayList.get(i)).setPanelNameIndex(WIZARD_STEP_NAMES[i], i);
        }
        return arrayList;
    }

    protected BpelEntity getTopParentEntity(BpelEntity bpelEntity) {
        BpelContainer bpelContainer;
        for (bpelContainer = bpelEntity.getParent(); bpelContainer != null && !(bpelContainer instanceof Scope) && !(bpelContainer instanceof Process); bpelContainer = bpelContainer.getParent()) {
            if (bpelContainer != null) continue;
            return null;
        }
        return bpelContainer;
    }

    private Map<Class, Icon> createTreeNodeIconsMap() {
        if (this.mapTreeNodeIcons != null) {
            return this.mapTreeNodeIcons;
        }
        HashMap<Class, Icon> hashMap = new HashMap<Class, Icon>(9);
        String string = "org/netbeans/modules/bpel/editors/api/nodes/images/UNKNOWN_TYPE.png";
        hashMap.put(Object.class, new ImageIcon(Utilities.loadImage((String)string)));
        string = "org/netbeans/modules/bpel/editors/api/nodes/images/RECEIVE.png";
        hashMap.put(Receive.class, new ImageIcon(Utilities.loadImage((String)string)));
        string = "org/netbeans/modules/bpel/editors/api/nodes/images/REPLY.png";
        hashMap.put(Reply.class, new ImageIcon(Utilities.loadImage((String)string)));
        string = "org/netbeans/modules/bpel/editors/api/nodes/images/INVOKE.png";
        hashMap.put(Invoke.class, new ImageIcon(Utilities.loadImage((String)string)));
        string = "org/netbeans/modules/bpel/editors/api/nodes/images/MESSAGE_TYPE.png";
        hashMap.put(Message.class, new ImageIcon(Utilities.loadImage((String)string)));
        string = "org/netbeans/modules/bpel/editors/api/nodes/images/MESSAGE_PART.png";
        hashMap.put(Part.class, new ImageIcon(Utilities.loadImage((String)string)));
        string = "org/netbeans/modules/bpel/editors/api/nodes/images/ON_EVENT.png";
        hashMap.put(OnEvent.class, new ImageIcon(Utilities.loadImage((String)string)));
        string = "org/netbeans/modules/bpel/editors/api/nodes/images/MESSAGE_HANDLER.png";
        hashMap.put(OnMessage.class, new ImageIcon(Utilities.loadImage((String)string)));
        string = "org/netbeans/modules/bpel/editors/api/nodes/images/GLOBAL_ELEMENT.png";
        hashMap.put(Element.class, new ImageIcon(Utilities.loadImage((String)string)));
        string = "org/netbeans/modules/bpel/editors/api/nodes/images/ATTRIBUTE.png";
        hashMap.put(Attribute.class, new ImageIcon(Utilities.loadImage((String)string)));
        string = "org/netbeans/modules/bpel/editors/api/nodes/images/GLOBAL_COMPLEX_TYPE.png";
        hashMap.put(ComplexType.class, new ImageIcon(Utilities.loadImage((String)string)));
        string = "org/netbeans/modules/bpel/editors/api/nodes/images/GLOBAL_SIMPLE_TYPE.png";
        hashMap.put(SimpleType.class, new ImageIcon(Utilities.loadImage((String)string)));
        return hashMap;
    }

    private void findNextAndFinishButtons(Container container) {
        java.awt.Component[] componentArray;
        for (java.awt.Component component : componentArray = container.getComponents()) {
            if (component instanceof Container) {
                this.findNextAndFinishButtons((Container)component);
                if (this.buttonNext != null && this.buttonFinish != null) {
                    return;
                }
            }
            if (component instanceof JButton) {
                if (((JButton)component).getText().startsWith(JBUTTON_TEXT_NEXT)) {
                    this.buttonNext = (JButton)component;
                } else if (((JButton)component).getText().startsWith(JBUTTON_TEXT_FINISH)) {
                    this.buttonFinish = (JButton)component;
                }
            }
            if (this.buttonNext == null || this.buttonFinish == null) continue;
            return;
        }
    }

    static {
        SIMPLE_TYPE_NAME_PATTERN = NbBundle.getMessage(DefineCorrelationWizard.class, (String)"LBL_Mapper_Tree_SimpleType_Name_Pattern");
    }

    public class WizardCorrelationConfigurationPanel
    extends WizardAbstractPanel {
        public boolean isValid() {
            boolean bl = false;
            if (DefineCorrelationWizard.this.buttonFinish != null) {
                DefineCorrelationWizard.this.buttonFinish.setEnabled(bl);
            }
            return bl;
        }

        public void validate() throws WizardValidationException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WizardDefineCorrelationPanel
    extends WizardAbstractPanel
    implements WizardConstants {
        private final String ACTION_KEY_DELETE = "ACTION_KEY_DELETE";
        private Mapper correlationMapper;

        public WizardDefineCorrelationPanel() {
            this.ACTION_KEY_DELETE = "ACTION_KEY_DELETE";
        }

        public void buildCorrelationMapper(BpelEntity bpelEntity, BpelEntity bpelEntity2) {
            Object object;
            boolean bl = this.correlationMapper == null;
            CorrelationMapperTreeModel correlationMapperTreeModel = (CorrelationMapperTreeModel)(this.correlationMapper == null ? null : this.correlationMapper.getModel().getLeftTreeModel());
            CorrelationMapperTreeModel correlationMapperTreeModel2 = (CorrelationMapperTreeModel)(this.correlationMapper == null ? null : ((CorrelationMapperModel)this.correlationMapper.getModel()).getRightTreeModel());
            if (bpelEntity != null) {
                correlationMapperTreeModel = new CorrelationMapperTreeModel();
                object = this.buildCorrelationTree(bpelEntity, NbBundle.getMessage(WizardDefineCorrelationPanel.class, (String)(bpelEntity instanceof OnMessage ? "LBL_Mapper_Tree_OnMessage_Name_Pattern" : (bpelEntity instanceof OnEvent ? "LBL_Mapper_Tree_OnEvent_Name_Pattern" : "LBL_Mapper_Tree_Top_Node_Name_Pattern"))));
                correlationMapperTreeModel.buildCorrelationMapperTree((CorrelationMapperTreeNode)object);
                bl = true;
            }
            if (bpelEntity2 != null) {
                correlationMapperTreeModel2 = new CorrelationMapperTreeModel();
                object = this.buildCorrelationTree(bpelEntity2, NbBundle.getMessage(WizardDefineCorrelationPanel.class, (String)(bpelEntity2 instanceof OnMessage ? "LBL_Mapper_Tree_OnMessage_Name_Pattern" : (bpelEntity2 instanceof OnEvent ? "LBL_Mapper_Tree_OnEvent_Name_Pattern" : "LBL_Mapper_Tree_Top_Node_Name_Pattern"))));
                correlationMapperTreeModel2.buildCorrelationMapperTree((CorrelationMapperTreeNode)object);
                bl = true;
            }
            object = null;
            if (bl) {
                object = new CorrelationMapperModel(correlationMapperTreeModel, correlationMapperTreeModel2);
            }
            if (this.correlationMapper == null) {
                this.wizardPanel.setLayout(new BorderLayout());
                EtchedBorder etchedBorder = (EtchedBorder)BorderFactory.createEtchedBorder(1, Color.BLACK, Color.WHITE);
                this.wizardPanel.setBorder(etchedBorder);
                this.correlationMapper = new Mapper((MapperModel)object);
                this.correlationMapper.setContext((MapperContext)new CorrelationMapperContext());
                this.defineCorrelationMapperKeyBindings();
                this.wizardPanel.add((java.awt.Component)this.correlationMapper);
                this.wizardPanel.revalidate();
            } else if (bl) {
                this.correlationMapper.setModel((MapperModel)object);
            }
            this.setAccessibilityInfo(this.correlationMapper);
            ((CorrelationMapperModel)object).expandTree(((CorrelationMapperModel)object).getLeftTreeModel());
            ((CorrelationMapperModel)object).expandTree(((CorrelationMapperModel)object).getRightTreeModel());
        }

        private void setAccessibilityInfo(Mapper mapper) {
            LeftTree leftTree = mapper.getLeftTree();
            leftTree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DefineCorrelationWizard.class, (String)"A11_DESCRIPTOR_MapperLeftTree"));
            leftTree.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DefineCorrelationWizard.class, (String)"A11_NAME_MapperLeftTree"));
            Canvas canvas = mapper.getCanvas();
            canvas.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DefineCorrelationWizard.class, (String)"A11_DESCRIPTOR_MapperCanvas"));
            canvas.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DefineCorrelationWizard.class, (String)"A11_NAME_MapperCanvas"));
            RightTree rightTree = mapper.getRightTree();
            rightTree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DefineCorrelationWizard.class, (String)"A11_DESCRIPTOR_MapperRightTree"));
            rightTree.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DefineCorrelationWizard.class, (String)"A11_NAME_MapperRightTree"));
        }

        private CorrelationMapperTreeNode buildCorrelationTree(BpelEntity bpelEntity, String string) {
            CorrelationMapperTreeNode correlationMapperTreeNode = new CorrelationMapperTreeNode(bpelEntity, string);
            correlationMapperTreeNode = this.buildCorrelationTree(bpelEntity, correlationMapperTreeNode);
            return correlationMapperTreeNode;
        }

        private CorrelationMapperTreeNode buildCorrelationTree(BpelEntity bpelEntity, CorrelationMapperTreeNode correlationMapperTreeNode) {
            Operation operation = WizardUtils.getBpelEntityOperation(bpelEntity);
            this.handleOperations(bpelEntity, correlationMapperTreeNode, operation);
            return correlationMapperTreeNode;
        }

        private void handleOperations(BpelEntity bpelEntity, CorrelationMapperTreeNode correlationMapperTreeNode, Operation operation) {
            Output output;
            Message message = null;
            Message message2 = null;
            ArrayList<Message> arrayList = new ArrayList<Message>();
            if (bpelEntity instanceof Requester) {
                try {
                    output = operation.getOutput();
                    message = (Message)output.getMessage().get();
                    arrayList.add(message);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bpelEntity instanceof Responder) {
                try {
                    output = operation.getInput();
                    message2 = (Message)output.getMessage().get();
                    arrayList.add(message2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.handleMessages(correlationMapperTreeNode, arrayList);
        }

        private void handleMessages(CorrelationMapperTreeNode correlationMapperTreeNode, Collection<Message> collection) {
            for (Message message : collection) {
                Collection collection2 = message.getParts();
                if (collection2.isEmpty()) continue;
                CorrelationMapperTreeNode correlationMapperTreeNode2 = new CorrelationMapperTreeNode(message, null);
                for (Part part : collection2) {
                    correlationMapperTreeNode2.add(this.handlePart(part));
                }
                correlationMapperTreeNode.add(correlationMapperTreeNode2);
            }
        }

        private CorrelationMapperTreeNode handlePart(Part part) {
            CorrelationMapperTreeNode correlationMapperTreeNode = new CorrelationMapperTreeNode(part, null);
            NamedComponentReference namedComponentReference = part.getElement();
            if (namedComponentReference != null) {
                GlobalElement globalElement = (GlobalElement)namedComponentReference.get();
                this.addSchemaComponentNode(correlationMapperTreeNode, (SchemaComponent)globalElement, new FindAllChildrenSchemaVisitor(true, true));
            } else {
                NamedComponentReference namedComponentReference2 = part.getType();
                if (namedComponentReference2 != null) {
                    GlobalType globalType = (GlobalType)namedComponentReference2.get();
                    this.addSchemaComponentNode(correlationMapperTreeNode, (SchemaComponent)globalType, new FindAllChildrenSchemaVisitor(true, true));
                }
            }
            return correlationMapperTreeNode;
        }

        private void addSchemaComponentNode(CorrelationMapperTreeNode correlationMapperTreeNode, SchemaComponent schemaComponent, FindAllChildrenSchemaVisitor findAllChildrenSchemaVisitor) {
            String string = schemaComponent instanceof SimpleType ? SIMPLE_TYPE_NAME_PATTERN : null;
            CorrelationMapperTreeNode correlationMapperTreeNode2 = new CorrelationMapperTreeNode(schemaComponent, string);
            List list = null;
            if (!(schemaComponent instanceof SimpleType)) {
                findAllChildrenSchemaVisitor.lookForSubcomponents(schemaComponent);
                list = findAllChildrenSchemaVisitor.getFound();
                for (SchemaComponent schemaComponent2 : list) {
                    this.addSchemaComponentNode(correlationMapperTreeNode2, schemaComponent2, new FindAllChildrenSchemaVisitor(true, true));
                }
            }
            if (schemaComponent instanceof Element && (list == null || list.isEmpty()) && this.isElementComplexType(schemaComponent)) {
                return;
            }
            if (schemaComponent instanceof Attribute && (list == null || list.isEmpty()) && this.isAttributeUnknownType(schemaComponent)) {
                return;
            }
            correlationMapperTreeNode.add(correlationMapperTreeNode2);
        }

        private boolean isElementComplexType(SchemaComponent schemaComponent) {
            if (!(schemaComponent instanceof Element)) {
                return false;
            }
            NamedComponentReference<? extends GlobalType> namedComponentReference = WizardUtils.getSchemaComponentTypeRef(schemaComponent);
            return namedComponentReference != null && namedComponentReference.get() instanceof ComplexType;
        }

        private boolean isAttributeUnknownType(SchemaComponent schemaComponent) {
            if (!(schemaComponent instanceof Attribute)) {
                return false;
            }
            return WizardUtils.getSchemaComponentTypeName(schemaComponent) == null;
        }

        private void defineCorrelationMapperKeyBindings() {
            if (this.correlationMapper == null) {
                return;
            }
            InputMap inputMap = this.correlationMapper.getInputMap(1);
            inputMap.put(KeyStroke.getKeyStroke(127, 0), "ACTION_KEY_DELETE");
            ActionMap actionMap = this.correlationMapper.getActionMap();
            actionMap.put("ACTION_KEY_DELETE", new ActionDeleteKey());
        }

        @Override
        public boolean isValid() {
            Graph graph;
            boolean bl = false;
            Map<TreePath, Graph> map = ((CorrelationMapperModel)this.correlationMapper.getModel()).getMapTreePathGraphs();
            Iterator<Graph> iterator = map.values().iterator();
            while (iterator.hasNext() && !(bl = (graph = iterator.next()).hasIngoingLinks())) {
            }
            DefineCorrelationWizard.this.wizardDescriptor.putProperty("WizardPanel_errorMessage", bl ? null : NbBundle.getMessage(WizardDefineCorrelationPanel.class, (String)"LBL_ErrMsg_No_Links_For_Correlation"));
            if (DefineCorrelationWizard.this.buttonFinish != null) {
                DefineCorrelationWizard.this.buttonFinish.setEnabled(bl);
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void validate() throws WizardValidationException {
            try {
                this.makeCorrelations();
            }
            finally {
                CorrelationWizardWSDLWrapper.closeInstance();
            }
        }

        private void makeCorrelations() throws WizardValidationException {
            CorrelationMapperModel correlationMapperModel = (CorrelationMapperModel)this.correlationMapper.getModel();
            CorrelationMapperTreeModel correlationMapperTreeModel = (CorrelationMapperTreeModel)correlationMapperModel.getLeftTreeModel();
            CorrelationMapperTreeModel correlationMapperTreeModel2 = (CorrelationMapperTreeModel)correlationMapperModel.getRightTreeModel();
            List<CorrelationLinker> list = this.getCorrelationLinkers(correlationMapperModel, correlationMapperTreeModel, correlationMapperTreeModel2);
            WSDLModel wSDLModel = null;
            while (!list.isEmpty()) {
                Object object;
                if (wSDLModel == null) {
                    object = CorrelationWizardWSDLWrapper.getInstance(DefineCorrelationWizard.this.correlatedActivity.getBpelModel());
                    wSDLModel = ((CorrelationWizardWSDLWrapper)object).getWsdlModel();
                    ((CorrelationWizardWSDLWrapper)object).importIntoBpelModel();
                }
                if ((object = this.getSublistEqualCorrelationLinkers(list)).isEmpty()) break;
                list.removeAll((Collection<?>)object);
                this.createCorrelationPropertiesAndPropertyAliases((List<CorrelationLinker>)object, wSDLModel);
                CorrelationSet correlationSet = this.createCorrelationSet((List<CorrelationLinker>)object);
                ((CorrelationLinker)object.get(0)).createActivityCorrelation(correlationSet);
            }
        }

        private CorrelationSet createCorrelationSet(List<CorrelationLinker> list) {
            if (list == null || list.isEmpty()) {
                return null;
            }
            BpelModel bpelModel = DefineCorrelationWizard.this.correlatedActivity.getBpelModel();
            Process process = bpelModel.getProcess();
            if (process == null) {
                return null;
            }
            String string = this.getUniqueCorrelationSetName(list.get(0), (BaseScope)process);
            BPELElementsBuilder bPELElementsBuilder = bpelModel.getBuilder();
            CorrelationSet correlationSet = bPELElementsBuilder.createCorrelationSet();
            try {
                correlationSet.setName(string);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
            ArrayList<WSDLReference> arrayList = new ArrayList<WSDLReference>();
            for (CorrelationLinker correlationLinker : list) {
                WSDLReference wSDLReference = correlationSet.createWSDLReference((ReferenceableWSDLComponent)correlationLinker.getCorrelationProperty(), CorrelationProperty.class);
                if (wSDLReference == null) continue;
                arrayList.add(wSDLReference);
            }
            if (!arrayList.isEmpty()) {
                correlationSet.setProperties(arrayList);
            }
            CorrelationSetContainer correlationSetContainer = process.getCorrelationSetContainer();
            this.addCorrelationSet(bpelModel, (BaseScope)process, correlationSetContainer, correlationSet);
            return correlationSet;
        }

        private void addCorrelationSet(final BpelModel bpelModel, final BaseScope baseScope, final CorrelationSetContainer correlationSetContainer, final CorrelationSet correlationSet) {
            try {
                bpelModel.invoke((Callable)new Callable<CorrelationSet>(){

                    @Override
                    public CorrelationSet call() throws Exception {
                        BPELElementsBuilder bPELElementsBuilder = bpelModel.getBuilder();
                        CorrelationSetContainer correlationSetContainer2 = correlationSetContainer;
                        if (correlationSetContainer2 == null) {
                            correlationSetContainer2 = bPELElementsBuilder.createCorrelationSetContainer();
                            baseScope.setCorrelationSetContainer(correlationSetContainer2);
                            correlationSetContainer2 = baseScope.getCorrelationSetContainer();
                        }
                        correlationSetContainer2.addCorrelationSet(correlationSet);
                        return correlationSet;
                    }
                }, (Object)correlationSet);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }

        private String getUniqueCorrelationSetName(CorrelationLinker correlationLinker, BaseScope baseScope) {
            BpelEntity bpelEntity = correlationLinker.getSource().getActivity();
            BpelEntity bpelEntity2 = correlationLinker.getTarget().getActivity();
            String string = "wzrd_set_" + WizardUtils.getCorrelationSetBpelEntityName(bpelEntity) + "_" + WizardUtils.getCorrelationSetBpelEntityName(bpelEntity2);
            CorrelationSetContainer correlationSetContainer = baseScope.getCorrelationSetContainer();
            if (correlationSetContainer == null) {
                return string;
            }
            CorrelationSet[] correlationSetArray = correlationSetContainer.getCorrelationSets();
            if (correlationSetArray != null && correlationSetArray.length > 0) {
                int n = 0;
                String string2 = string;
                while (++n < 10000) {
                    if (this.containsCorrelationSetName(correlationSetArray, string2)) {
                        string2 = string + "_" + n;
                        continue;
                    }
                    return string2;
                }
                if (n >= 10000) {
                    return null;
                }
            }
            return string;
        }

        private boolean containsCorrelationSetName(CorrelationSet[] correlationSetArray, String string) {
            for (CorrelationSet correlationSet : correlationSetArray) {
                String string2 = correlationSet.getName();
                if (!ValidationUtil.ignoreNamespace((String)string2).equals(string)) continue;
                return true;
            }
            return false;
        }

        private void createCorrelationPropertiesAndPropertyAliases(List<CorrelationLinker> list, WSDLModel wSDLModel) throws WizardValidationException {
            for (CorrelationLinker correlationLinker : list) {
                correlationLinker.createCorrelationProperty(wSDLModel);
                correlationLinker.createPropertyAlias(wSDLModel);
            }
        }

        private List<CorrelationLinker> getSublistEqualCorrelationLinkers(List<CorrelationLinker> list) {
            ArrayList<CorrelationLinker> arrayList = new ArrayList<CorrelationLinker>();
            CorrelationLinker correlationLinker = null;
            for (CorrelationLinker correlationLinker2 : list) {
                if (correlationLinker == null) {
                    correlationLinker = correlationLinker2;
                    arrayList.add(correlationLinker2);
                    continue;
                }
                if (!correlationLinker2.equals(correlationLinker)) continue;
                arrayList.add(correlationLinker2);
            }
            return arrayList;
        }

        private List<CorrelationLinker> getCorrelationLinkers(CorrelationMapperModel correlationMapperModel, CorrelationMapperTreeModel correlationMapperTreeModel, CorrelationMapperTreeModel correlationMapperTreeModel2) throws WizardValidationException {
            ArrayList<CorrelationLinker> arrayList = new ArrayList<CorrelationLinker>();
            BpelEntity bpelEntity = correlationMapperTreeModel.getTopBpelEntity();
            BpelEntity bpelEntity2 = correlationMapperTreeModel2.getTopBpelEntity();
            Map<TreePath, Graph> map = correlationMapperModel.getMapTreePathGraphs();
            for (Map.Entry<TreePath, Graph> entry : map.entrySet()) {
                CorrelationDataHolder correlationDataHolder = new CorrelationDataHolder();
                correlationDataHolder.setActivity(bpelEntity2);
                correlationDataHolder.extractDataFromTreePath(entry.getKey());
                Graph graph = entry.getValue();
                List list = graph.getLinks();
                for (Link link : list) {
                    CorrelationDataHolder correlationDataHolder2 = new CorrelationDataHolder();
                    correlationDataHolder2.setActivity(bpelEntity);
                    correlationDataHolder2.extractDataFromLink(link);
                    CorrelationLinker correlationLinker = new CorrelationLinker(correlationDataHolder2, correlationDataHolder);
                    arrayList.add(correlationLinker);
                }
            }
            return arrayList;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CorrelationMapperModel
        implements MapperModel {
            private TreeModel leftTreeModel;
            private TreeModel rightTreeModel;
            private Map<TreePath, Graph> mapTreePathGraphs = new HashMap<TreePath, Graph>();

            public CorrelationMapperModel(TreeModel treeModel, TreeModel treeModel2) {
                this.leftTreeModel = treeModel;
                this.rightTreeModel = treeModel2;
                TMP_FAKE_GRAPH = new Graph((MapperModel)this);
            }

            public void expandTree(TreeModel treeModel) {
                if (treeModel == null) {
                    return;
                }
                TreeNode treeNode = (TreeNode)treeModel.getRoot();
                this.expandTreeNode(treeNode, treeModel.equals(this.rightTreeModel));
            }

            private void expandTreeNode(TreeNode treeNode, boolean bl) {
                this.expandTreeNode(treeNode, bl ? 6 : 5, bl);
            }

            private void expandTreeNode(TreeNode treeNode, int n, boolean bl) {
                if (treeNode == null || n == 0) {
                    return;
                }
                TreePath treePath = new TreePath(bl ? ((CorrelationMapperTreeModel)this.rightTreeModel).getPathToRoot(treeNode) : ((CorrelationMapperTreeModel)this.leftTreeModel).getPathToRoot(treeNode));
                if (bl) {
                    WizardDefineCorrelationPanel.this.correlationMapper.expandGraphs(new ArrayList<TreePath>(Arrays.asList(treePath)));
                } else {
                    LeftTree leftTree = WizardDefineCorrelationPanel.this.correlationMapper.getLeftTree();
                    leftTree.expandPath(treePath);
                }
                int n2 = n = n == -1 ? -1 : n - 1;
                if (n == 0) {
                    return;
                }
                int n3 = treeNode.getChildCount();
                for (int i = 0; i < n3; ++i) {
                    TreeNode treeNode2 = treeNode.getChildAt(i);
                    this.expandTreeNode(treeNode2, n, bl);
                }
            }

            public boolean canConnect(TreePath treePath, SourcePin sourcePin, TargetPin targetPin, TreePath treePath2, Link link) {
                TreePath treePath3;
                if (link != null) {
                    return false;
                }
                boolean bl = false;
                CorrelationMapperTreeNode correlationMapperTreeNode = null;
                if (sourcePin != null && sourcePin instanceof TreeSourcePin) {
                    treePath3 = ((TreeSourcePin)sourcePin).getTreePath();
                    correlationMapperTreeNode = (CorrelationMapperTreeNode)treePath3.getLastPathComponent();
                    bl = correlationMapperTreeNode.isLeaf();
                    bl &= !correlationMapperTreeNode.getUserObject().equals(((CorrelationMapperTreeModel)this.leftTreeModel).getTopBpelEntity());
                    bl &= !this.isLeftTreePathLinked(treePath3);
                }
                correlationMapperTreeNode = (CorrelationMapperTreeNode)treePath.getLastPathComponent();
                bl &= correlationMapperTreeNode.isLeaf();
                bl &= !correlationMapperTreeNode.getUserObject().equals(((CorrelationMapperTreeModel)this.rightTreeModel).getTopBpelEntity());
                if (targetPin instanceof Graph && ((treePath3 = (Graph)targetPin).hasIngoingLinks() || treePath3.hasOutgoingLinks())) {
                    bl = false;
                }
                return bl;
            }

            public void connect(TreePath treePath, SourcePin sourcePin, TargetPin targetPin, TreePath treePath2, Link link) {
                if (link != null) {
                    return;
                }
                Graph graph = this.getGraph(treePath);
                if (graph == null || graph == TMP_FAKE_GRAPH) {
                    graph = this.createNewGraph(treePath);
                }
                Link link2 = new Link(sourcePin, targetPin);
                graph.addLink(link2);
                ((CorrelationMapperTreeModel)this.rightTreeModel).fireTreeChanged(this, treePath);
                this.postConnectLinkValidation(sourcePin, treePath);
            }

            public Map<TreePath, Graph> getMapTreePathGraphs() {
                return this.mapTreePathGraphs;
            }

            protected Graph createNewGraph(TreePath treePath) {
                Graph graph = new Graph((MapperModel)this);
                this.mapTreePathGraphs.put(treePath, graph);
                ((CorrelationMapperTreeModel)this.rightTreeModel).fireTreeChanged(this, treePath);
                return graph;
            }

            protected void deleteLink(Link link) {
                if (link == null) {
                    return;
                }
                SourcePin sourcePin = link.getSource();
                if (sourcePin == null || !(sourcePin instanceof TreeSourcePin)) {
                    return;
                }
                Graph graph = link.getGraph();
                if (graph == null) {
                    return;
                }
                graph.removeLink(link);
                TreePath treePath = this.getTreePathByGraph(graph);
                if (treePath == null) {
                    return;
                }
                this.mapTreePathGraphs.remove(treePath);
                ((CorrelationMapperTreeModel)this.rightTreeModel).fireTreeChanged(this, treePath);
            }

            protected void postConnectLinkValidation(SourcePin sourcePin, final TreePath treePath) {
                if (sourcePin == null || !(sourcePin instanceof TreeSourcePin) || treePath == null) {
                    return;
                }
                TreePath treePath2 = ((TreeSourcePin)sourcePin).getTreePath();
                CorrelationMapperTreeNode correlationMapperTreeNode = (CorrelationMapperTreeNode)treePath2.getLastPathComponent();
                CorrelationMapperTreeNode correlationMapperTreeNode2 = (CorrelationMapperTreeNode)treePath.getLastPathComponent();
                if (correlationMapperTreeNode == null || correlationMapperTreeNode2 == null) {
                    return;
                }
                SchemaComponent schemaComponent = (SchemaComponent)correlationMapperTreeNode.getUserObject();
                SchemaComponent schemaComponent2 = (SchemaComponent)correlationMapperTreeNode2.getUserObject();
                TypesCompatibilityValidatorImpl typesCompatibilityValidatorImpl = new TypesCompatibilityValidatorImpl(schemaComponent, schemaComponent2);
                typesCompatibilityValidatorImpl.checkSchemaComponentTypesCompatibility();
                TypesCompatibilityValidator.TypesCompatibilityResult typesCompatibilityResult = typesCompatibilityValidatorImpl.getTypesCompatibilityResult();
                if (typesCompatibilityResult != TypesCompatibilityValidator.TypesCompatibilityResult.TYPES_EQUAL) {
                    boolean bl;
                    String string = typesCompatibilityValidatorImpl.getWarningMessage();
                    boolean bl2 = bl = typesCompatibilityResult == TypesCompatibilityValidator.TypesCompatibilityResult.BASE_TYPES_UNEQUAL || typesCompatibilityResult == TypesCompatibilityValidator.TypesCompatibilityResult.SOURCE_BASE_TYPE_UNKNOWN || typesCompatibilityResult == TypesCompatibilityValidator.TypesCompatibilityResult.TARGET_BASE_TYPE_UNKNOWN;
                    if (bl) {
                        string = string + " " + NbBundle.getMessage(DefineCorrelationWizard.class, (String)"LBL_ErrMsg_Created_Mapper_Link_Deleted");
                    }
                    UserNotification.showMessage((String)string);
                    if (bl) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                Link link = (Link)CorrelationMapperModel.this.getGraph(treePath).getLinks().get(0);
                                CorrelationMapperModel.this.deleteLink(link);
                            }
                        });
                    }
                }
            }

            public TreePath getTreePathByGraph(Graph graph) {
                if (graph == null) {
                    return null;
                }
                TreePath treePath = null;
                for (Map.Entry<TreePath, Graph> entry : this.mapTreePathGraphs.entrySet()) {
                    if (!entry.getValue().equals(graph)) continue;
                    return entry.getKey();
                }
                return treePath;
            }

            public boolean isLeftTreePathLinked(TreePath treePath) {
                for (Graph graph : this.mapTreePathGraphs.values()) {
                    for (Link link : graph.getLinks()) {
                        TreePath treePath2 = ((TreeSourcePin)link.getSource()).getTreePath();
                        if (!treePath2.equals(treePath)) continue;
                        return true;
                    }
                }
                return false;
            }

            public Graph getGraph(TreePath treePath) {
                Graph graph = this.mapTreePathGraphs.get(treePath);
                return graph != null ? graph : TMP_FAKE_GRAPH;
            }

            public GraphSubset getGraphSubset(Transferable transferable) {
                return null;
            }

            public TreeModel getLeftTreeModel() {
                return this.leftTreeModel;
            }

            public TreeModel getRightTreeModel() {
                return this.rightTreeModel;
            }

            public TreeSourcePin getTreeSourcePin(TreePath treePath) {
                return new TreeSourcePin(treePath);
            }

            public boolean searchGraphsInside(TreePath treePath) {
                Object object = treePath.getLastPathComponent();
                for (TreePath treePath2 : this.mapTreePathGraphs.keySet()) {
                    while ((treePath2 = treePath2.getParentPath()) != null) {
                        Object object2 = treePath2.getLastPathComponent();
                        if (object2 != object) continue;
                        return true;
                    }
                }
                return false;
            }

            public void valueChanged(TreePath treePath, VertexItem vertexItem, Object object) {
            }

            public boolean canCopy(TreePath treePath, GraphSubset graphSubset) {
                return false;
            }

            public boolean canMove(TreePath treePath, GraphSubset graphSubset) {
                return false;
            }

            public GraphSubset copy(TreePath treePath, GraphSubset graphSubset, int n, int n2) {
                return null;
            }

            public void move(TreePath treePath, GraphSubset graphSubset, int n, int n2) {
            }

            public void addTreeModelListener(TreeModelListener treeModelListener) {
                this.rightTreeModel.addTreeModelListener(treeModelListener);
            }

            public Object getChild(Object object, int n) {
                return this.rightTreeModel.getChild(object, n);
            }

            public int getChildCount(Object object) {
                return this.rightTreeModel.getChildCount(object);
            }

            public int getIndexOfChild(Object object, Object object2) {
                return this.rightTreeModel.getIndexOfChild(object, object2);
            }

            public Object getRoot() {
                return this.rightTreeModel.getRoot();
            }

            public boolean isLeaf(Object object) {
                return this.rightTreeModel.isLeaf(object);
            }

            public void removeTreeModelListener(TreeModelListener treeModelListener) {
                this.rightTreeModel.removeTreeModelListener(treeModelListener);
            }

            public void valueForPathChanged(TreePath treePath, Object object) {
                this.rightTreeModel.valueForPathChanged(treePath, object);
            }

            public boolean canEditInplace(VertexItem vertexItem) {
                return true;
            }
        }

        private class CorrelationMapperContext
        extends DefaultMapperContext {
            private CorrelationMapperContext() {
            }

            public Icon getLeftIcon(MapperModel mapperModel, Object object, Icon icon) {
                return ((CorrelationMapperTreeNode)object).getIcon();
            }

            public Icon getRightIcon(MapperModel mapperModel, Object object, Icon icon) {
                return ((CorrelationMapperTreeNode)object).getIcon();
            }
        }

        private class CorrelationMapperTreeNode
        extends DefaultMutableTreeNode {
            private String nodeNamePattern;

            public CorrelationMapperTreeNode(Object object) {
                this(object, null);
            }

            public CorrelationMapperTreeNode(Object object, String string) {
                super(object);
                this.nodeNamePattern = string;
            }

            public String toString() {
                String string;
                String string2 = null;
                Object object = this.getUserObject();
                Object[] objectArray = new Object[]{};
                try {
                    if (object instanceof BpelEntity) {
                        if (object instanceof OnMessage || object instanceof OnEvent) {
                            return WizardUtils.getBpelEntityName((BpelEntity)object, this.nodeNamePattern);
                        }
                        string2 = WizardUtils.getBpelEntityName((BpelEntity)object);
                        objectArray = new Object[]{string2, ((BpelEntity)object).getElementType().getSimpleName()};
                    } else if (object instanceof Message) {
                        string2 = ((Message)object).getName();
                    } else if (object instanceof Part) {
                        string2 = ((Part)object).getName();
                    } else if (object instanceof Element || object instanceof Attribute) {
                        string2 = WizardUtils.getSchemaComponentName((SchemaComponent)object);
                        if (this.getChildCount() == 0 && (string = WizardUtils.getSchemaComponentTypeName((SchemaComponent)object)) != null) {
                            string2 = string2 + " " + MessageFormat.format(SIMPLE_TYPE_NAME_PATTERN, string);
                        }
                    } else if (object instanceof SimpleType || object instanceof ComplexType) {
                        string2 = WizardUtils.getSchemaComponentName((SchemaComponent)object);
                        objectArray = new Object[]{string2};
                    } else {
                        string2 = object.toString();
                    }
                }
                catch (Exception exception) {
                    string2 = object.toString();
                }
                string = this.nodeNamePattern == null ? string2 : MessageFormat.format(this.nodeNamePattern, objectArray);
                return string;
            }

            public Icon getIcon() {
                Object object = this.getUserObject();
                Class<Message> clazz = Object.class;
                if (object instanceof BpelEntity) {
                    clazz = ((BpelEntity)object).getElementType();
                } else {
                    if (object instanceof Message) {
                        clazz = Message.class;
                    }
                    if (object instanceof Part) {
                        clazz = Part.class;
                    }
                    if (object instanceof Element) {
                        clazz = Element.class;
                    }
                    if (object instanceof Attribute) {
                        clazz = Attribute.class;
                    }
                    if (object instanceof SimpleType) {
                        clazz = SimpleType.class;
                    }
                    if (object instanceof ComplexType) {
                        clazz = ComplexType.class;
                    }
                }
                Icon icon = (Icon)DefineCorrelationWizard.this.mapTreeNodeIcons.get(clazz);
                if (icon == null) {
                    icon = (Icon)DefineCorrelationWizard.this.mapTreeNodeIcons.get(Object.class);
                }
                return icon;
            }
        }

        private class CorrelationMapperTreeModel
        extends DefaultTreeModel {
            public CorrelationMapperTreeModel() {
                super(null);
            }

            public void buildCorrelationMapperTree(CorrelationMapperTreeNode correlationMapperTreeNode) {
                BpelEntity bpelEntity = (BpelEntity)correlationMapperTreeNode.getUserObject();
                CorrelationMapperTreeNode correlationMapperTreeNode2 = new CorrelationMapperTreeNode(bpelEntity.getBpelModel().getBuilder().createEmpty());
                correlationMapperTreeNode2.add(correlationMapperTreeNode);
                this.setRoot(correlationMapperTreeNode2);
            }

            public BpelEntity getTopBpelEntity() {
                CorrelationMapperTreeNode correlationMapperTreeNode = (CorrelationMapperTreeNode)((CorrelationMapperTreeNode)this.getRoot()).getChildAt(0);
                return (BpelEntity)correlationMapperTreeNode.getUserObject();
            }

            public void fireTreeChanged(Object object, TreePath treePath) {
                Object[] objectArray = this.listenerList.getListenerList();
                TreeModelEvent treeModelEvent = null;
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != TreeModelListener.class) continue;
                    if (treeModelEvent == null) {
                        TreePath treePath2 = treePath.getParentPath();
                        if (treePath2 != null) {
                            Object object2 = treePath.getLastPathComponent();
                            ((CorrelationMapperTreeNode)object2).setUserObject(((CorrelationMapperTreeNode)object2).getUserObject());
                            int n = this.getIndexOfChild(treePath2.getLastPathComponent(), object2);
                            treeModelEvent = new TreeModelEvent(object, treePath2, new int[]{n}, new Object[]{object2});
                        } else {
                            treeModelEvent = new TreeModelEvent(object, treePath, new int[0], new Object[0]);
                        }
                    }
                    ((TreeModelListener)objectArray[i + 1]).treeNodesChanged(treeModelEvent);
                }
                WizardDefineCorrelationPanel.this.isValid();
            }
        }

        private class ActionDeleteKey
        extends AbstractAction {
            private ActionDeleteKey() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                List list = WizardDefineCorrelationPanel.this.correlationMapper.getSelectionModel().getSelectedLinks();
                if (list != null && !list.isEmpty()) {
                    CorrelationMapperModel correlationMapperModel = (CorrelationMapperModel)WizardDefineCorrelationPanel.this.correlationMapper.getModel();
                    for (Link link : list) {
                        correlationMapperModel.deleteLink(link);
                    }
                }
            }
        }

        private class CorrelationDataHolder
        implements WizardConstants {
            private BpelEntity activity;
            private Message message;
            private Part part;
            private CorrelationMapperTreeNode mapperTreeNode;

            private CorrelationDataHolder() {
            }

            public WSDLModel getWSDLModel() {
                PortType portType = WizardUtils.getBpelEntityPortType(this.activity);
                return portType == null ? null : portType.getModel();
            }

            public void createActivityCorrelation(CorrelationSet correlationSet) {
                BpelModel bpelModel = this.activity.getBpelModel();
                BaseCorrelation baseCorrelation = this.createCorrelation(bpelModel, correlationSet);
                PatternedCorrelationContainer patternedCorrelationContainer = null;
                if (this.activity instanceof Invoke) {
                    patternedCorrelationContainer = ((Invoke)this.activity).getPatternedCorrelationContainer();
                } else if (this.activity instanceof Receive || this.activity instanceof Reply || this.activity instanceof OnMessage || this.activity instanceof OnEvent) {
                    patternedCorrelationContainer = ((CorrelationsHolder)this.activity).getCorrelationContainer();
                }
                this.addActivityCorrelation(bpelModel, (BpelContainer)patternedCorrelationContainer, baseCorrelation);
            }

            private void addActivityCorrelation(final BpelModel bpelModel, final BpelContainer bpelContainer, final BaseCorrelation baseCorrelation) {
                try {
                    bpelModel.invoke((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            BpelContainer bpelContainer2 = bpelContainer;
                            if (bpelContainer2 == null) {
                                BPELElementsBuilder bPELElementsBuilder = bpelModel.getBuilder();
                                Object object = bpelContainer2 = CorrelationDataHolder.this.activity instanceof Invoke ? bPELElementsBuilder.createPatternedCorrelationContainer() : bPELElementsBuilder.createCorrelationContainer();
                                if (CorrelationDataHolder.this.activity instanceof Invoke) {
                                    ((Invoke)CorrelationDataHolder.this.activity).setPatternedCorrelationContainer((PatternedCorrelationContainer)bpelContainer2);
                                    bpelContainer2 = ((Invoke)CorrelationDataHolder.this.activity).getPatternedCorrelationContainer();
                                } else if (CorrelationDataHolder.this.activity instanceof Receive || CorrelationDataHolder.this.activity instanceof Reply || CorrelationDataHolder.this.activity instanceof OnMessage || CorrelationDataHolder.this.activity instanceof OnEvent) {
                                    ((CorrelationsHolder)CorrelationDataHolder.this.activity).setCorrelationContainer((CorrelationContainer)bpelContainer2);
                                    bpelContainer2 = ((CorrelationsHolder)CorrelationDataHolder.this.activity).getCorrelationContainer();
                                }
                            }
                            if (CorrelationDataHolder.this.activity instanceof Invoke) {
                                ((PatternedCorrelationContainer)bpelContainer2).addPatternedCorrelation((PatternedCorrelation)baseCorrelation);
                            } else {
                                ((CorrelationContainer)bpelContainer2).addCorrelation((Correlation)baseCorrelation);
                            }
                            return baseCorrelation;
                        }
                    }, (Object)baseCorrelation);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }

            private BaseCorrelation createCorrelation(BpelModel bpelModel, CorrelationSet correlationSet) {
                BPELElementsBuilder bPELElementsBuilder = bpelModel.getBuilder();
                PatternedCorrelation patternedCorrelation = null;
                try {
                    Pattern pattern;
                    patternedCorrelation = this.activity instanceof Invoke ? bPELElementsBuilder.createPatternedCorrelation() : bPELElementsBuilder.createCorrelation();
                    BpelReference bpelReference = patternedCorrelation.createReference((BpelReferenceable)correlationSet, CorrelationSet.class);
                    patternedCorrelation.setSet(bpelReference);
                    this.setCorrelationInitiateValue((BaseCorrelation)patternedCorrelation);
                    if (patternedCorrelation instanceof PatternedCorrelation && (pattern = this.defineInvokeCorrelationPattern(this.activity)) != null) {
                        patternedCorrelation.setPattern(pattern);
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
                return patternedCorrelation;
            }

            private void setCorrelationInitiateValue(BaseCorrelation baseCorrelation) {
                baseCorrelation.setInitiate(DefineCorrelationWizard.this.correlatedActivity.equals(this.activity) ? Initiate.NO : Initiate.YES);
            }

            private Pattern defineInvokeCorrelationPattern(BpelEntity bpelEntity) {
                assert (bpelEntity != null);
                Operation operation = WizardUtils.getBpelEntityOperation(bpelEntity);
                if (bpelEntity instanceof Invoke && operation instanceof RequestResponseOperation) {
                    Output output;
                    Message message = null;
                    Message message2 = null;
                    try {
                        output = operation.getOutput();
                        message = (Message)output.getMessage().get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        output = operation.getInput();
                        message2 = (Message)output.getMessage().get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (message2 != null && message != null && this.message.equals(message2) && this.message.equals(message)) {
                        return Pattern.REQUEST_RESPONSE;
                    }
                    if (message2 != null && this.message.equals(message2)) {
                        return Pattern.REQUEST;
                    }
                    if (message != null && this.message.equals(message)) {
                        return Pattern.RESPONSE;
                    }
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void createPropertyAlias(WSDLModel wSDLModel, CorrelationProperty correlationProperty) {
                if (!WizardUtils.wsdlContainsPropertyAlias(wSDLModel, correlationProperty, this.message, this.part)) {
                    PropertyAlias propertyAlias = (PropertyAlias)wSDLModel.getFactory().create((WSDLComponent)wSDLModel.getDefinitions(), BPELQName.PROPERTY_ALIAS.getQName());
                    NamedComponentReference namedComponentReference = propertyAlias.createReferenceTo((ReferenceableWSDLComponent)correlationProperty, CorrelationProperty.class);
                    propertyAlias.setPropertyName(namedComponentReference);
                    NamedComponentReference namedComponentReference2 = propertyAlias.createReferenceTo((ReferenceableWSDLComponent)this.message, Message.class);
                    propertyAlias.setMessageType(namedComponentReference2);
                    propertyAlias.setPart(this.part.getName());
                    Query query = this.getPropertyAliasQuery(wSDLModel, propertyAlias);
                    if (query != null) {
                        propertyAlias.setQuery(query);
                    }
                    try {
                        wSDLModel.startTransaction();
                        wSDLModel.addChildComponent((Component)wSDLModel.getRootComponent(), (Component)propertyAlias, 0);
                    }
                    finally {
                        wSDLModel.endTransaction();
                    }
                }
            }

            private Query getPropertyAliasQuery(WSDLModel wSDLModel, PropertyAlias propertyAlias) {
                NamedComponentReference namedComponentReference = this.part.getElement();
                if (namedComponentReference != null && this.getSchemaComponent() != null) {
                    CorrelationMapperTreeNode correlationMapperTreeNode = this.mapperTreeNode;
                    Object object = correlationMapperTreeNode.getUserObject();
                    ArrayList<SchemaComponent> arrayList = new ArrayList<SchemaComponent>();
                    do {
                        arrayList.add(0, (SchemaComponent)object);
                    } while (!((object = (correlationMapperTreeNode = (CorrelationMapperTreeNode)correlationMapperTreeNode.getParent()).getUserObject()) instanceof Part));
                    WizardUtils.importRequiredSchemas(wSDLModel, arrayList);
                    String string = WizardUtils.makeLocationPath(wSDLModel, arrayList);
                    if (string.length() > 0) {
                        Query query = (Query)wSDLModel.getFactory().create((WSDLComponent)propertyAlias, BPELQName.QUERY.getQName());
                        query.setContent(string);
                        return query;
                    }
                }
                return null;
            }

            public boolean equals(Object object) {
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                CorrelationDataHolder correlationDataHolder = (CorrelationDataHolder)object;
                return this.activity.equals(correlationDataHolder.activity) && this.message.equals(correlationDataHolder.message) && this.part.equals(correlationDataHolder.part);
            }

            public int hashCode() {
                int n = 7;
                n = 97 * n + (this.activity != null ? this.activity.hashCode() : 0);
                n = 97 * n + (this.message != null ? this.message.hashCode() : 0);
                n = 97 * n + (this.part != null ? this.part.hashCode() : 0);
                n = 97 * n + (this.mapperTreeNode != null ? this.mapperTreeNode.hashCode() : 0);
                return n;
            }

            public void extractDataFromTreePath(TreePath treePath) {
                this.mapperTreeNode = (CorrelationMapperTreeNode)treePath.getLastPathComponent();
                this.getPartAndMessage(this.mapperTreeNode);
            }

            public void extractDataFromLink(Link link) {
                TreePath treePath = ((TreeSourcePin)link.getSource()).getTreePath();
                this.extractDataFromTreePath(treePath);
            }

            private void getPartAndMessage(CorrelationMapperTreeNode correlationMapperTreeNode) {
                if (correlationMapperTreeNode == null) {
                    return;
                }
                for (correlationMapperTreeNode = (CorrelationMapperTreeNode)correlationMapperTreeNode.getParent(); correlationMapperTreeNode != null; correlationMapperTreeNode = (CorrelationMapperTreeNode)correlationMapperTreeNode.getParent()) {
                    Object object = correlationMapperTreeNode.getUserObject();
                    if (!(object instanceof Part)) continue;
                    this.part = (Part)object;
                    try {
                        this.message = (Message)((CorrelationMapperTreeNode)correlationMapperTreeNode.getParent()).getUserObject();
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                    }
                    return;
                }
            }

            public BpelEntity getActivity() {
                return this.activity;
            }

            public void setActivity(BpelEntity bpelEntity) {
                this.activity = bpelEntity;
            }

            public Message getMessage() {
                return this.message;
            }

            public void setMessage(Message message) {
                this.message = message;
            }

            public Part getPart() {
                return this.part;
            }

            public void setPart(Part part) {
                this.part = part;
            }

            public CorrelationMapperTreeNode getMapperTreeNode() {
                return this.mapperTreeNode;
            }

            public SchemaComponent getSchemaComponent() {
                try {
                    return (SchemaComponent)this.mapperTreeNode.getUserObject();
                }
                catch (ClassCastException classCastException) {
                    ErrorManager.getDefault().notify((Throwable)classCastException);
                    return null;
                }
            }
        }

        private class CorrelationLinker {
            private CorrelationDataHolder source;
            private CorrelationDataHolder target;
            private CorrelationProperty correlationProperty;

            public CorrelationLinker(CorrelationDataHolder correlationDataHolder, CorrelationDataHolder correlationDataHolder2) {
                this.source = correlationDataHolder;
                this.target = correlationDataHolder2;
            }

            public CorrelationDataHolder getSource() {
                return this.source;
            }

            public CorrelationDataHolder getTarget() {
                return this.target;
            }

            public void setSource(CorrelationDataHolder correlationDataHolder) {
                this.source = correlationDataHolder;
            }

            public void setTarget(CorrelationDataHolder correlationDataHolder) {
                this.target = correlationDataHolder;
            }

            public CorrelationProperty getCorrelationProperty() {
                return this.correlationProperty;
            }

            public void createActivityCorrelation(CorrelationSet correlationSet) {
                this.source.createActivityCorrelation(correlationSet);
                this.target.createActivityCorrelation(correlationSet);
            }

            public void createPropertyAlias(WSDLModel wSDLModel) {
                this.source.createPropertyAlias(wSDLModel, this.correlationProperty);
                this.target.createPropertyAlias(wSDLModel, this.correlationProperty);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void createCorrelationProperty(WSDLModel wSDLModel) throws WizardValidationException {
                String string = this.getBasePropertyName();
                this.correlationProperty = (CorrelationProperty)wSDLModel.getFactory().create((WSDLComponent)wSDLModel.getDefinitions(), BPELQName.PROPERTY.getQName());
                this.correlationProperty.setName(string);
                GlobalSimpleType globalSimpleType = this.defineCorrelationPropertyType();
                assert (globalSimpleType != null);
                NamedComponentReference namedComponentReference = this.source.getSchemaComponent().createReferenceTo((ReferenceableSchemaComponent)globalSimpleType, GlobalType.class);
                if (namedComponentReference != null) {
                    this.correlationProperty.setType(namedComponentReference);
                }
                assert (namedComponentReference != null);
                WizardUtils.importWsdlIntoWsdl(wSDLModel, this.source.getWSDLModel());
                WizardUtils.importWsdlIntoWsdl(wSDLModel, this.target.getWSDLModel());
                if (Util.isUniquePropertyName(wSDLModel, string)) {
                    try {
                        wSDLModel.startTransaction();
                        wSDLModel.addChildComponent((Component)wSDLModel.getRootComponent(), (Component)this.correlationProperty, 0);
                    }
                    finally {
                        wSDLModel.endTransaction();
                    }
                }
            }

            private GlobalSimpleType defineCorrelationPropertyType() {
                TypesCompatibilityValidatorImpl typesCompatibilityValidatorImpl = new TypesCompatibilityValidatorImpl(this.source.getSchemaComponent(), this.target.getSchemaComponent());
                typesCompatibilityValidatorImpl.checkSchemaComponentTypesCompatibility();
                GlobalSimpleType globalSimpleType = typesCompatibilityValidatorImpl.getResolvedType();
                assert (globalSimpleType != null);
                return globalSimpleType;
            }

            private String getBasePropertyName() {
                return "wzrd_prop_" + WizardUtils.getSchemaComponentName(this.source.getSchemaComponent()) + "_" + WizardUtils.getSchemaComponentName(this.target.getSchemaComponent());
            }

            public boolean equals(Object object) {
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                CorrelationLinker correlationLinker = (CorrelationLinker)object;
                return this.source.equals(correlationLinker.source) && this.target.equals(correlationLinker.target);
            }

            public int hashCode() {
                int n = 3;
                n = 71 * n + (this.source != null ? this.source.hashCode() : 0);
                n = 71 * n + (this.target != null ? this.target.hashCode() : 0);
                return n;
            }
        }
    }

    public class WizardSelectMessagingActivityPanel
    extends WizardAbstractPanel
    implements ItemListener {
        private final Dimension COMBOBOX_DIMENSION;
        private final int COMBOBOX_MAX_ROW_COUNT = 16;
        private final JComboBox activityComboBox;
        private BpelEntity previousSelectedActivity;
        private BpelEntity initiatingActivity;

        public WizardSelectMessagingActivityPanel() {
            this.COMBOBOX_DIMENSION = new Dimension(350, CommonUtils.isMacOS() ? 25 : 20);
            this.COMBOBOX_MAX_ROW_COUNT = 16;
            this.activityComboBox = new JComboBox();
            this.wizardPanel.setLayout(new FlowLayout(0, this.insetX, this.insetY));
            this.wizardPanel.add(new JLabel(NbBundle.getMessage(WizardSelectMessagingActivityPanel.class, (String)"LBL_Initiating_Messaging_Activities")));
            this.fillActivityComboBox();
            this.activityComboBox.addItemListener(this);
            this.activityComboBox.setRenderer(new ComboBoxRenderer());
            this.activityComboBox.setMaximumRowCount(16);
            this.activityComboBox.setEditable(false);
            this.activityComboBox.setMinimumSize(this.COMBOBOX_DIMENSION);
            this.activityComboBox.setPreferredSize(this.activityComboBox.getMinimumSize());
            this.activityComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DefineCorrelationWizard.class, (String)"A11_DESCRIPTOR_ActivityComboBox"));
            this.activityComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DefineCorrelationWizard.class, (String)"A11_NAME_ActivityComboBox"));
            this.wizardPanel.add(this.activityComboBox);
        }

        private void fillActivityComboBox() {
            DefaultActivityChooser defaultActivityChooser = null;
            if (DefineCorrelationWizard.this.correlatedActivity instanceof Requester || DefineCorrelationWizard.this.correlatedActivity instanceof Responder || DefineCorrelationWizard.this.correlatedActivity instanceof OnMessage || DefineCorrelationWizard.this.correlatedActivity instanceof OnEvent) {
                defaultActivityChooser = new DefaultActivityChooser();
            }
            assert (defaultActivityChooser != null);
            List<BpelEntity> list = defaultActivityChooser.getInitiatingActivityList(DefineCorrelationWizard.this.correlatedActivity);
            if (list != null) {
                ((DefaultComboBoxModel)this.activityComboBox.getModel()).removeAllElements();
                for (BpelEntity bpelEntity : list) {
                    this.activityComboBox.addItem(bpelEntity);
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                this.isValid();
            }
        }

        public boolean isValid() {
            boolean bl = this.activityComboBox.getItemCount() > 0 && this.activityComboBox.getSelectedItem() != null;
            DefineCorrelationWizard.this.wizardDescriptor.putProperty("WizardPanel_errorMessage", bl ? null : NbBundle.getMessage(WizardSelectMessagingActivityPanel.class, (String)"LBL_ErrMsg_No_Activity_For_Correlation"));
            if (bl) {
                String string = WizardUtils.validateActivity((BpelEntity)this.activityComboBox.getSelectedItem());
                bl &= string == null;
                DefineCorrelationWizard.this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string);
            }
            if (DefineCorrelationWizard.this.buttonNext != null) {
                DefineCorrelationWizard.this.buttonNext.setEnabled(bl);
            }
            return bl;
        }

        public void validate() throws WizardValidationException {
            this.previousSelectedActivity = this.initiatingActivity;
            this.initiatingActivity = (BpelEntity)this.activityComboBox.getSelectedItem();
            WizardDefineCorrelationPanel wizardDefineCorrelationPanel = (WizardDefineCorrelationPanel)DefineCorrelationWizard.this.wizardPanels[1];
            if (this.previousSelectedActivity == null) {
                wizardDefineCorrelationPanel.buildCorrelationMapper(this.initiatingActivity, DefineCorrelationWizard.this.correlatedActivity);
            } else if (!this.previousSelectedActivity.equals(this.initiatingActivity)) {
                wizardDefineCorrelationPanel.buildCorrelationMapper(this.initiatingActivity, null);
            }
        }

        private class ComboBoxRenderer
        extends DefaultListCellRenderer {
            private ComboBoxRenderer() {
            }

            public java.awt.Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                java.awt.Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object != null && object instanceof BpelEntity && component != null && component instanceof JLabel) {
                    String string = "";
                    String string2 = null;
                    try {
                        if (object instanceof OnMessage || object instanceof OnEvent) {
                            string2 = NbBundle.getMessage(ComboBoxRenderer.class, (String)(object instanceof OnMessage ? "LBL_ComboBox_OnMessage_Name_Pattern" : "LBL_ComboBox_OnEvent_Name_Pattern"));
                            string = WizardUtils.getBpelEntityName((BpelEntity)object, string2);
                        } else {
                            string2 = NbBundle.getMessage(ComboBoxRenderer.class, (String)"LBL_ComboBox_Item_Name_Pattern");
                            string = WizardUtils.getBpelEntityName((BpelEntity)object);
                            Object[] objectArray = new Object[]{string, ((BpelEntity)object).getElementType().getSimpleName()};
                            string = MessageFormat.format(string2, objectArray);
                        }
                    }
                    catch (Exception exception) {
                        string = object.toString();
                    }
                    ((JLabel)component).setText(string);
                }
                return component;
            }
        }
    }

    public abstract class WizardAbstractPanel
    implements WizardDescriptor.ValidatingPanel {
        protected JPanel wizardPanel = this.createWizardPanel();
        protected ChangeSupport changeSupport = new ChangeSupport((Object)this);
        protected int insetX = 6;
        protected int insetY = 6;

        protected JPanel createWizardPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setPreferredSize(PANEL_DIMENSION_VALUE);
            return jPanel;
        }

        protected void setPanelNameIndex(String string, int n) {
            this.wizardPanel.setName(string);
            this.wizardPanel.putClientProperty("WizardPanel_contentSelectedIndex", n);
        }

        public java.awt.Component getComponent() {
            return this.wizardPanel;
        }

        public HelpCtx getHelp() {
            return null;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        public void readSettings(Object object) {
        }

        public void storeSettings(Object object) {
        }

        public void validate() throws WizardValidationException {
        }

        public boolean isValid() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DefaultActivityChooser
    extends AbstractActivityChooser {
        private DefaultActivityChooser() {
        }

        @Override
        public List<BpelEntity> getInitiatingActivityList(BpelEntity bpelEntity) {
            List<BpelEntity> list = super.getInitiatingActivityList(bpelEntity);
            if (list.isEmpty()) {
                return list;
            }
            list.remove(bpelEntity);
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractActivityChooser
    implements ActivityChooser {
        protected Set<Class> permittedActivityTypeSet = new HashSet<Class>(Arrays.asList(Requester.class, Responder.class, OnMessage.class, OnEvent.class));
        protected Set<Class> forbiddenActivityTypeSet = new HashSet<Class>();

        private AbstractActivityChooser() {
        }

        @Override
        public List<BpelEntity> getInitiatingActivityList(BpelEntity bpelEntity) {
            ArrayList<BpelEntity> arrayList = new ArrayList<BpelEntity>();
            Process process = bpelEntity.getBpelModel().getProcess();
            if (process == null) {
                return arrayList;
            }
            List<BpelEntity> list = this.chooseActivities((BpelEntity)process, new ArrayList<BpelEntity>());
            for (BpelEntity bpelEntity2 : list) {
                if (bpelEntity.equals(bpelEntity2)) {
                    arrayList.add(bpelEntity2);
                    continue;
                }
                if (this.isInstanceOfClass(this.forbiddenActivityTypeSet, bpelEntity2) || !this.isInstanceOfClass(this.permittedActivityTypeSet, bpelEntity2)) continue;
                arrayList.add(bpelEntity2);
            }
            return arrayList;
        }

        private boolean isInstanceOfClass(Set<Class> set, BpelEntity bpelEntity) {
            for (Class clazz : set) {
                try {
                    bpelEntity.getClass().asSubclass(clazz);
                    return true;
                }
                catch (ClassCastException classCastException) {
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
            return false;
        }

        protected List<BpelEntity> chooseActivities(BpelEntity bpelEntity, List<BpelEntity> list) {
            if (list == null) {
                return new ArrayList<BpelEntity>();
            }
            if (bpelEntity instanceof Requester || bpelEntity instanceof Responder) {
                list.add(bpelEntity);
            } else if (bpelEntity instanceof Pick) {
                list.addAll(this.handlePickEntity((Pick)bpelEntity, new ArrayList<BpelEntity>()));
            } else if (bpelEntity instanceof EventHandlers) {
                list.addAll(this.handleEventHandlersEntity((EventHandlers)bpelEntity, new ArrayList<BpelEntity>()));
            } else {
                this.addAllChildActivities(bpelEntity, list);
            }
            return list;
        }

        protected void addAllChildActivities(BpelEntity bpelEntity, List<BpelEntity> list) {
            for (BpelEntity bpelEntity2 : bpelEntity.getChildren(BpelEntity.class)) {
                list.addAll(this.chooseActivities(bpelEntity2, new ArrayList<BpelEntity>()));
            }
        }

        protected List<BpelEntity> handlePickEntity(Pick pick, List<BpelEntity> list) {
            for (OnMessage onMessage : pick.getOnMessages()) {
                list.add((BpelEntity)onMessage);
                this.addAllChildActivities((BpelEntity)onMessage, list);
            }
            for (OnMessage onMessage : pick.getOnAlarms()) {
                this.addAllChildActivities((BpelEntity)onMessage, list);
            }
            return list;
        }

        protected List<BpelEntity> handleEventHandlersEntity(EventHandlers eventHandlers, List<BpelEntity> list) {
            for (OnEvent onEvent : eventHandlers.getOnEvents()) {
                list.add((BpelEntity)onEvent);
                this.addAllChildActivities((BpelEntity)onEvent, list);
            }
            for (OnEvent onEvent : eventHandlers.getOnAlarms()) {
                this.addAllChildActivities((BpelEntity)onEvent, list);
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ActivityChooser {
        public List<BpelEntity> getInitiatingActivityList(BpelEntity var1);
    }
}

