/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.properties.editors.DefineCorrelationWizard;
import org.openide.util.NbBundle;

class UnnamedActivityNameHandler {
    private static UnnamedActivityNameHandler activityNameHandler;
    private static final String namePattern;
    private int nameCounter = 1;
    private Map<BpelEntity, Integer> activityNameNumberMap = new HashMap<BpelEntity, Integer>();

    private UnnamedActivityNameHandler() {
        this.initialize();
    }

    public void initialize() {
        this.nameCounter = 1;
        this.activityNameNumberMap.clear();
    }

    public String getActivityName(BpelEntity bpelEntity) {
        Integer n = this.activityNameNumberMap.get(bpelEntity);
        if (n == null) {
            n = this.nameCounter++;
            this.activityNameNumberMap.put(bpelEntity, n);
        }
        String string = MessageFormat.format(namePattern, n);
        return string;
    }

    public static UnnamedActivityNameHandler getInstance() {
        if (activityNameHandler == null) {
            activityNameHandler = new UnnamedActivityNameHandler();
        }
        return activityNameHandler;
    }

    static {
        namePattern = NbBundle.getMessage(DefineCorrelationWizard.class, (String)"LBL_Unnamed_Activity_Name_Pattern");
    }
}

