/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.CompiledMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class ReflectedCompiledMethod
extends CompiledMethod {
    private final Method method;

    public ReflectedCompiledMethod(RubyModule implementationClass, Arity arity, Visibility visibility, StaticScope staticScope, Object scriptObject, Method method, CallConfiguration callConfig) {
        super(implementationClass, arity, visibility, staticScope, scriptObject, callConfig);
        this.method = method;
    }

    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, IRubyObject[] args, boolean noSuper, Block block) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
        this.callConfig.pre(context, self, this.getImplementationClass(), this.arity, name, args, block, this.staticScope, this);
        Ruby runtime = context.getRuntime();
        try {
            try {
                IRubyObject iRubyObject;
                block12: {
                    boolean isTrace = runtime.hasEventHooks();
                    try {
                        if (isTrace) {
                            runtime.callEventHooks(context, 3, context.getFile(), context.getLine(), name, this.getImplementationClass());
                        }
                        iRubyObject = (IRubyObject)this.method.invoke(this.$scriptObject, context, self, args, block);
                        Object var11_14 = null;
                        if (!isTrace) break block12;
                        Frame frame = context.getPreviousFrame();
                        runtime.callEventHooks(context, 4, frame.getFile(), frame.getLine(), name, this.getImplementationClass());
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        if (!isTrace) throw throwable;
                        Frame frame = context.getPreviousFrame();
                        runtime.callEventHooks(context, 4, frame.getFile(), frame.getLine(), name, this.getImplementationClass());
                        throw throwable;
                    }
                }
                Object var14_19 = null;
                this.callConfig.post(context);
                return iRubyObject;
            }
            catch (IllegalArgumentException e) {
                throw RaiseException.createNativeRaiseException(runtime, e);
            }
            catch (IllegalAccessException e) {
                throw RaiseException.createNativeRaiseException(runtime, e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof JumpException.ReturnJump) {
                    JumpException.FlowControlException f = (JumpException.FlowControlException)cause;
                    if (f.getTarget() != this) throw f;
                    IRubyObject iRubyObject = (IRubyObject)f.getValue();
                    Object var14_20 = null;
                    this.callConfig.post(context);
                    return iRubyObject;
                }
                if (cause instanceof JumpException.RedoJump) {
                    throw runtime.newLocalJumpError("redo", runtime.getNil(), "unexpected redo");
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (!(cause instanceof Error)) throw RaiseException.createNativeRaiseException(runtime, cause);
                throw (Error)cause;
            }
        }
        catch (Throwable throwable) {
            Object var14_21 = null;
            this.callConfig.post(context);
            throw throwable;
        }
    }
}

