/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.CompiledBlockLight;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledSharedScopeBlock
extends CompiledBlockLight {
    public static Block newCompiledSharedScopeClosure(ThreadContext context, IRubyObject self, Arity arity, DynamicScope dynamicScope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        Binding binding = new Binding(self, context.getCurrentFrame().duplicate(), Visibility.PUBLIC, context.getRubyClass(), dynamicScope);
        CompiledSharedScopeBlock body = new CompiledSharedScopeBlock(arity, dynamicScope, callback, hasMultipleArgsHead, argumentType);
        return new Block(body, binding);
    }

    private CompiledSharedScopeBlock(Arity arity, DynamicScope containingScope, CompiledBlockCallback callback, boolean hasMultipleArgsHead, int argumentType) {
        super(arity, containingScope, callback, hasMultipleArgsHead, argumentType);
    }

    protected void pre(ThreadContext context, RubyModule klass, Binding binding) {
        context.preForBlock(binding, klass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject yield(ThreadContext context, IRubyObject args, IRubyObject self, RubyModule klass, boolean aValue, Binding binding, Block.Type type) {
        IRubyObject iRubyObject;
        if (klass == null) {
            self = binding.getSelf();
            binding.getFrame().setSelf(self);
        }
        Visibility oldVis = binding.getFrame().getVisibility();
        try {
            try {
                IRubyObject[] realArgs = aValue ? this.setupBlockArgs(context, args, self) : this.setupBlockArg(context, args, self);
                this.pre(context, klass, binding);
                try {
                    iRubyObject = this.callback.call(context, self, realArgs);
                }
                catch (JumpException.BreakJump bj) {
                    if (bj.getTarget() != null) throw bj;
                    bj.setTarget(this);
                    throw bj;
                }
                Object var12_14 = null;
            }
            catch (JumpException.NextJump nj) {
                IRubyObject iRubyObject2 = type == Block.Type.LAMBDA ? context.getRuntime().getNil() : (IRubyObject)nj.getValue();
                Object var12_15 = null;
                binding.getFrame().setVisibility(oldVis);
                this.post(context, binding);
                return iRubyObject2;
            }
            binding.getFrame().setVisibility(oldVis);
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            binding.getFrame().setVisibility(oldVis);
            this.post(context, binding);
            throw throwable;
        }
        this.post(context, binding);
        return iRubyObject;
    }

    private IRubyObject[] setupBlockArgs(ThreadContext context, IRubyObject value, IRubyObject self) {
        switch (this.argumentType) {
            case 0: {
                return IRubyObject.NULL_ARRAY;
            }
            case 1: {
                return new IRubyObject[]{value};
            }
        }
        int length = this.arrayLength(value);
        switch (length) {
            case 0: {
                value = context.getRuntime().getNil();
                break;
            }
            case 1: {
                value = ((RubyArray)value).eltInternal(0);
                break;
            }
            default: {
                context.getRuntime().getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (" + length + " for 1)", new Object[0]);
            }
        }
        return new IRubyObject[]{value};
    }

    private IRubyObject[] setupBlockArg(ThreadContext context, IRubyObject value, IRubyObject self) {
        switch (this.argumentType) {
            case 0: {
                return IRubyObject.NULL_ARRAY;
            }
            case 1: {
                return new IRubyObject[]{ArgsUtil.convertToRubyArray(context.getRuntime(), value, this.hasMultipleArgsHead)};
            }
        }
        if (value == null) {
            context.getRuntime().getWarnings().warn(IRubyWarnings.ID.MULTIPLE_VALUES_FOR_BLOCK, "multiple values for a block parameter (0 for 1)", new Object[0]);
            return new IRubyObject[]{context.getRuntime().getNil()};
        }
        return new IRubyObject[]{value};
    }

    public Block cloneBlock(Binding binding) {
        return new Block(this, binding);
    }
}

