/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.component;

import com.sun.rave.web.ui.component.ComplexComponent;
import com.sun.rave.web.ui.component.HelpInline;
import com.sun.rave.web.ui.component.Label;
import com.sun.rave.web.ui.component.PropertyBase;
import com.sun.rave.web.ui.util.ComponentUtilities;
import java.util.Iterator;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class Property
extends PropertyBase
implements ComplexComponent {
    public static final String CONTENT_FACET = "content";
    public static final String HELPTEXT_FACET = "helpText";
    public static final String LABEL_FACET = "label";

    public String getPrimaryElementID(FacesContext context) {
        UIComponent contentFacet = (UIComponent)this.getFacets().get(CONTENT_FACET);
        UIComponent labeledComponent = null;
        labeledComponent = contentFacet == null ? Property.findLabeledComponent((UIComponent)this, true) : Property.findLabeledComponent(contentFacet, false);
        if (labeledComponent != null) {
            return ":" + labeledComponent.getClientId(context);
        }
        return null;
    }

    private static UIComponent findLabeledComponent(UIComponent comp, boolean skip) {
        if (!skip && comp instanceof EditableValueHolder) {
            return comp;
        }
        Iterator it = comp.getFacetsAndChildren();
        while (it.hasNext()) {
            comp = Property.findLabeledComponent((UIComponent)it.next(), false);
            if (comp == null) continue;
            return comp;
        }
        return null;
    }

    public UIComponent getContentComponent() {
        return this.getFacet(CONTENT_FACET);
    }

    public UIComponent getHelpTextComponent() {
        UIComponent component = this.getFacet(HELPTEXT_FACET);
        if (component != null) {
            return component;
        }
        String helpText = this.getHelpText();
        if (helpText == null) {
            return null;
        }
        HelpInline helpInline = new HelpInline();
        helpInline.setText(helpText);
        helpInline.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, HELPTEXT_FACET));
        helpInline.setParent((UIComponent)this);
        helpInline.setType("field");
        return helpInline;
    }

    public UIComponent getLabelComponent() {
        Object component = this.getFacet(LABEL_FACET);
        if (component != null) {
            return component;
        }
        if (this.getLabel() == null) {
            return null;
        }
        component = ComponentUtilities.getPrivateFacet((UIComponent)this, LABEL_FACET, true);
        if (component == null) {
            Label label = new Label();
            label.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, LABEL_FACET));
            label.setText(this.getLabel());
            String id = this.getPrimaryElementID(FacesContext.getCurrentInstance());
            label.setFor(id);
            ComponentUtilities.putPrivateFacet((UIComponent)this, LABEL_FACET, (UIComponent)label);
            component = label;
        }
        return component;
    }
}

