/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.faces;

import com.sun.data.provider.FilterCriteria;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.CompareFilterCriteria;
import com.sun.data.provider.impl.TableRowDataProvider;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class ValueBindingFilterCriteria
extends FilterCriteria {
    protected Locale compareLocale;
    protected boolean matchEqualTo = true;
    protected boolean matchLessThan = false;
    protected boolean matchGreaterThan = false;
    private transient ValueBinding valueBinding;
    private Object compareValue;
    private String requestMapKey = "currentRow";
    private transient TableRowDataProvider rowProvider;
    private String rowProviderLock = "rowProviderLock";

    public ValueBindingFilterCriteria() {
    }

    public ValueBindingFilterCriteria(ValueBinding valueBinding) {
        this.valueBinding = valueBinding;
    }

    public ValueBindingFilterCriteria(Object compareValue) {
        this.compareValue = compareValue;
    }

    public ValueBindingFilterCriteria(ValueBinding valueBinding, Object compareValue) {
        this.valueBinding = valueBinding;
        this.compareValue = compareValue;
    }

    public ValueBindingFilterCriteria(ValueBinding valueBinding, Object compareValue, boolean matchLessThan, boolean matchEqualTo, boolean matchGreaterThan) {
        this.valueBinding = valueBinding;
        this.compareValue = compareValue;
        this.matchLessThan = matchLessThan;
        this.matchEqualTo = matchEqualTo;
        this.matchGreaterThan = matchGreaterThan;
    }

    public String getDisplayName() {
        String name = super.getDisplayName();
        if (name != null && !"".equals(name)) {
            return name;
        }
        Object val = this.getCompareValue();
        StringBuffer sb = new StringBuffer();
        sb.append(this.isInclude() ? "Include [" : "Exclude [");
        sb.append(this.valueBinding != null ? this.valueBinding.getExpressionString() : "<no value binding>");
        sb.append("] ");
        boolean anyMatches = false;
        if (this.matchLessThan) {
            anyMatches = true;
            sb.append("is less than ");
        }
        if (this.matchEqualTo) {
            if (anyMatches) {
                sb.append("OR ");
            }
            anyMatches = true;
            sb.append("is equal to ");
        }
        if (this.matchGreaterThan) {
            if (anyMatches) {
                sb.append("OR ");
            }
            sb.append("is greater than ");
        }
        sb.append("[" + val + "]");
        return sb.toString();
    }

    public void setValueBinding(ValueBinding valueBinding) {
        this.valueBinding = valueBinding;
    }

    public ValueBinding getValueBinding() {
        return this.valueBinding;
    }

    public String getRequestMapKey() {
        return this.requestMapKey;
    }

    public void setRequestMapKey(String requestMapKey) {
        this.requestMapKey = requestMapKey;
    }

    public void setCompareValue(Object value) {
        this.compareValue = value;
    }

    public Object getCompareValue() {
        return this.compareValue;
    }

    public void setCompareLocale(Locale compareLocale) {
        this.compareLocale = compareLocale;
    }

    public Locale getCompareLocale() {
        return this.compareLocale;
    }

    public void setMatchEqualTo(boolean matchEqualTo) {
        this.matchEqualTo = matchEqualTo;
    }

    public boolean isMatchEqualTo() {
        return this.matchEqualTo;
    }

    public void setMatchLessThan(boolean matchLessThan) {
        this.matchLessThan = matchLessThan;
    }

    public boolean isMatchLessThan() {
        return this.matchLessThan;
    }

    public void setMatchGreaterThan(boolean matchGreaterThan) {
        this.matchGreaterThan = matchGreaterThan;
    }

    public boolean isMatchGreaterThan() {
        return this.matchGreaterThan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(TableDataProvider provider, RowKey row) {
        if (this.valueBinding == null) {
            return true;
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Object value = null;
        String string = this.rowProviderLock;
        synchronized (string) {
            Object storedRequestMapValue = null;
            if (this.requestMapKey != null && !"".equals(this.requestMapKey)) {
                storedRequestMapValue = requestMap.get(this.requestMapKey);
                if (this.rowProvider == null) {
                    this.rowProvider = new TableRowDataProvider();
                }
                this.rowProvider.setTableDataProvider(provider);
                this.rowProvider.setTableRow(row);
                requestMap.put(this.requestMapKey, this.rowProvider);
            }
            value = this.valueBinding.getValue(facesContext);
            if (this.requestMapKey != null && !"".equals(this.requestMapKey)) {
                if (this.rowProvider != null) {
                    this.rowProvider.setTableDataProvider(null);
                    this.rowProvider.setTableRow(null);
                }
                requestMap.put(this.requestMapKey, storedRequestMapValue);
            }
        }
        int compare = CompareFilterCriteria.compare((Object)value, (Object)this.compareValue, (Locale)this.compareLocale);
        switch (compare) {
            case -1: {
                return this.matchLessThan;
            }
            case 0: {
                return this.matchEqualTo;
            }
            case 1: {
                return this.matchGreaterThan;
            }
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.compareValue);
        out.writeObject(this.requestMapKey);
        out.writeObject(this.rowProviderLock);
        if (this.valueBinding != null) {
            out.writeObject(this.valueBinding.getExpressionString());
        } else {
            out.writeObject(null);
        }
        if (this.valueBinding != null) {
            out.writeObject(this.valueBinding.getExpressionString());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.compareValue = in.readObject();
        this.requestMapKey = (String)in.readObject();
        this.rowProviderLock = (String)in.readObject();
        String s = (String)in.readObject();
        if (s != null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            this.valueBinding = facesContext.getApplication().createValueBinding(s);
        } else {
            this.valueBinding = null;
        }
    }
}

