/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.renderer;

import com.sun.rave.web.ui.component.Alarm;
import com.sun.rave.web.ui.renderer.ImageRenderer;
import com.sun.rave.web.ui.theme.Theme;
import com.sun.rave.web.ui.util.ThemeUtilities;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class AlarmRenderer
extends ImageRenderer {
    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Alarm alarm = (Alarm)component;
        this.setAlarmProperties(alarm, ThemeUtilities.getTheme(context));
        super.renderAttributes(context, (UIComponent)alarm, writer);
    }

    private void setAlarmProperties(Alarm alarm, Theme theme) {
        String severity = alarm.getSeverity();
        if (severity == null || severity.trim().length() == 0) {
            severity = "ok";
        }
        severity = severity.toLowerCase();
        if (severity.equals("critical")) {
            alarm.setIcon("ALARM_CRITICAL_MEDIUM");
            alarm.setAlt(theme.getMessage("Alarm.criticalImageAltText"));
            alarm.setToolTip(theme.getMessage("Alarm.criticalImageAltText"));
        } else if (severity.equals("major")) {
            alarm.setIcon("ALARM_MAJOR_MEDIUM");
            alarm.setAlt(theme.getMessage("Alarm.majorImageAltText"));
            alarm.setToolTip(theme.getMessage("Alarm.majorImageAltText"));
        } else if (severity.equals("minor")) {
            alarm.setIcon("ALARM_MINOR_MEDIUM");
            alarm.setAlt(theme.getMessage("Alarm.minorImageAltText"));
            alarm.setToolTip(theme.getMessage("Alarm.minorImageAltText"));
        } else if (severity.equals("down")) {
            alarm.setIcon("ALARM_DOWN_MEDIUM");
            alarm.setAlt(theme.getMessage("Alarm.downImageAltText"));
            alarm.setToolTip(theme.getMessage("Alarm.downImageAltText"));
        } else {
            alarm.setIcon(null);
            alarm.setAlt(null);
            alarm.setToolTip(null);
        }
    }
}

