/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.renderer.template.xml;

import com.sun.rave.web.ui.component.util.descriptors.LayoutDefinition;
import com.sun.rave.web.ui.renderer.template.LayoutDefinitionManager;
import com.sun.rave.web.ui.renderer.template.xml.XMLLayoutDefinitionReader;
import java.beans.Beans;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLLayoutDefinitionManager
extends LayoutDefinitionManager {
    private static Map layouts = new HashMap();
    private static LayoutDefinitionManager instance = null;
    private static final Class[] GET_REAL_PATH_ARGS = new Class[]{String.class};
    private static final int FILE_PREFIX_LENGTH = "file:///".length();
    public static final String ENTITY_RESOLVER = "entityResolver";
    public static final String ERROR_HANDLER = "errorHandler";
    public static final String BASE_URI = "baseURI";
    public static boolean DEBUG = Boolean.getBoolean("com.sun.rave.web.ui.DEBUG");

    protected XMLLayoutDefinitionManager() {
        try {
            this.setErrorHandler(new XMLErrorHandler(new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, "UTF-8"), true)));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        this.setEntityResolver(new ClassLoaderEntityResolver());
    }

    public static LayoutDefinitionManager getInstance() {
        if (instance == null) {
            instance = new XMLLayoutDefinitionManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayoutDefinition getLayoutDefinition(String key) {
        LayoutDefinition ld = (LayoutDefinition)layouts.get(key);
        if (DEBUG) {
            ld = null;
        }
        if (ld == null) {
            String path;
            int i;
            String url;
            String baseURI = this.getBaseURI();
            URL ldURL = null;
            Object ctx = FacesContext.getCurrentInstance().getExternalContext().getContext();
            Method method = null;
            try {
                method = ctx.getClass().getMethod("getRealPath", GET_REAL_PATH_ARGS);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException(ex);
            }
            try {
                if (baseURI == null) {
                    baseURI = "file:///" + method.invoke(ctx, "/");
                }
                url = (String)method.invoke(ctx, key);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
            if (!new File(url).canRead()) {
                url = null;
            }
            if (url != null) {
                try {
                    ldURL = new URL("file:///" + url);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Unable to create URL: 'file:///" + url + "' while attempting to locate '" + key + "'", ex);
                }
            }
            if (ldURL == null) {
                String path2;
                int idx;
                ldURL = this.getClass().getClassLoader().getResource(key);
                if (ldURL == null && (idx = key.indexOf(47)) > -1) {
                    ldURL = this.getClass().getClassLoader().getResource(key.substring(idx + 1));
                }
                if (Beans.isDesignTime() && (i = (path2 = ldURL.getPath()).indexOf("/" + key)) > -1) {
                    baseURI = path2.substring(0, i);
                }
            }
            if (ldURL == null) {
                throw new RuntimeException("Unable to locate '" + key + "'");
            }
            if (baseURI == null && Beans.isDesignTime() && (i = (path = ldURL.getPath()).indexOf("/" + key)) > -1) {
                baseURI = path.substring(0, i);
            }
            try {
                ld = new XMLLayoutDefinitionReader(ldURL, this.getEntityResolver(), this.getErrorHandler(), baseURI).read();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            Map map = layouts;
            synchronized (map) {
                layouts.put(key, ld);
            }
        }
        return ld;
    }

    public EntityResolver getEntityResolver() {
        return (EntityResolver)this.getAttribute(ENTITY_RESOLVER);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.setAttribute(ENTITY_RESOLVER, entityResolver);
    }

    public ErrorHandler getErrorHandler() {
        return (ErrorHandler)this.getAttribute(ERROR_HANDLER);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.setAttribute(ERROR_HANDLER, errorHandler);
    }

    public String getBaseURI() {
        return (String)this.getAttribute(BASE_URI);
    }

    public void setBaseURI(String baseURI) {
        this.setAttribute(BASE_URI, baseURI);
    }

    public static class ClassLoaderEntityResolver
    implements EntityResolver {
        public InputSource resolveEntity(String publicId, String systemId) {
            InputSource source = null;
            if (systemId != null && (systemId.endsWith(".xml") || systemId.endsWith(".dtd"))) {
                InputStream resourceStream;
                if (systemId.startsWith("file:")) {
                    int i = 5;
                    while (systemId.charAt(i) == '/') {
                        ++i;
                    }
                    systemId = systemId.substring(i);
                }
                if ((resourceStream = this.getClass().getClassLoader().getResourceAsStream(systemId)) != null) {
                    source = new InputSource(resourceStream);
                }
            }
            return source;
        }
    }

    private static class XMLErrorHandler
    implements ErrorHandler {
        private PrintWriter out;

        XMLErrorHandler(PrintWriter outWriter) {
            this.out = outWriter;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void warning(SAXParseException spe) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message, spe);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message, spe);
        }
    }
}

