/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.server.output;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.server.output.LineProcessor;
import org.netbeans.api.server.output.LineReader;
import org.netbeans.api.server.output.ReaderManager;
import org.openide.util.Parameters;

public class ReaderThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(ReaderThread.class.getName());
    private static final int DELAY = 500;
    private static final AtomicLong THREAD_COUNTER = new AtomicLong(0L);
    private final ReaderManager readerManager;
    private final LineReader lineReader;
    private final LineProcessor lineProcessor;

    public ReaderThread(ReaderManager readerManager, LineReader lineReader) {
        this(readerManager, lineReader, null);
    }

    public ReaderThread(ReaderManager readerManager, LineReader lineReader, LineProcessor lineProcessor) {
        super("line_reader_thread_" + THREAD_COUNTER.incrementAndGet());
        Parameters.notNull((CharSequence)"readerManager", (Object)readerManager);
        Parameters.notNull((CharSequence)"lineReader", (Object)lineReader);
        this.setDaemon(true);
        this.readerManager = readerManager;
        this.lineReader = lineReader;
        this.lineProcessor = lineProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean bl = false;
        try {
            while (true) {
                if (Thread.interrupted()) {
                    bl = true;
                    break;
                }
                this.lineReader.readLines(this.lineProcessor, false);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    break;
                }
            }
            this.lineReader.readLines(this.lineProcessor, true);
            return;
        }
        catch (Exception exception) {
            if (bl) return;
            if (Thread.currentThread().isInterrupted()) return;
            LOGGER.log(Level.INFO, null, exception);
            return;
        }
        finally {
            try {
                this.lineReader.close();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, null, iOException);
            }
            finally {
                Accessor.DEFAULT.notifyFinished(this.readerManager, this);
                if (bl) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static abstract class Accessor {
        public static Accessor DEFAULT;

        public abstract void notifyFinished(ReaderManager var1, ReaderThread var2);

        static {
            block2: {
                Class<ReaderManager> clazz = ReaderManager.class;
                try {
                    Class.forName(clazz.getName(), true, clazz.getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError((Object)classNotFoundException);
                }
            }
        }
    }
}

