/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.server.output;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.netbeans.api.server.output.LineProcessor;
import org.netbeans.api.server.output.LineReader;
import org.netbeans.modules.server.output.LineParsingHelper;
import org.openide.util.Parameters;

public class StreamLineReader
implements LineReader {
    private static final Logger LOGGER = Logger.getLogger(StreamLineReader.class.getName());
    private static final int BUFFER_SIZE = 128;
    private final LineParsingHelper helper = new LineParsingHelper();
    private final Charset charset;
    private final ReadableByteChannel channel;
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(128);
    private boolean closed;

    public StreamLineReader(InputStream inputStream, Charset charset) {
        Parameters.notNull((CharSequence)"stream", (Object)inputStream);
        Parameters.notNull((CharSequence)"charset", (Object)charset);
        this.charset = charset;
        this.channel = Channels.newChannel(inputStream);
    }

    public int readLines(LineProcessor lineProcessor, boolean bl) throws IOException {
        String[] stringArray;
        if (this.closed) {
            throw new IllegalStateException("Already closed reader");
        }
        int n = 0;
        this.buffer.clear();
        int n2 = this.channel.read(this.buffer);
        if (n2 > 0) {
            this.buffer.position(0).limit(n2);
            stringArray = this.helper.parse(this.buffer, this.charset);
            n += stringArray.length;
            if (lineProcessor != null) {
                for (String string : stringArray) {
                    lineProcessor.processLine(string);
                }
            }
        }
        if (bl && (stringArray = this.helper.getTrailingLine(true)) != null) {
            if (lineProcessor != null) {
                lineProcessor.processLine((String)stringArray);
            }
            ++n;
        }
        return n;
    }

    public void close() throws IOException {
        this.closed = true;
        this.channel.close();
    }
}

