/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsfloader;

import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.SwingUtilities;
import org.netbeans.modules.visualweb.api.insync.JsfJavaDataObjectMarker;
import org.netbeans.modules.visualweb.project.jsf.api.JsfDataObjectException;
import org.netbeans.modules.visualweb.project.jsfloader.CompoundSaveCookie;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJavaDataLoader;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJavaDataNode;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJavaEditorSupport;
import org.netbeans.modules.visualweb.project.jsfloader.JsfJspDataObject;
import org.netbeans.modules.visualweb.project.jsfloader.Utils;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsfJavaDataObject
extends MultiDataObject
implements JsfJavaDataObjectMarker,
CookieSet.Factory {
    static final long serialVersionUID = 8354927561693097159L;
    static final String JSF_ATTRIBUTE = "jsfjava";
    private OpenEdit openEdit = null;
    private JsfJavaEditorSupport jsfJavaEditor;
    private static final ThreadLocal<Boolean> pureCopy = new ThreadLocal();

    public JsfJavaDataObject(FileObject fileObject, JsfJavaDataLoader jsfJavaDataLoader) throws DataObjectExistsException {
        super(fileObject, (MultiFileLoader)jsfJavaDataLoader);
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add(OpenCookie.class, (CookieSet.Factory)this);
        cookieSet.add(EditCookie.class, (CookieSet.Factory)this);
        cookieSet.add(EditorCookie.class, (CookieSet.Factory)this);
        cookieSet.add(JsfJavaEditorSupport.class, (CookieSet.Factory)this);
    }

    <T extends Node.Cookie> T getPureCookie(Class<T> clazz) {
        return (T)super.getCookie(clazz);
    }

    public <T extends Node.Cookie> T getCookie(Class<T> clazz) {
        if (clazz == SaveCookie.class) {
            FileObject fileObject = Utils.findJspForJava(this.getPrimaryFile());
            if (fileObject != null && fileObject.isValid()) {
                SaveCookie saveCookie = (SaveCookie)super.getCookie(clazz);
                JsfJspDataObject jsfJspDataObject = this.getCookie(JsfJspDataObject.class);
                SaveCookie saveCookie2 = jsfJspDataObject == null ? null : (SaveCookie)jsfJspDataObject.getPureCookie(clazz);
                if (saveCookie == null && saveCookie2 == null) {
                    return null;
                }
                return (T)((Node.Cookie)clazz.cast(new CompoundSaveCookie(saveCookie, saveCookie2)));
            }
        } else if (clazz.isAssignableFrom(JsfJavaEditorSupport.class)) {
            return (T)((Node.Cookie)clazz.cast((Object)this.getJsfJavaEditorSupport()));
        }
        return (T)super.getCookie(clazz);
    }

    public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
        if (OpenCookie.class.equals(clazz) || EditCookie.class.equals(clazz)) {
            if (this.openEdit == null) {
                this.openEdit = new OpenEdit();
            }
            return (T)((Node.Cookie)clazz.cast(this.openEdit));
        }
        if (EditorCookie.class.equals(clazz) || JsfJavaEditorSupport.class.equals(clazz)) {
            return (T)((Node.Cookie)clazz.cast((Object)this.getJsfJavaEditorSupport()));
        }
        return null;
    }

    void addSaveCookie(SaveCookie saveCookie) {
        this.getCookieSet().add((Node.Cookie)saveCookie);
    }

    protected Node createNodeDelegate() {
        return new JsfJavaDataNode(this);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.visualweb.project.jsfloader.JsfJavaDataLoader.Obj");
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    protected JsfJavaEditorSupport getJsfJavaEditorSupport() {
        if (this.jsfJavaEditor == null) {
            this.jsfJavaEditor = new JsfJavaEditorSupport(this);
        }
        return this.jsfJavaEditor;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pureCopy(DataFolder dataFolder) throws IOException {
        try {
            pureCopy.set(Boolean.TRUE);
            this.copy(dataFolder);
        }
        finally {
            pureCopy.set(Boolean.FALSE);
        }
    }

    protected DataObject handleCopy(DataFolder dataFolder) throws IOException {
        if (pureCopy.get() == Boolean.TRUE) {
            return super.handleCopy(dataFolder);
        }
        FileObject fileObject = Utils.findJspForJava(this.getPrimaryFile());
        if (fileObject == null) {
            throw new JsfDataObjectException("Can't find jsp file for " + (Object)((Object)this));
        }
        DataObject dataObject = super.handleCopy(dataFolder);
        try {
            DataObject dataObject2 = DataObject.find((FileObject)fileObject);
            if (dataObject2 instanceof JsfJspDataObject) {
                FileObject fileObject2 = Utils.findJspFolderForJava(dataObject.getPrimaryFile());
                DataFolder dataFolder2 = DataFolder.findFolder((FileObject)fileObject2);
                ((JsfJspDataObject)dataObject2).pureCopy(dataFolder2);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)dataObjectNotFoundException);
        }
        return dataObject;
    }

    protected FileObject handleRename(String string) throws IOException {
        FileObject fileObject = super.handleRename(string);
        final JsfJavaEditorSupport jsfJavaEditorSupport = this.getCookie(JsfJavaEditorSupport.class);
        if (jsfJavaEditorSupport != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jsfJavaEditorSupport.updateMultiViewDisplayName();
                }
            });
        }
        return fileObject;
    }

    protected void removeSaveCookie(SaveCookie saveCookie) {
        SaveCookie saveCookie2;
        CompoundSaveCookie compoundSaveCookie;
        if (saveCookie instanceof CompoundSaveCookie && (compoundSaveCookie = (CompoundSaveCookie)saveCookie).containsCookie(saveCookie2 = this.getPureCookie(SaveCookie.class))) {
            this.getCookieSet().remove((Node.Cookie)saveCookie2);
        }
        this.getCookieSet().remove((Node.Cookie)saveCookie);
    }

    private class OpenEdit
    implements OpenCookie,
    EditCookie {
        private OpenEdit() {
        }

        public void open() {
            JsfJavaDataObject.this.getJsfJavaEditorSupport().open();
        }

        public void edit() {
            JsfJavaDataObject.this.getJsfJavaEditorSupport().open();
        }
    }
}

