/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.samples;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.samples.JavaEESamplesWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JavaEESamplesWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor.Panel[] panels;
    protected WizardDescriptor wiz;

    public static JavaEESamplesWizardIterator createIterator() {
        return new JavaEESamplesWizardIterator();
    }

    protected WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new JavaEESamplesWizardPanel(false)};
    }

    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage(JavaEESamplesWizardIterator.class, (String)"LBL_CreateProjectStep")};
    }

    public Set instantiate() throws IOException {
        File file;
        LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
        File file2 = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        JavaEESamplesWizardIterator.createFolder(file2);
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)this.wiz);
        FileObject fileObject2 = FileUtil.toFileObject((File)file2);
        JavaEESamplesWizardIterator.unZipFile(fileObject.getInputStream(), fileObject2);
        ProjectManager.getDefault().clearNonProjectCache();
        linkedHashSet.add(fileObject2);
        Enumeration enumeration = fileObject2.getFolders(true);
        while (enumeration.hasMoreElements()) {
            file = (FileObject)enumeration.nextElement();
            if (!ProjectManager.getDefault().isProject((FileObject)file)) continue;
            linkedHashSet.add(file);
        }
        file = file2.getParentFile();
        if (file != null && file.exists()) {
            ProjectChooser.setProjectsFolder((File)file);
        }
        return linkedHashSet;
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wiz = wizardDescriptor;
        this.index = 0;
        this.panels = this.createPanels();
        String[] stringArray = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray[i] == null) {
                stringArray[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray);
        }
        FileObject fileObject = Templates.getTemplate((WizardDescriptor)wizardDescriptor);
        wizardDescriptor.putProperty("name", (Object)fileObject.getName());
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(JavaEESamplesWizardIterator.class, (String)"LBL_Order", (Object[])new Object[]{new Integer(this.index + 1), new Integer(this.panels.length)});
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener changeListener) {
    }

    public final void removeChangeListener(ChangeListener changeListener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unZipFile(InputStream inputStream, FileObject fileObject) throws IOException {
        try {
            ZipEntry zipEntry;
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    FileUtil.createFolder((FileObject)fileObject, (String)zipEntry.getName());
                    continue;
                }
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                FileLock fileLock = fileObject2.lock();
                try {
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    try {
                        FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        }
        finally {
            inputStream.close();
        }
    }

    private static FileObject createFolder(File file) throws IOException {
        Stack<String> stack = new Stack<String>();
        while (!file.exists()) {
            stack.push(file.getName());
            file = file.getParentFile();
        }
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            JavaEESamplesWizardIterator.refreshFileSystem(file);
            fileObject = FileUtil.toFileObject((File)file);
        }
        assert (fileObject != null);
        while (!stack.isEmpty()) {
            fileObject = fileObject.createFolder((String)stack.pop());
        }
        return fileObject;
    }

    private static void refreshFileSystem(File file) throws FileStateInvalidException {
        File file2 = file;
        while (file2.getParentFile() != null) {
            file2 = file2.getParentFile();
        }
        FileObject fileObject = FileUtil.toFileObject((File)file2);
        assert (fileObject != null) : "At least disk roots must be mounted! " + file2;
        fileObject.getFileSystem().refresh(false);
    }
}

