/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.extensibility.model.impl;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.Element;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.model.visitor.SchemaVisitor;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.ModelSourceProvider;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.WSDLExtensibilityElement;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.WSDLExtensibilityElementInfo;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.WSDLExtensibilityElements;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.WSDLExtensibilityElementsFactory;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.XMLSchemaFileInfo;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.impl.ElementFinderVisitor;
import org.netbeans.modules.xml.wsdl.ui.extensibility.model.impl.XMLSchemaFileInfoImpl;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class ExtensibilityUtils {
    private static ModelSourceProvider mProvider;

    public static Schema readSchema(DataObject dataObject) {
        Schema schema = null;
        try {
            FileObject fileObject = dataObject.getPrimaryFile();
            ModelSource modelSource = null;
            modelSource = mProvider != null ? mProvider.getModelSource(fileObject, false) : Utilities.getModelSource((FileObject)fileObject, (boolean)false);
            SchemaModel schemaModel = SchemaModelFactory.getDefault().getModel(modelSource);
            if (schemaModel.getState() != Model.State.NOT_WELL_FORMED) {
                schema = schemaModel.getSchema();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return schema;
    }

    public static XMLSchemaFileInfo createXMLSchemaFileInfo(DataObject dataObject) {
        return new XMLSchemaFileInfoImpl(dataObject);
    }

    public static String getExtensibilityElementType(WSDLComponent wSDLComponent) {
        if (wSDLComponent instanceof Binding) {
            return "Binding";
        }
        if (wSDLComponent instanceof BindingOperation) {
            return "BindingOperation";
        }
        if (wSDLComponent instanceof BindingFault) {
            return "BindingOperationFault";
        }
        if (wSDLComponent instanceof BindingInput) {
            return "BindingOperationInput";
        }
        if (wSDLComponent instanceof BindingOutput) {
            return "BindingOperationOutput";
        }
        if (wSDLComponent instanceof Definitions) {
            return "Definitions";
        }
        if (wSDLComponent instanceof Message) {
            return "Message";
        }
        if (wSDLComponent instanceof Operation) {
            return "PortTypeOperation";
        }
        if (wSDLComponent instanceof Service) {
            return "Service";
        }
        if (wSDLComponent instanceof Port) {
            return "ServicePort";
        }
        return null;
    }

    public static Element getElement(ExtensibilityElement extensibilityElement) {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        ExtensibilityElement extensibilityElement2 = extensibilityElement;
        if (extensibilityElement2 != null) {
            arrayList.add(0, extensibilityElement2.getQName());
            while (ExtensibilityElement.class.isAssignableFrom(((WSDLComponent)extensibilityElement2.getParent()).getClass())) {
                extensibilityElement2 = (ExtensibilityElement)extensibilityElement2.getParent();
                arrayList.add(0, extensibilityElement2.getQName());
            }
        }
        String string = null;
        if (extensibilityElement.getParent() != null) {
            string = ExtensibilityUtils.getExtensibilityElementType(extensibilityElement2 != null ? (WSDLComponent)extensibilityElement2.getParent() : null);
        }
        if (string != null) {
            try {
                WSDLExtensibilityElementInfo wSDLExtensibilityElementInfo;
                WSDLExtensibilityElements wSDLExtensibilityElements = WSDLExtensibilityElementsFactory.getInstance().getWSDLExtensibilityElements();
                WSDLExtensibilityElement wSDLExtensibilityElement = wSDLExtensibilityElements.getWSDLExtensibilityElement(string);
                if (wSDLExtensibilityElement != null && arrayList.size() > 0 && (wSDLExtensibilityElementInfo = wSDLExtensibilityElement.getWSDLExtensibilityElementInfos((QName)arrayList.remove(0))) != null) {
                    GlobalElement globalElement = wSDLExtensibilityElementInfo.getElement();
                    ElementFinderVisitor elementFinderVisitor = new ElementFinderVisitor(arrayList);
                    globalElement.accept((SchemaVisitor)elementFinderVisitor);
                    return elementFinderVisitor.getElement();
                }
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        return null;
    }

    public static void setModelSourceProvider(ModelSourceProvider modelSourceProvider) {
        mProvider = modelSourceProvider;
    }

    public static String getExtensibilityElementType(QName qName) {
        if (qName == null || !qName.getNamespaceURI().equals("http://schemas.xmlsoap.org/wsdl/")) {
            return null;
        }
        String string = qName.getLocalPart();
        if ("binding".equals(string)) {
            return "Binding";
        }
        if ("operation".equals(string)) {
            return "BindingOperation";
        }
        if ("fault".equals(string)) {
            return "BindingOperationFault";
        }
        if ("input".equals(string)) {
            return "BindingOperationInput";
        }
        if ("output".equals(string)) {
            return "BindingOperationOutput";
        }
        if ("definitions".equals(string)) {
            return "Definitions";
        }
        if ("message".equals(string)) {
            return "Message";
        }
        if ("service".equals(string)) {
            return "Service";
        }
        if ("port".equals(string)) {
            return "ServicePort";
        }
        if ("operation".equals(string)) {
            return "PortTypeOperation";
        }
        return null;
    }
}

