/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.netbeans.module;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.JPanel;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.UIUtilities;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLColumn;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.NodesFactory;
import org.netbeans.modules.xml.xam.ui.column.BasicColumnView;
import org.netbeans.modules.xml.xam.ui.column.Column;
import org.netbeans.modules.xml.xam.ui.column.ColumnView;
import org.netbeans.modules.xml.xam.ui.column.LinkPanel;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLColumnsView
extends JPanel
implements ColumnView,
PropertyChangeListener {
    static final long serialVersionUID = 1L;
    private transient BasicColumnView columnView;
    private transient LinkPanel breadCrumbs = new LinkPanel((ColumnView)this);
    private transient WSDLModel wsdlModel;
    private transient Lookup lookup;
    private Class<? extends EventListener> columnListenerClass;
    private transient EventListener columnListener;
    public static final String PROP_COLUMN_ADDED = "column_added";

    public WSDLColumnsView(WSDLModel wSDLModel, Lookup lookup) {
        super(new BorderLayout());
        this.add((Component)this.breadCrumbs, "North");
        this.columnView = new BasicColumnView();
        this.add((Component)this.columnView, "Center");
        this.wsdlModel = wSDLModel;
        this.lookup = lookup;
        this.clearColumns();
        Node node = NodesFactory.getInstance().create((WSDLComponent)wSDLModel.getDefinitions());
        WSDLColumn wSDLColumn = this.createColumnComponent(node, true);
        this.appendColumn(wSDLColumn);
    }

    protected WSDLColumn createColumnComponent(Node node, boolean bl) {
        WSDLColumn wSDLColumn = new WSDLColumn(this, node, bl);
        this.addColumnListener(wSDLColumn);
        return wSDLColumn;
    }

    public void addColumnListener(WSDLColumn wSDLColumn) {
        if (this.columnListener != null || this.columnListenerClass != null) {
            try {
                Method method = WSDLColumn.class.getMethod("add" + this.columnListenerClass.getSimpleName(), this.columnListenerClass);
                method.invoke((Object)wSDLColumn, this.columnListener);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(16, (Throwable)exception);
            }
        }
    }

    public <L extends EventListener> void setColumnListener(Class<L> clazz, L l) {
        this.columnListenerClass = clazz;
        this.columnListener = l;
    }

    public EventListener getColumnListener() {
        return this.columnListener;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (propertyChangeEvent.getPropertyName().equals("title") && object instanceof Column) {
            this.breadCrumbs.updateLink((Column)object);
        }
    }

    public void showComponent(WSDLComponent wSDLComponent) {
        Object object;
        Object object2;
        Node node = null;
        Column column = this.getFirstColumn();
        ExplorerManager explorerManager = null;
        if (column instanceof ExplorerManager.Provider) {
            explorerManager = ((ExplorerManager.Provider)column).getExplorerManager();
        }
        if (explorerManager != null) {
            node = explorerManager.getRootContext();
        } else {
            object2 = NodesFactory.getInstance();
            Definitions definitions = this.wsdlModel.getDefinitions();
            node = ((NodesFactory)object2).create((WSDLComponent)definitions);
            this.clearColumns();
            column = this.createColumnComponent(node, false);
            this.appendColumn(column);
            explorerManager = ExplorerManager.find((Component)column.getComponent());
        }
        object2 = UIUtilities.findPathFromRoot(node, wSDLComponent);
        if (object2.isEmpty()) {
            return;
        }
        int n = 0;
        Column column2 = column;
        ExplorerManager explorerManager2 = explorerManager;
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            object = (Node)object3.next();
            boolean bl = false;
            while (explorerManager2 != null && explorerManager2.getRootContext() == object) {
                bl = true;
                column = column2;
                explorerManager = explorerManager2;
                if (!((column2 = this.getNextColumn(column2)) instanceof ExplorerManager.Provider)) break;
                explorerManager2 = ((ExplorerManager.Provider)column2).getExplorerManager();
            }
            if (bl) {
                ++n;
                continue;
            }
            this.removeColumnsAfter(column);
            try {
                explorerManager.setSelectedNodes(new Node[0]);
            }
            catch (PropertyVetoException propertyVetoException) {}
            break;
        }
        if (n < object2.size() - 1) {
            object3 = new ArrayList();
            for (Node node2 : object2.subList(n, object2.size() - 1)) {
                column = this.createColumnComponent(node2, true);
                object3.add(column);
            }
            object = object3.toArray(new Column[object3.size()]);
            this.appendColumns((Column[])object);
        }
        if (column instanceof ExplorerManager.Provider) {
            explorerManager = ((ExplorerManager.Provider)column).getExplorerManager();
        }
        try {
            if (explorerManager != null) {
                if (object2.size() <= 1) {
                    explorerManager.setSelectedNodes(new Node[0]);
                } else {
                    explorerManager.setSelectedNodes(new Node[]{(Node)object2.get(object2.size() - 1)});
                }
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void showComponent(SchemaComponent schemaComponent) {
        Object object;
        Node node = null;
        Column column = this.getFirstColumn();
        ExplorerManager explorerManager = null;
        if (column instanceof ExplorerManager.Provider) {
            explorerManager = ((ExplorerManager.Provider)column).getExplorerManager();
        }
        if (explorerManager != null) {
            node = explorerManager.getRootContext();
        } else {
            object = NodesFactory.getInstance();
            Definitions definitions = this.wsdlModel.getDefinitions();
            node = ((NodesFactory)object).create((WSDLComponent)definitions);
            this.clearColumns();
            column = this.createColumnComponent(node, false);
            this.appendColumn(column);
            explorerManager = ExplorerManager.find((Component)column.getComponent());
        }
        object = UIUtilities.findPathFromRoot(node, schemaComponent, this.wsdlModel);
        if (object.isEmpty()) {
            return;
        }
        int n = 0;
        Column column2 = column;
        ExplorerManager explorerManager2 = explorerManager;
        for (Object object2 : object.subList(0, object.size() - 1)) {
            boolean bl = false;
            while (explorerManager2 != null && explorerManager2.getRootContext() == object2) {
                bl = true;
                column = column2;
                explorerManager = explorerManager2;
                if (!((column2 = this.getNextColumn(column2)) instanceof ExplorerManager.Provider)) break;
                explorerManager2 = ((ExplorerManager.Provider)column2).getExplorerManager();
            }
            if (bl) {
                ++n;
                continue;
            }
            this.removeColumnsAfter(column);
            try {
                explorerManager.setSelectedNodes(new Node[0]);
            }
            catch (PropertyVetoException propertyVetoException) {}
            break;
        }
        if (n < object.size() - 1) {
            Object object2;
            ArrayList arrayList = new ArrayList();
            for (Node node2 : object.subList(n, object.size() - 1)) {
                column = this.createColumnComponent(node2, true);
                arrayList.add(column);
            }
            object2 = arrayList.toArray(new Column[arrayList.size()]);
            this.appendColumns((Column[])object2);
        }
        if (column instanceof ExplorerManager.Provider) {
            explorerManager = ((ExplorerManager.Provider)column).getExplorerManager();
        }
        try {
            if (explorerManager != null) {
                explorerManager.setSelectedNodes(new Node[]{(Node)object.get(object.size() - 1)});
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.columnView.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.columnView.requestFocusInWindow();
    }

    public void appendColumn(Column column) {
        column.addPropertyChangeListener((PropertyChangeListener)this);
        this.columnView.appendColumn(column);
        this.breadCrumbs.appendLink(column);
        this.firePropertyChange(PROP_COLUMN_ADDED, null, column);
    }

    public void appendColumns(Column[] columnArray) {
        for (Column column : columnArray) {
            column.addPropertyChangeListener((PropertyChangeListener)this);
            this.breadCrumbs.appendLink(column);
            this.firePropertyChange(PROP_COLUMN_ADDED, null, column);
        }
        this.columnView.appendColumns(columnArray);
    }

    public void clearColumns() {
        this.columnView.clearColumns();
        this.breadCrumbs.clearLinks();
    }

    public int getColumnCount() {
        return this.columnView.getColumnCount();
    }

    public int getColumnIndex(Column column) {
        return this.columnView.getColumnIndex(column);
    }

    public Column getFirstColumn() {
        return this.columnView.getFirstColumn();
    }

    public Column getNextColumn(Column column) {
        return this.columnView.getNextColumn(column);
    }

    public void removeColumnsAfter(Column column) {
        int n = this.columnView.getColumnIndex(column);
        this.columnView.removeColumnsAfter(column);
        this.breadCrumbs.truncateLinks(n + 1);
    }

    public void scrollToColumn(Column column, boolean bl) {
        this.columnView.scrollToColumn(column, bl);
    }
}

