/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.netbeans.module;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.validation.ShowCookie;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.SourceCookieProxyLookup;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.UIUtilities;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLDataObject;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLEditorSupport;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.WSDLMultiViewFactory;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.NodesFactory;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.WSDLElementNode;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class WSDLSourceMultiViewElement
extends CloneableEditor
implements MultiViewElement {
    private static final long serialVersionUID = 4403502726950453345L;
    private transient JComponent toolbar;
    private transient MultiViewElementCallback multiViewObserver;
    private WSDLDataObject wsdlDataObject;
    private Node rootNode;
    private Node selectedNode;
    private NodeAdapter nl;
    private Timer timerSelNodes;
    private CaretListener caretListener;
    private transient RequestProcessor.Task selectionTask = null;

    public WSDLSourceMultiViewElement() {
    }

    public WSDLSourceMultiViewElement(WSDLDataObject wSDLDataObject) {
        super((CloneableEditorSupport)wSDLDataObject.getWSDLEditorSupport());
        this.wsdlDataObject = wSDLDataObject;
        wSDLDataObject.getWSDLEditorSupport().initializeCloneableEditor(this);
        this.initialize();
    }

    private void initialize() {
        ShowCookie showCookie = new ShowCookie(){

            public void show(Validator.ResultItem resultItem) {
                if (WSDLSourceMultiViewElement.this.isActiveTC()) {
                    Component component = resultItem.getComponents();
                    if (component.getModel() == null) {
                        return;
                    }
                    UIUtilities.annotateSourceView(WSDLSourceMultiViewElement.this.wsdlDataObject, (DocumentComponent)component, resultItem.getDescription(), true);
                    if (component instanceof WSDLComponent) {
                        int n = ((WSDLComponent)component).findPosition();
                        WSDLSourceMultiViewElement.this.getEditorPane().setCaretPosition(n);
                    } else {
                        int n = resultItem.getLineNumber();
                        try {
                            int n2 = NbDocument.findLineOffset((StyledDocument)((StyledDocument)WSDLSourceMultiViewElement.this.getEditorPane().getDocument()), (int)n);
                            WSDLSourceMultiViewElement.this.getEditorPane().setCaretPosition(n2);
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        Node node = this.wsdlDataObject.getNodeDelegate();
        SourceCookieProxyLookup sourceCookieProxyLookup = new SourceCookieProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{this.getActionMap(), this.wsdlDataObject, showCookie})}, node);
        this.associateLookup((Lookup)sourceCookieProxyLookup);
        this.addPropertyChangeListener("activatedNodes", sourceCookieProxyLookup);
        this.caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                WSDLSourceMultiViewElement.this.timerSelNodes.restart();
            }
        };
        this.timerSelNodes = new Timer(1, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!WSDLSourceMultiViewElement.this.isActiveTC() || WSDLSourceMultiViewElement.this.getEditorPane() == null) {
                    return;
                }
                WSDLSourceMultiViewElement.this.selectElementsAtOffset();
            }
        });
        this.timerSelNodes.setRepeats(false);
    }

    public JComponent getToolbarRepresentation() {
        Document document = this.getEditorPane().getDocument();
        if (document instanceof NbDocument.CustomToolbar) {
            if (this.toolbar == null) {
                this.toolbar = ((NbDocument.CustomToolbar)document).createToolbar(this.getEditorPane());
            }
            return this.toolbar;
        }
        return null;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.multiViewObserver = multiViewElementCallback;
    }

    public void requestVisible() {
        if (this.multiViewObserver != null) {
            this.multiViewObserver.requestVisible();
        } else {
            super.requestVisible();
        }
    }

    public void requestActive() {
        if (this.multiViewObserver != null) {
            this.multiViewObserver.requestActive();
        } else {
            super.requestActive();
        }
    }

    protected String preferredID() {
        return "WSDLSourceMultiViewElementTC";
    }

    public UndoRedo getUndoRedo() {
        return this.wsdlDataObject.getWSDLEditorSupport().getUndoManager();
    }

    protected boolean closeLast() {
        WSDLEditorSupport wSDLEditorSupport = this.wsdlDataObject.getWSDLEditorSupport();
        JEditorPane[] jEditorPaneArray = wSDLEditorSupport.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length == 0) {
            return wSDLEditorSupport.silentClose();
        }
        return false;
    }

    public CloseOperationState canCloseElement() {
        if (!WSDLEditorSupport.isLastView(this.multiViewObserver.getTopComponent())) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)"ID_TEXT_CLOSING", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    public void componentActivated() {
        JEditorPane jEditorPane = this.getEditorPane();
        if (jEditorPane != null) {
            jEditorPane.addCaretListener(this.caretListener);
        }
        if (this.timerSelNodes != null) {
            this.timerSelNodes.restart();
        }
        super.componentActivated();
        WSDLEditorSupport wSDLEditorSupport = this.wsdlDataObject.getWSDLEditorSupport();
        wSDLEditorSupport.addUndoManagerToDocument();
        WSDLMultiViewFactory.updateGroupVisibility("wsdl-sourceview");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentDeactivated() {
        JEditorPane jEditorPane = this.getEditorPane();
        if (jEditorPane != null) {
            jEditorPane.removeCaretListener(this.caretListener);
        }
        Object object = this;
        synchronized (object) {
            if (this.selectionTask != null) {
                this.selectionTask.cancel();
                this.selectionTask = null;
            }
        }
        if (this.timerSelNodes != null) {
            this.timerSelNodes.stop();
        }
        super.componentDeactivated();
        object = this.wsdlDataObject.getWSDLEditorSupport();
        ((WSDLEditorSupport)object).syncModel();
        ((WSDLEditorSupport)object).removeUndoManagerFromDocument();
        WSDLMultiViewFactory.updateGroupVisibility("wsdl-sourceview");
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentClosed() {
        super.componentClosed();
        this.cleanup();
    }

    private void cleanup() {
        this.rootNode = null;
        if (this.selectedNode != null) {
            this.selectedNode.removeNodeListener((NodeListener)this.nl);
        }
        this.nl = null;
        this.selectedNode = null;
        this.toolbar = null;
        this.setActivatedNodes(new Node[0]);
        this.caretListener = null;
        this.multiViewObserver = null;
    }

    public void componentShowing() {
        super.componentShowing();
        WSDLEditorSupport wSDLEditorSupport = this.wsdlDataObject.getWSDLEditorSupport();
        wSDLEditorSupport.addUndoManagerToDocument();
    }

    public void componentHidden() {
        super.componentHidden();
        WSDLEditorSupport wSDLEditorSupport = this.wsdlDataObject.getWSDLEditorSupport();
        wSDLEditorSupport.syncModel();
        wSDLEditorSupport.removeUndoManagerFromDocument();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject((Object)this.wsdlDataObject);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof WSDLDataObject) {
            this.wsdlDataObject = (WSDLDataObject)((Object)object);
            this.initialize();
        }
    }

    void selectElementsAtOffset() {
        if (this.selectionTask != null) {
            this.selectionTask.cancel();
            this.selectionTask = null;
        }
        RequestProcessor requestProcessor = new RequestProcessor("WSDL Source view processor " + ((Object)((Object)this)).hashCode());
        this.selectionTask = requestProcessor.create(new Runnable(){

            public void run() {
                if (!WSDLSourceMultiViewElement.this.isActiveTC() || WSDLSourceMultiViewElement.this.wsdlDataObject == null || !WSDLSourceMultiViewElement.this.wsdlDataObject.isValid() || WSDLSourceMultiViewElement.this.wsdlDataObject.isTemplate()) {
                    return;
                }
                Node node = WSDLSourceMultiViewElement.this.findNode(WSDLSourceMultiViewElement.this.getEditorPane().getCaret().getDot());
                if (node == null) {
                    WSDLSourceMultiViewElement.this.setActivatedNodes(new Node[]{WSDLSourceMultiViewElement.this.wsdlDataObject.getNodeDelegate()});
                } else if (WSDLSourceMultiViewElement.this.selectedNode != node) {
                    if (WSDLSourceMultiViewElement.this.nl == null) {
                        WSDLSourceMultiViewElement.this.nl = new NodeAdapter(){

                            public void nodeDestroyed(NodeEvent nodeEvent) {
                                if (nodeEvent.getNode() == WSDLSourceMultiViewElement.this.selectedNode) {
                                    EventQueue.invokeLater(new Runnable(){

                                        public void run() {
                                            WSDLSourceMultiViewElement.this.selectElementsAtOffset();
                                        }
                                    });
                                }
                            }
                        };
                    } else if (WSDLSourceMultiViewElement.this.selectedNode != null) {
                        WSDLSourceMultiViewElement.this.selectedNode.removeNodeListener((NodeListener)WSDLSourceMultiViewElement.this.nl);
                    }
                    WSDLSourceMultiViewElement.this.selectedNode = node;
                    WSDLSourceMultiViewElement.this.selectedNode.addNodeListener((NodeListener)WSDLSourceMultiViewElement.this.nl);
                    WSDLSourceMultiViewElement.this.setActivatedNodes(new Node[]{WSDLSourceMultiViewElement.this.selectedNode});
                }
            }
        });
        if (EventQueue.isDispatchThread()) {
            this.selectionTask.run();
        } else {
            EventQueue.invokeLater((Runnable)this.selectionTask);
        }
    }

    private Node findNode(int n) {
        WSDLElementNode wSDLElementNode;
        WSDLEditorSupport wSDLEditorSupport = this.wsdlDataObject.getWSDLEditorSupport();
        if (wSDLEditorSupport == null) {
            return null;
        }
        WSDLModel wSDLModel = wSDLEditorSupport.getModel();
        if (wSDLModel == null || wSDLModel.getState() != Model.State.VALID) {
            return null;
        }
        if (this.rootNode != null && (wSDLElementNode = (WSDLElementNode)this.rootNode.getCookie(WSDLElementNode.class)) != null && !wSDLElementNode.isSameAsMyWSDLElement((Component)wSDLModel.getDefinitions())) {
            this.rootNode = null;
        }
        if (this.rootNode == null) {
            this.rootNode = NodesFactory.getInstance().create((WSDLComponent)wSDLModel.getDefinitions());
        }
        if (this.rootNode == null) {
            return null;
        }
        wSDLElementNode = wSDLEditorSupport.getModel().findComponent(n);
        if (wSDLElementNode == null) {
            return null;
        }
        List<Node> list = null;
        if (WSDLComponent.class.isInstance(wSDLElementNode)) {
            list = UIUtilities.findPathFromRoot(this.rootNode, (WSDLComponent)wSDLElementNode);
        } else if (SchemaComponent.class.isInstance(wSDLElementNode)) {
            list = UIUtilities.findPathFromRoot(this.rootNode, (SchemaComponent)wSDLElementNode, wSDLModel);
        }
        if (list != null && !list.isEmpty()) {
            return list.get(list.size() - 1);
        }
        return null;
    }

    protected boolean isActiveTC() {
        if (this.multiViewObserver != null) {
            return WSDLSourceMultiViewElement.getRegistry().getActivated() == this.multiViewObserver.getTopComponent();
        }
        return false;
    }
}

