/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import org.netbeans.modules.xml.wsdl.bindingsupport.template.localized.LocalizedTemplate;
import org.netbeans.modules.xml.wsdl.bindingsupport.template.localized.LocalizedTemplateGroup;
import org.netbeans.modules.xml.wsdl.ui.view.TemplatePanel;

public class BindingSubTypePanel
extends JPanel {
    private LocalizedTemplateGroup mLtg;
    private List<TemplatePanel> mPanels = new ArrayList<TemplatePanel>();
    private ActionListener mButtonActionListener;
    private ButtonGroup buttonGroup1;

    public BindingSubTypePanel(LocalizedTemplateGroup localizedTemplateGroup, ActionListener actionListener) {
        this.mLtg = localizedTemplateGroup;
        this.mButtonActionListener = actionListener;
        this.initComponents();
        this.initGUI();
    }

    void setPanelEnabled(boolean bl) {
        Enumeration<AbstractButton> enumeration = this.buttonGroup1.getElements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setEnabled(bl);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.setLayout(new BoxLayout(this, 1));
    }

    private void initGUI() {
        boolean bl = false;
        LocalizedTemplate[] localizedTemplateArray = this.mLtg.getTemplate();
        for (int i = 0; i < localizedTemplateArray.length; ++i) {
            LocalizedTemplate localizedTemplate = localizedTemplateArray[i];
            TemplatePanel templatePanel = new TemplatePanel(localizedTemplate, this.buttonGroup1);
            templatePanel.getRadioButton().addActionListener(this.mButtonActionListener);
            this.mPanels.add(templatePanel);
            this.add(templatePanel);
            if (!localizedTemplate.getDelegate().isDefault()) continue;
            this.setSelectedTemplateName(localizedTemplateArray[i].getName());
            bl = true;
        }
        if (!bl && localizedTemplateArray.length > 0) {
            this.setSelectedTemplateName(localizedTemplateArray[0].getName());
        }
    }

    public LocalizedTemplate getBindingSubType() {
        for (TemplatePanel templatePanel : this.mPanels) {
            if (!templatePanel.isSelected()) continue;
            return templatePanel.getTemplate();
        }
        return null;
    }

    public void reset(LocalizedTemplateGroup localizedTemplateGroup) {
        this.removeAll();
        for (TemplatePanel templatePanel : this.mPanels) {
            templatePanel.getRadioButton().removeActionListener(this.mButtonActionListener);
        }
        this.mPanels.clear();
        this.mLtg = localizedTemplateGroup;
        this.initGUI();
        this.revalidate();
    }

    public void setSelectedTemplateName(String string) {
        Enumeration<AbstractButton> enumeration = this.buttonGroup1.getElements();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                AbstractButton abstractButton = enumeration.nextElement();
                if (!abstractButton.getActionCommand().equals(string)) continue;
                abstractButton.setSelected(true);
            }
        }
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup1;
    }
}

