/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.border;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.RoundRectangle2D;
import org.netbeans.api.visual.border.Border;

public class RoundDashedBorder
implements Border {
    private int mArcWidth;
    private int mArcHeight;
    float[] mDash;
    int mThickness = 0;
    Insets mInsets;
    Color mFillColor;
    Color mDrawColor;
    Stroke mStroke;

    public RoundDashedBorder(int n, int n2, float[] fArray, int n3, Insets insets, Color color, Color color2) {
        this.mArcWidth = n;
        this.mArcHeight = n2;
        this.mDash = fArray;
        this.mThickness = n3;
        this.mInsets = insets;
        this.mFillColor = color;
        this.mDrawColor = color2;
        if (n3 < 1) {
            throw new IllegalArgumentException("Invalid thickness: " + n3);
        }
        this.mStroke = new BasicStroke(this.mThickness, 0, 1, 0.0f, this.mDash, 0.0f);
    }

    public Insets getInsets() {
        if (this.mInsets == null) {
            this.mInsets = new Insets(this.mThickness, this.mThickness, this.mThickness, this.mThickness);
        }
        return this.mInsets;
    }

    public void paint(Graphics2D graphics2D, Rectangle rectangle) {
        Stroke stroke = graphics2D.getStroke();
        Color color = graphics2D.getColor();
        graphics2D.setStroke(this.mStroke);
        if (this.mFillColor != null) {
            graphics2D.setColor(this.mFillColor);
            graphics2D.fill(new RoundRectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.mArcWidth, this.mArcHeight));
        }
        if (this.mDrawColor != null) {
            graphics2D.setColor(this.mDrawColor);
            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width - this.mThickness, rectangle.height - this.mThickness);
        }
    }

    public boolean isOpaque() {
        return true;
    }
}

