/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.xml.namespace.QName;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.BPELQName;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.PartnerLinkType;
import org.netbeans.modules.xml.wsdl.model.extensions.bpel.Role;
import org.netbeans.modules.xml.wsdl.ui.actions.ActionHelper;
import org.netbeans.modules.xml.wsdl.ui.actions.NameGenerator;
import org.netbeans.modules.xml.wsdl.ui.netbeans.module.Utility;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.actions.WidgetEditCookie;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.border.FilledBorder;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.ButtonWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.DnDHandler;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.ImageLabelWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.PartnerLinkTypeWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.PartnerScene;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.StubWidget;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetConstants;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetFactory;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetFilterNode;
import org.netbeans.modules.xml.wsdl.ui.view.grapheditor.widget.WidgetHelper;
import org.netbeans.modules.xml.wsdl.ui.view.treeeditor.ExtensibilityElementsFolderNode;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollaborationsWidget
extends Widget
implements DnDHandler,
PopupMenuProvider {
    private final WSDLModel mModel;
    private final Widget mCollaborationContentWidget;
    private Image IMAGE = Utilities.loadImage((String)"org/netbeans/modules/xml/wsdl/ui/view/grapheditor/palette/resources/partnerlinkTypesFolder.png");
    public static final Border MAIN_BORDER = new FilledBorder(1, 1, 8, 8, new Color(0x888888), Color.WHITE);
    private final ImageLabelWidget mLabelWidget;
    private final Widget mHeaderWidget;
    private ButtonWidget createButtonWidget;
    private PartnerLinkTypeHitPointWidget partnerLinkTypeHitPoint;
    private Object draggedObject = null;
    private int partnerLinkTypesHitPointIndex = -1;
    private Widget stubWidget;
    private Node componentNode;
    private ButtonWidget addButtonWidget;

    public CollaborationsWidget(Scene scene, WSDLModel wSDLModel) {
        super(scene);
        this.mModel = wSDLModel;
        this.partnerLinkTypeHitPoint = new PartnerLinkTypeHitPointWidget(scene);
        this.partnerLinkTypeHitPoint.setMinimumSize(new Dimension(625, 0));
        this.stubWidget = new StubWidget(scene, NbBundle.getMessage(CollaborationsWidget.class, (String)"LBL_CollaborationsWidget_ThereAreNoPartnerLinkTypes"));
        this.stubWidget.setMinimumSize(new Dimension(625, 0));
        this.setOpaque(true);
        this.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)15));
        this.setBorder(new EmptyBorder(20, 20, 40, 20));
        this.mHeaderWidget = new Widget(scene);
        this.mHeaderWidget.setMinimumSize(new Dimension(700, 0));
        this.mLabelWidget = new ImageLabelWidget(this.getScene(), this.IMAGE, NbBundle.getMessage(CollaborationsWidget.class, (String)"LBL_CollaborationsWidget_PartnerLinkTypes"), "(" + this.mModel.getDefinitions().getExtensibilityElements(PartnerLinkType.class).size() + ")");
        this.mHeaderWidget.setLayout(WidgetConstants.HEADER_LAYOUT);
        this.mHeaderWidget.setBorder(WidgetConstants.HEADER_BORDER);
        this.addChild(this.mHeaderWidget);
        this.mHeaderWidget.addChild((Widget)this.mLabelWidget);
        this.mHeaderWidget.addChild(this.createActionWidget(scene));
        this.mCollaborationContentWidget = new Widget(scene);
        this.addChild(this.mCollaborationContentWidget);
        this.mCollaborationContentWidget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)16));
        this.getActions().addAction(((PartnerScene)scene).getDnDAction());
        this.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)this));
        this.createContent();
        this.collapsePartnerLinkTypeWidgets();
    }

    private Widget createActionWidget(Scene scene) {
        Widget widget = new Widget(scene);
        widget.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)8));
        this.createButtonWidget = new ButtonWidget(scene, NbBundle.getMessage(CollaborationsWidget.class, (String)"LBL_CollaborationsWidget_AutoCreate"), true);
        this.createButtonWidget.setActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                WSDLComponentFactory wSDLComponentFactory = CollaborationsWidget.this.mModel.getFactory();
                QName qName = BPELQName.PARTNER_LINK_TYPE.getQName();
                try {
                    if (CollaborationsWidget.this.mModel.startTransaction()) {
                        Definitions definitions = CollaborationsWidget.this.mModel.getDefinitions();
                        Collection collection = CollaborationsWidget.this.getUnusedPortTypes();
                        for (PortType portType : collection) {
                            PartnerLinkType partnerLinkType = (PartnerLinkType)wSDLComponentFactory.create((WSDLComponent)definitions, qName);
                            String string = portType.getName();
                            if (string == null) continue;
                            int n = string.toLowerCase().indexOf("porttype");
                            if (n > 0) {
                                string = string.substring(0, n);
                            }
                            partnerLinkType.setName(NameGenerator.generateUniquePartnerLinkType(string, qName, CollaborationsWidget.this.mModel));
                            definitions.addExtensibilityElement((ExtensibilityElement)partnerLinkType);
                            Role role = (Role)wSDLComponentFactory.create((WSDLComponent)partnerLinkType, BPELQName.ROLE.getQName());
                            role.setName("role1");
                            partnerLinkType.setRole1(role);
                            NamedComponentReference namedComponentReference = role.createReferenceTo((ReferenceableWSDLComponent)portType, PortType.class);
                            role.setPortType(namedComponentReference);
                        }
                    }
                }
                finally {
                    CollaborationsWidget.this.mModel.endTransaction();
                }
            }
        });
        widget.addChild((Widget)this.createButtonWidget);
        this.addButtonWidget = new ButtonWidget(scene, NbBundle.getMessage(CollaborationsWidget.class, (String)"LBL_CollaborationsWidget_AddPartnerLinkType"), true);
        this.addButtonWidget.setActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CollaborationsWidget.this.addOrInsertPartnerLinkType(CollaborationsWidget.this.mModel.getDefinitions().getExtensibilityElements(PartnerLinkType.class).size());
            }
        });
        widget.addChild((Widget)this.addButtonWidget);
        return widget;
    }

    public Object hashKey() {
        return this.mModel.getDefinitions().getName();
    }

    private void update() {
        int n = this.mModel.getDefinitions().getExtensibilityElements(PartnerLinkType.class).size();
        this.mLabelWidget.setComment("(" + n + ")");
        Collection<PortType> collection = this.getUnusedPortTypes();
        this.createButtonWidget.setVisible(collection.size() > 0);
        if (n == 0) {
            this.mCollaborationContentWidget.addChild(this.stubWidget);
        } else {
            this.stubWidget.removeFromParent();
        }
    }

    public void updateContent(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("extensibilityElement")) {
            Object object = propertyChangeEvent.getNewValue();
            if (object != null && object instanceof PartnerLinkType) {
                this.update();
                if (propertyChangeEvent.getOldValue() == null) {
                    PartnerLinkType partnerLinkType;
                    PartnerLinkType partnerLinkType2 = (PartnerLinkType)object;
                    Widget widget = WidgetFactory.getInstance().getOrCreateWidget(this.getScene(), (WSDLComponent)partnerLinkType2, this.mCollaborationContentWidget);
                    List list = this.mModel.getDefinitions().getExtensibilityElements(PartnerLinkType.class);
                    int n = 0;
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext() && (partnerLinkType = (PartnerLinkType)iterator.next()) != partnerLinkType2) {
                        ++n;
                    }
                    if (n > this.mCollaborationContentWidget.getChildren().size()) {
                        this.mCollaborationContentWidget.addChild(widget);
                    } else {
                        this.mCollaborationContentWidget.addChild(n, widget);
                    }
                }
            } else {
                object = propertyChangeEvent.getOldValue();
                if (object != null && object instanceof PartnerLinkType) {
                    this.update();
                    WidgetHelper.removeObjectFromScene(this.getScene(), object);
                }
            }
            this.getScene().validate();
        }
    }

    private void createContent() {
        Object object;
        List list = this.mModel.getDefinitions().getExtensibilityElements(PartnerLinkType.class);
        if (list == null || list.isEmpty()) {
            this.mCollaborationContentWidget.addChild(this.stubWidget);
        } else {
            object = this.getScene();
            WidgetFactory widgetFactory = WidgetFactory.getInstance();
            for (PartnerLinkType partnerLinkType : list) {
                Widget widget = widgetFactory.getOrCreateWidget((Scene)object, (WSDLComponent)partnerLinkType, this.mCollaborationContentWidget);
                this.mCollaborationContentWidget.addChild(widget);
            }
        }
        object = this.getUnusedPortTypes();
        this.createButtonWidget.setVisible(object.size() > 0);
    }

    private boolean hasPartnerLinkTypes() {
        List list = this.mModel.getDefinitions().getExtensibilityElements(PartnerLinkType.class);
        return list == null || !list.isEmpty();
    }

    private void collapsePartnerLinkTypeWidgets() {
        for (Widget widget : this.mCollaborationContentWidget.getChildren()) {
            if (!(widget instanceof PartnerLinkTypeWidget)) continue;
            ((PartnerLinkTypeWidget)widget).collapseWidget();
        }
    }

    @Override
    public void dragExit() {
        this.hideHitPoint();
        this.getScene().validate();
    }

    @Override
    public boolean dragOver(Point point, WidgetAction.WidgetDropTargetDragEvent widgetDropTargetDragEvent) {
        Node node;
        Transferable transferable = widgetDropTargetDragEvent.getTransferable();
        if (transferable != null && (node = Utility.getPaletteNode(transferable)) != null && node.getName().startsWith("PartnerLinkType")) {
            this.showHitPoint(point, node);
            this.getScene().validate();
            return true;
        }
        return false;
    }

    @Override
    public boolean drop(Point point, WidgetAction.WidgetDropTargetDropEvent widgetDropTargetDropEvent) {
        Node node = (Node)this.draggedObject;
        int n = this.partnerLinkTypesHitPointIndex;
        this.hideHitPoint();
        this.getScene().validate();
        if (node != null && n >= 0) {
            this.addOrInsertPartnerLinkType(n);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrInsertPartnerLinkType(int n) {
        Object object;
        PartnerLinkType partnerLinkType = null;
        try {
            if (this.mModel.startTransaction()) {
                object = this.mModel.getDefinitions().getExtensibilityElements(PartnerLinkType.class).toArray(new PartnerLinkType[0]);
                partnerLinkType = (PartnerLinkType)this.mModel.getFactory().create((WSDLComponent)this.mModel.getDefinitions(), BPELQName.PARTNER_LINK_TYPE.getQName());
                String string = NameGenerator.generateUniquePartnerLinkType(null, BPELQName.PARTNER_LINK_TYPE.getQName(), this.mModel);
                partnerLinkType.setName(string);
                Role role = (Role)this.mModel.getFactory().create((WSDLComponent)partnerLinkType, BPELQName.ROLE.getQName());
                role.setName("role1");
                partnerLinkType.setRole1(role);
                if (n == ((Object)object).length) {
                    this.mModel.getDefinitions().addExtensibilityElement((ExtensibilityElement)partnerLinkType);
                } else {
                    Utility.insertIntoDefinitionsAtIndex(n, this.mModel, (WSDLComponent)partnerLinkType, "extensibilityElement");
                }
            }
        }
        finally {
            this.mModel.endTransaction();
        }
        ActionHelper.selectNode(partnerLinkType);
        object = (WidgetEditCookie)WidgetHelper.getWidgetLookup(partnerLinkType, this.getScene()).lookup(WidgetEditCookie.class);
        if (object != null) {
            object.edit();
        }
    }

    @Override
    public void expandForDragAndDrop() {
        this.setVisible(true);
    }

    @Override
    public boolean isCollapsed() {
        return !this.isVisible();
    }

    private void showHitPoint(Point point, Object object) {
        this.draggedObject = object;
        List<PartnerLinkTypeWidget> list = this.getPartnerLinkTypeWidgets();
        if (list == null) {
            return;
        }
        int n = this.placeHolderIndex(point);
        if (n < 0) {
            return;
        }
        this.partnerLinkTypesHitPointIndex = n;
        if (this.partnerLinkTypeHitPoint.getParentWidget() != null) {
            this.partnerLinkTypeHitPoint.getParentWidget().removeChild((Widget)this.partnerLinkTypeHitPoint);
        }
        this.stubWidget.removeFromParent();
        this.mCollaborationContentWidget.addChild(this.partnerLinkTypesHitPointIndex, (Widget)this.partnerLinkTypeHitPoint);
    }

    private void hideHitPoint() {
        this.partnerLinkTypeHitPoint.removeFromParent();
        if (!this.hasPartnerLinkTypes() && this.stubWidget.getParentWidget() == null) {
            this.mCollaborationContentWidget.addChild(this.stubWidget);
        }
        this.partnerLinkTypesHitPointIndex = -1;
        this.draggedObject = null;
    }

    private Collection<PortType> getUnusedPortTypes() {
        PortType portType;
        Definitions definitions;
        WSDLModel wSDLModel;
        Object object;
        Object object22;
        ArrayList<PortType> arrayList = new ArrayList<PortType>();
        Definitions definitions2 = this.mModel.getDefinitions();
        Collection collection = definitions2.getPortTypes();
        if (collection != null) {
            for (Object object22 : collection) {
                if (object22.getName() == null) continue;
                arrayList.add((PortType)object22);
            }
        }
        Collection collection2 = definitions2.getImports();
        object22 = collection2.iterator();
        while (object22.hasNext()) {
            object = (Import)object22.next();
            try {
                wSDLModel = object.getImportedWSDLModel();
                definitions = wSDLModel.getDefinitions();
                collection = definitions.getPortTypes();
                portType = collection.iterator();
                while (portType.hasNext()) {
                    PortType portType2 = (PortType)portType.next();
                    if (portType2.getName() == null) continue;
                    arrayList.add(portType2);
                }
            }
            catch (CatalogModelException catalogModelException) {
            }
        }
        object22 = definitions2.getExtensibilityElements(PartnerLinkType.class);
        if (object22 != null && object22.size() > 0 && arrayList != null && arrayList.size() > 0) {
            object = object22.iterator();
            while (object.hasNext()) {
                wSDLModel = (PartnerLinkType)object.next();
                definitions = this.getPortType(wSDLModel.getRole1());
                if (definitions != null) {
                    arrayList.remove(definitions);
                }
                if ((portType = this.getPortType(wSDLModel.getRole2())) == null) continue;
                arrayList.remove(portType);
            }
        }
        return arrayList;
    }

    private PortType getPortType(Role role) {
        NamedComponentReference namedComponentReference;
        if (role != null && (namedComponentReference = role.getPortType()) != null) {
            return (PortType)namedComponentReference.get();
        }
        return null;
    }

    private List<PartnerLinkTypeWidget> getPartnerLinkTypeWidgets() {
        if (this.mCollaborationContentWidget.getParentWidget() == null) {
            return null;
        }
        ArrayList<PartnerLinkTypeWidget> arrayList = new ArrayList<PartnerLinkTypeWidget>();
        for (Widget widget : this.mCollaborationContentWidget.getChildren()) {
            if (!(widget instanceof PartnerLinkTypeWidget)) continue;
            arrayList.add((PartnerLinkTypeWidget)widget);
        }
        return arrayList;
    }

    private int placeHolderIndex(Point point) {
        List<PartnerLinkTypeWidget> list = this.getPartnerLinkTypeWidgets();
        if (list.size() == 0) {
            return 0;
        }
        if (this.partnerLinkTypeHitPoint.getParentWidget() != null && this.partnerLinkTypeHitPoint.isHitAt(this.partnerLinkTypeHitPoint.convertSceneToLocal(point))) {
            return -1;
        }
        for (int i = 0; i < list.size(); ++i) {
            PartnerLinkTypeWidget partnerLinkTypeWidget = list.get(i);
            Point point2 = partnerLinkTypeWidget.convertSceneToLocal(point);
            Rectangle rectangle = partnerLinkTypeWidget.getBounds();
            if (!((double)point2.y < rectangle.getCenterY())) continue;
            return i;
        }
        return list.size();
    }

    protected TopComponent findTopComponent() {
        return (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this.getScene().getView());
    }

    private synchronized Node getNode() {
        if (this.componentNode == null) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("http://docs.oasis-open.org/wsbpel/2.0/plnktype");
            this.componentNode = new ExtensibilityElementsFolderNode(this.mModel.getDefinitions(), hashSet);
            this.componentNode = new WidgetFilterNode(this.componentNode);
        }
        return this.componentNode;
    }

    public JPopupMenu getPopupMenu(Widget widget, Point point) {
        Node node = this.getNode();
        if (node != null) {
            Lookup lookup;
            TopComponent topComponent = this.findTopComponent();
            if (topComponent != null) {
                topComponent.setActivatedNodes(new Node[]{node});
                lookup = topComponent.getLookup();
            } else {
                lookup = Lookup.EMPTY;
            }
            Action[] actionArray = node.getActions(true);
            return Utilities.actionsToPopup((Action[])actionArray, (Lookup)lookup);
        }
        return null;
    }

    private static class PartnerLinkTypeHitPointBorder
    implements Border {
        private PartnerLinkTypeHitPointBorder() {
        }

        public Insets getInsets() {
            return new Insets(8, 8, 8, 8);
        }

        public void paint(Graphics2D graphics2D, Rectangle rectangle) {
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
            graphics2D.setPaint(Color.WHITE);
            graphics2D.fill(rectangle);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setPaint(WidgetConstants.HIT_POINT_BORDER);
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.drawRoundRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2, 6, 6);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
        }

        public boolean isOpaque() {
            return true;
        }
    }

    private class PartnerLinkTypeHitPointWidget
    extends LabelWidget {
        public PartnerLinkTypeHitPointWidget(Scene scene) {
            super(scene, " ");
            this.setBorder(new PartnerLinkTypeHitPointBorder());
            this.setFont(scene.getDefaultFont());
        }
    }
}

