/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.view.ImportSchemaCustomizer;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceDataNode;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

public class ImportSchemaCreator
extends ImportSchemaCustomizer {
    private static final long serialVersionUID = 1L;
    private List<String> selectedFiles;
    private boolean ignorePropertyChange;

    public ImportSchemaCreator(Schema schema, WSDLModel wSDLModel, String string) {
        super(schema, wSDLModel);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.selectedFiles = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            this.selectedFiles.add(stringTokenizer.nextToken());
        }
    }

    protected boolean allowEmptySelection() {
        return true;
    }

    public void applyChanges() throws IOException {
    }

    public ExternalReferenceDataNode createExternalReferenceNode(Node node) {
        DataObject dataObject;
        String string;
        ExternalReferenceDataNode externalReferenceDataNode = super.createExternalReferenceNode(node);
        if (this.selectedFiles != null && this.selectedFiles.contains(string = ImportSchemaCreator.dataObjectToURI(dataObject = (DataObject)externalReferenceDataNode.getLookup().lookup(DataObject.class)))) {
            this.ignorePropertyChange = true;
            externalReferenceDataNode.setSelected(true);
            this.ignorePropertyChange = false;
        }
        return externalReferenceDataNode;
    }

    private static String dataObjectToURI(DataObject dataObject) {
        FileObject fileObject = dataObject.getPrimaryFile();
        File file = FileUtil.toFile((FileObject)fileObject);
        return file.toURI().normalize().toString();
    }

    public String getSelectedFiles() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.selectedFiles) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (!this.ignorePropertyChange && propertyChangeEvent.getPropertyName().equals("selected")) {
            ExternalReferenceDataNode externalReferenceDataNode = (ExternalReferenceDataNode)propertyChangeEvent.getSource();
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            DataObject dataObject = (DataObject)externalReferenceDataNode.getLookup().lookup(DataObject.class);
            String string = ImportSchemaCreator.dataObjectToURI(dataObject);
            if (bl) {
                this.selectedFiles.add(string);
            } else {
                this.selectedFiles.remove(string);
            }
        }
    }
}

