/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.wizard;

import java.awt.Component;
import java.awt.Container;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.netbeans.modules.xml.catalogsupport.DefaultProjectCatalogSupport;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelReference;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.xsd.WSDLSchema;
import org.netbeans.modules.xml.wsdl.ui.wizard.Utilities;
import org.netbeans.modules.xml.wsdl.ui.wizard.WizardBindingConfigurationStep;
import org.netbeans.modules.xml.wsdl.ui.wizard.WizardNewWSDLStep;
import org.netbeans.modules.xml.wsdl.ui.wizard.WizardPortTypeConfigurationStep;
import org.netbeans.modules.xml.wsdl.ui.wizard.WsdlPanel;
import org.netbeans.modules.xml.wsdl.ui.wizard.WsdlUIPanel;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NewWSDLWizardIterator
implements TemplateWizard.Iterator {
    private int index;
    private WizardDescriptor.Panel[] panels;
    private WizardDescriptor.Panel folderPanel;
    private static final Logger logger = Logger.getLogger(NewWSDLWizardIterator.class.getName());

    private WizardDescriptor.Panel[] createPanels(Project project, TemplateWizard templateWizard) {
        DataFolder dataFolder;
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        arrayList.addAll(Arrays.asList(sourceGroupArray));
        if (arrayList.isEmpty()) {
            dataFolder = sources.getSourceGroups("generic");
            arrayList.addAll(Arrays.asList(dataFolder));
        }
        dataFolder = DataFolder.findFolder((FileObject)((SourceGroup)arrayList.get(0)).getRootFolder());
        DataFolder dataFolder2 = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        try {
            if (templateWizard.getTargetFolder().equals(dataFolder2)) {
                templateWizard.setTargetFolder(dataFolder);
            }
        }
        catch (IOException iOException) {
            templateWizard.setTargetFolder(dataFolder);
        }
        SourceGroup[] sourceGroupArray2 = arrayList.toArray(new SourceGroup[arrayList.size()]);
        this.folderPanel = new WsdlPanel(project);
        WizardNewWSDLStep wizardNewWSDLStep = new WizardNewWSDLStep(Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])sourceGroupArray2, (WizardDescriptor.Panel)this.folderPanel));
        JComponent jComponent = (JComponent)wizardNewWSDLStep.getComponent();
        ((WsdlPanel)this.folderPanel).setNameTF(this.findFileNameField(jComponent, Templates.getTargetName((WizardDescriptor)templateWizard)));
        WizardPortTypeConfigurationStep wizardPortTypeConfigurationStep = new WizardPortTypeConfigurationStep(project);
        WizardBindingConfigurationStep wizardBindingConfigurationStep = new WizardBindingConfigurationStep();
        return new WizardDescriptor.Panel[]{wizardNewWSDLStep, wizardPortTypeConfigurationStep, wizardBindingConfigurationStep};
    }

    public Set<DataObject> instantiate(final TemplateWizard templateWizard) throws IOException {
        final FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)templateWizard);
        final String string = (String)templateWizard.getProperty("PROJECT_ENCODING");
        final String string2 = Templates.getTargetName((WizardDescriptor)templateWizard);
        FileSystem fileSystem = fileObject.getFileSystem();
        final FileObject[] fileObjectArray = new FileObject[1];
        FileSystem.AtomicAction atomicAction = new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                block11: {
                    FileObject fileObject2 = fileObject.createData(string2, "wsdl");
                    FileLock fileLock = null;
                    try {
                        fileLock = fileObject2.lock();
                        OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                        outputStream = new BufferedOutputStream(outputStream);
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
                        WSDLModel wSDLModel = (WSDLModel)templateWizard.getProperty("TEMP_WSDLMODEL");
                        DefaultProjectCatalogSupport defaultProjectCatalogSupport = DefaultProjectCatalogSupport.getInstance((FileObject)fileObject2);
                        if (wSDLModel == null) break block11;
                        try {
                            NewWSDLWizardIterator.this.postProcessImports(wSDLModel, fileObject2, defaultProjectCatalogSupport);
                            NewWSDLWizardIterator.this.addSchemaImport(wSDLModel, fileObject2, defaultProjectCatalogSupport);
                        }
                        catch (Exception exception) {
                            ErrorManager.getDefault().notify((Throwable)exception);
                        }
                        Document document = wSDLModel.getBaseDocument();
                        try {
                            outputStreamWriter.write(document.getText(0, document.getLength()));
                            ((Writer)outputStreamWriter).flush();
                        }
                        catch (BadLocationException badLocationException) {
                            ErrorManager.getDefault().notify((Throwable)badLocationException);
                        }
                        finally {
                            ((Writer)outputStreamWriter).close();
                        }
                        fileObjectArray[0] = fileObject2;
                    }
                    finally {
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                }
            }
        };
        fileSystem.runAtomicAction(atomicAction);
        HashSet<DataObject> hashSet = new HashSet<DataObject>(1);
        DataObject dataObject = DataObject.find((FileObject)fileObjectArray[0]);
        hashSet.add(dataObject);
        return hashSet;
    }

    private void postProcessImports(WSDLModel wSDLModel, FileObject fileObject, DefaultProjectCatalogSupport defaultProjectCatalogSupport) throws Exception {
        Schema schema;
        WSDLSchema wSDLSchema;
        SchemaModel schemaModel;
        List list;
        Types types = wSDLModel.getDefinitions().getTypes();
        if (types != null && (list = types.getExtensibilityElements(WSDLSchema.class)) != null && list.iterator().hasNext() && (schemaModel = (wSDLSchema = (WSDLSchema)list.iterator().next()).getSchemaModel()) != null && (schema = schemaModel.getSchema()) != null && schema.getImports() != null) {
            wSDLModel.startTransaction();
            for (Import import_ : schema.getImports()) {
                this.postProcessImport(import_, schemaModel, fileObject, defaultProjectCatalogSupport);
            }
            wSDLModel.endTransaction();
        }
    }

    private void postProcessImport(Import import_, SchemaModel schemaModel, FileObject fileObject, DefaultProjectCatalogSupport defaultProjectCatalogSupport) {
        String string = import_.getNamespace();
        Collection collection = schemaModel.findSchemas(string);
        for (Schema schema : collection) {
            SchemaModel schemaModel2 = schema.getModel();
            FileObject fileObject2 = (FileObject)schemaModel2.getModelSource().getLookup().lookup(FileObject.class);
            URI uRI = null;
            try {
                uRI = fileObject2.getURL().toURI();
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Not able to convert " + fileObject2.getName() + "to a valid URI", exception);
            }
            String string2 = this.getRelativePathOfSchema(fileObject, uRI, defaultProjectCatalogSupport);
            import_.setSchemaLocation(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSchemaImport(WSDLModel wSDLModel, FileObject fileObject, DefaultProjectCatalogSupport defaultProjectCatalogSupport) {
        WsdlPanel wsdlPanel = (WsdlPanel)this.folderPanel;
        WsdlUIPanel.SchemaInfo[] schemaInfoArray = wsdlPanel.getSchemas();
        if (wsdlPanel.isImport() && schemaInfoArray.length > 0) {
            String string = wsdlPanel.getNS();
            Schema schema = null;
            WSDLSchema wSDLSchema = null;
            for (int i = 0; i < schemaInfoArray.length; ++i) {
                FileObject fileObject2;
                String string2 = schemaInfoArray[i].getNamespace();
                if (string2.length() == 0) {
                    string2 = string;
                }
                String string3 = "ns" + String.valueOf(i + 1);
                String string4 = null;
                String string5 = schemaInfoArray[i].getSchemaName();
                File file = new File(string5);
                URI uRI = null;
                if (file.exists()) {
                    file = FileUtil.normalizeFile((File)file);
                    fileObject2 = FileUtil.toFileObject((File)file);
                    try {
                        uRI = fileObject2.getURL().toURI();
                    }
                    catch (Exception exception) {
                        logger.log(Level.SEVERE, "Not able to convert " + string5 + "to a valid URI", exception);
                    }
                }
                if (uRI == null) {
                    try {
                        uRI = new URI(string5);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        logger.log(Level.SEVERE, string5 + "is not a valid URI", uRISyntaxException);
                    }
                }
                string4 = this.getRelativePathOfSchema(fileObject, uRI, defaultProjectCatalogSupport);
                fileObject2 = wSDLModel.getDefinitions();
                wSDLModel.startTransaction();
                try {
                    SchemaModel schemaModel;
                    List list;
                    Types types = fileObject2.getTypes();
                    if (types == null) {
                        types = wSDLModel.getFactory().createTypes();
                        fileObject2.setTypes(types);
                    }
                    if ((list = types.getExtensibilityElements(WSDLSchema.class)) == null || list.size() == 0) {
                        wSDLSchema = wSDLModel.getFactory().createWSDLSchema();
                        schemaModel = wSDLSchema.getSchemaModel();
                        schema = schemaModel.getSchema();
                        schema.setTargetNamespace(wSDLModel.getDefinitions().getTargetNamespace());
                        types.addExtensibilityElement((ExtensibilityElement)wSDLSchema);
                    } else {
                        wSDLSchema = (WSDLSchema)list.get(0);
                        schemaModel = wSDLSchema.getSchemaModel();
                        schema = schemaModel.getSchema();
                    }
                    if (this.isSchemaImportExists(string4, string2, schema)) continue;
                    schema.addPrefix(string3, string2);
                    ((AbstractDocumentComponent)fileObject2).addPrefix(string3, string2);
                    schemaModel = schema.getModel().getFactory().createImport();
                    schemaModel.setNamespace(string2);
                    schemaModel.setSchemaLocation(string4);
                    schema.addExternalReference((SchemaModelReference)schemaModel);
                    continue;
                }
                finally {
                    wSDLModel.endTransaction();
                }
            }
        }
    }

    private boolean isSchemaImportExists(String string, String string2, Schema schema) {
        boolean bl = false;
        Collection collection = schema.getImports();
        for (Import import_ : collection) {
            String string3 = import_.getSchemaLocation();
            String string4 = import_.getNamespace();
            if (string4 == null || !string4.equals(string2) || string3 == null || !string3.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private String getRelativePathOfSchema(FileObject fileObject, URI uRI, DefaultProjectCatalogSupport defaultProjectCatalogSupport) {
        File file = FileUtil.toFile((FileObject)fileObject);
        FileObject fileObject2 = FileUtil.toFileObject((File)new File(uRI));
        String string = null;
        if (defaultProjectCatalogSupport != null && defaultProjectCatalogSupport.needsCatalogEntry(fileObject, fileObject2)) {
            try {
                URI uRI2 = defaultProjectCatalogSupport.getReferenceURI(fileObject, fileObject2);
                defaultProjectCatalogSupport.removeCatalogEntry(uRI2);
                defaultProjectCatalogSupport.createCatalogEntry(fileObject, fileObject2);
                string = defaultProjectCatalogSupport.getReferenceURI(fileObject, fileObject2).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                ErrorManager.getDefault().notify((Throwable)uRISyntaxException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            catch (CatalogModelException catalogModelException) {
                ErrorManager.getDefault().notify((Throwable)catalogModelException);
            }
        } else {
            string = org.netbeans.modules.xml.retriever.catalog.Utilities.relativize((URI)file.toURI(), (URI)uRI);
        }
        return string;
    }

    public void initialize(TemplateWizard templateWizard) {
        this.index = 0;
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        this.panels = this.createPanels(project, templateWizard);
        Object object = templateWizard.getProperty("WizardPanel_contentData");
        String[] stringArray = null;
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        String[] stringArray2 = Utilities.createSteps(stringArray, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component component = this.panels[i].getComponent();
            if (stringArray2[i] == null) {
                stringArray2[i] = component.getName();
            }
            if (!(component instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)component;
            jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jComponent.putClientProperty("WizardPanel_contentData", stringArray2);
        }
        String string = EncodingUtil.getProjectEncoding((FileObject)project.getProjectDirectory());
        if (string == null) {
            string = "UTF8";
        }
        templateWizard.putProperty("PROJECT_ENCODING", (Object)string);
    }

    public void uninitialize(TemplateWizard templateWizard) {
        FileObject fileObject;
        this.panels = null;
        this.folderPanel = null;
        templateWizard.putProperty("TEMP_WSDLMODEL", null);
        File file = (File)templateWizard.getProperty("TEMP_WSDLFILE");
        templateWizard.putProperty("TEMP_WSDLFILE", null);
        if (file != null && file.exists() && (fileObject = FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)file)))) != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                dataObject.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.panels.length;
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private JTextField findFileNameField(Component component, String string) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        this.getAllComponents(new Component[]{component}, arrayList);
        for (Component component2 : arrayList) {
            if (!(component2 instanceof JTextField)) continue;
            JTextField jTextField = (JTextField)component2;
            return jTextField;
        }
        return null;
    }

    public void getAllComponents(Component[] componentArray, Collection<Component> collection) {
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == null) continue;
            collection.add(componentArray[i]);
            if (((Container)componentArray[i]).getComponentCount() == 0) continue;
            this.getAllComponents(((Container)componentArray[i]).getComponents(), collection);
        }
    }
}

