/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.Import;
import org.netbeans.modules.xml.schema.model.ReferenceableSchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Fault;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.RequestResponseOperation;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.ui.actions.NameGenerator;
import org.netbeans.modules.xml.wsdl.ui.view.ElementOrType;
import org.netbeans.modules.xml.wsdl.ui.view.OperationType;
import org.netbeans.modules.xml.wsdl.ui.view.PartAndElementOrTypeTableModel;
import org.netbeans.modules.xml.wsdl.ui.wizard.Command;
import org.netbeans.modules.xml.wsdl.ui.wizard.SchemaImportsGenerator;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationGenerator
implements Command {
    private WSDLModel mModel;
    private Map mConfigurationMap;
    private PortType mParentPortType;
    private Operation mOperation;
    private List<Message> mNewMessageList = new ArrayList<Message>();
    private Collection<Import> mImports = new ArrayList<Import>();

    public OperationGenerator(WSDLModel wSDLModel, PortType portType, Map map) {
        this.mModel = wSDLModel;
        this.mParentPortType = portType;
        this.mConfigurationMap = map;
    }

    public Operation getOperation() {
        return this.mOperation;
    }

    public List<Message> getNewMessages() {
        return this.mNewMessageList;
    }

    public Collection<Import> getImports() {
        return this.mImports;
    }

    @Override
    public void execute() {
        if (this.mModel != null) {
            String string = (String)this.mConfigurationMap.get("OPERATION_NAME");
            OperationType operationType = (OperationType)this.mConfigurationMap.get("OPERATION_TYPE");
            this.mOperation = this.createOperation(operationType, this.mModel);
            this.mOperation.setName(string);
            this.mParentPortType.addOperation(this.mOperation);
            List list = (List)this.mConfigurationMap.get("OPERATION_INPUT");
            List list2 = (List)this.mConfigurationMap.get("OPERATION_OUTPUT");
            List list3 = (List)this.mConfigurationMap.get("OPERATION_FAULT");
            SchemaImportsGenerator schemaImportsGenerator = new SchemaImportsGenerator(this.mModel, this.mConfigurationMap);
            schemaImportsGenerator.execute();
            this.mImports.addAll(schemaImportsGenerator.getImports());
            String string2 = (String)this.mConfigurationMap.get("OPERATION_INPUT_MESSAGE");
            String string3 = (String)this.mConfigurationMap.get("OPERATION_OUTPUT_MESSAGE");
            String string4 = (String)this.mConfigurationMap.get("OPERATION_FAULT_MESSAGE");
            this.processOperationType(operationType, this.mOperation, list, list2, list3, string2, string3, string4);
        }
    }

    private Operation createOperation(OperationType operationType, WSDLModel wSDLModel) {
        RequestResponseOperation requestResponseOperation = null;
        if (operationType.getOperationType().equals("OPERATION_REQUEST_REPLY")) {
            requestResponseOperation = wSDLModel.getFactory().createRequestResponseOperation();
        } else if (operationType.getOperationType().equals("OPERATION_ONE_WAY")) {
            requestResponseOperation = wSDLModel.getFactory().createOneWayOperation();
        } else if (operationType.getOperationType().equals("OPERATION_SOLICIT_RESPONSE")) {
            requestResponseOperation = wSDLModel.getFactory().createSolicitResponseOperation();
        } else if (operationType.getOperationType().equals("OPERATION_NOTIFICATION")) {
            requestResponseOperation = wSDLModel.getFactory().createNotificationOperation();
        }
        return requestResponseOperation;
    }

    private void processOperationType(OperationType operationType, Operation operation, List<PartAndElementOrTypeTableModel.PartAndElementOrType> list, List<PartAndElementOrTypeTableModel.PartAndElementOrType> list2, List<PartAndElementOrTypeTableModel.PartAndElementOrType> list3, String string, String string2, String string3) {
        Message message = null;
        Message message2 = null;
        Message message3 = null;
        NamedComponentReference namedComponentReference = null;
        NamedComponentReference namedComponentReference2 = null;
        NamedComponentReference namedComponentReference3 = null;
        if (string != null) {
            message = this.findMessage(string);
        } else {
            string = NameGenerator.getInstance().generateUniqueInputMessageName(operation.getName(), this.mModel);
        }
        if (message == null && list != null) {
            message = this.createAndAddMessage(list);
            message.setName(string);
        }
        if (message != null) {
            namedComponentReference = operation.createReferenceTo((ReferenceableWSDLComponent)message, Message.class);
            this.createAndAddInput(operation, (NamedComponentReference<Message>)namedComponentReference);
        }
        if (string2 != null) {
            message2 = this.findMessage(string2);
        } else {
            string2 = NameGenerator.getInstance().generateUniqueOutputMessageName(operation.getName(), this.mModel);
        }
        if (message2 == null && list2 != null) {
            message2 = this.createAndAddMessage(list2);
            message2.setName(string2);
        }
        if (message2 != null) {
            namedComponentReference2 = operation.createReferenceTo((ReferenceableWSDLComponent)message2, Message.class);
            this.createAndAddOuput(operation, (NamedComponentReference<Message>)namedComponentReference2);
        }
        if (string3 != null) {
            message3 = this.findMessage(string3);
        } else {
            string3 = NameGenerator.getInstance().generateUniqueFaultMessageName(operation.getName(), this.mModel);
        }
        if (message3 == null && list3 != null && list3.size() > 0) {
            message3 = this.createAndAddMessage(list3);
            message3.setName(string3);
        }
        if (message3 != null) {
            namedComponentReference3 = operation.createReferenceTo((ReferenceableWSDLComponent)message3, Message.class);
            this.createAndAddFault(operation, (NamedComponentReference<Message>)namedComponentReference3);
        }
    }

    private Input createAndAddInput(Operation operation, NamedComponentReference<Message> namedComponentReference) {
        Input input = this.mModel.getFactory().createInput();
        String string = NameGenerator.getInstance().generateUniqueOperationInputName(operation);
        input.setName(string);
        operation.setInput(input);
        if (namedComponentReference != null) {
            input.setMessage(namedComponentReference);
        }
        return input;
    }

    private Output createAndAddOuput(Operation operation, NamedComponentReference<Message> namedComponentReference) {
        Output output = this.mModel.getFactory().createOutput();
        String string = NameGenerator.getInstance().generateUniqueOperationOutputName(operation);
        output.setName(string);
        operation.setOutput(output);
        if (namedComponentReference != null) {
            output.setMessage(namedComponentReference);
        }
        return output;
    }

    private Fault createAndAddFault(Operation operation, NamedComponentReference<Message> namedComponentReference) {
        Fault fault = this.mModel.getFactory().createFault();
        String string = NameGenerator.getInstance().generateUniqueOperationFaultName(operation);
        fault.setName(string);
        operation.addFault(fault);
        if (namedComponentReference != null) {
            fault.setMessage(namedComponentReference);
        }
        return fault;
    }

    private Message createAndAddMessage(List<PartAndElementOrTypeTableModel.PartAndElementOrType> list) {
        Message message = this.mModel.getFactory().createMessage();
        this.mModel.getDefinitions().addMessage(message);
        this.mNewMessageList.add(message);
        if (list != null) {
            for (PartAndElementOrTypeTableModel.PartAndElementOrType partAndElementOrType : list) {
                NamedComponentReference namedComponentReference;
                String string = partAndElementOrType.getPartName();
                ElementOrType elementOrType = partAndElementOrType.getElementOrType();
                Part part = this.mModel.getFactory().createPart();
                part.setName(string);
                message.addPart(part);
                if (elementOrType == null) continue;
                GlobalElement globalElement = elementOrType.getElement();
                GlobalType globalType = elementOrType.getType();
                if (globalElement != null) {
                    namedComponentReference = part.createSchemaReference((ReferenceableSchemaComponent)globalElement, GlobalElement.class);
                    if (namedComponentReference == null) continue;
                    part.setElement(namedComponentReference);
                    continue;
                }
                if (globalType == null || (namedComponentReference = part.createSchemaReference((ReferenceableSchemaComponent)globalType, GlobalType.class)) == null) continue;
                part.setType(namedComponentReference);
            }
        }
        return message;
    }

    private Message findMessage(String string) {
        QName qName = this.constructQName(string);
        if (qName != null) {
            return (Message)this.mModel.findComponentByName(qName, Message.class);
        }
        return null;
    }

    private QName constructQName(String string) {
        if (string == null) {
            return null;
        }
        QName qName = null;
        int n = string.lastIndexOf(":");
        String string2 = "";
        String string3 = null;
        String string4 = null;
        if (n != -1) {
            string2 = string.substring(0, n);
            string4 = string.substring(n + 1);
            string3 = ((AbstractDocumentComponent)this.mModel.getDefinitions()).lookupNamespaceURI(string2);
        } else {
            string4 = string;
            string3 = this.mModel.getDefinitions().getTargetNamespace();
        }
        qName = new QName(string3, string4, string2);
        return qName;
    }
}

