/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.net.URL;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class J2SELibraryClassPathProvider
implements ClassPathProvider {
    private FileObject lastUsedRoot;
    private Library lastUsedLibrary;

    public ClassPath findClassPath(FileObject fileObject, String string) {
        assert (fileObject != null);
        Library library = this.getLastUsedLibrary(fileObject);
        if (library != null) {
            ClassPath[] classPathArray = this.findClassPathOrNull(fileObject, string, library);
            return classPathArray != null ? classPathArray[0] : null;
        }
        for (LibraryManager libraryManager : LibraryManager.getOpenManagers()) {
            for (Library library2 : libraryManager.getLibraries()) {
                ClassPath[] classPathArray = this.findClassPathOrNull(fileObject, string, library2);
                if (classPathArray == null) continue;
                return classPathArray[0];
            }
        }
        return null;
    }

    private ClassPath[] findClassPathOrNull(FileObject fileObject, String string, Library library) {
        List list;
        ClassPath classPath;
        FileObject fileObject2;
        if (library.getType().equals("j2se") && (fileObject2 = (classPath = ClassPathSupport.createClassPath((URL[])(list = library.getContent("src")).toArray(new URL[list.size()]))).findOwnerRoot(fileObject)) != null) {
            this.setLastUsedLibrary(fileObject2, library);
            if ("classpath/source".equals(string)) {
                return new ClassPath[]{classPath};
            }
            if ("classpath/compile".equals(string)) {
                list = library.getContent("classpath");
                return new ClassPath[]{ClassPathSupport.createClassPath((URL[])list.toArray(new URL[list.size()]))};
            }
            if ("classpath/boot".equals(string)) {
                return new ClassPath[]{JavaPlatformManager.getDefault().getDefaultPlatform().getBootstrapLibraries()};
            }
            return new ClassPath[]{null};
        }
        return null;
    }

    private synchronized Library getLastUsedLibrary(FileObject fileObject) {
        if (this.lastUsedRoot != null && FileUtil.isParentOf((FileObject)this.lastUsedRoot, (FileObject)fileObject)) {
            return this.lastUsedLibrary;
        }
        return null;
    }

    private synchronized void setLastUsedLibrary(FileObject fileObject, Library library) {
        this.lastUsedRoot = fileObject;
        this.lastUsedLibrary = library;
    }
}

