/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.wizard;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.java.j2seplatform.platformdefinition.J2SEPlatformImpl;
import org.netbeans.modules.java.j2seplatform.wizard.J2SEWizardIterator;
import org.netbeans.modules.java.j2seplatform.wizard.NewJ2SEPlatform;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectPanel
extends JPanel {
    private NewJ2SEPlatform primaryPlatform;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField javadoc;
    private JTextField jdkName;
    private JLabel progressLabel;
    private JPanel progressPanel;
    private JTextField sources;

    public DetectPanel(NewJ2SEPlatform newJ2SEPlatform) {
        this.initComponents();
        this.postInitComponents();
        this.putClientProperty("WizardPanel_contentData", new String[]{NbBundle.getMessage(DetectPanel.class, (String)"TITLE_PlatformName")});
        this.primaryPlatform = newJ2SEPlatform;
        this.setName(NbBundle.getMessage(DetectPanel.class, (String)"TITLE_PlatformName"));
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    private void postInitComponents() {
        this.jdkName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                DetectPanel.this.handleNameChange();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                DetectPanel.this.handleNameChange();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                DetectPanel.this.handleNameChange();
            }
        });
        this.progressLabel.setVisible(false);
        this.progressPanel.setVisible(false);
    }

    private void handleNameChange() {
        this.cs.fireChange();
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.jdkName = new JTextField();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.javadoc = new JTextField();
        this.sources = new JTextField();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel2 = new JPanel();
        this.progressLabel = new JLabel();
        this.progressPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_DetectPanel"));
        this.jLabel3.setLabelFor(this.jdkName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getBundle(DetectPanel.class).getString("LBL_DetailsPanel_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.jdkName, gridBagConstraints);
        this.jdkName.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_PlatformName"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.sources);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(DetectPanel.class).getString("TXT_Sources"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel4.setLabelFor(this.javadoc);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getBundle(DetectPanel.class).getString("TXT_JavaDoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel1.add((Component)this.javadoc, gridBagConstraints);
        this.javadoc.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_PlatformJavadoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.sources, gridBagConstraints);
        this.sources.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_PlatformSources"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getBundle(DetectPanel.class).getString("LBL_BrowseSources"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetectPanel.this.selectSources(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.jButton1.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_SelectSources"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getBundle(DetectPanel.class).getString("LBL_BrowseJavadoc"));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetectPanel.this.selectJavadoc(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        this.jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(DetectPanel.class).getString("AD_SelectJavadoc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.progressLabel.setLabelFor(this.progressPanel);
        Mnemonics.setLocalizedText((JLabel)this.progressLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/java/j2seplatform/wizard/Bundle").getString("TXT_PlatfromDetectProgress"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 6, 0);
        this.add((Component)this.progressLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.progressPanel, gridBagConstraints);
    }

    private void selectJavadoc(ActionEvent actionEvent) {
        String string = this.browse(this.javadoc.getText(), NbBundle.getMessage(DetectPanel.class, (String)"TXT_SelectJavadoc"));
        if (string != null) {
            this.javadoc.setText(string);
        }
    }

    private void selectSources(ActionEvent actionEvent) {
        String string = this.browse(this.sources.getText(), NbBundle.getMessage(DetectPanel.class, (String)"TXT_SelectSources"));
        if (string != null) {
            this.sources.setText(string);
        }
    }

    public final synchronized void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public final synchronized void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    public String getPlatformName() {
        return this.jdkName.getText();
    }

    String getSources() {
        String string = this.sources.getText();
        return string.length() == 0 ? null : string;
    }

    void setSources(String string) {
        this.sources.setText(string == null ? "" : string);
    }

    String getJavadoc() {
        String string = this.javadoc.getText();
        return string.length() == 0 ? null : string;
    }

    void setJavadoc(String string) {
        this.javadoc.setText(string == null ? "" : string);
    }

    void updateData() {
        Map map = this.primaryPlatform.getSystemProperties();
        if ("".equals(this.jdkName.getText())) {
            this.jdkName.setText(DetectPanel.getInitialName(map));
            this.jdkName.selectAll();
        }
    }

    private static String getInitialName(Map<String, String> map) {
        String string = map.get("java.specification.version");
        StringBuilder stringBuilder = new StringBuilder(NbBundle.getMessage(DetectPanel.class, (String)"TXT_DetectPanel_Java"));
        if (string != null) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private String browse(String string, String string2) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.exists() && file.canRead() && (file.isDirectory() || file.getName().endsWith(".zip") || file.getName().endsWith(".jar"));
            }

            public String getDescription() {
                return NbBundle.getMessage(DetectPanel.class, (String)"TXT_ZipFilter");
            }
        });
        File file = new File(string);
        jFileChooser.setSelectedFile(file);
        jFileChooser.setDialogTitle(string2);
        if (jFileChooser.showOpenDialog(this) == 0) {
            return jFileChooser.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WizardPanel
    implements WizardDescriptor.Panel<WizardDescriptor>,
    TaskListener,
    ChangeListener {
        private DetectPanel component;
        private RequestProcessor.Task task;
        private final J2SEWizardIterator iterator;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private boolean detected;
        private boolean valid;
        private boolean firstPass = true;
        private WizardDescriptor wiz;
        private ProgressHandle progressHandle;

        WizardPanel(J2SEWizardIterator j2SEWizardIterator) {
            this.iterator = j2SEWizardIterator;
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public Component getComponent() {
            if (this.component == null) {
                final NewJ2SEPlatform newJ2SEPlatform = this.iterator.getPlatform();
                final NewJ2SEPlatform newJ2SEPlatform2 = this.iterator.getSecondaryPlatform();
                this.component = new DetectPanel(newJ2SEPlatform);
                this.component.addChangeListener(this);
                this.task = RequestProcessor.getDefault().create(new Runnable(){

                    public void run() {
                        newJ2SEPlatform.run();
                        if (newJ2SEPlatform2 != null) {
                            newJ2SEPlatform2.run();
                        }
                    }
                });
                this.task.addTaskListener((TaskListener)this);
            }
            return this.component;
        }

        void setValid(boolean bl) {
            if (bl == this.valid) {
                return;
            }
            this.valid = bl;
            this.cs.fireChange();
        }

        public HelpCtx getHelp() {
            return new HelpCtx(DetectPanel.class);
        }

        public boolean isValid() {
            return this.valid;
        }

        public void readSettings(WizardDescriptor wizardDescriptor) {
            File file;
            Serializable serializable2;
            Object object3;
            Object object2;
            this.wiz = wizardDescriptor;
            NewJ2SEPlatform newJ2SEPlatform = this.iterator.getPlatform();
            String string = null;
            String string2 = null;
            ClassPath classPath = newJ2SEPlatform.getSourceFolders();
            if (classPath.entries().size() > 0) {
                object2 = ((ClassPath.Entry)classPath.entries().get(0)).getURL();
                if ("jar".equals(((URL)object2).getProtocol())) {
                    object2 = FileUtil.getArchiveFile(object2);
                }
                string = new File(URI.create(((URL)object2).toExternalForm())).getAbsolutePath();
            } else if (this.firstPass) {
                for (Object object3 : newJ2SEPlatform.getInstallFolders()) {
                    serializable2 = FileUtil.toFile((FileObject)object3);
                    if (serializable2 == null) continue;
                    file = new File((File)serializable2, "src.zip");
                    if (file.canRead()) {
                        string = file.getAbsolutePath();
                        continue;
                    }
                    file = new File((File)serializable2, "src.jar");
                    if (!file.canRead()) continue;
                    string = file.getAbsolutePath();
                }
            }
            object2 = newJ2SEPlatform.getJavadocFolders();
            if (object2.size() > 0) {
                object3 = (URL)object2.get(0);
                if ("jar".equals(((URL)object3).getProtocol())) {
                    object3 = FileUtil.getArchiveFile((URL)object3);
                }
                string2 = new File(URI.create(((URL)object3).toExternalForm())).getAbsolutePath();
            } else if (this.firstPass) {
                for (Serializable serializable2 : newJ2SEPlatform.getInstallFolders()) {
                    File file2;
                    file = FileUtil.toFile((FileObject)serializable2);
                    if (file == null || !(file2 = new File(file, "docs")).isDirectory() || !file2.canRead()) continue;
                    string2 = file2.getAbsolutePath();
                }
                this.firstPass = false;
            }
            this.component.setSources(string);
            this.component.setJavadoc(string2);
            this.component.jdkName.setEditable(false);
            this.component.progressPanel.setVisible(true);
            this.component.progressLabel.setVisible(true);
            this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DetectPanel.class, (String)"TXT_PlatfromDetectProgress"));
            this.component.progressPanel.removeAll();
            this.component.progressPanel.setLayout(new GridBagLayout());
            object3 = new GridBagConstraints();
            ((GridBagConstraints)object3).gridy = -1;
            ((GridBagConstraints)object3).gridx = -1;
            ((GridBagConstraints)object3).gridwidth = 0;
            ((GridBagConstraints)object3).gridheight = 0;
            ((GridBagConstraints)object3).fill = 2;
            ((GridBagConstraints)object3).weightx = 1.0;
            serializable2 = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.progressHandle);
            ((GridBagLayout)this.component.progressPanel.getLayout()).setConstraints((Component)serializable2, (GridBagConstraints)object3);
            this.component.progressPanel.add((Component)serializable2);
            this.progressHandle.start();
            this.task.schedule(0);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        public void storeSettings(WizardDescriptor wizardDescriptor) {
            if (this.isValid()) {
                URL uRL;
                Object object;
                Object object2;
                String string = this.component.getPlatformName();
                ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
                ArrayList<URL> arrayList2 = new ArrayList<URL>();
                String string2 = this.component.getSources();
                if (string2 != null) {
                    object2 = new File(string2);
                    try {
                        object = ((File)object2).toURI().toURL();
                        if (FileUtil.isArchiveFile((URL)object)) {
                            uRL = URLMapper.findFileObject((URL)(object = FileUtil.getArchiveRoot((URL)object)));
                            if (uRL != null && (uRL = uRL.getFileObject("src")) != null) {
                                object = uRL.getURL();
                            }
                            arrayList.add(ClassPathSupport.createResource((URL)object));
                        } else {
                            arrayList.add(ClassPathSupport.createResource((URL)object));
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        ErrorManager.getDefault().notify((Throwable)malformedURLException);
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
                    }
                }
                if ((object2 = this.component.getJavadoc()) != null) {
                    object = new File((String)object2);
                    try {
                        uRL = ((File)object).toURI().toURL();
                        if (FileUtil.isArchiveFile((URL)uRL)) {
                            uRL = FileUtil.getArchiveRoot((URL)uRL);
                        } else if (!((File)object).exists()) {
                            uRL = new URL(uRL.toExternalForm() + '/');
                        }
                        arrayList2.add(uRL);
                    }
                    catch (MalformedURLException malformedURLException) {
                        ErrorManager.getDefault().notify((Throwable)malformedURLException);
                    }
                }
                object = this.iterator.getPlatform();
                ((J2SEPlatformImpl)((Object)object)).setDisplayName(string);
                ((J2SEPlatformImpl)((Object)object)).setAntName(WizardPanel.createAntName(string));
                ((J2SEPlatformImpl)((Object)object)).setSourceFolders(ClassPathSupport.createClassPath(arrayList));
                ((J2SEPlatformImpl)((Object)object)).setJavadocFolders(arrayList2);
                object = this.iterator.getSecondaryPlatform();
                if (object != null) {
                    string = NbBundle.getMessage(DetectPanel.class, (String)"FMT_64BIT", (Object)string);
                    ((J2SEPlatformImpl)((Object)object)).setDisplayName(string);
                    ((J2SEPlatformImpl)((Object)object)).setAntName(WizardPanel.createAntName(string));
                    ((J2SEPlatformImpl)((Object)object)).setSourceFolders(ClassPathSupport.createClassPath(arrayList));
                    ((J2SEPlatformImpl)((Object)object)).setJavadocFolders(arrayList2);
                }
            }
        }

        public void taskFinished(Task task) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    WizardPanel.this.component.updateData();
                    WizardPanel.this.component.jdkName.setEditable(true);
                    assert (WizardPanel.this.progressHandle != null);
                    WizardPanel.this.progressHandle.finish();
                    WizardPanel.this.component.progressPanel.setVisible(false);
                    WizardPanel.this.component.progressLabel.setVisible(false);
                    WizardPanel.this.detected = WizardPanel.this.iterator.getPlatform().isValid();
                    WizardPanel.this.checkValid();
                }
            });
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.checkValid();
        }

        private void checkValid() {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)"");
            String string = this.component.getPlatformName();
            boolean bl = string.length() > 0;
            boolean bl2 = false;
            if (!this.detected) {
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_NoSDKRegistry"));
            } else if (!bl) {
                this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_InvalidDisplayName"));
            } else {
                JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getInstalledPlatforms();
                for (int i = 0; i < javaPlatformArray.length; ++i) {
                    if (!string.equals(javaPlatformArray[i].getDisplayName())) continue;
                    bl2 = true;
                    this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(DetectPanel.class, (String)"ERROR_UsedDisplayName"));
                    break;
                }
            }
            boolean bl3 = this.detected && bl && !bl2;
            this.setValid(bl3);
        }

        private static String createAntName(String string) {
            if (string == null || string.length() == 0) {
                throw new IllegalArgumentException();
            }
            String string2 = PropertyUtils.getUsablePropertyName((String)string);
            if (WizardPanel.platformExists(string2)) {
                String string3 = string2;
                int n = 1;
                string2 = string3 + Integer.toString(n);
                while (WizardPanel.platformExists(string2)) {
                    string2 = string3 + Integer.toString(++n);
                }
            }
            return string2;
        }

        private static boolean platformExists(String string) {
            JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
            JavaPlatform[] javaPlatformArray = javaPlatformManager.getInstalledPlatforms();
            for (int i = 0; i < javaPlatformArray.length; ++i) {
                String string2;
                if (!(javaPlatformArray[i] instanceof J2SEPlatformImpl) || !string.equals(string2 = ((J2SEPlatformImpl)javaPlatformArray[i]).getAntName())) continue;
                return true;
            }
            return false;
        }
    }
}

