/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui;

import java.beans.PropertyChangeEvent;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.openide.awt.ToolbarPool;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

public class DebuggerManagerListener
extends DebuggerManagerAdapter {
    private boolean isOpened = false;

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (DebuggerManager.getDebuggerManager().getCurrentEngine() != null && !this.isOpened) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TopComponentGroup topComponentGroup = WindowManager.getDefault().findTopComponentGroup("debugger");
                    if (topComponentGroup != null) {
                        topComponentGroup.open();
                        if (ToolbarPool.getDefault().getConfiguration().equals("Standard")) {
                            ToolbarPool.getDefault().setConfiguration("Debugging");
                        }
                    }
                }
            });
            this.isOpened = true;
        }
        if (propertyChangeEvent.getPropertyName() == "debuggerEngines" && ((DebuggerEngine[])propertyChangeEvent.getNewValue()).length == 0) {
            DebuggerManagerListener.closeDebuggerUI();
            this.isOpened = false;
        }
    }

    static void closeDebuggerUI() {
        if (SwingUtilities.isEventDispatchThread()) {
            DebuggerManagerListener.doCloseDebuggerUI();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DebuggerManagerListener.doCloseDebuggerUI();
                }
            });
        }
    }

    private static void doCloseDebuggerUI() {
        TopComponentGroup topComponentGroup = WindowManager.getDefault().findTopComponentGroup("debugger");
        if (topComponentGroup != null) {
            topComponentGroup.close();
            if (ToolbarPool.getDefault().getConfiguration().equals("Debugging")) {
                ToolbarPool.getDefault().setConfiguration("Standard");
            }
        }
    }

    public String[] getProperties() {
        return new String[]{"debuggerEngines", "currentEngine"};
    }
}

