/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.indentation;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.options.BaseOptions;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.openide.text.IndentEngine;
import org.openide.util.Lookup;

class IndentationModel {
    private boolean originalExpandedTabs = this.isExpandTabs();
    private int originalSpacesPerTab = this.getSpacesPerTab();
    private int originalTabSize = this.getTabSize();
    private int originalRightMargin = this.getRightMargin();
    private boolean changed = false;
    private EditorKit kit;
    private BaseOptions exampleBaseOptions = null;
    private IndentEngine exampleIndentEngine = null;

    IndentationModel() {
    }

    private EditorKit getEditorKit() {
        if (this.kit == null) {
            this.kit = (EditorKit)MimeLookup.getLookup((MimePath)MimePath.parse((String)"text/xml")).lookup(EditorKit.class);
        }
        return this.kit;
    }

    boolean isExpandTabs() {
        return (Boolean)Settings.getValue(this.getEditorKit().getClass(), (String)"expand-tabs");
    }

    void setExpandTabs(boolean bl) {
        Settings.setValue(this.getEditorKit().getClass(), (String)"expand-tabs", (Object)bl);
        this.updateChanged();
    }

    Integer getSpacesPerTab() {
        Integer n = (Integer)Settings.getValue(this.getEditorKit().getClass(), (String)"spaces-per-tab");
        return n;
    }

    void setSpacesPerTab(Integer n) {
        if (n > 0) {
            Settings.setValue(this.getEditorKit().getClass(), (String)"spaces-per-tab", (Object)n);
            Settings.setValue(this.getEditorKit().getClass(), (String)"indent-shift-width", (Object)n);
        }
        this.updateChanged();
    }

    Integer getTabSize() {
        BaseOptions baseOptions = this.getExampleBaseOptions();
        if (baseOptions != null) {
            return baseOptions.getTabSize();
        }
        return 4;
    }

    void setTabSize(Integer n) {
        BaseOptions baseOptions;
        if (n > 0 && (baseOptions = this.getExampleBaseOptions()) != null) {
            baseOptions.setTabSize(n.intValue());
        }
        this.updateChanged();
    }

    Integer getRightMargin() {
        BaseOptions baseOptions = this.getExampleBaseOptions();
        if (baseOptions != null) {
            return baseOptions.getTextLimitWidth();
        }
        return 120;
    }

    void setRightMargin(Integer n) {
        BaseOptions baseOptions;
        if (n > 0 && (baseOptions = this.getExampleBaseOptions()) != null) {
            baseOptions.setTextLimitWidth(n.intValue());
        }
        this.updateChanged();
    }

    boolean isChanged() {
        return this.changed;
    }

    void applyChanges() {
        if (!this.changed) {
            return;
        }
        this.applyParameterToAll("setExpandTabs", this.isExpandTabs(), Boolean.TYPE);
        this.applyParameterToAll("setSpacesPerTab", this.getSpacesPerTab(), Integer.TYPE);
        this.applyParameterToAll("setTabSize", this.getTabSize(), Integer.TYPE);
        this.applyParameterToAll("setTextLimitWidth", this.getRightMargin(), Integer.TYPE);
    }

    void revertChanges() {
        if (!this.changed) {
            return;
        }
        if (this.isExpandTabs() != this.originalExpandedTabs) {
            this.setExpandTabs(this.originalExpandedTabs);
        }
        if (this.getSpacesPerTab() != this.originalSpacesPerTab && this.originalSpacesPerTab > 0) {
            this.setSpacesPerTab(new Integer(this.originalSpacesPerTab));
        }
        if (this.getTabSize() != this.originalTabSize && this.originalTabSize > 0) {
            this.setTabSize(new Integer(this.originalTabSize));
        }
        if (this.getRightMargin() != this.originalRightMargin && this.originalRightMargin > 0) {
            this.setRightMargin(new Integer(this.originalRightMargin));
        }
    }

    private void updateChanged() {
        this.changed = this.isExpandTabs() != this.originalExpandedTabs || this.getSpacesPerTab() != this.originalSpacesPerTab || this.getTabSize() != this.originalTabSize || this.getRightMargin() != this.originalRightMargin;
    }

    private BaseOptions getExampleBaseOptions() {
        if (this.exampleBaseOptions == null) {
            BaseOptions baseOptions = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)"text/xml")).lookup(BaseOptions.class);
            if (baseOptions == null) {
                baseOptions = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)"text/plain")).lookup(BaseOptions.class);
            }
            this.exampleBaseOptions = baseOptions;
        }
        return this.exampleBaseOptions;
    }

    private IndentEngine getExampleIndentEngine() {
        if (this.exampleIndentEngine == null) {
            BaseOptions baseOptions = this.getExampleBaseOptions();
            this.exampleIndentEngine = baseOptions == null ? null : baseOptions.getIndentEngine();
        }
        return this.exampleIndentEngine;
    }

    private Object getParameter(String string, Object object) {
        IndentEngine indentEngine = this.getExampleIndentEngine();
        if (indentEngine != null) {
            try {
                Method method = indentEngine.getClass().getMethod(string, new Class[0]);
                return method.invoke((Object)indentEngine, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    private void setParameter(String string, Object object, Class clazz) {
        IndentEngine indentEngine = this.getExampleIndentEngine();
        if (indentEngine != null) {
            try {
                Method method = indentEngine.getClass().getMethod(string, clazz);
                method.invoke((Object)indentEngine, object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void applyParameterToAll(String string, Object object, Class clazz) {
        Object object2;
        BaseOptions baseOptions;
        Object object32;
        HashSet<IndentEngine> hashSet = new HashSet<IndentEngine>();
        Set set = EditorSettings.getDefault().getMimeTypes();
        for (Object object32 : set) {
            GenericDeclaration genericDeclaration;
            baseOptions = (BaseOptions)MimeLookup.getLookup((MimePath)MimePath.parse((String)object32)).lookup(BaseOptions.class);
            if (baseOptions == null) continue;
            object2 = baseOptions.getIndentEngine();
            hashSet.add((IndentEngine)object2);
            ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (baseOptions.getClass().getName().equals("org.netbeans.modules.java.editor.options.JavaOptions") && !object2.getClass().getName().equals("org.netbeans.modules.editor.java.JavaIndentEngine")) {
                try {
                    genericDeclaration = classLoader.loadClass("org.netbeans.modules.editor.java.JavaIndentEngine");
                    object2 = (IndentEngine)Lookup.getDefault().lookup(genericDeclaration);
                    baseOptions.setIndentEngine((IndentEngine)object2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (baseOptions.getClass().getName().equals("org.netbeans.modules.web.core.syntax.JSPOptions") && !object2.getClass().getName().equals("org.netbeans.modules.web.core.syntax.JspIndentEngine")) {
                try {
                    genericDeclaration = classLoader.loadClass("org.netbeans.modules.web.core.syntax.JspIndentEngine");
                    object2 = (IndentEngine)Lookup.getDefault().lookup(genericDeclaration);
                    baseOptions.setIndentEngine((IndentEngine)object2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                genericDeclaration = baseOptions.getClass().getMethod(string, clazz);
                ((Method)genericDeclaration).invoke(baseOptions, object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                genericDeclaration = object2.getClass().getMethod(string, clazz);
                ((Method)genericDeclaration).invoke(object2, object);
            }
            catch (Exception exception) {}
        }
        Collection collection = Lookup.getDefault().lookupAll(IndentEngine.class);
        object32 = collection.iterator();
        while (object32.hasNext()) {
            baseOptions = (IndentEngine)object32.next();
            if (hashSet.contains(baseOptions)) continue;
            try {
                object2 = baseOptions.getClass().getMethod(string, clazz);
                ((Method)object2).invoke((Object)baseOptions, object);
            }
            catch (Exception exception) {}
        }
    }
}

