/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.builder.xsd;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    private static final String PRINTWRITER_ENCODING = "UTF-8";
    private static final String TAB = "  ";
    protected boolean canonical;
    protected PrintWriter out;

    public DOMWriter(Writer writer, boolean bl) throws UnsupportedEncodingException {
        this.out = new PrintWriter(writer);
        this.canonical = bl;
    }

    public static String getWriterEncoding() {
        return PRINTWRITER_ENCODING;
    }

    public void print(String string, Node node) {
        this.print(string, node, true);
    }

    public void print(String string, Node node, boolean bl) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                Object object;
                if (!this.canonical) {
                    object = DOMWriter.getWriterEncoding();
                    if (((String)object).equalsIgnoreCase("DEFAULT")) {
                        object = PRINTWRITER_ENCODING;
                    } else if (((String)object).equalsIgnoreCase("Unicode")) {
                        object = "UTF-16";
                    }
                    this.out.println("<?xml version=\"1.0\" encoding=\"" + (String)object + "\"?>");
                }
                object = node.getChildNodes();
                for (int i = 0; i < object.getLength(); ++i) {
                    this.print(string, object.item(i));
                }
                this.out.flush();
                break;
            }
            case 1: {
                this.out.print(string + '<');
                this.out.print(node.getNodeName());
                Attr[] attrArray = this.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrArray.length; ++i) {
                    Attr attr = attrArray[i];
                    this.out.print(' ');
                    this.out.print(attr.getNodeName());
                    this.out.print("=\"");
                    this.out.print(this.normalize(attr.getNodeValue()));
                    this.out.print('\"');
                }
                this.out.print('>');
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node2 = nodeList.item(i);
                    if (node2.getNodeType() != 3) {
                        this.out.println();
                    }
                    this.print(string + TAB, nodeList.item(i));
                }
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList nodeList = node.getChildNodes();
                    if (nodeList == null) break;
                    int n = nodeList.getLength();
                    for (int i = 0; i < n; ++i) {
                        this.print(string, nodeList.item(i));
                    }
                    break;
                }
                this.out.print('&');
                this.out.print(node.getNodeName());
                this.out.print(';');
                break;
            }
            case 4: {
                if (this.canonical) {
                    this.out.print(this.normalize(node.getNodeValue()));
                    break;
                }
                this.out.print("<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.print("]]>");
                break;
            }
            case 3: {
                this.out.print(this.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(node.getNodeName());
                String string2 = node.getNodeValue();
                if (string2 != null && string2.length() > 0) {
                    this.out.print(' ');
                    this.out.print(string2);
                }
                this.out.println("?>");
                break;
            }
        }
        if (s == 1) {
            if (this.containsOnlyTextNode(node)) {
                this.out.print("</");
            } else {
                this.out.println();
                this.out.print(string + "</");
            }
            this.out.print(node.getNodeName());
            this.out.print('>');
        }
        this.out.flush();
    }

    protected String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    if (this.canonical) {
                        stringBuffer.append("&#");
                        stringBuffer.append(Integer.toString(c));
                        stringBuffer.append(';');
                        continue block7;
                    }
                    stringBuffer.append(c);
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    protected Attr[] sortAttributes(NamedNodeMap namedNodeMap) {
        int n;
        int n2 = namedNodeMap != null ? namedNodeMap.getLength() : 0;
        Attr[] attrArray = new Attr[n2];
        for (n = 0; n < n2; ++n) {
            attrArray[n] = (Attr)namedNodeMap.item(n);
        }
        for (n = 0; n < n2 - 1; ++n) {
            String string = attrArray[n].getNodeName();
            int n3 = n;
            for (int i = n + 1; i < n2; ++i) {
                String string2 = attrArray[i].getNodeName();
                if (string2.compareTo(string) >= 0) continue;
                string = string2;
                n3 = i;
            }
            if (n3 == n) continue;
            Attr attr = attrArray[n];
            attrArray[n] = attrArray[n3];
            attrArray[n3] = attr;
        }
        return attrArray;
    }

    private boolean containsOnlyTextNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() == 3) continue;
            return false;
        }
        return true;
    }
}

