/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.model.jaxb.Artifact;
import org.netbeans.modules.websvc.saas.model.jaxb.Artifacts;
import org.netbeans.modules.websvc.saas.model.jaxb.Method;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasMetadata;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasServices;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Saas {
    public static final String PROP_PARENT_GROUP = "parentGroup";
    public static final String PROP_STATE = "saasState";
    public static final String NS_SAAS = "http://xml.netbeans.org/websvc/saas/services/1.0";
    public static final String NS_WSDL = "http://schemas.xmlsoap.org/wsdl/";
    public static final String NS_WADL = "http://research.sun.com/wadl/2006/10";
    public static final String ARTIFACT_TYPE_LIBRARY = "library";
    protected final SaasServices delegate;
    private SaasGroup parentGroup;
    private SaasGroup topGroup;
    private List<SaasMethod> saasMethods;
    private State state = State.UNINITIALIZED;
    protected FileObject saasFolder;
    private boolean userDefined = true;
    private List<FileObject> libraryJars;
    protected FileObject saasFile;
    private Properties props;
    public static final String SAAS_PROPERTIES = "saas.properties";
    public static final String PROP_LOCAL_SERVICE_FILE = "local.service.file";
    private FileObject propFile;

    public Saas(SaasGroup saasGroup, SaasServices saasServices) {
        this.delegate = saasServices;
        this.parentGroup = saasGroup;
    }

    public Saas(SaasGroup saasGroup, String string, String string2, String string3) {
        SaasMetadata.CodeGen codeGen;
        this.delegate = new SaasServices();
        this.delegate.setUrl(string);
        this.delegate.setDisplayName(string2);
        SaasMetadata saasMetadata = this.delegate.getSaasMetadata();
        if (saasMetadata == null) {
            saasMetadata = new SaasMetadata();
            this.getDelegate().setSaasMetadata(saasMetadata);
        }
        if ((codeGen = saasMetadata.getCodeGen()) == null) {
            codeGen = new SaasMetadata.CodeGen();
            saasMetadata.setCodeGen(codeGen);
        }
        codeGen.setPackageName(string3);
        this.setParentGroup(saasGroup);
        this.computePathFromRoot();
    }

    public SaasServices getDelegate() {
        return this.delegate;
    }

    public SaasGroup getParentGroup() {
        return this.parentGroup;
    }

    protected void setParentGroup(SaasGroup saasGroup) {
        this.parentGroup = saasGroup;
    }

    public SaasGroup getTopLevelGroup() {
        if (this.topGroup == null && this.parentGroup != null) {
            this.topGroup = this.parentGroup;
            while (this.topGroup != null && this.topGroup.getParent() != SaasServicesModel.getInstance().getRootGroup()) {
                this.topGroup = this.topGroup.getParent();
            }
            if (this.topGroup == null) {
                this.topGroup = SaasServicesModel.getInstance().getRootGroup();
            }
        }
        return this.topGroup;
    }

    protected void computePathFromRoot() {
        this.delegate.getSaasMetadata().setGroup(this.parentGroup.getPathFromRoot());
    }

    public FileObject getSaasFile() throws IOException {
        if (this.saasFile == null) {
            FileObject fileObject = this.getSaasFolder();
            String string = fileObject.getName() + "-saas.xml";
            this.saasFile = fileObject.getFileObject(string);
            if (this.saasFile == null) {
                this.saasFile = this.getSaasFolder().createData(string);
            }
        }
        return this.saasFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        block6: {
            try {
                SaasUtil.saveSaas(this, this.getSaasFile());
                if (this.getProperties().size() <= 0) break block6;
                OutputStream outputStream = null;
                try {
                    outputStream = this.getPropFile(true).getOutputStream();
                    this.getProperties().store(outputStream, this.getDisplayName() + " : " + this.getUrl());
                }
                finally {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }

    public boolean isUserDefined() {
        return this.userDefined;
    }

    protected void setUserDefined(boolean bl) {
        if (this.userDefined) {
            this.userDefined = bl;
        }
    }

    public String getUrl() {
        return this.delegate.getUrl();
    }

    public State getState() {
        return this.state;
    }

    protected synchronized void setState(State state) {
        State state2 = this.state;
        this.state = state;
        SaasServicesModel.getInstance().fireChange(PROP_STATE, this, (Object)state2, (Object)this.state);
    }

    public void toStateReady(boolean bl) {
        if (bl) {
            this.setState(this.state);
        } else {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    Saas.this.setState(State.READY);
                }
            });
        }
    }

    public SaasMetadata getSaasMetadata() {
        return this.delegate.getSaasMetadata();
    }

    public List<SaasMethod> getMethods() {
        if (this.saasMethods == null) {
            this.saasMethods = new ArrayList<SaasMethod>();
            if (this.delegate.getMethods() != null && this.delegate.getMethods().getMethod() != null) {
                for (Method method : this.delegate.getMethods().getMethod()) {
                    this.saasMethods.add(this.createSaasMethod(method));
                }
            }
        }
        return Collections.unmodifiableList(this.saasMethods);
    }

    protected SaasMethod createSaasMethod(Method method) {
        return new SaasMethod(this, method);
    }

    public SaasServices.Header getHeader() {
        return this.delegate.getHeader();
    }

    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public String getApiDoc() {
        return this.delegate.getApiDoc();
    }

    public FileObject getSaasFolder() {
        if (this.saasFolder == null) {
            String string = SaasUtil.toValidJavaName(this.getDisplayName());
            this.saasFolder = SaasServicesModel.getWebServiceHome().getFileObject(string);
            if (this.saasFolder == null) {
                try {
                    this.saasFolder = SaasServicesModel.getWebServiceHome().createFolder(string);
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
        return this.saasFolder;
    }

    public String toString() {
        return this.getDisplayName();
    }

    protected void refresh() {
        this.setState(State.INITIALIZING);
        this.saasMethods = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties() throws IOException {
        if (this.props == null) {
            this.props = new Properties();
            FileObject fileObject = this.getPropFile(false);
            if (fileObject != null) {
                InputStream inputStream = this.getPropFile(false).getInputStream();
                try {
                    this.props.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
        }
        return this.props;
    }

    private FileObject getPropFile(boolean bl) throws IOException {
        if (this.propFile == null) {
            this.propFile = this.getSaasFolder().getFileObject(SAAS_PROPERTIES);
            if (this.propFile == null && bl) {
                this.propFile = this.getSaasFolder().createData(SAAS_PROPERTIES);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.propFile;
    }

    protected String getProperty(String string) {
        try {
            return this.getProperties().getProperty(string);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    protected void setProperty(String string, String string2) {
        try {
            this.getProperties().setProperty(string, string2);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public List<FileObject> getLibraryJars() {
        if (this.getState() != State.READY) {
            throw new IllegalStateException("Should only access libraries when in ready state");
        }
        if (this.libraryJars == null) {
            this.libraryJars = new ArrayList<FileObject>();
            if (this.getSaasMetadata() != null && this.getSaasMetadata().getCodeGen() != null) {
                for (Artifacts artifacts : this.getSaasMetadata().getCodeGen().getArtifacts()) {
                    for (Artifact artifact : artifacts.getArtifact()) {
                        if (!ARTIFACT_TYPE_LIBRARY.equals(artifact.getType())) continue;
                        try {
                            URL uRL = new URL(artifact.getUrl());
                            this.libraryJars.add(FileUtil.toFileObject((File)new File(uRL.toURI())));
                        }
                        catch (Exception exception) {
                            Exceptions.printStackTrace((Throwable)exception);
                        }
                    }
                }
            }
        }
        return Collections.unmodifiableList(this.libraryJars);
    }

    public String getPackageName() {
        return SaasUtil.deriveDefaultPackageName(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNINITIALIZED,
        INITIALIZING,
        RETRIEVED,
        READY;

    }
}

