/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.modules.websvc.saas.model.CustomSaas;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.WadlSaas;
import org.netbeans.modules.websvc.saas.model.WsdlSaas;
import org.netbeans.modules.websvc.saas.model.jaxb.Group;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasServices;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.netbeans.modules.websvc.saas.util.WsdlUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaasServicesModel {
    public static final String PROP_GROUPS = "groups";
    public static final String PROP_SERVICES = "services";
    public static final String ROOT_GROUP = "root";
    public static final String WEBSVC_HOME = System.getProperty("netbeans.user") + File.separator + "config" + File.separator + "WebServices";
    public static final String SERVICE_GROUP_XML = "service-groups.xml";
    public static final String PROFILE_PROPERTIES_FILE = "profile.properties";
    private SaasGroup rootGroup;
    private State state = State.UNINITIALIZED;
    private PropertyChangeSupport pps = new PropertyChangeSupport(this);
    private static SaasServicesModel instance;

    public static SaasServicesModel getInstance() {
        if (instance == null) {
            instance = new SaasServicesModel();
        }
        return instance;
    }

    private SaasServicesModel() {
    }

    public SaasGroup getInitialRootGroup() {
        if (this.rootGroup == null) {
            this.loadUserDefinedGroups();
        }
        return this.rootGroup;
    }

    public synchronized void initRootGroup() {
        if (this.state == State.READY) {
            return;
        }
        this.setState(State.INITIALIZING);
        this.getInitialRootGroup();
        this.loadFromDefaultFileSystem();
        this.loadFromWebServicesHome();
        WsdlUtil.ensureImportExisting60Services();
        this.setState(State.READY);
    }

    private void loadUserDefinedGroups() {
        FileObject fileObject = FileUtil.toFileObject((File)new File(WEBSVC_HOME, SERVICE_GROUP_XML));
        try {
            if (fileObject != null) {
                this.rootGroup = SaasUtil.loadSaasGroup(fileObject);
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        if (this.rootGroup == null) {
            Group group = new Group();
            group.setName(ROOT_GROUP);
            this.rootGroup = new SaasGroup(null, group);
        }
    }

    private void loadFromDefaultFileSystem() {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource("SaaSServices");
        if (fileObject != null && fileObject.isFolder()) {
            Enumeration enumeration = fileObject.getFolders(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject2 = (FileObject)enumeration.nextElement();
                for (FileObject fileObject3 : fileObject2.getChildren()) {
                    if (fileObject3.isFolder() || PROFILE_PROPERTIES_FILE.equals(fileObject3.getNameExt())) continue;
                    this.loadSaasServiceFile(fileObject3, false);
                }
                SaasGroup saasGroup = this.rootGroup.getChildGroup(fileObject2.getName());
                if (saasGroup == null) continue;
                saasGroup.setIcon16Path((String)fileObject2.getAttribute("icon16"));
                saasGroup.setIcon32Path((String)fileObject2.getAttribute("icon32"));
            }
        }
    }

    public void saveRootGroup() {
        try {
            SaasUtil.saveSaasGroup(this.rootGroup, new File(WEBSVC_HOME, SERVICE_GROUP_XML));
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public static FileObject getWebServiceHome() {
        File file = new File(WEBSVC_HOME);
        if (!file.isFile()) {
            file.mkdirs();
        }
        return FileUtil.toFileObject((File)file);
    }

    private void loadFromWebServicesHome() {
        for (FileObject fileObject : SaasServicesModel.getWebServiceHome().getChildren()) {
            if (!fileObject.isFolder()) continue;
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (!fileObject2.getNameExt().endsWith("-saas.xml")) continue;
                try {
                    this.loadSaasServiceFile(fileObject2, true);
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    private Saas createService(SaasGroup saasGroup, SaasServices saasServices) {
        if ("http://research.sun.com/wadl/2006/10".equals(saasServices.getType())) {
            return new WadlSaas(saasGroup, saasServices);
        }
        if ("http://schemas.xmlsoap.org/wsdl/".equals(saasServices.getType())) {
            return new WsdlSaas(saasGroup, saasServices);
        }
        return new CustomSaas(saasGroup, saasServices);
    }

    private void loadSaasServiceFile(FileObject fileObject, boolean bl) {
        block6: {
            try {
                SaasServices saasServices = SaasUtil.loadSaasServices(fileObject);
                Group group = saasServices.getSaasMetadata().getGroup();
                SaasGroup saasGroup = this.rootGroup;
                Saas saas = null;
                if (group == null || group.getName() == null || group.getName().trim().length() == 0) {
                    saas = this.createService(saasGroup, saasServices);
                    saas.setUserDefined(bl);
                    saasGroup.addService(saas);
                    break block6;
                }
                while (group != null) {
                    SaasGroup saasGroup2 = saasGroup.getChildGroup(group.getName());
                    if (saasGroup2 == null) {
                        saasGroup2 = new SaasGroup(saasGroup, group);
                        saasGroup.addChildGroup(saasGroup2);
                    }
                    saasGroup2.setUserDefined(bl);
                    if (group.getGroup().size() == 0) {
                        saas = this.createService(saasGroup2, saasServices);
                        saas.setUserDefined(bl);
                        saasGroup2.addService(saas);
                        break;
                    }
                    group = group.getGroup().get(0);
                    saasGroup = saasGroup2;
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)exception, (String)("Error loading saas file: " + fileObject.getPath())));
            }
        }
    }

    public SaasGroup getRootGroup() {
        this.initRootGroup();
        return this.rootGroup;
    }

    public State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(State state) {
        State state2 = state;
        synchronized (state2) {
            this.state = state;
            if (state == State.READY) {
                this.fireChange(PROP_GROUPS, this.rootGroup, null, this.rootGroup.getChildrenGroups());
                this.fireChange(PROP_SERVICES, this.rootGroup, null, this.rootGroup.getServices());
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pps.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pps.removePropertyChangeListener(propertyChangeListener);
    }

    protected void fireChange(String string, Object object, Object object2, Object object3) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(object, string, object2, object3);
        this.pps.firePropertyChange(propertyChangeEvent);
    }

    List<SaasGroup> getGroups() {
        return this.getRootGroup().getChildrenGroups();
    }

    public SaasGroup getTopGroup(String string) {
        return this.getRootGroup().getChildGroup(string);
    }

    public Saas getTopService(String string) {
        return this.getRootGroup().getChildService(string);
    }

    public synchronized SaasGroup createTopGroup(String string) {
        return this.createGroup(this.getInitialRootGroup(), string);
    }

    public synchronized SaasGroup createGroup(SaasGroup saasGroup, String string) {
        this.initRootGroup();
        SaasGroup saasGroup2 = saasGroup.createGroup(string);
        saasGroup.addChildGroup(saasGroup2);
        this.saveRootGroup();
        this.fireChange(PROP_GROUPS, saasGroup, null, saasGroup2);
        return saasGroup2;
    }

    public synchronized void removeGroup(SaasGroup saasGroup) {
        this.initRootGroup();
        SaasGroup saasGroup2 = saasGroup.getParent();
        if (saasGroup2 == null || !saasGroup2.removeChildGroup(saasGroup)) {
            throw new IllegalArgumentException("Can't remove group " + saasGroup.getName());
        }
        this.saveRootGroup();
        this.fireChange(PROP_GROUPS, saasGroup2, saasGroup, null);
    }

    public synchronized WsdlSaas createWsdlService(SaasGroup saasGroup, String string, String string2, String string3) {
        this.initRootGroup();
        WsdlSaas wsdlSaas = new WsdlSaas(saasGroup, string2, string, string3);
        wsdlSaas.setUserDefined(true);
        WsdlData wsdlData = WsdlUtil.addWsdlData(string2, string3);
        if (wsdlData != null) {
            wsdlSaas.setWsdlData(wsdlData);
            wsdlData.addPropertyChangeListener(wsdlSaas);
        }
        saasGroup.addService(wsdlSaas);
        wsdlSaas.save();
        this.fireChange(PROP_SERVICES, saasGroup, null, wsdlSaas);
        return wsdlSaas;
    }

    public WsdlSaas createWsdlService(SaasGroup saasGroup, String string, String string2) {
        return this.createWsdlService(saasGroup, WsdlUtil.getServiceDirName(string), string, string2);
    }

    public WadlSaas createWadlService(SaasGroup saasGroup, String string, String string2) {
        this.initRootGroup();
        String string3 = SaasUtil.getWadlServiceDirName(string);
        WadlSaas wadlSaas = new WadlSaas(saasGroup, string, string3, string2);
        wadlSaas.toStateReady(false);
        wadlSaas.setUserDefined(true);
        saasGroup.addService(wadlSaas);
        wadlSaas.save();
        this.fireChange(PROP_SERVICES, saasGroup, null, wadlSaas);
        return wadlSaas;
    }

    public synchronized void removeService(Saas saas) {
        this.initRootGroup();
        SaasGroup saasGroup = saas.getParentGroup();
        saasGroup.removeService(saas);
        this._removeService(saas);
        this.fireChange(PROP_SERVICES, saasGroup, saas, null);
    }

    void _removeService(Saas saas) {
        try {
            WsdlSaas wsdlSaas;
            if (saas instanceof WsdlSaas && (wsdlSaas = (WsdlSaas)saas).getState() == Saas.State.READY) {
                WsdlUtil.removeWsdlData(wsdlSaas.getWsdlData());
            }
            if ((wsdlSaas = saas.getSaasFolder()) != null) {
                wsdlSaas.delete();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public synchronized void renameGroup(SaasGroup saasGroup, String string) {
        String string2 = saasGroup.getName();
        saasGroup.setName(string);
        this.saveRootGroup();
        this.saveAllSaas(saasGroup);
        this.fireChange("groupName", saasGroup, string2, string);
    }

    private void saveAllSaas(SaasGroup saasGroup) {
        for (Saas object : saasGroup.getServices()) {
            object.save();
        }
        for (SaasGroup saasGroup2 : saasGroup.getChildrenGroups()) {
            this.saveAllSaas(saasGroup2);
        }
    }

    public synchronized void refreshService(Saas saas) {
        saas.refresh();
    }

    void reset() {
        this.rootGroup = null;
        this.state = State.UNINITIALIZED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        UNINITIALIZED,
        INITIALIZING,
        READY;

    }
}

