/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.netbeans.modules.websvc.saas.model.Saas;
import org.netbeans.modules.websvc.saas.model.SaasGroup;
import org.netbeans.modules.websvc.saas.model.WadlSaasMethod;
import org.netbeans.modules.websvc.saas.model.WadlSaasResource;
import org.netbeans.modules.websvc.saas.model.jaxb.Method;
import org.netbeans.modules.websvc.saas.model.jaxb.SaasServices;
import org.netbeans.modules.websvc.saas.model.wadl.Application;
import org.netbeans.modules.websvc.saas.model.wadl.Include;
import org.netbeans.modules.websvc.saas.model.wadl.Resource;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.netbeans.modules.websvc.saas.util.Xsd2Java;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WadlSaas
extends Saas {
    private Application wadlModel;
    private List<WadlSaasResource> resources;
    private FileObject wadlFile;
    private List<FileObject> schemaFiles;
    private List<FileObject> jaxbJars;
    private List<FileObject> jaxbSourceJars;

    public WadlSaas(SaasGroup saasGroup, SaasServices saasServices) {
        super(saasGroup, saasServices);
    }

    public WadlSaas(SaasGroup saasGroup, String string, String string2, String string3) {
        super(saasGroup, string, string2, string3);
        this.getDelegate().setType("http://research.sun.com/wadl/2006/10");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Application getWadlModel() throws IOException {
        if (this.wadlModel == null) {
            InputStream inputStream = null;
            if (this.isUserDefined()) {
                if (this.getLocalWadlFile() != null) {
                    inputStream = this.getLocalWadlFile().getInputStream();
                }
            } else {
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getUrl());
            }
            try {
                if (inputStream != null) {
                    this.wadlModel = SaasUtil.loadWadl(inputStream);
                }
            }
            catch (JAXBException jAXBException) {
                String string = NbBundle.getMessage(WadlSaas.class, (String)"MSG_ErrorLoadingWadl", (Object)this.getUrl());
                IOException iOException = new IOException(string);
                iOException.initCause(jAXBException);
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return this.wadlModel;
    }

    public List<WadlSaasResource> getResources() {
        if (this.resources == null) {
            this.resources = new ArrayList<WadlSaasResource>();
            try {
                for (Resource resource : this.getWadlModel().getResources().getResource()) {
                    this.resources.add(new WadlSaasResource(this, null, resource));
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                return Collections.EMPTY_LIST;
            }
        }
        return Collections.unmodifiableList(this.resources);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileObject getLocalWadlFile() {
        if (this.wadlFile != null) return this.wadlFile;
        try {
            if (this.isUserDefined()) {
                String string = this.getProperty("local.service.file");
                if (string != null) {
                    this.wadlFile = this.getSaasFolder().getFileObject(string);
                }
                if (this.wadlFile != null) return this.wadlFile;
                this.wadlFile = SaasUtil.retrieveWadlFile(this);
                if (this.wadlFile == null) throw new IllegalStateException("Failed to retrieved " + this.getUrl());
                string = FileUtil.getRelativePath((FileObject)this.saasFolder, (FileObject)this.wadlFile);
                this.setProperty("local.service.file", string);
                this.save();
                return this.wadlFile;
            } else {
                this.wadlFile = SaasUtil.extractWadlFile(this);
            }
            return this.wadlFile;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return this.wadlFile;
    }

    @Override
    protected WadlSaasMethod createSaasMethod(Method method) {
        return new WadlSaasMethod(this, method);
    }

    @Override
    public void toStateReady(boolean bl) {
        if (this.wadlModel == null) {
            this.setState(Saas.State.INITIALIZING);
            if (bl) {
                this.toStateReady();
            } else {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        WadlSaas.this.toStateReady();
                    }
                });
            }
        }
    }

    private void toStateReady() {
        try {
            this.getWadlModel();
            this.setState(Saas.State.RETRIEVED);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            this.setState(Saas.State.UNINITIALIZED);
            return;
        }
        try {
            this.compileSchemas();
            this.setState(Saas.State.READY);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public List getResourcesOrMethods() {
        if (this.getMethods() != null && this.getMethods().size() > 0) {
            return this.getMethods();
        }
        return this.getResources();
    }

    public String getBaseURL() {
        try {
            return this.getWadlModel().getResources().getBase();
        }
        catch (IOException iOException) {
            return NbBundle.getMessage(WadlSaas.class, (String)"LBL_BAD_WADL");
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.wadlFile != null) {
            try {
                this.wadlFile.getParent().delete();
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        this.wadlFile = null;
        this.wadlModel = null;
        this.resources = null;
        this.toStateReady(false);
    }

    private boolean compileSchemas() throws IOException {
        assert (this.wadlModel != null);
        this.jaxbJars = new ArrayList<FileObject>();
        this.jaxbSourceJars = new ArrayList<FileObject>();
        for (FileObject fileObject : this.getLocalSchemaFiles()) {
            Xsd2Java xsd2Java = new Xsd2Java(fileObject, this.getPackageName() + "." + SaasUtil.toValidJavaName(fileObject.getName()).toLowerCase());
            if (!xsd2Java.compile()) {
                return false;
            }
            this.jaxbJars.add(xsd2Java.getJaxbJarFile());
            this.jaxbSourceJars.add(xsd2Java.getJaxbSourceJarFile());
        }
        return true;
    }

    public List<FileObject> getLocalSchemaFiles() throws IOException {
        if (this.wadlModel == null) {
            throw new IllegalStateException("Should transition state to at least RETRIEVED");
        }
        FileObject fileObject = this.getLocalWadlFile().getParent();
        this.schemaFiles = new ArrayList<FileObject>();
        if (this.wadlModel.getGrammars() == null || this.wadlModel.getGrammars().getInclude() == null) {
            return this.schemaFiles;
        }
        for (Include include : this.wadlModel.getGrammars().getInclude()) {
            String string = include.getHref();
            FileObject fileObject2 = fileObject.getFileObject(string);
            if (fileObject2 == null) {
                try {
                    URI uRI = new URI(this.getUrl()).resolve(string);
                    String string2 = SaasUtil.dirOnlyPath(string);
                    fileObject2 = SaasUtil.saveResourceAsFile(fileObject, string2, uRI.getPath());
                }
                catch (URISyntaxException uRISyntaxException) {
                    Exceptions.printStackTrace((Throwable)uRISyntaxException);
                }
            }
            this.schemaFiles.add(fileObject2);
        }
        return this.schemaFiles;
    }

    @Override
    public List<FileObject> getLibraryJars() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(super.getLibraryJars());
        if (this.jaxbJars == null) {
            try {
                this.compileSchemas();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        arrayList.addAll(this.jaxbJars);
        return arrayList;
    }

    public List<FileObject> getJaxbSourceJars() {
        if (this.jaxbSourceJars == null) {
            try {
                this.compileSchemas();
                return Collections.unmodifiableList(this.jaxbSourceJars);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return Collections.emptyList();
    }
}

