/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabDisplayerUI;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;
import org.netbeans.swing.tabcontrol.plaf.ColorUtil;
import org.netbeans.swing.tabcontrol.plaf.DefaultTabSelectionModel;
import org.netbeans.swing.tabcontrol.plaf.EqualPolygon;
import org.netbeans.swing.tabcontrol.plaf.TabControlButton;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.TabState;
import org.netbeans.swing.tabcontrol.plaf.ViewTabLayoutModel;
import org.netbeans.swing.tabcontrol.plaf.ViewTabLayoutModel2;
import org.openide.windows.TopComponent;

public abstract class AbstractViewTabDisplayerUI
extends TabDisplayerUI {
    private TabDataModel dataModel;
    private TabLayoutModel layoutModel;
    private FontMetrics fm;
    private Font txtFont;
    private Component controlButtons;
    protected Controller controller;
    private TabControlButton btnClose;
    private TabControlButton btnAutoHidePin;
    private TabControlButton btnMaximizeRestore;
    private final Action pinAction = new PinAction();
    private static final String PIN_ACTION = "pinAction";
    private static final String TRANSPARENCY_ACTION = "transparencyAction";
    private static final int ICON_X_PAD = 1;
    protected final TabState tabState = new ViewTabState();

    public AbstractViewTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
        tabDisplayer.setLayout(null);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        ToolTipManager.sharedInstance().registerComponent(this.displayer);
        this.controller = this.createController();
        this.dataModel = this.displayer.getModel();
        if (Boolean.getBoolean("winsys.non_stretching_view_tabs")) {
            ViewTabLayoutModel2.PaddingInfo paddingInfo = new ViewTabLayoutModel2.PaddingInfo();
            paddingInfo.iconsXPad = 5;
            paddingInfo.txtIconsXPad = 10;
            paddingInfo.txtPad = new Dimension(5, 2);
            this.layoutModel = new ViewTabLayoutModel2(this.displayer, paddingInfo);
        } else {
            this.layoutModel = new ViewTabLayoutModel(this.dataModel, jComponent);
        }
        this.dataModel.addChangeListener(this.controller);
        this.dataModel.addComplexListDataListener(this.controller);
        this.displayer.addPropertyChangeListener(this.controller);
        this.selectionModel.addChangeListener(this.controller);
        this.displayer.addMouseListener(this.controller);
        this.displayer.addMouseMotionListener(this.controller);
        this.installControlButtons();
        this.dataModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AbstractViewTabDisplayerUI.this.showHidePinButton();
                if (null != AbstractViewTabDisplayerUI.this.dataModel) {
                    AbstractViewTabDisplayerUI.this.dataModel.removeChangeListener(this);
                }
            }
        });
    }

    void showHidePinButton() {
        Component component = null;
        int n = Math.max(0, this.displayer.getSelectionModel().getSelectedIndex());
        if (n >= 0 && n < this.displayer.getModel().size()) {
            TabData tabData = this.displayer.getModel().getTab(n);
            component = tabData.getComponent();
        }
        this.btnAutoHidePin.setVisible(component != null && !TabDisplayer.ORIENTATION_INVISIBLE.equals(this.displayer.getWinsysInfo().getOrientation(component)));
    }

    protected void installControlButtons() {
        if (null != this.getControlButtons()) {
            this.displayer.add(this.getControlButtons());
        }
    }

    protected Component getControlButtons() {
        if (null == this.controlButtons) {
            Icon icon;
            JPanel jPanel = new JPanel(null);
            jPanel.setOpaque(false);
            int n = 0;
            int n2 = 0;
            if (null != this.displayer.getWinsysInfo()) {
                this.btnAutoHidePin = TabControlButtonFactory.createSlidePinButton(this.displayer);
                jPanel.add(this.btnAutoHidePin);
                icon = this.btnAutoHidePin.getIcon();
                if (0 != n) {
                    ++n;
                }
                this.btnAutoHidePin.setBounds(n, 0, icon.getIconWidth(), icon.getIconHeight());
                n += icon.getIconWidth();
            }
            this.btnClose = TabControlButtonFactory.createCloseButton(this.displayer);
            jPanel.add(this.btnClose);
            icon = this.btnClose.getIcon();
            if (0 != n) {
                ++n;
            }
            this.btnClose.setBounds(n, 0, icon.getIconWidth(), icon.getIconHeight());
            n2 = icon.getIconHeight();
            Dimension dimension = new Dimension(n += icon.getIconWidth(), n2);
            jPanel.setMinimumSize(dimension);
            jPanel.setSize(dimension);
            jPanel.setPreferredSize(dimension);
            jPanel.setMaximumSize(dimension);
            this.controlButtons = jPanel;
        }
        return this.controlButtons;
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        ToolTipManager.sharedInstance().unregisterComponent(this.displayer);
        this.displayer.removePropertyChangeListener(this.controller);
        this.dataModel.removeChangeListener(this.controller);
        this.dataModel.removeComplexListDataListener(this.controller);
        this.selectionModel.removeChangeListener(this.controller);
        this.displayer.removeMouseListener(this.controller);
        this.displayer.removeMouseMotionListener(this.controller);
        if (this.controlButtons != null) {
            this.displayer.remove(this.controlButtons);
            this.controlButtons = null;
        }
        this.layoutModel = null;
        this.selectionModel = null;
        this.dataModel = null;
        this.controller = null;
    }

    protected Controller createController() {
        return new Controller();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        ColorUtil.setupAntialiasing(graphics);
        for (int i = 0; i < this.dataModel.size(); ++i) {
            TabData tabData = this.dataModel.getTab(i);
            int n = this.layoutModel.getX(i);
            int n2 = this.layoutModel.getY(i);
            int n3 = this.layoutModel.getW(i);
            int n4 = this.layoutModel.getH(i);
            String string = tabData.getText();
            if (!graphics.hitClip(n, n2, n3, n4)) continue;
            this.paintTabBackground(graphics, i, n, n2, n3, n4);
            this.paintTabContent(graphics, i, string, n, n2, n3, n4);
            this.paintTabBorder(graphics, i, n, n2, n3, n4);
        }
    }

    protected final TabDataModel getDataModel() {
        return this.dataModel;
    }

    public final TabLayoutModel getLayoutModel() {
        return this.layoutModel;
    }

    protected final TabDisplayer getDisplayer() {
        return this.displayer;
    }

    protected final SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public Controller getController() {
        return this.controller;
    }

    protected final boolean isSelected(int n) {
        return this.selectionModel.getSelectedIndex() == n;
    }

    protected final boolean isActive() {
        return this.displayer.isActive();
    }

    protected final boolean isFocused(int n) {
        return this.isSelected(n) && this.isActive();
    }

    protected final SingleSelectionModel createSelectionModel() {
        return new DefaultTabSelectionModel(this.displayer.getModel());
    }

    public int dropIndexOfPoint(Point point) {
        int n = 0;
        for (int i = 0; i < this.displayer.getModel().size(); ++i) {
            int n2 = this.getLayoutModel().getX(i);
            int n3 = this.getLayoutModel().getW(i);
            if (point.x < n2 || point.x > n2 + n3) continue;
            if (i == this.displayer.getModel().size() - 1) {
                if (point.x > n2 + n3 / 2) {
                    n = this.displayer.getModel().size();
                    break;
                }
                n = i;
                break;
            }
            n = i;
            break;
        }
        return n;
    }

    protected Font getTxtFont() {
        if (this.txtFont == null) {
            this.txtFont = (Font)UIManager.get("windowTitleFont");
            if (this.txtFont == null) {
                this.txtFont = new Font("Dialog", 0, 11);
            } else if (this.txtFont.isBold()) {
                this.txtFont = new Font(this.txtFont.getName(), 0, this.txtFont.getSize());
            }
        }
        return this.txtFont;
    }

    protected final FontMetrics getTxtFontMetrics() {
        if (this.fm == null) {
            TabDisplayer tabDisplayer = this.getDisplayer();
            this.fm = tabDisplayer.getFontMetrics(this.getTxtFont());
        }
        return this.fm;
    }

    protected abstract void paintTabContent(Graphics var1, int var2, String var3, int var4, int var5, int var6, int var7);

    protected abstract void paintTabBorder(Graphics var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract void paintTabBackground(Graphics var1, int var2, int var3, int var4, int var5, int var6);

    public void unregisterShortcuts(JComponent jComponent) {
        jComponent.getInputMap(1).remove(KeyStroke.getKeyStroke(8, 128));
        jComponent.getActionMap().remove(PIN_ACTION);
        jComponent.getInputMap(1).remove(KeyStroke.getKeyStroke(96, 128));
        jComponent.getActionMap().remove(TRANSPARENCY_ACTION);
    }

    public void registerShortcuts(JComponent jComponent) {
        jComponent.getInputMap(1).put(KeyStroke.getKeyStroke(8, 128), PIN_ACTION);
        jComponent.getActionMap().put(PIN_ACTION, this.pinAction);
        jComponent.getInputMap(1).put(KeyStroke.getKeyStroke(96, 128), TRANSPARENCY_ACTION);
        jComponent.getActionMap().put(TRANSPARENCY_ACTION, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractViewTabDisplayerUI.this.shouldPerformAction("toggleTransparency", AbstractViewTabDisplayerUI.this.getSelectionModel().getSelectedIndex(), null);
            }
        });
    }

    public Polygon getExactTabIndication(int n) {
        TabDisplayer tabDisplayer = this.getDisplayer();
        int n2 = tabDisplayer.getHeight();
        TabLayoutModel tabLayoutModel = this.getLayoutModel();
        int n3 = tabLayoutModel.getX(n);
        int n4 = n3 + tabLayoutModel.getW(n);
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = n3;
        nArray2[0] = 0;
        nArray[1] = n4;
        nArray2[1] = 0;
        nArray[2] = n4;
        nArray2[2] = n2 - 1;
        nArray[3] = n3;
        nArray2[3] = n2 - 1;
        return new EqualPolygon(nArray, nArray2);
    }

    public Polygon getInsertTabIndication(int n) {
        int n2;
        int n3;
        EqualPolygon equalPolygon = new EqualPolygon();
        TabDisplayer tabDisplayer = this.getDisplayer();
        int n4 = tabDisplayer.getHeight();
        int n5 = tabDisplayer.getWidth();
        TabLayoutModel tabLayoutModel = this.getLayoutModel();
        if (n == 0) {
            n3 = 0;
            n2 = tabLayoutModel.getW(0) / 2;
        } else if (n >= this.getDataModel().size()) {
            n3 = tabLayoutModel.getX(n - 1) + tabLayoutModel.getW(n - 1) / 2;
            n2 = n3 + tabLayoutModel.getW(n - 1);
            if (n2 > n5) {
                n2 = n5;
            }
        } else {
            n3 = tabLayoutModel.getX(n - 1) + tabLayoutModel.getW(n - 1) / 2;
            n2 = tabLayoutModel.getX(n) + tabLayoutModel.getW(n) / 2;
        }
        equalPolygon.moveTo(n3, 0);
        equalPolygon.lineTo(n2, 0);
        equalPolygon.lineTo(n2, n4 - 1);
        equalPolygon.lineTo(n3, n4 - 1);
        return equalPolygon;
    }

    public Image createImageOfTab(int n) {
        TabData tabData = this.displayer.getModel().getTab(n);
        JLabel jLabel = new JLabel(tabData.getText());
        int n2 = jLabel.getFontMetrics(jLabel.getFont()).stringWidth(tabData.getText());
        int n3 = jLabel.getFontMetrics(jLabel.getFont()).getHeight();
        n2 = n2 + tabData.getIcon().getIconWidth() + 6;
        n3 = Math.max(n3, tabData.getIcon().getIconHeight()) + 5;
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(jLabel.getForeground());
        graphics2D.setFont(jLabel.getFont());
        tabData.getIcon().paintIcon(jLabel, graphics2D, 0, 0);
        graphics2D.drawString(tabData.getText(), 18, n3 / 2);
        return bufferedImage;
    }

    public Rectangle getTabRect(int n, Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        if (n < 0 || n > this.displayer.getModel().size()) {
            rectangle.setBounds(0, 0, 0, 0);
            return rectangle;
        }
        rectangle.x = this.layoutModel.getX(n);
        rectangle.width = this.layoutModel.getW(n);
        rectangle.height = this.layoutModel.getH(n);
        rectangle.y = Math.min(0, this.displayer.getHeight() - rectangle.height);
        return rectangle;
    }

    public int tabForCoordinate(Point point) {
        int n = this.displayer.getModel().size();
        if (n == 0 || point.y > this.displayer.getHeight() || point.y < 0 || point.x < 0 || point.x > this.displayer.getWidth()) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = this.layoutModel.getX(i);
            int n3 = n2 + this.layoutModel.getW(i);
            if (point.x <= n2 || point.x >= n3) continue;
            return i;
        }
        return -1;
    }

    protected int createRepaintPolicy() {
        return 93;
    }

    protected boolean isAttention(int n) {
        return (this.tabState.getState(n) & 0x4000) != 0;
    }

    protected void requestAttention(int n) {
        this.tabState.addAlarmTab(n);
    }

    protected void cancelRequestAttention(int n) {
        this.tabState.removeAlarmTab(n);
    }

    private class PinAction
    extends AbstractAction {
        private PinAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (null != AbstractViewTabDisplayerUI.this.btnAutoHidePin) {
                AbstractViewTabDisplayerUI.this.btnAutoHidePin.performAction(null);
            }
        }
    }

    protected class Controller
    extends MouseAdapter
    implements MouseMotionListener,
    ChangeListener,
    PropertyChangeListener,
    ComplexListDataListener {
        private boolean selectionChanged;

        protected Controller() {
        }

        protected boolean shouldReact(MouseEvent mouseEvent) {
            boolean bl = SwingUtilities.isLeftMouseButton(mouseEvent);
            return bl;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            AbstractViewTabDisplayerUI.this.displayer.repaint();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("active".equals(propertyChangeEvent.getPropertyName())) {
                AbstractViewTabDisplayerUI.this.displayer.repaint();
            }
        }

        public boolean inControlButtonsRect(Point point) {
            if (null != AbstractViewTabDisplayerUI.this.controlButtons) {
                Point point2 = SwingUtilities.convertPoint(AbstractViewTabDisplayerUI.this.displayer, point, AbstractViewTabDisplayerUI.this.controlButtons);
                return AbstractViewTabDisplayerUI.this.controlButtons.contains(point2);
            }
            return false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl;
            Point point = mouseEvent.getPoint();
            int n = AbstractViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
            AbstractViewTabDisplayerUI.this.tabState.setPressed(n);
            SingleSelectionModel singleSelectionModel = AbstractViewTabDisplayerUI.this.getSelectionModel();
            boolean bl2 = this.selectionChanged = n != singleSelectionModel.getSelectedIndex();
            if ((n != -1 || !this.selectionChanged) && (bl = AbstractViewTabDisplayerUI.this.shouldPerformAction("select", n, mouseEvent))) {
                AbstractViewTabDisplayerUI.this.getSelectionModel().setSelectedIndex(n);
                AbstractViewTabDisplayerUI.this.tabState.setSelected(n);
                Component component = AbstractViewTabDisplayerUI.this.getDataModel().getTab(n).getComponent();
                if (null != component && component instanceof TopComponent && !((TopComponent)component).isAncestorOf(KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner())) {
                    ((TopComponent)component).requestActive();
                }
            }
            if (n != -1 && mouseEvent.isPopupTrigger()) {
                AbstractViewTabDisplayerUI.this.shouldPerformAction("popup", n, mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() >= 2 && !mouseEvent.isPopupTrigger()) {
                boolean bl;
                SingleSelectionModel singleSelectionModel;
                Point point = mouseEvent.getPoint();
                int n = AbstractViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
                boolean bl2 = this.selectionChanged = n != (singleSelectionModel = AbstractViewTabDisplayerUI.this.getSelectionModel()).getSelectedIndex();
                if ((n != -1 || !this.selectionChanged) && (bl = AbstractViewTabDisplayerUI.this.shouldPerformAction("select", n, mouseEvent))) {
                    AbstractViewTabDisplayerUI.this.getSelectionModel().setSelectedIndex(n);
                }
                if (n != -1) {
                    AbstractViewTabDisplayerUI.this.shouldPerformAction("maximize", n, mouseEvent);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            AbstractViewTabDisplayerUI.this.tabState.setPressed(-1);
            Point point = mouseEvent.getPoint();
            int n = AbstractViewTabDisplayerUI.this.getLayoutModel().indexOfPoint(point.x, point.y);
            if (n != -1 && mouseEvent.isPopupTrigger()) {
                AbstractViewTabDisplayerUI.this.shouldPerformAction("popup", n, mouseEvent);
            }
        }

        public void indicesAdded(ComplexListDataEvent complexListDataEvent) {
            AbstractViewTabDisplayerUI.this.tabState.indicesAdded(complexListDataEvent);
        }

        public void indicesRemoved(ComplexListDataEvent complexListDataEvent) {
            AbstractViewTabDisplayerUI.this.tabState.indicesRemoved(complexListDataEvent);
        }

        public void indicesChanged(ComplexListDataEvent complexListDataEvent) {
            AbstractViewTabDisplayerUI.this.tabState.indicesChanged(complexListDataEvent);
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            AbstractViewTabDisplayerUI.this.tabState.intervalAdded(listDataEvent);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            AbstractViewTabDisplayerUI.this.tabState.intervalRemoved(listDataEvent);
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            AbstractViewTabDisplayerUI.this.tabState.contentsChanged(listDataEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private class ViewTabState
    extends TabState {
        public int getRepaintPolicy(int n) {
            return AbstractViewTabDisplayerUI.this.createRepaintPolicy();
        }

        public void repaintAllTabs() {
            AbstractViewTabDisplayerUI.this.displayer.repaint();
        }

        public void repaintTab(int n) {
            if (n < 0 || n >= AbstractViewTabDisplayerUI.this.displayer.getModel().size()) {
                return;
            }
            Rectangle rectangle = AbstractViewTabDisplayerUI.this.getTabRect(n, null);
            AbstractViewTabDisplayerUI.this.displayer.repaint(rectangle);
        }
    }
}

