/*
 * Decompiled with CFR 0.152.
 */
package editor;

import com.tomsawyer.drawing.TSDLicenseManager;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import editor.ExGraphManager;
import editor.Tomahawk;
import editor.tool.ExMoveSelectedKeyAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.Timer;

public class ExGraphWindow
extends TSEGraphWindow
implements ActionListener {
    Timer timer = new Timer(this.getDefaultTimerDelay(), this);
    boolean updateOnTimerRequested;
    String status;
    boolean changed;
    String graphFileName;
    protected boolean hasFileName;
    ExMoveSelectedKeyAdapter moveAdapter;
    boolean needsFitInWindow = true;

    public ExGraphWindow(boolean bl) {
        this(null, bl);
    }

    public ExGraphWindow(ExGraphManager exGraphManager, boolean bl) {
        super((TSEGraphManager)exGraphManager, bl);
        this.timer.start();
        if (TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDIT_MOVE)) {
            this.moveAdapter = new ExMoveSelectedKeyAdapter(this);
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (Tomahawk.getInstance().isAutoFitInWindow()) {
                    ExGraphWindow.this.fitInWindow(true);
                }
            }
        });
    }

    public TSEGraphManager newGraphManager() {
        return new ExGraphManager();
    }

    public int getDefaultTimerDelay() {
        return 100;
    }

    public void setTimerDelay(int n) {
        this.timer.setDelay(n);
    }

    public int getTimerDelay() {
        return this.timer.getDelay();
    }

    public void addTimerListener(ActionListener actionListener) {
        this.timer.addActionListener(actionListener);
    }

    public void removeTimerListener(ActionListener actionListener) {
        this.timer.removeActionListener(actionListener);
    }

    public boolean isTimerEvent(ActionEvent actionEvent) {
        return actionEvent != null && actionEvent.getSource() == this.timer;
    }

    public void startTimer() {
        if (!this.isTimerRunning()) {
            this.timer.start();
        }
    }

    public boolean isTimerRunning() {
        return this.timer.isRunning();
    }

    public boolean stopTimer() {
        boolean bl = this.isTimerRunning();
        if (bl) {
            this.timer.stop();
        }
        return bl;
    }

    public void requestUpdateOnTimer() {
        this.updateOnTimerRequested = true;
    }

    public void onTimer() {
        if (this.updateOnTimerRequested) {
            this.updateInvalidRegion(true);
            this.updateOnTimerRequested = false;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isTimerEvent(actionEvent)) {
            this.onTimer();
        }
    }

    public void onResize(int n, int n2) {
        super.onResize(n, n2);
        if (this.needsFitInWindow) {
            this.fitInWindow(true);
            Tomahawk tomahawk = Tomahawk.getInstance();
            if (!tomahawk.isUsingMultipleWindows() || tomahawk.isUsingTabbedWindows() || tomahawk.getFrameForGraphWindow(this).isMaximum() && this.getCanvas().getHeight() > 100 && this.getCanvas().getWidth() > 100) {
                this.needsFitInWindow = false;
            }
        }
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setGraphFileName(String string) {
        this.graphFileName = string;
    }

    public String getGraphFileName() {
        return this.graphFileName;
    }

    protected boolean ownsSameGraphFile(String string) {
        if (!this.hasFileName) {
            return false;
        }
        if (this.graphFileName == null) {
            return string == null;
        }
        return this.graphFileName.equalsIgnoreCase(string);
    }

    public void move(int n) {
        if (this.moveAdapter != null) {
            this.moveAdapter.move(n);
        }
    }

    public void finalizeMove() {
        if (this.moveAdapter != null) {
            this.moveAdapter.finalizeTool();
        }
    }
}

