/*
 * Decompiled with CFR 0.152.
 */
package editor;

import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDLicenseManager;
import com.tomsawyer.editor.TSEDockableDialog;
import com.tomsawyer.editor.TSEDockingManager;
import com.tomsawyer.editor.TSEDrawingPreferencesDialog;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEImage;
import com.tomsawyer.editor.TSELineGrid;
import com.tomsawyer.editor.TSELocalization;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEPointGrid;
import com.tomsawyer.editor.TSEWindowTool;
import com.tomsawyer.editor.TSVisualizationProduct;
import com.tomsawyer.editor.command.TSEIncrementalLayoutCommand;
import com.tomsawyer.editor.command.TSELabelingCommand;
import com.tomsawyer.editor.command.TSELayoutCommand;
import com.tomsawyer.editor.command.TSERoutingCommand;
import com.tomsawyer.editor.complexity.TSEFoldingManager;
import com.tomsawyer.editor.complexity.TSEHidingManager;
import com.tomsawyer.editor.complexity.TSENestingManager;
import com.tomsawyer.editor.dialog.TSDialogCallBackListener;
import com.tomsawyer.editor.dialog.TSDialogWithCallBack;
import com.tomsawyer.editor.dialog.TSDoublePercentDocument;
import com.tomsawyer.editor.dialog.TSFileChooser;
import com.tomsawyer.editor.dialog.TSFileFilter;
import com.tomsawyer.editor.export.TSEPrint;
import com.tomsawyer.editor.export.TSEPrintPreviewWindow;
import com.tomsawyer.editor.export.TSEPrintSetup;
import com.tomsawyer.editor.export.TSEPrintSetupDialog;
import com.tomsawyer.editor.export.TSESaveAsImageDialog;
import com.tomsawyer.editor.inspector.TSEInspector;
import com.tomsawyer.editor.inspector.TSEInspectorWindow;
import com.tomsawyer.editor.overview.TSEOverviewWindow;
import com.tomsawyer.editor.service.TSEAllOptionsServiceInputData;
import com.tomsawyer.editor.service.layout.jlayout.TSELayoutConstraintsDialog;
import com.tomsawyer.editor.service.layout.jlayout.TSELayoutPropertiesDialog;
import com.tomsawyer.editor.tool.TSECreateEdgeTool;
import com.tomsawyer.editor.tool.TSECreateNodeTool;
import com.tomsawyer.editor.tool.TSEInteractiveZoomTool;
import com.tomsawyer.editor.tool.TSELinkNavigationTool;
import com.tomsawyer.editor.tool.TSEPanTool;
import com.tomsawyer.editor.tool.TSESelectTool;
import com.tomsawyer.editor.tool.TSEZoomTool;
import com.tomsawyer.editor.ui.TSEDefaultEdgeUI;
import com.tomsawyer.editor.ui.TSEDefaultNodeUI;
import com.tomsawyer.editor.ui.TSEEdgeUI;
import com.tomsawyer.editor.ui.TSELabelUI;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.editorx.TSENodePalette;
import com.tomsawyer.editorx.TSENodePaletteItem;
import com.tomsawyer.editorx.TSESVGImage;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphManager;
import com.tomsawyer.service.TSServiceException;
import com.tomsawyer.service.TSServiceInputData;
import com.tomsawyer.service.client.TSServiceProxy;
import com.tomsawyer.service.layout.jlayout.TSGeneralLayoutInputTailor;
import com.tomsawyer.service.layout.jlayout.TSLayoutInputTailor;
import com.tomsawyer.service.layout.jlayout.client.TSLayoutProxy;
import com.tomsawyer.util.TSLicenseManager;
import com.tomsawyer.util.TSLicenseRuntimeException;
import com.tomsawyer.util.TSOptionData;
import com.tomsawyer.util.TSProperty;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.xml.editor.TSEEnumerationTable;
import com.tomsawyer.xml.editor.TSEGraphXMLReader;
import com.tomsawyer.xml.editor.TSEVisualizationXMLReader;
import com.tomsawyer.xml.editor.TSEVisualizationXMLWriter;
import com.tomsawyer.xml.graph.TSGraphXMLWriter;
import com.tomsawyer.xml.service.layout.TSLayoutXMLWriter;
import editor.ExComboBox;
import editor.ExGraphManager;
import editor.ExGraphWindow;
import editor.ExParameterReader;
import editor.ExPrintSetup;
import editor.ExResourceBundle;
import editor.TomahawkActions;
import editor.tool.ExSelectTool;
import editor.ui.ExRectNodeUI;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultFocusManager;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import javax.swing.plaf.metal.MetalInternalFrameUI;
import javax.swing.text.Document;

public class Tomahawk
extends JApplet
implements ExParameterReader {
    public static final int MAX_ZOOM = 5000;
    public static final double MIN_ZOOM = 0.01;
    private static ExResourceBundle resourceBundle = null;
    private static AppletStub appletStub = null;
    private static Tomahawk tomahawk = null;
    private static TomahawkActions actions = null;
    static boolean isChangingMultipleWindowsDisplay = false;
    ExGraphWindow graphWindow;
    String graphFileName;
    TSFileChooser fileChooser;
    TSFileChooser importFileChooser;
    TSFileChooser exportFileChooser;
    Hashtable nodeStore = new Hashtable();
    Hashtable edgeStore = new Hashtable();
    Hashtable labelStore = new Hashtable();
    TSLayoutProxy layoutProxy;
    Hashtable serviceInputDataTable = new Hashtable();
    TSEOverviewWindow overviewWindow;
    Rectangle overviewBounds = new Rectangle(0, 0, 200, 200);
    boolean overviewBoundsCreated;
    TSEInspectorWindow inspectorWindow;
    TSELayoutConstraintsDialog layoutConstraintsDialog;
    TSEPrintSetup printSetup;
    TSEDockableDialog nodePalette;
    TSELayoutPropertiesDialog layoutPropertiesDialog;
    TSEDrawingPreferencesDialog drawingPreferencesDialog;
    TSESaveAsImageDialog saveAsImageDialog;
    WindowHandler windowHandler;
    MouseHandler mouseHandler;
    TSEDockingManager dockingManager;
    boolean dockableWindows = true;
    boolean canCooperate;
    boolean useMultipleWindows;
    boolean useTabbedWindows;
    boolean isAppExiting = false;
    JTabbedPane tabbedPane = null;
    JDesktopPane desktopPane = null;
    List graphWindowList = new LinkedList();
    JFrame appFrame;
    JToolBar nodeToolBar;
    JToolBar edgeToolBar;
    JToolBar miscToolBar;
    JPanel northPanel;
    JPanel southPanel;
    JPanel westPanel;
    JPanel eastPanel;
    TSELineGrid lineGrid;
    TSEPointGrid pointGrid;
    ExComboBox zoomComboBox;
    boolean autoFitInWindow;
    Insets windowInsets = new Insets(12, 12, 29, 29);
    boolean inspectorFirstShown;
    boolean constraintFirstShown;
    boolean hasFileWriteAccess;
    boolean hasFileReadAccess;
    boolean hasClipboardAccess;
    boolean hasPrinterAccess;
    boolean incrementalLayoutEnabled = true;
    boolean batikPresent;
    int nextNewDocIndex = 1;
    private boolean windowActivated = false;
    private TSFileFilter tsvFilter;
    private TSFileFilter tsvzFilter;
    static /* synthetic */ Class class$editor$ui$ExRectNodeUI;
    static /* synthetic */ Class class$editor$ui$ExAnimatedImageNodeUI;
    static /* synthetic */ Class class$editor$ui$ExAnimatedRectNodeUI;
    static /* synthetic */ Class class$editor$ui$ExBusNodeUI;
    static /* synthetic */ Class class$editor$ui$ExCompositeNodeUI;
    static /* synthetic */ Class class$editor$ui$ExJButtonNodeUI;
    static /* synthetic */ Class class$editor$ui$ExJComboBoxNodeUI;
    static /* synthetic */ Class class$editor$ui$ExJTableNodeUI;
    static /* synthetic */ Class class$editor$ui$ExJEditorPaneNodeUI;
    static /* synthetic */ Class class$editor$ui$ExAnimatedEdgeUI;
    static /* synthetic */ Class class$editor$ui$ExJButtonLabelUI;
    static /* synthetic */ Class class$editor$ui$ExJCheckBoxLabelUI;
    static /* synthetic */ Class class$editor$Tomahawk;

    public Tomahawk() throws Exception {
        if (tomahawk != null) {
            throw new Exception("Multiple instantiation of Tomahawk not allowed");
        }
        tomahawk = this;
        if (!Tomahawk.isApplet()) {
            this.setStub(Tomahawk.getAppletStub());
            this.appFrame = new JFrame();
            this.appFrame.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    Tomahawk.this.getRootPane().requestFocus();
                }
            });
        } else {
            this.getRootPane().setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createRaisedBevelBorder()));
        }
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                Tomahawk.this.getRootPane().requestFocus();
            }
        });
        this.getRootPane().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                Tomahawk.this.onFocusGained();
            }
        });
        this.hasFileReadAccess = TSSystem.hasFileReadAccess();
        this.hasFileWriteAccess = TSSystem.hasFileWriteAccess();
        this.hasClipboardAccess = TSSystem.hasClipboardAccess();
        this.hasPrinterAccess = true;
        TSSystem.setApplet((boolean)Tomahawk.isApplet());
    }

    public static Tomahawk getInstance() {
        if (tomahawk == null) {
            try {
                tomahawk = new Tomahawk();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return tomahawk;
    }

    public static ExResourceBundle getResources() {
        if (resourceBundle == null) {
            resourceBundle = (ExResourceBundle)ResourceBundle.getBundle("editor.TomahawkBundle");
            resourceBundle.setParameterReader(Tomahawk.getInstance());
        }
        return resourceBundle;
    }

    public static TomahawkActions getActions() {
        if (actions == null) {
            actions = new TomahawkActions();
        }
        return actions;
    }

    static AppletStub getAppletStub() {
        return appletStub;
    }

    static void setAppletStub(AppletStub appletStub) {
        Tomahawk.appletStub = appletStub;
    }

    public void init() {
        block2: {
            try {
                TSDLicenseManager.checkLicenseException((String)TSDLicenseManager.BASE);
            }
            catch (TSLicenseRuntimeException tSLicenseRuntimeException) {
                JOptionPane.showMessageDialog(null, tSLicenseRuntimeException.getMessage(), Tomahawk.getResources().getStringResource("dialog.licensebaseerror.title"), 0);
                if (this.isApplet()) break block2;
                System.exit(1);
            }
        }
        TSLicenseManager.initTSSLicensing();
        this.installLayoutServer();
        this.createGUI();
        TSENestingManager.getManager((TSDGraphManager)this.getGraphManager());
        TSEFoldingManager.getManager((TSDGraphManager)this.getGraphManager());
        TSEHidingManager.getManager((TSDGraphManager)this.getGraphManager());
        this.getGraphManager().getEventManager().setFireEvents(false);
        this.setDefaults();
        this.getGraphManager().getEventManager().setFireEvents(true);
        super.init();
    }

    public void start() {
        this.canCooperate = true;
        super.start();
        this.getGraphWindow().initDropTarget();
    }

    public void stop() {
        this.canCooperate = false;
        super.stop();
    }

    public void destroy() {
        if (this.layoutPropertiesDialog != null) {
            this.layoutPropertiesDialog.dispose();
        }
        if (this.drawingPreferencesDialog != null) {
            this.drawingPreferencesDialog.dispose();
        }
        if (this.nodePalette != null) {
            this.nodePalette.dispose();
        }
        if (this.layoutConstraintsDialog != null) {
            this.layoutConstraintsDialog.dispose();
        }
        if (this.overviewWindow != null) {
            this.overviewWindow.dispose();
        }
        if (this.inspectorWindow != null) {
            this.inspectorWindow.dispose();
        }
        resourceBundle = null;
        appletStub = null;
        tomahawk = null;
        actions = null;
        super.destroy();
    }

    public String getLayoutServerOperations() {
        String string = null;
        string = this.getLayoutProxy() != null ? this.getLayoutProxy().getAvailableOperations() : "Unavailable";
        return string;
    }

    public String getLayoutServerStyles() {
        String string = null;
        string = this.getLayoutProxy() != null ? this.getLayoutProxy().getAvailableStyles() : "Unavailable";
        return string;
    }

    public String getLayoutServerType() {
        String string = Tomahawk.getResources().getStringResource("service.server.type");
        String string2 = string.equals("direct") ? "Local Layout Configuration" : (string.equals("soap") ? "SOAP Layout Configuration" : (string.equals("servlet") ? "Servlet Layout Configuration" : (string.equals("rmi") ? "RMI Layout Configuration" : "No Layout Configuration")));
        return string2;
    }

    public String getLayoutServerStyleHeadings() {
        String string = null;
        if (this.isLayoutStyleSupported(1)) {
            string = string == null ? "H" : string + ", H";
        }
        if (this.isLayoutStyleSupported(2)) {
            string = string == null ? "O" : string + ", O";
        }
        if (this.isLayoutStyleSupported(3)) {
            string = string == null ? "S" : string + ", S";
        }
        if (string == null) {
            string = "Unavailable";
        }
        return string;
    }

    public boolean isLayoutStyleSupported(int n) {
        boolean bl = false;
        if (n == 1) {
            if (TSDLicenseManager.checkLicense((String)TSDLicenseManager.HIERARCHICAL_ORTHOGONAL_LAYOUT) || TSDLicenseManager.checkLicense((String)TSDLicenseManager.HIERARCHICAL_POLYLINE_LAYOUT)) {
                bl = true;
            }
        } else if (n == 2) {
            if (TSDLicenseManager.checkLicense((String)TSDLicenseManager.ORTHOGONAL_LAYOUT)) {
                bl = true;
            }
        } else if (n == 3 && TSDLicenseManager.checkLicense((String)TSDLicenseManager.SYMMETRIC_LAYOUT)) {
            bl = true;
        }
        return bl && this.getLayoutServerStyles().indexOf(String.valueOf(n)) != -1;
    }

    public boolean isLayoutOperationSupported(int n) {
        boolean bl = false;
        if (n == 1000) {
            if (TSDLicenseManager.checkLicense((String)TSDLicenseManager.GLOBAL_LAYOUT) || TSDLicenseManager.checkLicense((String)TSDLicenseManager.INCREMENTAL_LAYOUT)) {
                bl = true;
            }
        } else if (n == 1001) {
            if (TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDGE_ROUTING_LAYOUT)) {
                bl = true;
            }
        } else if (n == 1002 && TSDLicenseManager.checkLicense((String)TSDLicenseManager.LABEL_LAYOUT)) {
            bl = true;
        }
        return bl && this.getLayoutServerOperations().indexOf(String.valueOf(n)) != -1;
    }

    public String getAppletInfo() {
        String string = Tomahawk.getResources().getStringResource("applet.info");
        string = TSSystem.replace((String)string, (String)"%TSVJ_VERSION%", (String)TSVisualizationProduct.getBuildString());
        return string;
    }

    public void setDefaults() {
        if (!TSSystem.isJVM14orAbove()) {
            FocusManager.setCurrentManager(new ExFocusManager());
        }
        this.createDefaultNodeUI();
        this.createDefaultEdgeUI();
        this.setGraphWindowDefaults(this.getGraphWindow());
        this.checkAllButtons();
        this.correlateButtonAbility("PASTE_GRAPH", this.getGraphWindow().canPaste());
        this.setTitle();
        this.setAutoFitInWindow(false);
        this.tsvFilter = new TSFileFilter(Tomahawk.getResources().getStringResource("file.xml.extension"), Tomahawk.getResources().getStringResource("file.xml.description"));
        this.tsvzFilter = new TSFileFilter(Tomahawk.getResources().getStringResource("file.xmlCompressed.extension"), Tomahawk.getResources().getStringResource("file.xmlCompressed.description"));
        UIManager.put("FileChooser.acceptAllFileFilterText", Tomahawk.getResources().getStringResource("file.all.description"));
    }

    static void registerNewUIs() {
        TSEEnumerationTable.getTable().addUIName("rectangleNode", class$editor$ui$ExRectNodeUI == null ? (class$editor$ui$ExRectNodeUI = Tomahawk.class$("editor.ui.ExRectNodeUI")) : class$editor$ui$ExRectNodeUI);
        TSEEnumerationTable.getTable().addUIName("animatedImageNode", class$editor$ui$ExAnimatedImageNodeUI == null ? (class$editor$ui$ExAnimatedImageNodeUI = Tomahawk.class$("editor.ui.ExAnimatedImageNodeUI")) : class$editor$ui$ExAnimatedImageNodeUI);
        TSEEnumerationTable.getTable().addUIName("animatedShapeNode", class$editor$ui$ExAnimatedRectNodeUI == null ? (class$editor$ui$ExAnimatedRectNodeUI = Tomahawk.class$("editor.ui.ExAnimatedRectNodeUI")) : class$editor$ui$ExAnimatedRectNodeUI);
        TSEEnumerationTable.getTable().addUIName("busNode", class$editor$ui$ExBusNodeUI == null ? (class$editor$ui$ExBusNodeUI = Tomahawk.class$("editor.ui.ExBusNodeUI")) : class$editor$ui$ExBusNodeUI);
        TSEEnumerationTable.getTable().addUIName("compositeNode", class$editor$ui$ExCompositeNodeUI == null ? (class$editor$ui$ExCompositeNodeUI = Tomahawk.class$("editor.ui.ExCompositeNodeUI")) : class$editor$ui$ExCompositeNodeUI);
        TSEEnumerationTable.getTable().addUIName("buttonNode", class$editor$ui$ExJButtonNodeUI == null ? (class$editor$ui$ExJButtonNodeUI = Tomahawk.class$("editor.ui.ExJButtonNodeUI")) : class$editor$ui$ExJButtonNodeUI);
        TSEEnumerationTable.getTable().addUIName("comboboxNode", class$editor$ui$ExJComboBoxNodeUI == null ? (class$editor$ui$ExJComboBoxNodeUI = Tomahawk.class$("editor.ui.ExJComboBoxNodeUI")) : class$editor$ui$ExJComboBoxNodeUI);
        TSEEnumerationTable.getTable().addUIName("tableNode", class$editor$ui$ExJTableNodeUI == null ? (class$editor$ui$ExJTableNodeUI = Tomahawk.class$("editor.ui.ExJTableNodeUI")) : class$editor$ui$ExJTableNodeUI);
        TSEEnumerationTable.getTable().addUIName("editorPaneNode", class$editor$ui$ExJEditorPaneNodeUI == null ? (class$editor$ui$ExJEditorPaneNodeUI = Tomahawk.class$("editor.ui.ExJEditorPaneNodeUI")) : class$editor$ui$ExJEditorPaneNodeUI);
        TSEEnumerationTable.getTable().addUIName("animatedEdge", class$editor$ui$ExAnimatedEdgeUI == null ? (class$editor$ui$ExAnimatedEdgeUI = Tomahawk.class$("editor.ui.ExAnimatedEdgeUI")) : class$editor$ui$ExAnimatedEdgeUI);
        TSEEnumerationTable.getTable().addUIName("buttonLabel", class$editor$ui$ExJButtonLabelUI == null ? (class$editor$ui$ExJButtonLabelUI = Tomahawk.class$("editor.ui.ExJButtonLabelUI")) : class$editor$ui$ExJButtonLabelUI);
        TSEEnumerationTable.getTable().addUIName("checkboxLabel", class$editor$ui$ExJCheckBoxLabelUI == null ? (class$editor$ui$ExJCheckBoxLabelUI = Tomahawk.class$("editor.ui.ExJCheckBoxLabelUI")) : class$editor$ui$ExJCheckBoxLabelUI);
    }

    public void setGraphWindowDefaults(TSEGraphWindow tSEGraphWindow) {
        if (this.hasClipboardAccess) {
            tSEGraphWindow.setClipboard(this.getToolkit().getSystemClipboard());
        }
        Tomahawk.getActions().onSwitchToSelect();
        tSEGraphWindow.setToolTipShown(true);
        this.lineGrid = new TSELineGrid();
        this.pointGrid = new TSEPointGrid();
        Tomahawk.getActions().onGridType("GRID_TYPE.none", false);
        Tomahawk.getActions().onGridSize("GRID_SIZE.10", false);
        TSENodeUI tSENodeUI = this.getNodeUI("nodeUI.default");
        tSEGraphWindow.setCurrentNodeUI(tSENodeUI);
        TSEEdgeUI tSEEdgeUI = this.getEdgeUI("edgeUI.default");
        tSEGraphWindow.setCurrentEdgeUI(tSEEdgeUI);
    }

    void createDefaultNodeUI() {
        String string = Tomahawk.getResources().getStringResource("nodeUI.default.class");
        try {
            TSENodeUI tSENodeUI = (TSENodeUI)Class.forName(string).newInstance();
            this.setUIAttributes("nodeUI.default", (TSEObjectUI)tSENodeUI);
            this.addNodeUI("nodeUI.default", tSENodeUI);
            this.correlateButtonSelection("CREATE_NODE_TOOL.nodeUI.default", true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.println("Failed to instantiate default node UI " + string);
            TSEDefaultNodeUI tSEDefaultNodeUI = new TSEDefaultNodeUI();
            this.addNodeUI("nodeUI.default", (TSENodeUI)tSEDefaultNodeUI);
        }
    }

    void createDefaultEdgeUI() {
        String string = Tomahawk.getResources().getStringResource("edgeUI.default.class");
        try {
            TSEEdgeUI tSEEdgeUI = (TSEEdgeUI)Class.forName(string).newInstance();
            this.setUIAttributes("edgeUI.default", (TSEObjectUI)tSEEdgeUI);
            this.addEdgeUI("edgeUI.default", tSEEdgeUI);
            this.correlateButtonSelection("CREATE_EDGE_TOOL.edgeUI.default", true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.println("Failed to instantiate edge UI " + string);
            TSEDefaultEdgeUI tSEDefaultEdgeUI = new TSEDefaultEdgeUI();
            this.addEdgeUI("edgeUI.default", (TSEEdgeUI)tSEDefaultEdgeUI);
        }
    }

    public void createGUI() {
        this.setLookAndFeel();
        this.getContentPane().setLayout(new BorderLayout());
        this.windowHandler = new WindowHandler();
        this.mouseHandler = new MouseHandler();
        TSEImage.setLoaderClass(this.getClass());
        this.useMultipleWindows = "true".equals(Tomahawk.getResources().getStringResource("app.mdi.enabled"));
        this.useTabbedWindows = "true".equals(Tomahawk.getResources().getStringResource("app.mdi.style.tabbed"));
        boolean bl = false;
        Tomahawk.registerNewUIs();
        if (!this.isApplet()) {
            try {
                TSESVGImage.initBatik();
                TSESVGImage.setLoaderClass(this.getClass());
                this.batikPresent = true;
            }
            catch (Throwable throwable) {
                this.batikPresent = false;
                System.err.println("Failed to initialize Batik.");
                throwable.printStackTrace();
            }
            if (this.getGraphFileName() != null) {
                bl = this.onLoadGraph(this.getGraphFileName());
            }
        }
        if (!bl) {
            this.setGraphFileName(null);
            this.initGraphWindow();
            this.setChanged(false);
        }
        this.createMenusAndToolbars();
        if (!this.isApplet()) {
            this.appFrame.addWindowListener(this.windowHandler);
        }
        this.mouseHandler.init();
        this.dockingManager = new TSEDockingManager(this.getContentPane(), Tomahawk.getResources().getIconResource("app.icon", class$editor$Tomahawk == null ? (class$editor$Tomahawk = Tomahawk.class$("editor.Tomahawk")) : class$editor$Tomahawk));
        this.createLayoutConstraintsDialog();
        this.createLayoutProperties();
        this.registerKeyCommands(this.getRootPane());
        this.getRootPane().requestFocus();
        this.setChanged(false);
        if (!this.isApplet()) {
            try {
                this.appFrame.pack();
                int n = Integer.parseInt(this.getResources().getStringResource("app.window.width"));
                int n2 = Integer.parseInt(this.getResources().getStringResource("app.window.height"));
                int n3 = Math.max(n, this.appFrame.getWidth());
                int n4 = Math.max(n2, this.appFrame.getHeight());
                this.appFrame.setSize(n3, n4);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.appFrame.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - this.appFrame.getSize().width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - this.appFrame.getSize().height) / 2);
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setLookAndFeel() {
        String string = Tomahawk.getResources().getStringResource("app.lookAndFeel");
        string = "mac".equals(string) ? "com.apple.mrj.swing.MacLookAndFeel" : ("windows".equals(string) ? "com.sun.java.swing.plaf.windows.WindowsLookAndFeel" : ("motif".equals(string) ? "com.sun.java.swing.plaf.motif.MotifLookAndFeel" : ("metal".equals(string) ? "javax.swing.plaf.metal.MetalLookAndFeel" : ("system".equals(string) ? UIManager.getSystemLookAndFeelClassName() : null))));
        if (string != null) {
            try {
                UIManager.setLookAndFeel(string);
                SwingUtilities.updateComponentTreeUI(this.getOwnerFrame());
            }
            catch (Exception exception) {
                System.err.println("failed to set look and feel to " + string);
            }
        }
    }

    public JToolBar addToolBar(String string) {
        JToolBar jToolBar = Tomahawk.getResources().createToolBar(string, Tomahawk.getActions());
        if (jToolBar == null) {
            return jToolBar;
        }
        Object object = Tomahawk.getResources().getObjectResource(string + ".location");
        JPanel jPanel = object == "South" ? this.southPanel : (object == "West" ? this.westPanel : (object == "East" ? this.eastPanel : this.northPanel));
        Object object2 = Tomahawk.getResources().getObjectResource(string + ".sublocation");
        if (object2 == null) {
            object2 = "Center";
        }
        jPanel.add((Component)jToolBar, object2);
        return jToolBar;
    }

    public void createMenusAndToolbars() {
        this.setJMenuBar(Tomahawk.getResources().createMenuBar(Tomahawk.getActions()));
        this.northPanel = new JPanel(new BorderLayout());
        this.southPanel = new JPanel(new BorderLayout());
        this.westPanel = new JPanel(new BorderLayout());
        this.eastPanel = new JPanel(new BorderLayout());
        this.northPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.southPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.westPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.eastPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.getContentPane().add((Component)this.northPanel, "North");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.getContentPane().add((Component)this.westPanel, "West");
        this.getContentPane().add((Component)this.eastPanel, "East");
        this.nodeToolBar = this.addToolBar("toolbar.nodes");
        this.edgeToolBar = this.addToolBar("toolbar.edges");
        this.miscToolBar = this.addToolBar("toolbar.misc");
    }

    public void initGraphWindow() {
        ExGraphWindow exGraphWindow = new ExGraphWindow(true);
        exGraphWindow.getGraphManager().getEventManager().setFireEvents(false);
        this.initGraphWindow(exGraphWindow);
        exGraphWindow.getGraphManager().getEventManager().setFireEvents(true);
        this.graphWindow.hasFileName = false;
    }

    public void initGraphWindow(ExGraphWindow exGraphWindow) {
        this.graphWindow = exGraphWindow;
        Tomahawk.getActions().registerListeners();
        try {
            exGraphWindow.setDefaultTool((TSEWindowTool)new ExSelectTool());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n = Integer.parseInt(Tomahawk.getResources().getStringResource("app.undo.limit"));
            exGraphWindow.setDefaultUndoLimit(n);
        }
        catch (Exception exception) {
            System.out.println("Unable to set requested undo limit.");
        }
        if (!this.isUsingMultipleWindows()) {
            this.getContentPane().add((Component)((Object)exGraphWindow), "Center");
            if (this.dockingManager != null) {
                this.dockingManager.updateGraphWindow((TSEGraphWindow)exGraphWindow);
            }
        } else {
            this.addGraphWindow(exGraphWindow);
            this.graphWindowList.add(0, exGraphWindow);
        }
        exGraphWindow.getCanvas().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Tomahawk.this.getRootPane().requestFocus();
            }
        });
        exGraphWindow.getCanvas().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                Tomahawk.this.getRootPane().requestFocus();
            }
        });
        exGraphWindow.setBorder(new SoftBevelBorder(1));
    }

    public boolean isUsingMultipleWindows() {
        return this.useMultipleWindows;
    }

    public boolean isUsingTabbedWindows() {
        return this.useMultipleWindows && this.useTabbedWindows;
    }

    public boolean isUsingInternalWindows() {
        return this.useMultipleWindows && !this.useTabbedWindows;
    }

    public void addGraphWindow(ExGraphWindow exGraphWindow) {
        String string;
        ImageIcon imageIcon = Tomahawk.getResources().getIconResource("app.doc.icon", class$editor$Tomahawk == null ? (class$editor$Tomahawk = Tomahawk.class$("editor.Tomahawk")) : class$editor$Tomahawk);
        this.graphWindow = exGraphWindow;
        this.graphFileName = this.graphWindow.getGraphFileName();
        String string2 = string = this.getGraphName();
        if (exGraphWindow.getGraphFileName() == null) {
            exGraphWindow.setGraphFileName(this.getGraphFileName());
        }
        if (this.isUsingTabbedWindows()) {
            JTabbedPane jTabbedPane = this.getTabbedPane();
            if (isChangingMultipleWindowsDisplay) {
                jTabbedPane.insertTab(string, imageIcon, (Component)((Object)exGraphWindow), string2, 0);
                jTabbedPane.setSelectedIndex(0);
            } else {
                jTabbedPane.addTab(string, imageIcon, (Component)((Object)exGraphWindow), string2);
                jTabbedPane.setSelectedIndex(jTabbedPane.getTabCount() - 1);
            }
        } else if (this.isUsingInternalWindows()) {
            TSJInternalFrame tSJInternalFrame = new TSJInternalFrame(string, true, true, true, true);
            tSJInternalFrame.setSize(Integer.parseInt(Tomahawk.getResources().getStringResource("graphwindow.default.width")), Integer.parseInt(Tomahawk.getResources().getStringResource("graphwindow.default.height")));
            tSJInternalFrame.setLocation(10, 10);
            tSJInternalFrame.setFrameIcon(imageIcon);
            tSJInternalFrame.getContentPane().add((Component)((Object)exGraphWindow));
            tSJInternalFrame.setVisible(true);
            this.getDesktopPane().add(tSJInternalFrame);
            try {
                tSJInternalFrame.setMaximum(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                System.err.println("Error maximizing internal frame.");
            }
            tSJInternalFrame.toFront();
            tSJInternalFrame.setDefaultCloseOperation(0);
            if (!TSSystem.isJVM14orAbove() && "metal".equals(Tomahawk.getResources().getStringResource("app.lookAndFeel"))) {
                tSJInternalFrame.setUI(new MetalInternalFrameUI(tSJInternalFrame){

                    public MouseInputListener createGlassPaneDispatcher() {
                        return new BasicInternalFrameUI.GlassPaneDispatcher(this){
                            private final /* synthetic */ 6 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void mouseDragged(MouseEvent mouseEvent) {
                                mouseEvent = new MouseEvent(6.access$100(this.this$1).getGraphWindow().getCanvas(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                                6.access$100(this.this$1).getGraphWindow().getCanvas().dispatchEvent(mouseEvent);
                            }
                        };
                    }

                    static /* synthetic */ Tomahawk access$100(6 var0) {
                        return var0.Tomahawk.this;
                    }
                });
            }
            tSJInternalFrame.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
                    if (Tomahawk.this.isWindowActivated()) {
                        Tomahawk.this.onGraphWindowChanged();
                        if (!Tomahawk.this.hasGraphWindow()) {
                            Tomahawk.this.onNoWindowVisible();
                        } else if (Tomahawk.this.isAutoFitInWindow()) {
                            Tomahawk.this.graphWindow.fitInWindow(true);
                        }
                    }
                }

                public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
                    if (internalFrameEvent.getSource() instanceof TSJInternalFrame) {
                        ExGraphWindow exGraphWindow = ((TSJInternalFrame)internalFrameEvent.getSource()).getGraphWindow();
                        if (Tomahawk.this.getGraphWindow() != exGraphWindow) {
                            Tomahawk.getActions().unregisterListeners();
                        }
                    }
                    Tomahawk.this.onGraphWindowChanged();
                }

                public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
                    if (Tomahawk.this.isWindowActivated()) {
                        Tomahawk.this.onGraphWindowChanged();
                        if (Tomahawk.this.hasGraphWindow() && Tomahawk.this.isAutoFitInWindow()) {
                            Tomahawk.this.graphWindow.fitInWindow(true);
                        }
                        if (Tomahawk.this.hasGraphWindow()) {
                            Tomahawk.this.graphWindow.getCanvas().requestFocus();
                        }
                    }
                }

                public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                    JInternalFrame jInternalFrame = (JInternalFrame)internalFrameEvent.getSource();
                    try {
                        jInternalFrame.setClosed(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }

                public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
                    try {
                        TSJInternalFrame tSJInternalFrame = (TSJInternalFrame)internalFrameEvent.getSource();
                        tSJInternalFrame.setSelected(false);
                        ExGraphWindow exGraphWindow = tSJInternalFrame.getGraphWindow();
                        if (exGraphWindow != null) {
                            exGraphWindow.getCurrentTool().cancelAction();
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            });
            this.getRootPane().requestFocus();
        }
    }

    TSJInternalFrame findInternalWindow(boolean bl) {
        return this.findInternalWindow(bl, false);
    }

    TSJInternalFrame findInternalWindow(boolean bl, boolean bl2) {
        JInternalFrame jInternalFrame = null;
        if (this.desktopPane != null) {
            JInternalFrame[] jInternalFrameArray = this.desktopPane.getAllFramesInLayer(this.desktopPane.highestLayer());
            if (jInternalFrameArray == null || jInternalFrameArray.length == 0) {
                jInternalFrameArray = this.desktopPane.getAllFrames();
            }
            for (int i = 0; jInternalFrame == null && i < jInternalFrameArray.length; ++i) {
                JInternalFrame jInternalFrame2 = jInternalFrameArray[i];
                if (jInternalFrame2.isIcon() && !bl2 || !jInternalFrame2.isSelected() && bl) continue;
                jInternalFrame = jInternalFrame2;
            }
        }
        return (TSJInternalFrame)jInternalFrame;
    }

    public JInternalFrame getFrameForGraphWindow(TSEGraphWindow tSEGraphWindow) {
        JInternalFrame[] jInternalFrameArray = this.getDesktopPane().getAllFrames();
        for (int i = 0; i < jInternalFrameArray.length; ++i) {
            if (((TSJInternalFrame)jInternalFrameArray[i]).getGraphWindow() != tSEGraphWindow) continue;
            return jInternalFrameArray[i];
        }
        return null;
    }

    public JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            JTabbedPane jTabbedPane = new JTabbedPane(3);
            this.setTabbedPane(jTabbedPane);
            TSELocalization.setComponentOrientation((Component)this.tabbedPane);
            this.tabbedPane.setFont(new Font("Dialog", 0, 11));
            if (this.dockingManager == null || !this.dockingManager.hasDockedWindows()) {
                this.getContentPane().add(jTabbedPane);
            }
            jTabbedPane.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (!isChangingMultipleWindowsDisplay) {
                        Iterator iterator = Tomahawk.this.graphWindowList.iterator();
                        while (iterator.hasNext()) {
                            ((ExGraphWindow)iterator.next()).setVisible(false);
                        }
                        Tomahawk.this.onGraphWindowChanged();
                        Tomahawk.this.updateSecondaryWindows();
                        if (!Tomahawk.this.hasGraphWindow()) {
                            Tomahawk.this.onNoWindowVisible();
                        }
                    }
                }
            });
            jTabbedPane.addMouseListener(this.mouseHandler);
            new DropTarget(this.tabbedPane, 3, new MDIDnDListener(), true);
        }
        return this.tabbedPane;
    }

    public void setTabbedPane(JTabbedPane jTabbedPane) {
        if (this.tabbedPane != null) {
            this.tabbedPane.removeMouseListener(this.mouseHandler);
        }
        if (jTabbedPane != null) {
            jTabbedPane.addMouseListener(this.mouseHandler);
        }
        this.tabbedPane = jTabbedPane;
    }

    public JDesktopPane getDesktopPane() {
        if (this.desktopPane == null) {
            this.desktopPane = new JDesktopPane();
            TSELocalization.setComponentOrientation((Component)this.desktopPane);
            this.desktopPane.addContainerListener(new ContainerAdapter(){

                public void componentAdded(ContainerEvent containerEvent) {
                    TSJInternalFrame tSJInternalFrame = null;
                    tSJInternalFrame = containerEvent.getChild() instanceof TSJInternalFrame ? (TSJInternalFrame)containerEvent.getChild() : Tomahawk.this.findInternalWindow(false);
                    ExGraphWindow exGraphWindow = tSJInternalFrame == null ? null : tSJInternalFrame.getGraphWindow();
                    Tomahawk.this.graphWindow = exGraphWindow;
                    Tomahawk.this.updateSecondaryWindows();
                    if (Tomahawk.this.hasGraphWindow()) {
                        Tomahawk.this.setGraphFileName(Tomahawk.this.graphWindow.getGraphFileName());
                        Tomahawk.this.setTitle();
                    }
                }

                public void componentRemoved(ContainerEvent containerEvent) {
                    TSJInternalFrame tSJInternalFrame = null;
                    if (!(containerEvent.getChild() instanceof TSJInternalFrame)) {
                        tSJInternalFrame = Tomahawk.this.findInternalWindow(false);
                    }
                    ExGraphWindow exGraphWindow = tSJInternalFrame == null ? null : tSJInternalFrame.getGraphWindow();
                    Tomahawk.this.graphWindow = exGraphWindow;
                    if (exGraphWindow != null) {
                        Tomahawk.this.setGraphFileName(exGraphWindow.getGraphFileName());
                    } else {
                        Tomahawk.this.setGraphFileName(null);
                    }
                    Tomahawk.this.updateSecondaryWindows();
                    if (!Tomahawk.this.hasGraphWindow()) {
                        Tomahawk.this.onNoWindowVisible();
                    }
                }
            });
            new DropTarget(this.desktopPane, 3, new MDIDnDListener(), true);
            if (this.dockingManager == null || !this.dockingManager.hasDockedWindows()) {
                this.getContentPane().add(this.desktopPane);
            }
        }
        return this.desktopPane;
    }

    public void onGraphWindowChanged() {
        if (this.hasGraphWindow()) {
            Tomahawk.getActions().unregisterListeners();
        }
        if (this.isUsingTabbedWindows()) {
            this.graphWindow = this.getTabbedPane().getTabCount() > 0 ? (ExGraphWindow)((Object)this.getTabbedPane().getSelectedComponent()) : null;
        } else if (this.isUsingInternalWindows()) {
            TSJInternalFrame tSJInternalFrame = this.findInternalWindow(true);
            this.graphWindow = tSJInternalFrame != null ? tSJInternalFrame.getGraphWindow() : null;
        }
        if (!this.hasGraphWindow()) {
            return;
        }
        Tomahawk.getActions().registerListeners();
        if (this.isAutoFitInWindow()) {
            this.getGraphWindow().fitInWindow(true);
        }
        this.graphWindow.updateScrollBarValues();
        this.graphWindow.initDropTarget();
        this.setChanged(this.graphWindow.isChanged());
        this.showStatus(this.graphWindow.getStatus());
        this.setGraphFileName(this.graphWindow.getGraphFileName());
        this.updateToolButtonSelection();
        this.setTitle();
        this.updateZoomComboBox();
        this.correlateButtonAbility("PASTE_GRAPH", this.getGraphWindow().canPaste());
        this.updateSecondaryWindows();
        this.correlateButtonAbility("GOTO_PARENT", this.graphWindow.getGraph().isChildGraph());
    }

    public void onSwitchMultipleWindowsStyle() {
        if (this.isUsingMultipleWindows()) {
            isChangingMultipleWindowsDisplay = true;
            ExGraphWindow exGraphWindow = null;
            if (this.isUsingInternalWindows()) {
                int n;
                this.useTabbedWindows = true;
                ExGraphWindow exGraphWindow2 = null;
                if (this.hasGraphWindow()) {
                    exGraphWindow2 = this.graphWindow;
                }
                for (int i = 0; i < this.graphWindowList.size(); ++i) {
                    this.graphWindow = (ExGraphWindow)this.graphWindowList.get(i);
                    TSJInternalFrame tSJInternalFrame = (TSJInternalFrame)this.getFrameForGraphWindow(this.graphWindow);
                    this.setGraphFileName(this.graphWindow.getGraphFileName());
                    try {
                        tSJInternalFrame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    exGraphWindow = tSJInternalFrame.getGraphWindow();
                    this.setGraphFileName(exGraphWindow.getGraphFileName());
                    tSJInternalFrame.remove((Component)((Object)exGraphWindow));
                    n = this.desktopPane.getIndexOf(tSJInternalFrame);
                    this.desktopPane.remove(n);
                    this.desktopPane.repaint();
                    this.addGraphWindow(exGraphWindow);
                }
                if (this.graphWindowList.size() > 0) {
                    if (exGraphWindow2 != null) {
                        this.getTabbedPane().setSelectedComponent((Component)((Object)exGraphWindow2));
                    } else {
                        this.getTabbedPane().setSelectedIndex(this.getTabbedPane().getTabCount() - 1);
                    }
                    this.graphWindow = (ExGraphWindow)((Object)this.getTabbedPane().getSelectedComponent());
                    this.setChanged(this.graphWindow.isChanged());
                    this.setGraphFileName(this.graphWindow.getGraphFileName());
                } else {
                    this.setGraphFileName(null);
                }
                this.setTitle();
                if (!(this.desktopPane.getParent() instanceof JSplitPane)) {
                    this.getContentPane().remove(this.desktopPane);
                    this.getContentPane().add(this.getTabbedPane());
                } else {
                    JSplitPane jSplitPane = (JSplitPane)this.desktopPane.getParent();
                    n = jSplitPane.getDividerLocation();
                    if (jSplitPane.getLeftComponent() == this.desktopPane) {
                        jSplitPane.setLeftComponent(this.getTabbedPane());
                    } else {
                        jSplitPane.setRightComponent(this.getTabbedPane());
                    }
                    jSplitPane.setDividerLocation(n);
                }
                this.getContentPane().repaint();
                this.desktopPane = null;
            } else if (this.isUsingTabbedWindows()) {
                this.useTabbedWindows = false;
                ExGraphWindow exGraphWindow3 = (ExGraphWindow)((Object)this.getTabbedPane().getSelectedComponent());
                TSJInternalFrame tSJInternalFrame = null;
                Iterator iterator = this.graphWindowList.iterator();
                while (iterator.hasNext()) {
                    exGraphWindow = (ExGraphWindow)iterator.next();
                    this.setGraphFileName(exGraphWindow.getGraphFileName());
                    this.addGraphWindow(exGraphWindow);
                    if (exGraphWindow != exGraphWindow3) continue;
                    tSJInternalFrame = this.findInternalWindow(false);
                }
                this.getTabbedPane().removeAll();
                if (!(this.getTabbedPane().getParent() instanceof JSplitPane)) {
                    this.getContentPane().remove(this.getTabbedPane());
                    this.getContentPane().add(this.getDesktopPane());
                } else {
                    JSplitPane jSplitPane = (JSplitPane)this.getTabbedPane().getParent();
                    int n = jSplitPane.getDividerLocation();
                    if (jSplitPane.getLeftComponent() == this.getTabbedPane()) {
                        jSplitPane.setLeftComponent(this.getDesktopPane());
                    } else {
                        jSplitPane.setRightComponent(this.getDesktopPane());
                    }
                    jSplitPane.setDividerLocation(n);
                }
                this.getContentPane().repaint();
                this.setTabbedPane(null);
                if (tSJInternalFrame != null) {
                    tSJInternalFrame.toFront();
                    tSJInternalFrame.getGraphWindow().getCanvas().requestFocus();
                    try {
                        tSJInternalFrame.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
            this.onGraphWindowChanged();
            isChangingMultipleWindowsDisplay = false;
        }
    }

    public void onNextWindow() {
        if (this.isUsingMultipleWindows() && this.numberOfWindowsOpen(true) > 0) {
            if (this.isUsingTabbedWindows()) {
                this.tabbedPane.setSelectedIndex((this.tabbedPane.getSelectedIndex() + 1) % this.tabbedPane.getTabCount());
            } else if (this.isUsingInternalWindows()) {
                int n;
                TSJInternalFrame tSJInternalFrame = this.findInternalWindow(true);
                if (tSJInternalFrame != null) {
                    ExGraphWindow exGraphWindow;
                    int n2 = 0;
                    Iterator iterator = this.graphWindowList.iterator();
                    while (iterator.hasNext() && (exGraphWindow = (ExGraphWindow)iterator.next()) != this.getGraphWindow()) {
                        ++n2;
                    }
                    n = (n2 + 1) % this.graphWindowList.size();
                    if (n == n2) {
                        n = -1;
                    }
                } else {
                    n = 0;
                }
                if (n != -1) {
                    JInternalFrame jInternalFrame = this.getFrameForGraphWindow((ExGraphWindow)this.graphWindowList.get(n));
                    try {
                        if (jInternalFrame.isIcon()) {
                            jInternalFrame.setIcon(false);
                        }
                        jInternalFrame.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    jInternalFrame.toFront();
                }
            }
            this.getRootPane().requestFocus();
        }
    }

    public JPopupMenu getTabPopupMenu() {
        return this.mouseHandler.getTabPopupMenu();
    }

    public Frame getOwnerFrame() {
        return JOptionPane.getFrameForComponent(SwingUtilities.getRootPane(this));
    }

    public void setTitle() {
        if (!Tomahawk.isApplet()) {
            String string = Tomahawk.getResources().getStringResource("app.title");
            string = TSSystem.replace((String)string, (String)"%TSVJ_VERSION%", (String)TSVisualizationProduct.getVersionString());
            String string2 = this.getGraphName();
            if (!string2.equals("")) {
                string = string + " - " + string2;
            }
            this.getOwnerFrame().setTitle(string);
        }
    }

    public void registerKeyCommands(JComponent jComponent) {
        String string;
        int n = 1;
        while ((string = Tomahawk.getResources().getStringResource("key." + n + ".keyCode")) != null) {
            int n2 = Integer.valueOf(string);
            int n3 = Integer.valueOf(Tomahawk.getResources().getStringResource("key." + n + ".modifiers"));
            String string2 = Tomahawk.getResources().getStringResource("key." + n + ".command");
            int n4 = Integer.valueOf(Tomahawk.getResources().getStringResource("key." + n + ".focus"));
            boolean bl = Tomahawk.getResources().getStringResource("key." + n + ".released") != null;
            jComponent.registerKeyboardAction(Tomahawk.getActions(), string2, KeyStroke.getKeyStroke(n2, n3, bl), n4);
            if (TSSystem.isJVM14orAbove()) {
                int n5 = n3 | 0x10;
                jComponent.registerKeyboardAction(Tomahawk.getActions(), string2, KeyStroke.getKeyStroke(n2, n5, bl), n4);
                n5 = n3 | 8;
                jComponent.registerKeyboardAction(Tomahawk.getActions(), string2, KeyStroke.getKeyStroke(n2, n5, bl), n4);
                n5 = n3 | 4;
                jComponent.registerKeyboardAction(Tomahawk.getActions(), string2, KeyStroke.getKeyStroke(n2, n5, bl), n4);
            }
            ++n;
        }
    }

    public void unregisterKeyCommands(JComponent jComponent) {
        String string;
        int n = 1;
        while ((string = Tomahawk.getResources().getStringResource("key." + n + ".keyCode")) != null) {
            boolean bl;
            int n2 = Integer.valueOf(string);
            int n3 = Integer.valueOf(Tomahawk.getResources().getStringResource("key." + n + ".modifiers"));
            String string2 = Tomahawk.getResources().getStringResource("key." + n + ".command");
            int n4 = Integer.valueOf(Tomahawk.getResources().getStringResource("key." + n + ".focus"));
            boolean bl2 = bl = Tomahawk.getResources().getStringResource("key." + n + ".released") != null;
            if (string2.indexOf("ZOOM") >= 0 || string2.indexOf("SCROLL") >= 0) {
                jComponent.registerKeyboardAction(Tomahawk.getActions(), "ACTION_ABORT", KeyStroke.getKeyStroke(n2, n3, bl), n4);
            }
            ++n;
        }
    }

    List getNetworkedFiles(boolean bl) {
        String string;
        String string2;
        String string3 = this.getGraphFileName();
        if (string3 == null) {
            string2 = this.getDocumentBase().toString();
            if (string2.endsWith(".html")) {
                int n = string2.lastIndexOf(47);
                string2 = string2.substring(0, n + 1);
            }
            string3 = string2 + "examples/editor/graphs/";
        }
        string2 = Tomahawk.getResources().getStringResource("dialog.open.title");
        if (bl) {
            string2 = Tomahawk.getResources().getStringResource("dialog.import.title");
        }
        if ((string = (String)JOptionPane.showInputDialog(this, Tomahawk.getResources().getStringResource("dialog.open.message"), string2, 3, Tomahawk.getResources().getIconResource("dialog.open.icon", class$editor$Tomahawk == null ? (class$editor$Tomahawk = Tomahawk.class$("editor.Tomahawk")) : class$editor$Tomahawk), null, string3)) == null) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string);
        return linkedList;
    }

    List getLocalFiles(boolean bl, boolean bl2) {
        Object object;
        Object object2;
        File[] fileArray;
        int n;
        TSFileChooser tSFileChooser = !bl2 ? this.getFileChooser(bl) : (bl ? this.getImportFileChooser() : this.getExportFileChooser());
        if (bl) {
            if (bl2) {
                tSFileChooser.setDialogTitle(Tomahawk.getResources().getStringResource("dialog.import.title"));
            } else {
                tSFileChooser.setDialogTitle(Tomahawk.getResources().getStringResource("dialog.open.title"));
            }
            tSFileChooser.cancelSelection();
            n = tSFileChooser.showOpenDialog((Component)this);
        } else {
            if (this.hasGraphWindow()) {
                fileArray = Tomahawk.getResources().getStringResource("file.xml.extension");
                object2 = Tomahawk.getResources().getStringResource("file.xmlCompressed.extension");
                String string = this.getGraphFileName();
                int n2 = string.lastIndexOf(46) + 1;
                if (bl2 && tSFileChooser.getFileFilter() instanceof TSFileFilter) {
                    object = (TSFileFilter)tSFileChooser.getFileFilter();
                    if (string.endsWith((String)fileArray) || string.endsWith((String)object2) || string.endsWith(Tomahawk.getResources().getStringResource("file.old.extension")) || string.endsWith(Tomahawk.getResources().getStringResource("file.oldCompressed.extension"))) {
                        string = string.substring(0, n2) + object.getExtension();
                    }
                }
                if (string.endsWith(Tomahawk.getResources().getStringResource("file.analysisCompressed.extension")) || string.endsWith(Tomahawk.getResources().getStringResource("file.layoutCompressed.extension")) || string.endsWith(Tomahawk.getResources().getStringResource("file.oldCompressed.extension"))) {
                    if (!bl2) {
                        string = string.substring(0, n2);
                        string = string + (String)object2;
                        tSFileChooser.setFileFilter((FileFilter)this.tsvzFilter);
                    }
                } else if (!bl2) {
                    string = string.substring(0, n2);
                    string = string + (String)fileArray;
                    tSFileChooser.setFileFilter((FileFilter)this.tsvFilter);
                }
                tSFileChooser.setSelectedFiles(new File[]{new File(string)});
            }
            if (bl2) {
                tSFileChooser.setDialogTitle(Tomahawk.getResources().getStringResource("dialog.export.title"));
            } else {
                tSFileChooser.setDialogTitle(Tomahawk.getResources().getStringResource("dialog.saveAs.title"));
            }
            n = tSFileChooser.showSaveDialog((Component)this);
        }
        if (n != 0) {
            return null;
        }
        fileArray = tSFileChooser.getSelectedFiles();
        if (fileArray == null) {
            return null;
        }
        if (fileArray.length == 0) {
            if (tSFileChooser.getUI() instanceof BasicFileChooserUI) {
                object2 = (BasicFileChooserUI)tSFileChooser.getUI();
                ((BasicFileChooserUI)object2).getApproveSelectionAction().actionPerformed(null);
            }
            fileArray = new File[]{tSFileChooser.getSelectedFile()};
        }
        object2 = new LinkedList();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            object = file.getAbsolutePath();
            String string = file.getName();
            if (tSFileChooser.getFileFilter() instanceof TSFileFilter) {
                TSFileFilter tSFileFilter = (TSFileFilter)tSFileChooser.getFileFilter();
                if (string.indexOf(46) < 0) {
                    object = (String)object + "." + tSFileFilter.getExtension();
                }
            }
            object2.add(object);
        }
        return object2;
    }

    List getFileNames(boolean bl) {
        return this.getFileNames(bl, false);
    }

    List getFileNames(boolean bl, boolean bl2) {
        List list = this.hasFileReadAccess || this.hasFileWriteAccess ? this.getLocalFiles(bl, bl2) : this.getNetworkedFiles(bl2);
        return list;
    }

    public TSFileChooser getFileChooser(boolean bl) {
        if (this.fileChooser == null) {
            this.fileChooser = new TSFileChooser(System.getProperty("user.dir"));
            this.fileChooser.addChoosableFileFilter((FileFilter)this.tsvFilter);
            this.fileChooser.addChoosableFileFilter((FileFilter)this.tsvzFilter);
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setMultiSelectionEnabled(this.isUsingMultipleWindows());
            FileFilter fileFilter = this.fileChooser.getAcceptAllFileFilter();
            this.fileChooser.removeChoosableFileFilter(fileFilter);
            this.fileChooser.addChoosableFileFilter(fileFilter);
            this.fileChooser.setFileFilter((FileFilter)this.tsvFilter);
            TSELocalization.setComponentOrientation((Component)this.fileChooser);
        }
        this.fileChooser.rescanCurrentDirectory();
        return this.fileChooser;
    }

    public TSFileChooser getImportFileChooser() {
        if (this.importFileChooser == null) {
            this.importFileChooser = new TSFileChooser(System.getProperty("user.dir"));
            TSFileFilter tSFileFilter = new TSFileFilter(Tomahawk.getResources().getStringResource("file.analysis.extension"), Tomahawk.getResources().getStringResource("file.analysis.description"));
            TSFileFilter tSFileFilter2 = new TSFileFilter(Tomahawk.getResources().getStringResource("file.analysisCompressed.extension"), Tomahawk.getResources().getStringResource("file.analysisCompressed.description"));
            TSFileFilter tSFileFilter3 = new TSFileFilter(Tomahawk.getResources().getStringResource("file.layout.extension"), Tomahawk.getResources().getStringResource("file.layout.description"));
            TSFileFilter tSFileFilter4 = new TSFileFilter(Tomahawk.getResources().getStringResource("file.layoutCompressed.extension"), Tomahawk.getResources().getStringResource("file.layoutCompressed.description"));
            TSFileFilter tSFileFilter5 = new TSFileFilter(Tomahawk.getResources().getStringResource("file.old.extension"), Tomahawk.getResources().getStringResource("file.old.description"));
            TSFileFilter tSFileFilter6 = new TSFileFilter(Tomahawk.getResources().getStringResource("file.oldCompressed.extension"), Tomahawk.getResources().getStringResource("file.oldCompressed.description"));
            this.importFileChooser.addChoosableFileFilter((FileFilter)tSFileFilter);
            this.importFileChooser.addChoosableFileFilter((FileFilter)tSFileFilter2);
            this.importFileChooser.addChoosableFileFilter((FileFilter)tSFileFilter3);
            this.importFileChooser.addChoosableFileFilter((FileFilter)tSFileFilter4);
            this.importFileChooser.addChoosableFileFilter((FileFilter)tSFileFilter5);
            this.importFileChooser.addChoosableFileFilter((FileFilter)tSFileFilter6);
            this.importFileChooser.setFileSelectionMode(0);
            this.importFileChooser.setMultiSelectionEnabled(this.isUsingMultipleWindows());
            FileFilter fileFilter = this.importFileChooser.getAcceptAllFileFilter();
            this.importFileChooser.removeChoosableFileFilter(fileFilter);
            this.importFileChooser.addChoosableFileFilter(fileFilter);
            this.importFileChooser.setFileFilter((FileFilter)tSFileFilter5);
            TSELocalization.setComponentOrientation((Component)this.importFileChooser);
        }
        this.importFileChooser.rescanCurrentDirectory();
        return this.importFileChooser;
    }

    public TSFileChooser getExportFileChooser() {
        if (this.exportFileChooser == null) {
            this.exportFileChooser = new TSFileChooser(System.getProperty("user.dir"));
            TSFileFilter tSFileFilter = new TSFileFilter(Tomahawk.getResources().getStringResource("file.analysis.extension"), Tomahawk.getResources().getStringResource("file.analysis.description"));
            TSFileFilter tSFileFilter2 = new TSFileFilter(Tomahawk.getResources().getStringResource("file.analysisCompressed.extension"), Tomahawk.getResources().getStringResource("file.analysisCompressed.description"));
            TSFileFilter tSFileFilter3 = new TSFileFilter(Tomahawk.getResources().getStringResource("file.layout.extension"), Tomahawk.getResources().getStringResource("file.layout.description"));
            TSFileFilter tSFileFilter4 = new TSFileFilter(Tomahawk.getResources().getStringResource("file.layoutCompressed.extension"), Tomahawk.getResources().getStringResource("file.layoutCompressed.description"));
            this.exportFileChooser.addChoosableFileFilter((FileFilter)tSFileFilter);
            this.exportFileChooser.addChoosableFileFilter((FileFilter)tSFileFilter2);
            this.exportFileChooser.addChoosableFileFilter((FileFilter)tSFileFilter3);
            this.exportFileChooser.addChoosableFileFilter((FileFilter)tSFileFilter4);
            this.exportFileChooser.setFileSelectionMode(0);
            this.exportFileChooser.setMultiSelectionEnabled(this.isUsingMultipleWindows());
            FileFilter fileFilter = this.exportFileChooser.getAcceptAllFileFilter();
            this.exportFileChooser.removeChoosableFileFilter(fileFilter);
            this.exportFileChooser.setFileFilter((FileFilter)tSFileFilter);
            TSELocalization.setComponentOrientation((Component)this.exportFileChooser);
        }
        this.exportFileChooser.rescanCurrentDirectory();
        return this.exportFileChooser;
    }

    public void adjustCheckBoxes() {
        Enumeration enumeration = Tomahawk.getResources().getAllButtons();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = (AbstractButton)enumeration.nextElement();
            String string = abstractButton.getActionCommand();
            if ("OVERVIEW_WINDOW".equals(string)) {
                abstractButton.setSelected(this.overviewWindow != null && (this.overviewWindow.isVisible() || this.overviewWindow.isDocked()));
                continue;
            }
            if ("INSPECTOR_WINDOW".equals(string)) {
                abstractButton.setSelected(this.inspectorWindow != null && (this.inspectorWindow.isVisible() || this.inspectorWindow.isDocked()));
                continue;
            }
            if ("CONSTRAINT_WINDOW".equals(string)) {
                abstractButton.setSelected(this.layoutConstraintsDialog != null && (this.layoutConstraintsDialog.isVisible() || this.layoutConstraintsDialog.isDocked()));
                continue;
            }
            if (abstractButton.isEnabled() && "PALETTE_WINDOW".equals(string)) {
                abstractButton.setSelected(this.nodePalette != null && (this.nodePalette.isVisible() || this.nodePalette.isDocked()));
                continue;
            }
            if ("RUN_MODE".equals(string)) {
                abstractButton.setSelected(this.graphWindow != null && abstractButton.isEnabled() && this.getGraphWindow().isInRunMode());
                continue;
            }
            if ("DOCKABLE_WINDOWS".equals(string)) {
                abstractButton.setSelected(this.dockableWindows);
                continue;
            }
            if ("TABBED_WINDOWS".equals(string)) {
                abstractButton.setSelected(this.isUsingTabbedWindows());
                continue;
            }
            if ("LAYOUT_PROPERTIES".equals(string)) {
                abstractButton.setSelected(this.layoutPropertiesDialog != null && this.layoutPropertiesDialog.isVisible());
                continue;
            }
            if (!"DRAWING_PREFERENCES".equals(string)) continue;
            abstractButton.setSelected(this.drawingPreferencesDialog != null && this.drawingPreferencesDialog.isVisible());
        }
    }

    public void updateToolButtonSelection() {
        Enumeration enumeration = Tomahawk.getResources().getAllButtons();
        while (enumeration.hasMoreElements()) {
            TSENodeUI tSENodeUI;
            TSENodeUI tSENodeUI2;
            String string;
            AbstractButton abstractButton = (AbstractButton)enumeration.nextElement();
            String string2 = abstractButton.getActionCommand();
            TSEWindowTool tSEWindowTool = !this.hasGraphWindow() ? null : this.getGraphWindow().getCurrentTool();
            if (!(abstractButton instanceof JToggleButton)) continue;
            if (string2.equals("SELECT_TOOL")) {
                abstractButton.setSelected(tSEWindowTool == this.getGraphWindow().getDefaultTool());
                continue;
            }
            if (string2.equals("PAN_TOOL")) {
                abstractButton.setSelected(tSEWindowTool instanceof TSEPanTool);
                continue;
            }
            if (string2.equals("ZOOM_TOOL")) {
                abstractButton.setSelected(tSEWindowTool instanceof TSEZoomTool);
                continue;
            }
            if (string2.equals("INTERACTIVE_ZOOM_TOOL")) {
                abstractButton.setSelected(tSEWindowTool instanceof TSEInteractiveZoomTool);
                continue;
            }
            if (string2.equals("EDGE_NAVIGATION_TOOL")) {
                abstractButton.setSelected(tSEWindowTool instanceof TSELinkNavigationTool);
                continue;
            }
            if (string2.equals("CREATE_NODE_TOOL")) {
                abstractButton.setSelected(tSEWindowTool instanceof TSECreateNodeTool);
                continue;
            }
            if (string2.equals("CREATE_EDGE_TOOL")) {
                abstractButton.setSelected(tSEWindowTool instanceof TSECreateEdgeTool);
                continue;
            }
            if (string2.startsWith("CREATE_NODE_TOOL")) {
                string = string2.substring(string2.indexOf(46) + 1);
                tSENodeUI2 = this.getNodeUI(string);
                tSENodeUI = null;
                if (this.graphWindow != null) {
                    tSENodeUI = this.getGraphWindow().getCurrentNodeUI();
                }
                abstractButton.setSelected(false);
                if (string.equals("nodeUI.default")) {
                    abstractButton.setSelected(tSENodeUI instanceof ExRectNodeUI || tSENodeUI instanceof TSEDefaultNodeUI);
                    continue;
                }
                if (tSENodeUI == null || !tSENodeUI.equals(tSENodeUI2)) continue;
                abstractButton.setSelected(true);
                continue;
            }
            if (!string2.startsWith("CREATE_EDGE_TOOL")) continue;
            string = string2.substring(string2.indexOf(46) + 1);
            tSENodeUI2 = this.getEdgeUI(string);
            tSENodeUI = null;
            if (this.hasGraphWindow()) {
                tSENodeUI = this.getGraphWindow().getCurrentEdgeUI();
            }
            abstractButton.setSelected(false);
            if (string.equals("edgeUI.solid")) {
                abstractButton.setSelected(tSENodeUI instanceof TSEDefaultEdgeUI);
                continue;
            }
            if (tSENodeUI == null || !tSENodeUI.equals(tSENodeUI2)) continue;
            abstractButton.setSelected(true);
        }
    }

    public void correlateButtonSelection(String string, boolean bl) {
        Enumeration enumeration = Tomahawk.getResources().getAllButtons();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = (AbstractButton)enumeration.nextElement();
            if (!abstractButton.getActionCommand().equals(string) || abstractButton.isSelected() == bl) continue;
            abstractButton.setSelected(bl);
        }
    }

    public void correlateButtonAbility(String string, boolean bl) {
        Enumeration enumeration = Tomahawk.getResources().getAllButtons();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = (AbstractButton)enumeration.nextElement();
            if (!abstractButton.getActionCommand().equals(string) || abstractButton.isEnabled() == bl) continue;
            abstractButton.setEnabled(bl);
        }
    }

    void installLayoutServer() {
        try {
            String string = Tomahawk.getResources().getStringResource("service.server.type");
            if (string.equals("direct")) {
                this.layoutProxy = new TSLayoutProxy();
            } else if (string.equals("soap")) {
                this.layoutProxy = new TSLayoutProxy(string, Tomahawk.getResources().getStringResource("service.server.soapLocation"));
            } else if (string.equals("servlet")) {
                this.layoutProxy = new TSLayoutProxy(string, Tomahawk.getResources().getStringResource("service.server.servletLocation"));
            } else if (string.equals("rmi")) {
                this.layoutProxy = new TSLayoutProxy(string, Tomahawk.getResources().getStringResource("service.server.rmiLocation"));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.out.println("Layout proxy not instantiated: failed to create layout proxy");
        }
    }

    public TSLayoutProxy getLayoutProxy() {
        return this.layoutProxy;
    }

    public ExGraphWindow getGraphWindow() {
        if (!this.hasGraphWindow()) {
            this.graphWindow = new ExGraphWindow(true);
        }
        return this.graphWindow;
    }

    public boolean hasGraphWindow() {
        return this.graphWindow != null;
    }

    public int numberOfWindowsOpen(boolean bl) {
        int n = 0;
        if (!this.isUsingMultipleWindows()) {
            if (this.hasGraphWindow()) {
                n = 1;
            }
        } else if (this.isUsingTabbedWindows()) {
            n = this.graphWindowList.size();
        } else if (this.isUsingInternalWindows()) {
            if (bl) {
                n = this.getDesktopPane().getAllFrames().length;
            } else {
                JInternalFrame[] jInternalFrameArray = this.getDesktopPane().getAllFrames();
                int n2 = jInternalFrameArray.length;
                for (int i = 0; i < n2; ++i) {
                    if (jInternalFrameArray[i].isIcon()) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public TSEGraphManager getGraphManager() {
        return this.getGraphWindow().getGraphManager();
    }

    public TSEGraph getGraph() {
        TSEGraph tSEGraph = null;
        if (this.graphWindow != null) {
            tSEGraph = this.getGraphWindow().getGraph();
        }
        return tSEGraph;
    }

    public String getGraphName() {
        int n;
        String string;
        if (!this.hasGraphWindow()) {
            string = "";
        } else if (this.getGraphFileName() == null) {
            string = this.nextNewDocTitle();
            this.setGraphFileName(string);
        } else {
            n = Math.max(this.graphFileName.lastIndexOf(47), this.graphFileName.lastIndexOf(92));
            string = n < 0 ? this.graphFileName : this.graphFileName.substring(n + 1);
        }
        n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public void setGraphFileName(String string) {
        this.graphFileName = string;
    }

    public String getGraphFileName() {
        return this.graphFileName;
    }

    public TSENodeUI getNodeUI(String string) {
        return (TSENodeUI)this.nodeStore.get(string);
    }

    public void addNodeUI(String string, TSENodeUI tSENodeUI) {
        this.nodeStore.put(string, tSENodeUI);
    }

    public TSEEdgeUI getEdgeUI(String string) {
        return (TSEEdgeUI)this.edgeStore.get(string);
    }

    public void addEdgeUI(String string, TSEEdgeUI tSEEdgeUI) {
        this.edgeStore.put(string, tSEEdgeUI);
    }

    public TSELabelUI getLabelUI(String string) {
        return (TSELabelUI)this.labelStore.get(string);
    }

    public void addLabelUI(String string, TSELabelUI tSELabelUI) {
        this.labelStore.put(string, tSELabelUI);
    }

    void onNoWindowVisible() {
        this.checkAllButtons();
        this.correlateButtonAbility("PASTE_GRAPH", false);
        this.setTitle();
        this.showStatus("No window visible");
    }

    public void onUseNewNodeUI(String string) {
        Object object;
        String string2 = string.substring(string.indexOf(46) + 1);
        if (string.indexOf(46) > 0) {
            object = this.getNodeUI(string2);
            if (object == null) {
                String string3 = Tomahawk.getResources().getStringResource(string2 + ".class");
                Cursor cursor = this.getCursor();
                try {
                    object = (TSENodeUI)Class.forName(string3).newInstance();
                    if (string3.endsWith("TSESVGImageNodeUI")) {
                        this.setCursor(Cursor.getPredefinedCursor(3));
                        this.setUIAttributes(string2, (TSEObjectUI)object);
                        this.setCursor(cursor);
                    } else {
                        this.setUIAttributes(string2, (TSEObjectUI)object);
                    }
                    this.addNodeUI(string2, (TSENodeUI)object);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    System.err.println("Failed to instantiate node UI " + string3);
                    object = this.getNodeUI("nodeUI.default");
                    this.setCursor(cursor);
                }
            }
            if (object != null) {
                this.getGraphWindow().setCurrentNodeUI((TSENodeUI)object);
            }
        } else {
            object = this.getGraphWindow().getCurrentNodeUI();
            if (object instanceof TSEDefaultNodeUI) {
                this.onUseNewNodeUI(string + "." + "nodeUI.default");
            }
        }
        this.correlateButtonSelection(string, true);
        object = Tomahawk.getResources().getStringResource("nodeType." + string2.substring(string2.indexOf(46) + 1));
        int n = 0;
        if (object != null) {
            try {
                n = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        if (n == 0) {
            this.onSwitchToCreateNodes();
        } else {
            this.onSwitchToCreateNodes(n);
        }
    }

    public void onUseNewEdgeUI(String string) {
        Object object;
        String string2 = string.substring(string.indexOf(46) + 1);
        if (string.indexOf(46) > 0) {
            object = this.getEdgeUI(string2);
            if (object == null) {
                String string3 = Tomahawk.getResources().getStringResource(string2 + ".class");
                try {
                    object = (TSEEdgeUI)Class.forName(string3).newInstance();
                    this.setUIAttributes(string2, (TSEObjectUI)object);
                    this.addEdgeUI(string2, (TSEEdgeUI)object);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    System.err.println("Failed to instantiate edge UI " + string3);
                    object = this.getEdgeUI("edgeUI.default");
                }
            }
            if (object != null) {
                this.getGraphWindow().setCurrentEdgeUI((TSEEdgeUI)object);
            }
            this.getGraphWindow().setEdgeCreatedWithLabel("true".equals(Tomahawk.getResources().getStringResource(string2 + ".labeled")));
        }
        this.correlateButtonSelection(string, true);
        object = Tomahawk.getResources().getStringResource("edgeType." + string2.substring(string2.indexOf(46) + 1));
        int n = 0;
        if (object != null) {
            try {
                n = Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                n = 0;
            }
        }
        if (n == 0) {
            this.onSwitchToCreateEdges();
        } else {
            this.onSwitchToCreateEdges(n);
        }
    }

    public void setUIAttributes(String string, TSEObjectUI tSEObjectUI) {
        int n = 1;
        while (true) {
            String string2 = Tomahawk.getResources().getStringResource(string + ".property." + n + ".name");
            String string3 = Tomahawk.getResources().getStringResource(string + ".property." + n + ".value");
            if (string2 == null || string3 == null) {
                return;
            }
            tSEObjectUI.setProperty(new TSProperty(string2, (Object)string3));
            ++n;
        }
    }

    public void onSwitchToCreateNodes() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDIT_ADD)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            this.getGraphWindow().switchTool((TSEWindowTool)new TSECreateNodeTool());
            this.showWindowStatus(Tomahawk.getResources().getStringResource("tools.createNodes.status"));
            this.correlateButtonSelection("CREATE_NODE_TOOL", true);
        }
    }

    public void onSwitchToCreateNodes(int n) {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDIT_ADD)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            this.getGraphWindow().switchTool((TSEWindowTool)new TSECreateNodeTool(n));
            this.showWindowStatus(Tomahawk.getResources().getStringResource("tools.createNodes.status"));
            this.correlateButtonSelection("CREATE_NODE_TOOL", true);
        }
    }

    public void onSwitchToCreateEdges() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDIT_ADD)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            this.getGraphWindow().switchTool((TSEWindowTool)new TSECreateEdgeTool());
            this.showWindowStatus(Tomahawk.getResources().getStringResource("tools.createEdges.status"));
            this.correlateButtonSelection("CREATE_EDGE_TOOL", true);
        }
    }

    public void onSwitchToCreateEdges(int n) {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDIT_ADD)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            this.getGraphWindow().switchTool((TSEWindowTool)new TSECreateEdgeTool(n));
            this.showWindowStatus(Tomahawk.getResources().getStringResource("tools.createEdges.status"));
            this.correlateButtonSelection("CREATE_EDGE_TOOL", true);
        }
    }

    public void updateSecondaryWindows() {
        if (this.overviewWindow != null) {
            this.overviewWindow.getOverviewComponent().setGraphWindow((TSEGraphWindow)this.graphWindow);
        }
        if (this.inspectorWindow != null) {
            this.inspectorWindow.getInspector().setGraphWindow((TSEGraphWindow)this.graphWindow);
        }
        if (this.layoutPropertiesDialog != null) {
            this.layoutPropertiesDialog.setGraphWindow((TSEGraphWindow)this.graphWindow, this.getServiceInputData(this.graphWindow));
        }
        if (this.layoutConstraintsDialog != null) {
            this.layoutConstraintsDialog.setGraphWindow((TSEGraphWindow)this.graphWindow, this.getServiceInputData(this.graphWindow));
        }
        if (this.drawingPreferencesDialog != null) {
            this.drawingPreferencesDialog.setGraphWindow((TSEGraphWindow)this.graphWindow);
        }
        if (this.saveAsImageDialog != null) {
            this.saveAsImageDialog.setGraphWindow((TSEGraphWindow)this.graphWindow);
        }
    }

    public void onNewGraph() {
        if (!this.isUsingMultipleWindows() && this.hasGraphWindow()) {
            if (!this.saveConfirm()) {
                return;
            }
            this.closeGraph();
        }
        this.newGraph();
    }

    void newGraph() {
        if (this.hasGraphWindow()) {
            this.getActions().unregisterListeners();
        }
        this.setGraphFileName(null);
        this.initGraphWindow();
        this.setGraphWindowDefaults(this.graphWindow);
        this.setChanged(false);
        this.onGraphWindowChanged();
    }

    public boolean onCloseGraph() {
        boolean bl = true;
        if (!this.isUsingMultipleWindows()) {
            this.onNewGraph();
        } else if (this.saveConfirm()) {
            this.closeGraph();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean onCloseGraphs(ExGraphWindow exGraphWindow) {
        boolean bl = true;
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        int n = 0;
        if (exGraphWindow != null) {
            n = 1;
        }
        boolean bl2 = true;
        while (this.numberOfWindowsOpen(true) > n) {
            if (this.getGraphWindow() != exGraphWindow && !(bl2 = this.onCloseGraph())) {
                bl = false;
                break;
            }
            this.onNextWindow();
        }
        this.setCursor(cursor);
        return bl;
    }

    void closeGraph() {
        this.setGraphFileName(null);
        this.getGraphWindow().resetGraphWindow();
        this.getGraphWindow().getCurrentTool().finalizeTool();
        this.getGraphWindow().getGraphManager().emptyTopology();
        TSEGraphManager tSEGraphManager = this.getGraphManager();
        if (tSEGraphManager != null) {
            TSENestingManager.discardManager((TSDGraphManager)tSEGraphManager);
            TSEFoldingManager.discardManager((TSDGraphManager)tSEGraphManager);
            TSEHidingManager.discardManager((TSDGraphManager)tSEGraphManager);
        }
        this.getGraphWindow().stopTimer();
        if (this.getGraphWindow().getDefaultTool() instanceof ExSelectTool) {
            ((ExSelectTool)this.getGraphWindow().getDefaultTool()).nullifyReferences();
        }
        this.serviceInputDataTable.remove(this.getGraphWindow().getGraphManager());
        this.incrementalLayoutEnabled = true;
        if (!this.isUsingMultipleWindows()) {
            this.getContentPane().remove((Component)((Object)this.getGraphWindow()));
            this.graphWindow = null;
        } else if (this.isUsingTabbedWindows()) {
            if (this.getTabbedPane().getTabCount() > 1) {
                ExGraphWindow exGraphWindow = (ExGraphWindow)((Object)this.getTabbedPane().getSelectedComponent());
                int n = this.getTabbedPane().getSelectedIndex();
                this.getTabbedPane().removeTabAt(this.getTabbedPane().getSelectedIndex());
                if (!isChangingMultipleWindowsDisplay && this.getTabbedPane().getTabCount() > 0 && n == this.getTabbedPane().getSelectedIndex()) {
                    this.onGraphWindowChanged();
                    this.updateSecondaryWindows();
                    if (!this.hasGraphWindow()) {
                        this.onNoWindowVisible();
                    }
                }
                this.graphWindowList.remove(exGraphWindow);
                this.graphWindow = (ExGraphWindow)((Object)this.getTabbedPane().getSelectedComponent());
                this.setChanged(this.graphWindow.isChanged());
                this.setGraphFileName(this.graphWindow.getGraphFileName());
                this.setTitle();
            } else {
                this.graphWindowList.remove(this.graphWindow);
                this.getTabbedPane().removeTabAt(0);
                this.graphWindow = null;
            }
        } else if (this.isUsingInternalWindows()) {
            TSJInternalFrame tSJInternalFrame;
            JDesktopPane jDesktopPane = this.getDesktopPane();
            if (!this.isAppExiting) {
                tSJInternalFrame = this.findInternalWindow(true);
                if (tSJInternalFrame == null) {
                    tSJInternalFrame = this.findInternalWindow(false);
                }
                tSJInternalFrame.remove((Component)((Object)this.graphWindow));
                this.graphWindowList.remove(this.graphWindow);
                jDesktopPane.remove(jDesktopPane.getIndexOf(tSJInternalFrame));
                jDesktopPane.repaint();
            } else {
                tSJInternalFrame = this.findInternalWindow(false, true);
                try {
                    tSJInternalFrame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this.graphWindow = tSJInternalFrame.getGraphWindow();
                tSJInternalFrame.remove((Component)((Object)this.graphWindow));
                this.graphWindowList.remove(this.graphWindow);
                int n = jDesktopPane.getIndexOf(tSJInternalFrame);
                if (n >= 0) {
                    jDesktopPane.remove(n);
                } else {
                    tSJInternalFrame.dispose();
                }
                jDesktopPane.repaint();
            }
            if (this.numberOfWindowsOpen(true) >= 1) {
                if (this.isAppExiting) {
                    tSJInternalFrame = this.findInternalWindow(false, true);
                    this.graphWindow = tSJInternalFrame.getGraphWindow();
                    this.setChanged(this.graphWindow.isChanged());
                    this.setGraphFileName(this.graphWindow.getGraphFileName());
                    this.setTitle();
                } else {
                    tSJInternalFrame = this.findInternalWindow(true);
                    if (tSJInternalFrame == null) {
                        tSJInternalFrame = this.findInternalWindow(false);
                    }
                    if (tSJInternalFrame != null) {
                        this.graphWindow = tSJInternalFrame.getGraphWindow();
                        this.setChanged(this.graphWindow.isChanged());
                        this.setGraphFileName(this.graphWindow.getGraphFileName());
                        this.setTitle();
                        if (!tSJInternalFrame.isSelected()) {
                            try {
                                tSJInternalFrame.setSelected(true);
                            }
                            catch (PropertyVetoException propertyVetoException) {}
                        }
                    }
                }
            } else {
                this.graphWindow = null;
            }
        }
    }

    public void setName(String string) {
        if (this.canCooperate) {
            this.setGraphFileName(string);
            Cursor cursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (this.loadGraphManager()) {
                this.onFitInWindow();
                this.setChanged(false);
                this.getActions().registerListeners();
                this.onGraphWindowChanged();
            }
            this.setCursor(cursor);
        }
    }

    public boolean onImportGraph() {
        return this.onLoadGraph(null, true);
    }

    public boolean onExportGraph() {
        return this.onSaveGraph(true, true);
    }

    public boolean onLoadGraph() {
        return this.onLoadGraph(null);
    }

    public boolean onLoadGraph(String string) {
        return this.onLoadGraph(string, false);
    }

    public boolean onLoadGraph(String string, boolean bl) {
        ExGraphWindow exGraphWindow = this.graphWindow;
        Cursor cursor = null;
        if (exGraphWindow != null) {
            cursor = exGraphWindow.showWaitCursorOnCanvas();
        }
        boolean bl2 = false;
        if (!this.isUsingMultipleWindows()) {
            if (this.saveConfirm()) {
                Object object;
                if (string == null && (object = this.getFileNames(true, bl)) != null) {
                    string = object.get(0).toString();
                }
                if (string != null) {
                    object = null;
                    if (this.hasGraphWindow()) {
                        object = this.getGraphWindow();
                    }
                    if ((bl2 = this.loadGraph(string, bl)) && object != null) {
                        ExGraphWindow exGraphWindow2 = this.getGraphWindow();
                        this.graphWindow = object;
                        this.closeGraph();
                        this.graphWindow = exGraphWindow2;
                    } else if (!bl2 && object != null) {
                        this.graphWindow = object;
                    }
                    this.onGraphWindowChanged();
                }
            }
        } else {
            bl2 = this.loadGraph(string, bl);
        }
        if (exGraphWindow != null) {
            exGraphWindow.setCursorOnCanvas(cursor);
        }
        return bl2;
    }

    boolean loadGraph(String string, boolean bl) {
        LinkedList<String> linkedList;
        boolean bl2 = false;
        this.setCursor(Cursor.getPredefinedCursor(3));
        String string2 = this.getGraphFileName();
        if (string != null) {
            this.setGraphFileName(string);
            linkedList = new LinkedList<String>();
            linkedList.add(this.getGraphFileName());
        } else {
            linkedList = this.getFileNames(true, bl);
        }
        if (linkedList != null) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next().toString();
                boolean bl3 = false;
                if (this.isUsingMultipleWindows() && string3 != null) {
                    if (this.isUsingTabbedWindows()) {
                        for (int i = 0; i < this.getTabbedPane().getTabCount(); ++i) {
                            ExGraphWindow exGraphWindow = (ExGraphWindow)((Object)this.getTabbedPane().getComponentAt(i));
                            if (!exGraphWindow.ownsSameGraphFile(string3)) continue;
                            bl3 = true;
                            this.getTabbedPane().setSelectedIndex(i);
                            break;
                        }
                    } else if (this.isUsingInternalWindows()) {
                        JInternalFrame[] jInternalFrameArray = this.getDesktopPane().getAllFrames();
                        for (int i = 0; i < jInternalFrameArray.length; ++i) {
                            ExGraphWindow exGraphWindow = ((TSJInternalFrame)jInternalFrameArray[i]).getGraphWindow();
                            if (!exGraphWindow.ownsSameGraphFile(string3)) continue;
                            bl3 = true;
                            try {
                                jInternalFrameArray[i].setIcon(false);
                                jInternalFrameArray[i].toFront();
                                jInternalFrameArray[i].show();
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                System.err.println("Cannot display component!");
                            }
                            exGraphWindow.drawGraph();
                            exGraphWindow.repaint();
                            break;
                        }
                    }
                }
                if (string3 == null || bl3) continue;
                if (this.hasGraphWindow()) {
                    this.getActions().unregisterListeners();
                }
                this.setGraphFileName(string3);
                if (this.loadGraphManager(true)) {
                    this.setChanged(false);
                    bl2 = true;
                    continue;
                }
                this.graphWindow = null;
                this.setGraphFileName(null);
                if (!this.isUsingMultipleWindows()) {
                    this.setGraphFileName(string2);
                } else if (this.isUsingTabbedWindows()) {
                    if (this.getTabbedPane().getTabCount() > 0) {
                        this.graphWindow = (ExGraphWindow)((Object)this.getTabbedPane().getSelectedComponent());
                    }
                } else if (this.isUsingInternalWindows()) {
                    TSJInternalFrame tSJInternalFrame = this.findInternalWindow(true);
                    if (tSJInternalFrame == null) {
                        tSJInternalFrame = this.findInternalWindow(false, false);
                    }
                    if (tSJInternalFrame != null) {
                        this.graphWindow = tSJInternalFrame.getGraphWindow();
                    }
                }
                if (!this.hasGraphWindow()) continue;
                this.setGraphFileName(this.getGraphWindow().getGraphFileName());
                this.getActions().registerListeners();
            }
        }
        this.incrementalLayoutEnabled = true;
        this.checkAllButtons();
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (this.hasGraphWindow()) {
            this.correlateButtonAbility("PASTE_GRAPH", this.getGraphWindow().canPaste());
        }
        return bl2;
    }

    public boolean onRevertGraph() {
        boolean bl = false;
        Cursor cursor = Tomahawk.getInstance().getGraphWindow().showWaitCursorOnCanvas();
        int n = JOptionPane.showConfirmDialog(this, TSSystem.replace((String)Tomahawk.getResources().getStringResource("dialog.revert.message"), (String)"%FILENAME%", (String)this.getGraphName()), Tomahawk.getResources().getStringResource("dialog.revert.title"), 0, 2);
        String string = this.getGraphFileName();
        if (n == 0) {
            this.getActions().unregisterListeners();
            if (this.loadGraphManager()) {
                this.onFitInWindow();
                this.setChanged(false);
                bl = true;
            } else {
                this.setGraphFileName(string);
                this.getGraphWindow().fastRepaint();
            }
            this.onGraphWindowChanged();
        }
        Tomahawk.getInstance().getGraphWindow().setCursorOnCanvas(cursor);
        return bl;
    }

    public boolean onSaveGraph() {
        return this.onSaveGraph(false, true);
    }

    public boolean onSaveGraph(boolean bl, boolean bl2) {
        boolean bl3 = true;
        if (bl2) {
            if (bl) {
                bl3 = false;
            } else {
                boolean bl4 = bl3 = this.getGraphFileName().endsWith(Tomahawk.getResources().getStringResource("file.xml.extension")) || this.getGraphFileName().endsWith(Tomahawk.getResources().getStringResource("file.xmlCompressed.extension"));
            }
        }
        if (this.getGraphFileName() == null || !this.graphWindow.hasFileName || !bl3) {
            return this.onSaveGraphAs(bl);
        }
        if (this.saveGraphManager()) {
            this.setChanged(false);
            this.graphWindow.hasFileName = true;
            if (this.isUsingMultipleWindows()) {
                if (this.isUsingTabbedWindows()) {
                    this.getTabbedPane().setTitleAt(this.getTabbedPane().getSelectedIndex(), this.getGraphName());
                    this.getTabbedPane().setToolTipTextAt(this.getTabbedPane().getSelectedIndex(), this.getGraphName());
                } else if (this.isUsingInternalWindows()) {
                    TSJInternalFrame tSJInternalFrame = this.findInternalWindow(true);
                    if (tSJInternalFrame == null) {
                        tSJInternalFrame = this.findInternalWindow(false);
                    }
                    tSJInternalFrame.setTitle(this.getGraphName());
                }
            }
            this.graphWindow.setGraphFileName(this.getGraphFileName());
            this.setTitle();
            return true;
        }
        this.getGraphWindow().fastRepaint();
        return false;
    }

    public boolean onSaveGraphAs(boolean bl) {
        boolean bl2 = false;
        List list = this.getFileNames(false, bl);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                if (string == null) continue;
                boolean bl3 = true;
                File file = new File(string);
                if (file.exists()) {
                    bl3 = this.overWriteConfirm(file.getName());
                }
                if (!bl3) continue;
                boolean bl4 = this.graphWindow.hasFileName;
                this.graphWindow.hasFileName = true;
                this.setGraphFileName(string);
                bl2 = this.onSaveGraph(bl, false);
                if (bl2) continue;
                this.graphWindow.hasFileName = bl4;
            }
        }
        return bl2;
    }

    public boolean saveConfirm() {
        boolean bl;
        if (this.isUsingInternalWindows()) {
            try {
                this.findInternalWindow(false, true).setIcon(false);
                this.getGraphWindow().cancelAction();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        if (!this.hasChanged()) {
            bl = true;
        } else if (this.isApplet()) {
            int n = JOptionPane.showConfirmDialog(this, TSSystem.replace((String)Tomahawk.getResources().getStringResource("dialog.discardConfirm.message"), (String)"%FILENAME%", (String)this.getGraphName()), Tomahawk.getResources().getStringResource("dialog.discardConfirm.title"), 0, 2);
            bl = n == 0;
        } else {
            int n;
            String string = this.getGraphName();
            File file = new File(this.getGraphFileName());
            if (file.exists()) {
                string = file.getAbsolutePath();
            }
            bl = (n = JOptionPane.showConfirmDialog(this, TSSystem.replace((String)Tomahawk.getResources().getStringResource("dialog.saveConfirm.message"), (String)"%FILENAME%", (String)string), Tomahawk.getResources().getStringResource("dialog.saveConfirm.title"), 1, 2)) == 0 ? (!this.isFileImported() ? this.onSaveGraph() : this.onSaveGraphAs(false)) : n == 1;
        }
        return bl;
    }

    public boolean overWriteConfirm(String string) {
        int n = JOptionPane.showConfirmDialog(this, TSSystem.replace((String)Tomahawk.getResources().getStringResource("dialog.overWriteConfirm.message"), (String)"%FILENAME%", (String)string), Tomahawk.getResources().getStringResource("dialog.overWriteConfirm.title"), 0, 2);
        return n == 0;
    }

    public void onSaveGraphAsImage() {
        if (this.saveAsImageDialog == null) {
            TSDialogCallBackListener tSDialogCallBackListener = new TSDialogCallBackListener(){

                public Object uponCallBack(Object object) {
                    String string = null;
                    if (object instanceof TSLicenseRuntimeException) {
                        Tomahawk.showLicenseErrorMessage();
                        string = new String("Warning message displayed");
                    }
                    return string;
                }
            };
            this.saveAsImageDialog = new TSESaveAsImageDialog(this.getOwnerFrame(), Tomahawk.getResources().getStringResource("dialog.saveAsImage.title"), (TSEGraphWindow)this.getGraphWindow());
            this.saveAsImageDialog.registerCallBackListener(tSDialogCallBackListener);
            this.saveAsImageDialog.addWindowListener((WindowListener)this.windowHandler);
        }
        this.saveAsImageDialog.setVisible(!this.saveAsImageDialog.isVisible());
    }

    public void onPrintSetup() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.SINGLE_PAGE_PRINT)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            if (this.printSetup == null) {
                this.printSetup = new ExPrintSetup(this.getGraphWindow());
            } else if (this.printSetup.getGraphWindow() != this.getGraphWindow()) {
                this.printSetup.setGraphWindow((TSEGraphWindow)this.getGraphWindow());
            }
            TSDialogCallBackListener tSDialogCallBackListener = new TSDialogCallBackListener(){

                public Object uponCallBack(Object object) {
                    String string = null;
                    if (object instanceof TSLicenseRuntimeException) {
                        Tomahawk.showLicenseErrorMessage();
                        string = new String("Warning message displayed");
                    }
                    return string;
                }
            };
            TSEPrintSetupDialog tSEPrintSetupDialog = new TSEPrintSetupDialog(this.getOwnerFrame(), Tomahawk.getResources().getStringResource("dialog.printSetup.title"), this.printSetup);
            ((TSDialogWithCallBack)tSEPrintSetupDialog).registerCallBackListener(tSDialogCallBackListener);
            tSEPrintSetupDialog.setVisible(true);
        }
    }

    public void onPrintPreview() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.PRINT_PREVIEW) || !TSDLicenseManager.checkLicense((String)TSDLicenseManager.SINGLE_PAGE_PRINT)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            if (this.printSetup == null) {
                this.printSetup = new ExPrintSetup(this.getGraphWindow());
            } else if (this.printSetup.getGraphWindow() != this.getGraphWindow()) {
                this.printSetup.setGraphWindow((TSEGraphWindow)this.getGraphWindow());
            }
            try {
                this.printSetup.getPageColumns();
                this.printSetup.getPageRows();
            }
            catch (TSLicenseRuntimeException tSLicenseRuntimeException) {
                Tomahawk.showLicenseErrorMessage();
                return;
            }
            boolean bl = this.getGraphWindow().stopTimer();
            TSEPrintPreviewWindow tSEPrintPreviewWindow = new TSEPrintPreviewWindow(this.getOwnerFrame(), Tomahawk.getResources().getStringResource("dialog.printPreview.title"), this.printSetup);
            tSEPrintPreviewWindow.setVisible(true);
            if (bl) {
                this.getGraphWindow().startTimer();
            }
            this.repaint();
        }
    }

    public void onPrintGraph() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.SINGLE_PAGE_PRINT)) {
            Tomahawk.showLicenseErrorMessage();
        } else if (this.hasPrinterAccess) {
            if (this.printSetup == null) {
                this.printSetup = new ExPrintSetup(this.getGraphWindow());
            } else if (this.printSetup.getGraphWindow() != this.getGraphWindow()) {
                this.printSetup.setGraphWindow((TSEGraphWindow)this.getGraphWindow());
            }
            try {
                this.printSetup.getPageColumns();
                this.printSetup.getPageRows();
            }
            catch (TSLicenseRuntimeException tSLicenseRuntimeException) {
                Tomahawk.showLicenseErrorMessage();
                return;
            }
            final TSEPrint tSEPrint = new TSEPrint(this.getOwnerFrame(), this.printSetup);
            Runnable runnable = new Runnable(){

                public void run() {
                    tSEPrint.execute();
                    Tomahawk.this.getOwnerFrame().setEnabled(true);
                    Tomahawk.this.getOwnerFrame().setVisible(true);
                }
            };
            Thread thread = new Thread(runnable);
            this.getOwnerFrame().setEnabled(false);
            thread.start();
        }
    }

    public void createLayoutProperties() {
        this.layoutPropertiesDialog = new TSELayoutPropertiesDialog(this.getOwnerFrame(), Tomahawk.getResources().getStringResource("dialog.layoutProperties.title"), (TSEGraphWindow)this.getGraphWindow(), (TSServiceProxy)this.getLayoutProxy(), this.getServiceInputData(this.getGraphWindow()));
        this.layoutPropertiesDialog.addWindowListener((WindowListener)this.windowHandler);
        this.layoutPropertiesDialog.getOKButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tomahawk.this.layoutPropertiesDialog.setVisible(false);
                Tomahawk.this.adjustCheckBoxes();
            }
        });
        this.layoutPropertiesDialog.getCancelButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tomahawk.this.layoutPropertiesDialog.setVisible(false);
                Tomahawk.this.adjustCheckBoxes();
            }
        });
        TSDialogCallBackListener tSDialogCallBackListener = new TSDialogCallBackListener(){

            public Object uponCallBack(Object object) {
                String string = null;
                if (object instanceof Exception && ((Exception)object).getMessage().indexOf("Feature not found in license file") >= 0) {
                    Tomahawk.showLicenseErrorMessage();
                    string = new String("Warning message displayed");
                }
                return string;
            }
        };
        this.layoutPropertiesDialog.registerCallBackListener(tSDialogCallBackListener);
    }

    public void showLayoutProperties() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.GLOBAL_LAYOUT) && !TSDLicenseManager.checkLicense((String)TSDLicenseManager.LABEL_LAYOUT)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            if (this.layoutPropertiesDialog == null) {
                this.createLayoutProperties();
            }
            this.layoutPropertiesDialog.setVisible(!this.layoutPropertiesDialog.isVisible());
            this.repaint();
        }
        this.adjustCheckBoxes();
    }

    public void onLayoutProperties() {
        this.showLayoutProperties();
    }

    public void createDrawingPreferences() {
        this.drawingPreferencesDialog = new TSEDrawingPreferencesDialog(this.getOwnerFrame(), Tomahawk.getResources().getStringResource("dialog.drawingPreferences.title"), (TSEGraphWindow)this.getGraphWindow());
        this.drawingPreferencesDialog.addWindowListener((WindowListener)this.windowHandler);
        this.drawingPreferencesDialog.getOKButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tomahawk.this.drawingPreferencesDialog.setVisible(false);
                Tomahawk.this.adjustCheckBoxes();
            }
        });
        this.drawingPreferencesDialog.getCancelButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Tomahawk.this.drawingPreferencesDialog.setVisible(false);
                Tomahawk.this.adjustCheckBoxes();
            }
        });
    }

    public void showDrawingPreferences() {
        if (this.drawingPreferencesDialog == null) {
            this.createDrawingPreferences();
        }
        this.drawingPreferencesDialog.setVisible(!this.drawingPreferencesDialog.isVisible());
        this.adjustCheckBoxes();
        this.repaint();
    }

    public void onDrawingPreferences() {
        this.showDrawingPreferences();
    }

    public ExComboBox getZoomComboBox() {
        if (this.zoomComboBox == null) {
            Object[] objectArray = new String[]{"2000%", "1000%", "500%", "150%", "100%", "75%", "50%", "25%", "10%", "Fit In Window"};
            this.zoomComboBox = new ExComboBox(objectArray);
            this.zoomComboBox.setEditable(true);
            this.zoomComboBox.setActionCommand("ZOOM_CHANGE");
            this.zoomComboBox.setFont(new Font("Dialog", 0, 12));
            Dimension dimension = new Dimension(95, 25);
            this.zoomComboBox.setPreferredSize(dimension);
            this.zoomComboBox.setMaximumSize(dimension);
            this.zoomComboBox.setMinimumSize(dimension);
            JTextField jTextField = (JTextField)this.zoomComboBox.getEditor().getEditorComponent();
            jTextField.setDocument((Document)new TSDoublePercentDocument(Double.POSITIVE_INFINITY));
        }
        return this.zoomComboBox;
    }

    public void updateZoomComboBox() {
        double d = this.getGraphWindow().getZoomLevel() * 100.0;
        String string = String.valueOf(d = (double)Math.round(d * 100.0) / 100.0);
        if (string.endsWith(".0")) {
            string = string.substring(0, string.lastIndexOf(".0"));
        }
        ExComboBox exComboBox = this.getZoomComboBox();
        exComboBox.setFireEvents(false);
        exComboBox.setSelectedItem(string + "%");
        exComboBox.setFireEvents(true);
    }

    public void onShowPalette() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDIT_ADD)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            if (this.nodePalette == null) {
                TSENodePaletteItem[] tSENodePaletteItemArray = this.createNodePaletteItemArray();
                this.nodePalette = new TSENodePalette(this.getOwnerFrame(), Tomahawk.getResources().getStringResource("dialog.nodePalette.title"), tSENodePaletteItemArray, (int)Math.ceil((double)tSENodePaletteItemArray.length / 6.0), 6, 27, 27);
                this.nodePalette.addWindowListener((WindowListener)this.windowHandler);
                this.nodePalette.addComponentListener((ComponentListener)this.dockingManager);
                this.nodePalette.setDockedSize(this.nodePalette.getSize());
                ExGraphWindow exGraphWindow = this.getGraphWindow();
                int n = exGraphWindow.getLocationOnScreen().x + exGraphWindow.getSize().width - this.nodePalette.getSize().width - this.windowInsets.right;
                int n2 = exGraphWindow.getLocationOnScreen().y + exGraphWindow.getSize().height - this.nodePalette.getSize().height - this.windowInsets.bottom;
                this.nodePalette.setLocation(n, n2);
            } else if (this.nodePalette.isDocked()) {
                this.dockingManager.replaceInternalFrame(this.nodePalette);
                this.nodePalette.setDocked(false);
                this.adjustCheckBoxes();
                return;
            }
            this.nodePalette.setVisible(!this.nodePalette.isVisible());
            this.repaint();
        }
        this.adjustCheckBoxes();
    }

    public TSENodePaletteItem[] createNodePaletteItemArray() {
        TSENodePaletteItem tSENodePaletteItem;
        ExResourceBundle exResourceBundle = Tomahawk.getResources();
        String string = TSEGraphWindow.getToolTipFormat();
        Vector<TSENodePaletteItem> vector = new Vector<TSENodePaletteItem>();
        String string2 = "node";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        boolean bl = false;
        int n = exResourceBundle.locate("node") + 2;
        string2 = (String)exResourceBundle.getKeyAt(n);
        int n2 = n;
        while (string2.startsWith("node")) {
            string4 = string2.substring(string2.lastIndexOf(46) + 1, string2.length());
            string6 = string2.substring(string2.indexOf(46) + 1, string2.lastIndexOf(46));
            if (string6.indexOf(46) <= -1) {
                string2 = (String)exResourceBundle.getKeyAt(n2 + 1);
            } else {
                string6 = string6.substring(string6.indexOf(46) + 1, string6.length());
                if (!string6.equals(string3) && n != n2) {
                    if (!bl && string5 != null) {
                        tSENodePaletteItem = new TSENodePaletteItem(string5, "nodeUI." + string3, string7);
                        vector.add(tSENodePaletteItem);
                        string5 = null;
                    } else {
                        bl = false;
                    }
                }
                string3 = string6;
                if (string4.equals("icon")) {
                    string5 = (String)exResourceBundle.getValueAt(n2);
                } else if (string4.equals("tooltip")) {
                    string7 = TSSystem.replace((String)string, (String)TSEGraphWindow.TOOLTIP_PLACEHOLDER, (String)((String)exResourceBundle.getValueAt(n2)));
                } else if (string4.equals("notInAppletToolbar") && exResourceBundle.getValueAt(n2) != null && Tomahawk.isApplet()) {
                    bl = true;
                } else if (string4.equals("notWithoutBatik") && exResourceBundle.getValueAt(n2) != null && !this.batikPresent) {
                    bl = true;
                } else if (string4.equals("notInMacJVM13Application") && exResourceBundle.getValueAt(n2) != null && System.getProperty("os.name").startsWith("Mac") && TSSystem.isJVM13()) {
                    if (!this.isApplet()) {
                        bl = true;
                    }
                }
                string2 = (String)exResourceBundle.getKeyAt(n2 + 1);
            }
            ++n2;
        }
        if (!bl && string5 != null) {
            tSENodePaletteItem = new TSENodePaletteItem(string5, "nodeUI." + string3, string7);
            vector.add(tSENodePaletteItem);
        }
        TSENodePaletteItem[] tSENodePaletteItemArray = new TSENodePaletteItem[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            tSENodePaletteItemArray[i] = (TSENodePaletteItem)vector.get(i);
        }
        return tSENodePaletteItemArray;
    }

    public void onShowOverviewWindow() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.OVERVIEW_WINDOW)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            if (this.overviewWindow != null && this.overviewWindow.isDocked()) {
                this.dockingManager.replaceInternalFrame((TSEDockableDialog)this.overviewWindow);
                this.overviewWindow.setDocked(false);
                this.adjustCheckBoxes();
                return;
            }
            if (!this.overviewBoundsCreated) {
                int n = this.graphWindow.getLocationOnScreen().x + this.graphWindow.getSize().width - 200 - this.windowInsets.right;
                int n2 = this.graphWindow.getLocationOnScreen().y + this.windowInsets.top;
                this.overviewBounds = new Rectangle(n, n2, 200, 200);
                this.overviewBoundsCreated = true;
            }
            if (this.overviewWindow == null) {
                this.overviewWindow = new TSEOverviewWindow(this.getOwnerFrame(), Tomahawk.getResources().getStringResource("dialog.overviewWindow.title"), (TSEGraphWindow)this.getGraphWindow());
                this.overviewWindow.setBounds(this.overviewBounds);
                this.overviewWindow.addWindowListener((WindowListener)this.windowHandler);
                this.overviewWindow.addComponentListener((ComponentListener)this.dockingManager);
                this.overviewWindow.setDockedSize(this.overviewWindow.getSize());
            }
            this.overviewWindow.getOverviewComponent().setToolEnabled(!this.isAutoFitInWindow());
            this.overviewWindow.setVisible(!this.overviewWindow.isVisible());
            this.repaint();
        }
        this.adjustCheckBoxes();
    }

    protected void createInspectorWindow() {
        this.inspectorWindow = new TSEInspectorWindow(this.getOwnerFrame(), Tomahawk.getResources().getStringResource("dialog.objectProperties.title"), new TSEInspector((TSEGraphWindow)this.getGraphWindow()));
        this.inspectorWindow.addWindowListener((WindowListener)this.windowHandler);
        this.inspectorWindow.addComponentListener((ComponentListener)this.dockingManager);
        this.inspectorWindow.setDockedSize(this.inspectorWindow.getWidth(), this.inspectorWindow.getHeight() / 2);
    }

    public TSEInspectorWindow getInspectorWindow() {
        return this.inspectorWindow;
    }

    public void onShowInspectorWindow() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.PROPERTY_INSPECTOR)) {
            Tomahawk.showLicenseErrorMessage();
        } else if (this.inspectorWindow != null && this.inspectorWindow.isDocked()) {
            this.dockingManager.replaceInternalFrame((TSEDockableDialog)this.inspectorWindow);
            this.inspectorWindow.setDocked(false);
        } else {
            if (this.inspectorWindow == null) {
                this.createInspectorWindow();
            }
            if (this.inspectorWindow.isVisible()) {
                this.inspectorWindow.setVisible(false);
                this.inspectorWindow.getInspector().setActive(false);
            } else {
                ExGraphWindow exGraphWindow = this.getGraphWindow();
                this.inspectorWindow.getInspector().setActive(true);
                if (!this.inspectorFirstShown) {
                    int n = exGraphWindow.getLocationOnScreen().x + this.windowInsets.left;
                    int n2 = exGraphWindow.getLocationOnScreen().y + exGraphWindow.getSize().height - this.inspectorWindow.getSize().height - this.windowInsets.bottom;
                    this.inspectorWindow.setLocation(n, n2);
                    this.inspectorFirstShown = true;
                }
                this.inspectorWindow.setVisible(true);
            }
            this.repaint();
        }
        this.adjustCheckBoxes();
    }

    public void showInspectorWindow(int n, int n2) {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.PROPERTY_INSPECTOR)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            if (this.inspectorWindow == null) {
                this.createInspectorWindow();
            }
            if (this.inspectorWindow.isDocked()) {
                return;
            }
            this.inspectorWindow.setLocation(n, n2);
            if (!this.inspectorWindow.isVisible()) {
                this.inspectorFirstShown = true;
                this.inspectorWindow.getInspector().setActive(true);
                this.inspectorWindow.setVisible(true);
            }
            this.repaint();
        }
        this.adjustCheckBoxes();
    }

    protected void createLayoutConstraintsDialog() {
        this.layoutConstraintsDialog = new TSELayoutConstraintsDialog(this.getOwnerFrame(), Tomahawk.getResources().getStringResource("dialog.constraints.title"), (TSEGraphWindow)this.graphWindow, (TSServiceProxy)this.getLayoutProxy(), this.getServiceInputData(this.graphWindow));
        this.layoutConstraintsDialog.addWindowListener((WindowListener)this.windowHandler);
        this.layoutConstraintsDialog.addComponentListener((ComponentListener)this.dockingManager);
        this.layoutConstraintsDialog.setDockedSize(this.layoutConstraintsDialog.getWidth(), this.layoutConstraintsDialog.getHeight() / 2);
        TSDialogCallBackListener tSDialogCallBackListener = new TSDialogCallBackListener(){

            public Object uponCallBack(Object object) {
                String string = null;
                if (object instanceof Exception && ((Exception)object).getMessage().indexOf("Feature not found in license file") >= 0) {
                    Tomahawk.showLicenseErrorMessage();
                    string = new String("Warning message displayed");
                }
                return string;
            }
        };
        this.layoutConstraintsDialog.registerCallBackListener(tSDialogCallBackListener);
    }

    public void onShowLayoutConstraintsDialog() {
        if (this.layoutConstraintsDialog.isDocked()) {
            this.dockingManager.replaceInternalFrame((TSEDockableDialog)this.layoutConstraintsDialog);
            this.layoutConstraintsDialog.setDocked(false);
        } else {
            if (this.layoutConstraintsDialog == null) {
                this.createLayoutConstraintsDialog();
            }
            if (this.layoutConstraintsDialog.isVisible()) {
                this.layoutConstraintsDialog.setVisible(false);
            } else {
                ExGraphWindow exGraphWindow = this.getGraphWindow();
                if (!this.constraintFirstShown) {
                    int n = exGraphWindow.getLocationOnScreen().x + this.windowInsets.left;
                    int n2 = exGraphWindow.getLocationOnScreen().y + exGraphWindow.getSize().height - this.layoutConstraintsDialog.getSize().height - this.windowInsets.bottom;
                    this.layoutConstraintsDialog.setLocation(n, n2);
                    this.constraintFirstShown = true;
                }
                this.layoutConstraintsDialog.setVisible(true);
            }
            this.repaint();
        }
        this.adjustCheckBoxes();
    }

    public void showLayoutConstraints(int n, int n2) {
        if (this.layoutConstraintsDialog.isDocked()) {
            return;
        }
        if (this.layoutConstraintsDialog == null) {
            this.createLayoutConstraintsDialog();
        }
        this.layoutConstraintsDialog.setLocation(n, n2);
        if (!this.layoutConstraintsDialog.isVisible()) {
            this.constraintFirstShown = true;
            this.layoutConstraintsDialog.setVisible(true);
        }
        this.repaint();
        this.adjustCheckBoxes();
    }

    public void setWindowsDockability(boolean bl) {
        this.dockableWindows = bl;
        this.dockingManager.setEnabled(bl);
        if (!this.dockableWindows) {
            if (this.nodePalette != null && this.nodePalette.isDocked()) {
                this.onShowPalette();
                this.nodePalette.setVisible(true);
            }
            if (this.overviewWindow != null && this.overviewWindow.isDocked()) {
                this.onShowOverviewWindow();
                this.overviewWindow.setVisible(true);
            }
            if (this.layoutConstraintsDialog != null && this.layoutConstraintsDialog.isDocked()) {
                this.onShowLayoutConstraintsDialog();
                this.layoutConstraintsDialog.setVisible(true);
            }
            if (this.inspectorWindow != null && this.inspectorWindow.isDocked()) {
                this.onShowInspectorWindow();
                this.inspectorWindow.getInspector().setActive(true);
                this.inspectorWindow.setVisible(true);
            }
        }
        this.adjustCheckBoxes();
    }

    public void onDockableWindows() {
        this.setWindowsDockability(!this.dockableWindows);
    }

    public void onPartialSelection() {
        TSESelectTool tSESelectTool;
        tSESelectTool.setPartialSelection(!(tSESelectTool = (TSESelectTool)this.getGraphWindow().getDefaultTool()).getPartialSelection());
        this.adjustCheckBoxes();
    }

    public void onFitInWindow() {
        this.getGraphWindow().fitInWindow(true);
        this.correlateButtonSelection("ZOOM_CUSTOM", true);
    }

    public void onAutoFitInWindow() {
        TSEWindowTool tSEWindowTool;
        this.setAutoFitInWindow(!this.isAutoFitInWindow());
        if (this.isAutoFitInWindow()) {
            if (this.hasGraphWindow()) {
                this.getGraphWindow().fitInWindow(true);
            }
            this.unregisterKeyCommands(this.getRootPane());
        } else {
            this.registerKeyCommands(this.getRootPane());
        }
        if (this.overviewWindow != null) {
            this.overviewWindow.getOverviewComponent().setToolEnabled(!this.isAutoFitInWindow());
        }
        if (this.hasGraphWindow() && ((tSEWindowTool = Tomahawk.getInstance().getGraphWindow().getCurrentTool()) instanceof TSEPanTool || tSEWindowTool instanceof TSEZoomTool || tSEWindowTool instanceof TSEInteractiveZoomTool || tSEWindowTool instanceof TSELinkNavigationTool)) {
            actions.onSwitchToSelect();
        }
        this.getZoomComboBox().setEnabled(!this.isAutoFitInWindow());
        this.checkAllButtons();
    }

    public boolean isAutoFitInWindow() {
        return this.autoFitInWindow;
    }

    public void setAutoFitInWindow(boolean bl) {
        this.autoFitInWindow = bl;
        if (this.autoFitInWindow) {
            Iterator iterator = this.graphWindowList.iterator();
            while (iterator.hasNext()) {
                ((TSEGraphWindow)iterator.next()).fitInWindow(false);
            }
        }
    }

    public void onAppExit() {
        this.isAppExiting = true;
        boolean bl = true;
        while (bl && this.numberOfWindowsOpen(true) > 0) {
            if (this.isUsingInternalWindows()) {
                TSJInternalFrame tSJInternalFrame = this.findInternalWindow(false, true);
                this.graphWindow = tSJInternalFrame.getGraphWindow();
                this.setGraphFileName(this.getGraphWindow().getGraphFileName());
                try {
                    if (tSJInternalFrame.isIcon()) {
                        tSJInternalFrame.setIcon(false);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            if (this.saveConfirm()) {
                this.closeGraph();
                continue;
            }
            bl = false;
        }
        if (bl) {
            this.stop();
            this.destroy();
            System.exit(0);
        } else {
            this.isAppExiting = false;
        }
    }

    public boolean loadGraphManager(boolean bl) {
        boolean bl2;
        if (bl) {
            ExGraphWindow exGraphWindow = this.graphWindow;
            this.graphWindow = new ExGraphWindow(true);
            bl2 = this.loadGraphManager();
            if (bl2) {
                this.graphWindow.setGraphFileName(this.getGraphFileName());
                this.initGraphWindow(this.graphWindow);
                this.setGraphWindowDefaults(this.graphWindow);
            } else {
                this.graphWindow = exGraphWindow;
            }
        } else {
            bl2 = this.loadGraphManager();
        }
        return bl2;
    }

    public boolean loadGraphManager() {
        Reader reader = null;
        boolean bl = true;
        try {
            TSEGraphManager tSEGraphManager = null;
            if (this.hasGraphWindow()) {
                tSEGraphManager = this.getGraphManager();
            }
            if (tSEGraphManager != null) {
                tSEGraphManager.emptyTopology();
                TSENestingManager.discardManager((TSDGraphManager)tSEGraphManager);
                TSEFoldingManager.discardManager((TSDGraphManager)tSEGraphManager);
                TSEHidingManager.discardManager((TSDGraphManager)tSEGraphManager);
            }
            ExGraphManager exGraphManager = new ExGraphManager();
            if (this.getGraphFileName().endsWith("." + Tomahawk.getResources().getStringResource("file.analysis.extension")) || this.getGraphFileName().endsWith("." + Tomahawk.getResources().getStringResource("file.analysisCompressed.extension"))) {
                TSEGraphXMLReader tSEGraphXMLReader = this.hasFileReadAccess ? new TSEGraphXMLReader(new File(this.getGraphFileName())) : new TSEGraphXMLReader(new URL(this.getGraphFileName()));
                tSEGraphXMLReader.setGraph((TSGraph)exGraphManager.getMainDisplayGraph());
                if (!tSEGraphXMLReader.read()) {
                    JOptionPane.showMessageDialog(this, TSSystem.replace((String)Tomahawk.getResources().getStringResource("dialog.openError.general.message"), (String)"%FILENAME%", (String)this.getGraphFileName()), Tomahawk.getResources().getStringResource("dialog.openError.general.title"), 0);
                }
            } else if (this.getGraphFileName().endsWith("." + Tomahawk.getResources().getStringResource("file.old.extension")) || this.getGraphFileName().endsWith("." + Tomahawk.getResources().getStringResource("file.oldCompressed.extension"))) {
                reader = this.hasFileReadAccess ? (this.isFileCompressed() ? new BufferedReader(new InputStreamReader((InputStream)new InflaterInputStream(new FileInputStream(this.getGraphFileName()), new Inflater(true)), "UTF-8")) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getGraphFileName()), "UTF-8"))) : (this.isFileCompressed() ? new BufferedReader(new InputStreamReader((InputStream)new InflaterInputStream(new URL(this.getGraphFileName()).openStream(), new Inflater(true)), "UTF-8")) : new BufferedReader(new InputStreamReader(new URL(this.getGraphFileName()).openStream(), "UTF-8")));
                TSLayoutInputTailor tSLayoutInputTailor = new TSLayoutInputTailor((TSServiceInputData)this.getServiceInputData(exGraphManager));
                tSLayoutInputTailor.setGraphManager((TSDGraphManager)exGraphManager);
                exGraphManager.readGMF(reader, (TSOptionData)this.getServiceInputData(exGraphManager));
            } else {
                TSEVisualizationXMLReader tSEVisualizationXMLReader = this.hasFileReadAccess ? new TSEVisualizationXMLReader(new File(this.getGraphFileName())) : new TSEVisualizationXMLReader(new URL(this.getGraphFileName()));
                tSEVisualizationXMLReader.setGraphManager((TSGraphManager)exGraphManager);
                tSEVisualizationXMLReader.setServiceInputData((TSServiceInputData)this.getServiceInputData(exGraphManager));
                tSEVisualizationXMLReader.setPreferences(this.getGraphWindow().getPreferences());
                if (!tSEVisualizationXMLReader.read()) {
                    JOptionPane.showMessageDialog(this, TSSystem.replace((String)Tomahawk.getResources().getStringResource("dialog.openError.general.message"), (String)"%FILENAME%", (String)this.getGraphFileName()), Tomahawk.getResources().getStringResource("dialog.openError.general.title"), 0);
                }
            }
            this.getGraphWindow().setGraphManager(exGraphManager);
            this.getGraphWindow().setUserActionEnabled(false);
            this.repaint();
            if (reader != null) {
                reader.close();
            }
            TSENestingManager.getManager((TSDGraphManager)this.getGraphWindow().getGraphManager());
            TSEFoldingManager.getManager((TSDGraphManager)this.getGraphWindow().getGraphManager());
            TSEHidingManager.getManager((TSDGraphManager)this.getGraphWindow().getGraphManager());
        }
        catch (Exception exception) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (exception instanceof TSLicenseRuntimeException) {
                Tomahawk.showLicenseErrorMessage();
            } else if (exception instanceof FileNotFoundException) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this, TSSystem.replace((String)Tomahawk.getResources().getStringResource("dialog.openError.fileNotFound.message"), (String)"%FILENAME%", (String)this.getGraphFileName()), Tomahawk.getResources().getStringResource("dialog.openError.fileNotFound.title"), 0);
            } else {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this, TSSystem.replace((String)Tomahawk.getResources().getStringResource("dialog.openError.general.message"), (String)"%FILENAME%", (String)this.getGraphFileName()), Tomahawk.getResources().getStringResource("dialog.openError.general.title"), 0);
            }
            this.setGraphFileName(null);
            bl = false;
        }
        if (bl) {
            this.getGraphWindow().resetGraphWindow();
            this.getGraphWindow().setUserActionEnabled(true);
            Tomahawk.getActions().onSwitchToSelect();
            this.graphWindow.hasFileName = true;
        }
        return bl;
    }

    private boolean isFileCompressed() {
        return this.getGraphFileName().endsWith("." + Tomahawk.getResources().getStringResource("file.xmlCompressed.extension")) || this.getGraphFileName().endsWith("." + Tomahawk.getResources().getStringResource("file.oldCompressed.extension")) || this.getGraphFileName().endsWith("." + Tomahawk.getResources().getStringResource("file.layoutCompressed.extension")) || this.getGraphFileName().endsWith("." + Tomahawk.getResources().getStringResource("file.analysisCompressed.extension"));
    }

    private boolean isFileImported() {
        return this.getGraphFileName().endsWith("." + Tomahawk.getResources().getStringResource("file.analysisCompressed.extension")) || this.getGraphFileName().endsWith("." + Tomahawk.getResources().getStringResource("file.layoutCompressed.extension")) || this.getGraphFileName().endsWith("." + Tomahawk.getResources().getStringResource("file.oldCompressed.extension")) || this.getGraphFileName().endsWith("." + Tomahawk.getResources().getStringResource("file.analysis.extension")) || this.getGraphFileName().endsWith("." + Tomahawk.getResources().getStringResource("file.layout.extension")) || this.getGraphFileName().endsWith("." + Tomahawk.getResources().getStringResource("file.old.extension"));
    }

    public boolean loadGraph() {
        return this.loadGraphManager();
    }

    public boolean saveGraphManager() {
        Writer writer = null;
        boolean bl = true;
        this.getGraphWindow().setUserActionEnabled(false);
        String string = this.getGraphFileName();
        if (string.endsWith(Tomahawk.getResources().getStringResource("file.xml.extension")) || string.endsWith(Tomahawk.getResources().getStringResource("file.xmlCompressed.extension"))) {
            try {
                this.repaint();
                TSEGraphManager tSEGraphManager = this.getGraphWindow().getGraphManager();
                TSEVisualizationXMLWriter tSEVisualizationXMLWriter = new TSEVisualizationXMLWriter(new File(this.getGraphFileName()), false, this.isFileCompressed());
                tSEVisualizationXMLWriter.setGraphManager((TSGraphManager)tSEGraphManager);
                tSEVisualizationXMLWriter.setServiceInputData((TSServiceInputData)this.getServiceInputData(this.getGraphWindow()));
                tSEVisualizationXMLWriter.setPreferences(this.getGraphWindow().getPreferences());
                tSEVisualizationXMLWriter.write();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (exception instanceof FileNotFoundException) {
                    JOptionPane.showMessageDialog(this, TSSystem.replace((String)Tomahawk.getResources().getStringResource("dialog.saveError.pathNotFound.message"), (String)"%FILENAME%", (String)this.getGraphFileName()), Tomahawk.getResources().getStringResource("dialog.saveError.pathNotFound.title"), 0);
                } else {
                    JOptionPane.showMessageDialog(this, TSSystem.replace((String)Tomahawk.getResources().getStringResource("dialog.saveError.message"), (String)"%FILENAME%", (String)this.getGraphFileName()), Tomahawk.getResources().getStringResource("dialog.saveError.title"), 0);
                }
                this.setGraphFileName(null);
                bl = false;
            }
        } else if (string.endsWith(Tomahawk.getResources().getStringResource("file.layout.extension")) || string.endsWith(Tomahawk.getResources().getStringResource("file.layoutCompressed.extension"))) {
            try {
                this.repaint();
                TSEGraphManager tSEGraphManager = this.getGraphWindow().getGraphManager();
                TSLayoutXMLWriter tSLayoutXMLWriter = new TSLayoutXMLWriter(new File(this.getGraphFileName()), false, this.isFileCompressed());
                tSLayoutXMLWriter.setGraphManager((TSGraphManager)tSEGraphManager);
                tSLayoutXMLWriter.setServiceInputData((TSServiceInputData)this.getServiceInputData(this.getGraphWindow()));
                tSLayoutXMLWriter.write();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (exception instanceof FileNotFoundException) {
                    JOptionPane.showMessageDialog(this, TSSystem.replace((String)Tomahawk.getResources().getStringResource("dialog.saveError.pathNotFound.message"), (String)"%FILENAME%", (String)this.getGraphFileName()), Tomahawk.getResources().getStringResource("dialog.saveError.pathNotFound.title"), 0);
                } else {
                    JOptionPane.showMessageDialog(this, TSSystem.replace((String)Tomahawk.getResources().getStringResource("dialog.saveError.message"), (String)"%FILENAME%", (String)this.getGraphFileName()), Tomahawk.getResources().getStringResource("dialog.saveError.title"), 0);
                }
                this.setGraphFileName(null);
                bl = false;
            }
        } else if (string.endsWith(Tomahawk.getResources().getStringResource("file.analysis.extension")) || string.endsWith(Tomahawk.getResources().getStringResource("file.analysisCompressed.extension"))) {
            try {
                this.repaint();
                TSEGraphManager tSEGraphManager = this.getGraphWindow().getGraphManager();
                TSGraphXMLWriter tSGraphXMLWriter = new TSGraphXMLWriter(new File(this.getGraphFileName()), false, this.isFileCompressed());
                tSGraphXMLWriter.setGraph((TSGraph)tSEGraphManager.getMainDisplayGraph());
                tSGraphXMLWriter.write();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (exception instanceof FileNotFoundException) {
                    JOptionPane.showMessageDialog(this, TSSystem.replace((String)Tomahawk.getResources().getStringResource("dialog.saveError.pathNotFound.message"), (String)"%FILENAME%", (String)this.getGraphFileName()), Tomahawk.getResources().getStringResource("dialog.saveError.pathNotFound.title"), 0);
                } else {
                    JOptionPane.showMessageDialog(this, TSSystem.replace((String)Tomahawk.getResources().getStringResource("dialog.saveError.message"), (String)"%FILENAME%", (String)this.getGraphFileName()), Tomahawk.getResources().getStringResource("dialog.saveError.title"), 0);
                }
                this.setGraphFileName(null);
                bl = false;
            }
        }
        this.getGraphWindow().setUserActionEnabled(true);
        return bl;
    }

    public int getOperationFromCommand(String string) {
        String string2 = null;
        int n = -1;
        int n2 = string.indexOf(46);
        if (n2 != -1) {
            String string3 = string.substring(n2 + 1);
            int n3 = string3.indexOf(46);
            string2 = n3 != -1 ? string3.substring(0, n3) : string3;
        }
        if (string2 != null) {
            n = Integer.parseInt(string2);
        }
        return n;
    }

    public int getLayoutStyleFromCommand(String string) {
        String string2;
        int n;
        String string3 = null;
        int n2 = -1;
        int n3 = string.indexOf(46);
        if (n3 != -1 && (n = (string2 = string.substring(n3 + 1)).indexOf(46)) != -1) {
            string3 = string2.substring(n + 1);
        }
        if (string3 != null) {
            n2 = Integer.parseInt(string3);
        }
        return n2;
    }

    public void onApplyOperation(String string, boolean bl) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.canCooperate = false;
        this.getGraphWindow().setUserActionEnabled(false);
        int n = this.getOperationFromCommand(string);
        if (n == 1000) {
            this.onApplyLayout(string, bl);
        } else if (n == 1001) {
            if (string.indexOf("ALL_EDGES") >= 0) {
                this.onApplyRouting(false);
            } else {
                this.onApplyRouting(true);
            }
        } else if (n == 1002) {
            this.onApplyLabeling();
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.getGraphWindow().setUserActionEnabled(true);
        this.canCooperate = true;
        this.checkAllButtons();
    }

    public void onApplyLayout(String string, boolean bl) {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.GLOBAL_LAYOUT)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            int n = this.getLayoutStyleFromCommand(string);
            TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData = this.getServiceInputData(this.getGraphWindow());
            if (n == -1) {
                n = this.getLayoutStyle(this.getGraphWindow());
            }
            try {
                if (bl) {
                    this.getGraphWindow().transmit((TSCommand)new TSEIncrementalLayoutCommand((TSEGraphWindow)this.getGraphWindow(), (TSServiceProxy)this.getLayoutProxy(), tSEAllOptionsServiceInputData, n));
                } else {
                    this.getGraphWindow().transmit((TSCommand)new TSELayoutCommand((TSEGraphWindow)this.getGraphWindow(), (TSServiceProxy)this.getLayoutProxy(), tSEAllOptionsServiceInputData, n));
                }
                this.correlateButtonSelection(string, true);
                this.correlateButtonSelection("ZOOM_CUSTOM", true);
            }
            catch (TSServiceException tSServiceException) {
                this.processServiceException(tSServiceException);
            }
            catch (Exception exception) {
                if (exception.getMessage() != null && exception.getMessage().indexOf("Feature not found in license file") >= 0) {
                    this.getGraphWindow().popUndoStack();
                    Tomahawk.showLicenseErrorMessage();
                }
                exception.printStackTrace();
                this.layoutProxy = null;
                this.checkAllButtons();
                JOptionPane.showMessageDialog(this, Tomahawk.getResources().getStringResource("dialog.layoutError.message"), Tomahawk.getResources().getStringResource("dialog.layoutError.title"), 0);
            }
            this.checkAllButtons();
        }
    }

    public void onApplyRouting(boolean bl) {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.GLOBAL_LAYOUT)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData = this.getServiceInputData(this.getGraphWindow());
            try {
                this.getGraphWindow().transmit((TSCommand)new TSERoutingCommand((TSEGraphWindow)this.getGraphWindow(), (TSServiceProxy)this.getLayoutProxy(), tSEAllOptionsServiceInputData, bl));
                this.correlateButtonSelection("ZOOM_CUSTOM", true);
            }
            catch (TSServiceException tSServiceException) {
                this.processServiceException(tSServiceException);
            }
            catch (Exception exception) {
                if (exception.getMessage().indexOf("Feature not found in license file") >= 0) {
                    this.getGraphWindow().popUndoStack();
                    Tomahawk.showLicenseErrorMessage();
                }
                exception.printStackTrace();
                this.layoutProxy = null;
                this.checkAllButtons();
                JOptionPane.showMessageDialog(this, Tomahawk.getResources().getStringResource("dialog.layoutError.message"), Tomahawk.getResources().getStringResource("dialog.layoutError.title"), 0);
            }
            this.checkAllButtons();
        }
    }

    public void onApplyLabeling() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.LABEL_LAYOUT)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData = this.getServiceInputData(this.getGraphWindow());
            try {
                this.getGraphWindow().transmit((TSCommand)new TSELabelingCommand((TSEGraphWindow)this.getGraphWindow(), (TSServiceProxy)this.getLayoutProxy(), tSEAllOptionsServiceInputData));
                this.correlateButtonSelection("ZOOM_CUSTOM", true);
            }
            catch (TSServiceException tSServiceException) {
                this.processServiceException(tSServiceException);
            }
            catch (Exception exception) {
                if (exception.getMessage().indexOf("Feature not found in license file") >= 0) {
                    this.getGraphWindow().popUndoStack();
                    Tomahawk.showLicenseErrorMessage();
                }
                exception.printStackTrace();
                this.layoutProxy = null;
                this.checkAllButtons();
                JOptionPane.showMessageDialog(this, Tomahawk.getResources().getStringResource("dialog.layoutError.message"), Tomahawk.getResources().getStringResource("dialog.layoutError.title"), 0);
            }
            this.checkAllButtons();
        }
    }

    void processServiceException(TSServiceException tSServiceException) {
        if (tSServiceException.getErrorCode() != 4) {
            String string = Tomahawk.getResources().getStringResource("service.server.type");
            if (string.equals("direct") || string.equals("rmi")) {
                this.layoutProxy = null;
            }
            this.checkAllButtons();
        }
        if (this.graphWindow != null) {
            this.graphWindow.drawGraph();
            this.graphWindow.repaint();
        }
        if (tSServiceException.getErrorCode() == 4) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            JOptionPane.showMessageDialog(this, Tomahawk.getResources().getStringResource("dialog.layoutError.message") + "\nError code: " + tSServiceException.getErrorCode(), Tomahawk.getResources().getStringResource("dialog.layoutError.title"), 0);
            tSServiceException.printStackTrace();
        }
    }

    public TSEAllOptionsServiceInputData getServiceInputData(TSEGraphWindow tSEGraphWindow) {
        TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData = null;
        if (tSEGraphWindow != null) {
            tSEAllOptionsServiceInputData = this.getServiceInputData(tSEGraphWindow.getGraphManager());
        }
        return tSEAllOptionsServiceInputData;
    }

    public TSEAllOptionsServiceInputData getServiceInputData(TSEGraphManager tSEGraphManager) {
        TSEAllOptionsServiceInputData tSEAllOptionsServiceInputData = null;
        if (this.graphWindow != null) {
            if (this.serviceInputDataTable.containsKey(tSEGraphManager)) {
                tSEAllOptionsServiceInputData = (TSEAllOptionsServiceInputData)this.serviceInputDataTable.get(tSEGraphManager);
            } else {
                tSEAllOptionsServiceInputData = new TSEAllOptionsServiceInputData((TSDGraphManager)tSEGraphManager);
                this.serviceInputDataTable.put(tSEGraphManager, tSEAllOptionsServiceInputData);
                TSLayoutInputTailor tSLayoutInputTailor = new TSLayoutInputTailor((TSServiceInputData)tSEAllOptionsServiceInputData);
                tSLayoutInputTailor.setGraphManager((TSDGraphManager)tSEGraphManager);
            }
        }
        return tSEAllOptionsServiceInputData;
    }

    public int getLayoutStyle(TSEGraphWindow tSEGraphWindow) {
        return this.getLayoutStyle(tSEGraphWindow.getGraph());
    }

    public int getLayoutStyle(TSEGraph tSEGraph) {
        TSEGraphWindow tSEGraphWindow = tSEGraph.getGraphWindow();
        TSGeneralLayoutInputTailor tSGeneralLayoutInputTailor = new TSGeneralLayoutInputTailor((TSServiceInputData)this.getServiceInputData(tSEGraphWindow), (TSDGraph)tSEGraphWindow.getGraph());
        return tSGeneralLayoutInputTailor.getLayoutStyle();
    }

    public void showWindowStatus(String string) {
        this.graphWindow.setStatus(string);
        this.showStatus(string);
    }

    public boolean hasChanged() {
        boolean bl = !this.hasGraphWindow() ? false : this.graphWindow.isChanged();
        return bl;
    }

    public void setChanged(boolean bl) {
        this.getGraphWindow().setChanged(bl);
        this.checkAllButtons();
    }

    private String nextNewDocTitle() {
        String string = Tomahawk.getResources().getString("file.noname") + this.nextNewDocIndex + "." + Tomahawk.getResources().getStringResource("file.xml.extension");
        ++this.nextNewDocIndex;
        return string;
    }

    protected void onFocusGained() {
        if (this.hasGraphWindow()) {
            this.correlateButtonAbility("PASTE_GRAPH", this.getGraphWindow().canPaste());
        }
    }

    public void checkAllButtons() {
        Enumeration enumeration = Tomahawk.getResources().getAllButtons();
        while (enumeration.hasMoreElements()) {
            this.chooseState((AbstractButton)enumeration.nextElement());
        }
        this.adjustCheckBoxes();
        if (this.zoomComboBox != null) {
            this.zoomComboBox.setEnabled(this.hasGraphWindow() && !this.isAutoFitInWindow());
        }
    }

    public void chooseState(AbstractButton abstractButton) {
        block119: {
            String string = abstractButton.getActionCommand();
            if ("APP_EXIT".equals(string)) {
                abstractButton.setEnabled(!Tomahawk.isApplet());
            } else if ("CLOSE_GRAPH".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow());
            } else if ("CLOSE_ALL_GRAPHS".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow());
            } else if ("CLEAR_ALL".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraphManager().getMainDisplayGraph().numberOfNodes() > 0);
            } else if ("COPY_GRAPH".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && (this.getGraphManager().hasSelectedNodes() || this.getGraphManager().hasSelectedEdgeLabels(true) || this.getGraphManager().hasSelectedNodeLabels() || this.getGraphManager().hasSelectedConnectorLabels()));
            } else if ("CUT_GRAPH".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && (this.getGraphManager().hasSelectedNodes() || this.getGraphManager().hasSelectedEdgeLabels(true, false) || this.getGraphManager().hasSelectedNodeLabels() || this.getGraphManager().hasSelectedConnectorLabels()));
            } else if ("OVERVIEW_WINDOW".equals(string) || "INSPECTOR_WINDOW".equals(string) || "PALETTE_WINDOW".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow());
            } else if (string.startsWith("GRID_SIZE") || string.startsWith("GRID_TYPE")) {
                abstractButton.setEnabled(this.hasGraphWindow());
            } else if ("DRAWING_PREFERENCES".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow());
            } else if ("HIDE_SELECTED".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && (this.getGraphManager().hasSelectedNodes() || this.getGraphManager().hasSelectedEdges(false, true)));
            } else if ("UNHIDE_ALL".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && TSEHidingManager.getManager((TSDGraphManager)this.getGraphManager()).hasHiddenViewableObjects());
            } else if ("DELETE_SELECTED".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraphManager().hasSelected(true, true));
            } else if ("REVERT_GRAPH".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraphFileName() != null && this.getGraphWindow().hasFileName && this.hasChanged());
            } else if ("DUPLICATE_GRAPH".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && (this.getGraphManager().hasSelectedNodes() || this.getGraphManager().hasSelectedEdges(true, false) || this.getGraphManager().hasSelectedEdgeLabels(true, false) || this.getGraphManager().hasSelectedNodeLabels() || this.getGraphManager().hasSelectedConnectorLabels()));
            } else if ("PRINT_SETUP".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.hasPrinterAccess);
            } else if ("PRINT_PREVIEW".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.hasPrinterAccess);
            } else if ("PRINT_GRAPH".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.hasPrinterAccess);
            } else if ("REDO".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraphWindow().canRedo());
            } else if ("SAVE_GRAPH".equals(string)) {
                try {
                    if (!this.hasGraphWindow()) {
                        abstractButton.setEnabled(false);
                        break block119;
                    }
                    if (this.hasGraphWindow() && this.getGraphWindow().hasFileName && !new File(this.getGraphFileName()).canWrite()) {
                        abstractButton.setEnabled(false);
                        break block119;
                    }
                    abstractButton.setEnabled(this.hasChanged() && this.hasFileWriteAccess);
                }
                catch (Exception exception) {
                    abstractButton.setEnabled(false);
                }
            } else if ("SAVE_GRAPH_AS".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.hasFileWriteAccess);
            } else if ("EXPORT_GRAPH".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.hasFileWriteAccess);
            } else if ("SAVE_GRAPH_AS_IMAGE".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.hasFileWriteAccess && !Tomahawk.isApplet());
            } else if ("SELECT_ALL".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraph().numberOfNodes() > 0);
            } else if ("SELECT_EDGES".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraphManager().numberOfViewableEdges() + this.getGraphManager().numberOfViewableIntergraphEdges() > 0);
            } else if ("SELECT_LABELS".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraphManager().numberOfViewableEdgeLabels() + this.getGraphManager().numberOfViewableNodeLabels() + this.getGraphManager().numberOfViewableConnectorLabels() > 0);
            } else if ("SELECT_NODES".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraph().numberOfNodes() > 0);
            } else if ("SELECT_TOOL".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow());
            } else if ("EDGE_NAVIGATION_TOOL".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraphManager().numberOfViewableEdges() + this.getGraphManager().numberOfViewableIntergraphEdges() > 0 && !this.isAutoFitInWindow());
            } else if ("UNDO".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraphWindow().canUndo());
            } else if ("CLEAR_HISTORY".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && (this.getGraphWindow().canUndo() || this.getGraphWindow().canRedo()));
            } else if ("ZOOM_FIT".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraph().numberOfNodes() > 0 && !this.isAutoFitInWindow());
            } else if ("RUN_MODE".equals(string)) {
                boolean bl = this.hasGraphWindow();
                abstractButton.setEnabled(bl);
                if (bl) {
                    if (this.graphWindow != null) {
                        this.correlateButtonSelection("RUN_MODE", this.getGraphWindow().isInRunMode());
                    } else {
                        abstractButton.setSelected(false);
                    }
                }
            } else if ("TABBED_WINDOWS".equals(string)) {
                abstractButton.setEnabled(this.isUsingMultipleWindows());
            } else if ("ZOOM_IN".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraphWindow().getZoomLevel() < this.getGraphWindow().getMaxZoomLevel() / 1.1 && !this.isAutoFitInWindow());
            } else if ("ZOOM_OUT".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraphWindow().getZoomLevel() > this.getGraphWindow().getMinZoomLevel() * 1.1 && !this.isAutoFitInWindow());
            } else if ("ZOOM_CUSTOM".equals(string) || "PAN_TOOL".equals(string) || "ZOOM_TOOL".equals(string) || "INTERACTIVE_ZOOM_TOOL".equals(string) || string.startsWith("ZOOM")) {
                abstractButton.setEnabled(this.hasGraphWindow() && !this.isAutoFitInWindow());
            } else if ("SNAP_TO_GRID".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraphWindow().getGrid() != null && this.getGraphManager().hasSelected(true));
            } else if (string.startsWith("CREATE_NODE_TOOL")) {
                abstractButton.setEnabled(this.hasGraphWindow());
            } else if (string.startsWith("CREATE_EDGE_TOOL")) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraph().numberOfNodes() > 0);
            } else if (string.startsWith("EXPAND_ALL")) {
                if (this.hasGraphWindow()) {
                    TSENestingManager tSENestingManager = (TSENestingManager)TSENestingManager.getManager((TSDGraphManager)this.getGraphManager());
                    abstractButton.setEnabled(tSENestingManager.hasViewableCollapsedNodes());
                } else {
                    abstractButton.setEnabled(false);
                }
            } else if (string.startsWith("COLLAPSE_ALL")) {
                abstractButton.setEnabled(this.hasGraphWindow() && TSENestingManager.hasExpandedNodes((TSDGraph)this.getGraph()));
            } else if (string.startsWith("EXPAND_SELECTED")) {
                abstractButton.setEnabled(this.hasGraphWindow() && ((TSENestingManager)TSENestingManager.getManager((TSDGraphManager)this.getGraphManager())).hasSelectedCollapsedNodes());
            } else if (string.startsWith("COLLAPSE_SELECTED")) {
                abstractButton.setEnabled(this.hasGraphWindow() && ((TSENestingManager)TSENestingManager.getManager((TSDGraphManager)this.getGraphManager())).hasSelectedExpandedNodes());
            } else if (string.startsWith("FOLD_SELECTED")) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraphManager().hasSelectedNodes());
            } else if (string.startsWith("UNFOLD_ALL")) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraphManager().hasViewableFolderNodes());
            } else if (string.startsWith("UNFOLD_SELECTED")) {
                abstractButton.setEnabled(this.hasGraphWindow() && ((TSEFoldingManager)TSEFoldingManager.getManager((TSDGraphManager)this.getGraphManager())).hasSelectedFolderNodes());
            } else if ("GOTO_PARENT".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.getGraphWindow().getGraph().isChildGraph());
            } else if ("INCREMENTAL_LAYOUT".equals(string)) {
                if (TSDLicenseManager.checkLicense((String)TSDLicenseManager.INCREMENTAL_LAYOUT) && this.hasGraphWindow()) {
                    boolean bl = false;
                    Iterator iterator = TSENestingManager.getNestedGraphsWithin((TSDGraph)this.getGraph()).iterator();
                    while (iterator.hasNext()) {
                        TSEGraph tSEGraph = (TSEGraph)iterator.next();
                        int n = 5;
                        int n2 = this.getLayoutStyle(tSEGraph);
                        if (n2 == n) continue;
                        bl = true;
                        break;
                    }
                    abstractButton.setEnabled(this.getGraph().numberOfNodes() > 0 && bl && this.layoutProxy != null && this.incrementalLayoutEnabled);
                } else {
                    abstractButton.setEnabled(false);
                }
            } else if ("LAYOUT_PROPERTIES".equals(string) || "CONSTRAINT_WINDOW".equals(string)) {
                abstractButton.setEnabled(this.hasGraphWindow() && this.layoutProxy != null);
            } else if (string.startsWith("APPLY_OPERATION") || string.startsWith("RANDOM_LAYOUT")) {
                if (this.getOperationFromCommand(string) == 1002) {
                    abstractButton.setEnabled(this.hasGraphWindow() && (this.getGraphManager().numberOfViewableNodeLabels() > 0 || this.getGraphManager().numberOfViewableConnectorLabels() > 0 || this.getGraphManager().numberOfViewableEdgeLabels() > 0) && this.isLayoutOperationSupported(1002));
                } else if (this.getOperationFromCommand(string) == 1001) {
                    abstractButton.setEnabled(!(!this.hasGraphWindow() || this.getGraphManager().numberOfViewableEdges() <= 0 && this.getGraphManager().numberOfViewableIntergraphEdges() <= 0 || !this.isLayoutOperationSupported(1001) || string.indexOf("SELECTED_EDGES") >= 0 && !this.getGraphManager().hasSelectedEdges(true)));
                } else if (!this.hasGraphWindow()) {
                    abstractButton.setEnabled(false);
                } else {
                    int n = this.getLayoutStyle(this.getGraph());
                    int n3 = this.getLayoutStyleFromCommand(string);
                    if (n3 != -1) {
                        abstractButton.setEnabled(this.getGraph().numberOfNodes() > 0 && this.isLayoutStyleSupported(n3));
                        abstractButton.setSelected(n == n3);
                    } else {
                        abstractButton.setEnabled(this.getGraph().numberOfNodes() > 0 && this.isLayoutStyleSupported(n));
                    }
                }
            }
        }
    }

    public static boolean isApplet() {
        return Tomahawk.getAppletStub() == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isWindowActivated() {
        if (this.windowActivated) return true;
        if (!this.isApplet()) return false;
        if (!this.isActive()) return false;
        return true;
    }

    private void setWindowActivated(boolean bl) {
        this.windowActivated = bl;
    }

    public static void main(String[] stringArray) {
        int n;
        JLabel jLabel = new JLabel(" ");
        jLabel.setBorder(new EmptyBorder(0, 5, 0, 5));
        Tomahawk.setAppletStub(new LocalAppletStub(stringArray, jLabel));
        Tomahawk tomahawk = Tomahawk.getInstance();
        ImageIcon imageIcon = Tomahawk.getResources().getIconResource("app.icon", class$editor$Tomahawk == null ? (class$editor$Tomahawk = Tomahawk.class$("editor.Tomahawk")) : class$editor$Tomahawk);
        if (imageIcon != null && imageIcon.getImage() != null) {
            tomahawk.appFrame.setIconImage(imageIcon.getImage());
        }
        tomahawk.appFrame.getContentPane().add((Component)jLabel, "South");
        tomahawk.appFrame.getContentPane().add((Component)tomahawk, "Center");
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            boolean bl = true;
            if (string.indexOf(61) != -1) {
                int n2 = string.indexOf(61);
                String string2 = string.substring(0, n2);
                if (tomahawk.getResources().getObjectResource(string2) != null) {
                    bl = false;
                }
            }
            if (!bl) continue;
            vector.add(stringArray[n]);
        }
        if (vector.size() > 0) {
            tomahawk.setGraphFileName((String)vector.get(0));
        }
        tomahawk.init();
        tomahawk.getGraphWindow().fitInWindow(true);
        if (tomahawk.isUsingMultipleWindows() && vector.size() > 1) {
            for (n = 1; n < vector.size(); ++n) {
                tomahawk.onLoadGraph((String)vector.get(n));
            }
        }
        tomahawk.appFrame.addComponentListener(tomahawk.new WindowMotionHandler());
        tomahawk.appFrame.setVisible(true);
        tomahawk.appFrame.setDefaultCloseOperation(0);
        tomahawk.start();
    }

    public static void showLicenseErrorMessage() {
        JOptionPane.showMessageDialog(null, Tomahawk.getResources().getStringResource("dialog.licenseerror.message"), Tomahawk.getResources().getStringResource("dialog.licenseerror.title"), 2);
        Tomahawk.getInstance().updateToolButtonSelection();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        JPopupMenu tabPopupMenu;
        MouseEvent lastMousePressedEvent;

        private MouseHandler() {
        }

        public JPopupMenu getTabPopupMenu() {
            if (this.tabPopupMenu == null) {
                this.tabPopupMenu = Tomahawk.getResources().createPopup("popup.tab");
            }
            return this.tabPopupMenu;
        }

        public void init() {
            JMenuBar jMenuBar = Tomahawk.this.getJMenuBar();
            int n = jMenuBar.getMenuCount();
            for (int i = 0; i < n; ++i) {
                JMenu jMenu = jMenuBar.getMenu(i);
                jMenu.addMouseListener(this);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = mouseEvent.getModifiers();
            if (mouseEvent.getSource() instanceof JMenu) {
                if (Tomahawk.this.hasGraphWindow()) {
                    Tomahawk.this.getGraphWindow().cancelAction();
                }
            } else if (Tomahawk.this.isUsingTabbedWindows() && mouseEvent.getSource() instanceof JTabbedPane && Tomahawk.this.getTabbedPane().getTabCount() > 0) {
                JTabbedPane jTabbedPane = Tomahawk.this.getTabbedPane();
                Rectangle rectangle = jTabbedPane.getUI().getTabBounds(jTabbedPane, jTabbedPane.getSelectedIndex());
                if (rectangle.contains(mouseEvent.getPoint())) {
                    Tomahawk.this.getGraphWindow().cancelAction();
                }
                if ((!System.getProperty("os.name").startsWith("Mac") && (n & 4) != 0 || System.getProperty("os.name").startsWith("Mac") && mouseEvent.isPopupTrigger()) && rectangle.contains(mouseEvent.getPoint())) {
                    this.lastMousePressedEvent = mouseEvent;
                    this.showPopup();
                }
            }
        }

        private void showPopup() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ MouseHandler this$1;
                {
                    this.this$1 = mouseHandler;
                }

                public void run() {
                    try {
                        JPopupMenu jPopupMenu = this.this$1.getTabPopupMenu();
                        MenuElement[] menuElementArray = jPopupMenu.getSubElements();
                        for (int i = 0; i < menuElementArray.length; ++i) {
                            MouseHandler.access$300(this.this$1).chooseState((JMenuItem)menuElementArray[i]);
                        }
                        MouseEvent mouseEvent = this.this$1.lastMousePressedEvent;
                        ExSelectTool exSelectTool = (ExSelectTool)MouseHandler.access$300(this.this$1).getGraphWindow().getDefaultTool();
                        exSelectTool.showPopup("TAB_POPUP", mouseEvent.getPoint());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }

        static /* synthetic */ Tomahawk access$300(MouseHandler mouseHandler) {
            return mouseHandler.Tomahawk.this;
        }
    }

    static class LocalAppletContext
    implements AppletContext {
        JLabel statusLabel;

        public LocalAppletContext(JLabel jLabel) {
            this.statusLabel = jLabel;
            TSELocalization.setComponentOrientation((Component)this.statusLabel);
        }

        public Applet getApplet(String string) {
            return null;
        }

        public Enumeration getApplets() {
            return new Vector().elements();
        }

        public AudioClip getAudioClip(URL uRL) {
            return null;
        }

        public Image getImage(URL uRL) {
            String string = uRL.getFile();
            return Toolkit.getDefaultToolkit().getImage(string);
        }

        public void showDocument(URL uRL) {
        }

        public void showDocument(URL uRL, String string) {
        }

        public void showStatus(String string) {
            this.statusLabel.setText(string);
        }

        public void setStream(String string, InputStream inputStream) throws IOException {
        }

        public Iterator getStreamKeys() {
            return null;
        }

        public InputStream getStream(String string) {
            return null;
        }
    }

    static class LocalAppletStub
    implements AppletStub {
        String[] args;
        AppletContext appletContext;

        public LocalAppletStub(String[] stringArray, JLabel jLabel) {
            this.args = stringArray;
            this.appletContext = new LocalAppletContext(jLabel);
        }

        public void appletResize(int n, int n2) {
        }

        public AppletContext getAppletContext() {
            return this.appletContext;
        }

        public URL getCodeBase() {
            return this.getDocumentBase();
        }

        public URL getDocumentBase() {
            try {
                String string = System.getProperty("user.dir");
                if (string.indexOf(58) > 0) {
                    string = string.substring(string.indexOf(58) + 2);
                }
                return new URL("file://" + InetAddress.getLocalHost().getHostName() + "/" + string.replace('\\', '/'));
            }
            catch (Exception exception) {
                return null;
            }
        }

        public String getParameter(String string) {
            for (int i = 0; i < this.args.length; ++i) {
                int n;
                String string2 = this.args[i];
                if (!string2.startsWith(string) || (n = string2.indexOf(61)) <= 0 || n >= string2.length() - 1) continue;
                return string2.substring(n + 1);
            }
            return null;
        }

        public boolean isActive() {
            return true;
        }
    }

    class ExFocusManager
    extends DefaultFocusManager {
        ExFocusManager() {
        }

        public void processKeyEvent(Component component, KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() != 73 && (keyEvent.getKeyCode() != 9 || (keyEvent.getModifiers() & 2) == 0)) {
                super.processKeyEvent(component, keyEvent);
            }
        }
    }

    class WindowMotionHandler
    extends ComponentAdapter {
        int oldX;
        int oldY;
        double oldWidth;
        double oldHeight;

        WindowMotionHandler() {
            this.oldX = Tomahawk.this.appFrame.getLocation().x;
            this.oldY = Tomahawk.this.appFrame.getLocation().y;
            this.oldWidth = Tomahawk.this.appFrame.getSize().width;
            this.oldHeight = Tomahawk.this.appFrame.getSize().height;
        }

        public void componentMoved(ComponentEvent componentEvent) {
            int n = Tomahawk.this.appFrame.getLocation().x - this.oldX;
            int n2 = Tomahawk.this.appFrame.getLocation().y - this.oldY;
            if (Tomahawk.this.overviewWindow != null && Tomahawk.this.overviewWindow.isAttached()) {
                Tomahawk.this.overviewWindow.setLocation(Tomahawk.this.overviewWindow.getLocation().x + n, Tomahawk.this.overviewWindow.getLocation().y + n2);
            }
            if (Tomahawk.this.nodePalette != null && Tomahawk.this.nodePalette.isAttached()) {
                Tomahawk.this.nodePalette.setLocation(Tomahawk.this.nodePalette.getLocation().x + n, Tomahawk.this.nodePalette.getLocation().y + n2);
            }
            if (Tomahawk.this.inspectorWindow != null && Tomahawk.this.inspectorWindow.isAttached()) {
                Tomahawk.this.inspectorWindow.setLocation(Tomahawk.this.inspectorWindow.getLocation().x + n, Tomahawk.this.inspectorWindow.getLocation().y + n2);
            }
            if (Tomahawk.this.layoutConstraintsDialog != null && Tomahawk.this.layoutConstraintsDialog.isAttached()) {
                Tomahawk.this.layoutConstraintsDialog.setLocation(Tomahawk.this.layoutConstraintsDialog.getLocation().x + n, Tomahawk.this.layoutConstraintsDialog.getLocation().y + n2);
            }
            this.oldX = Tomahawk.this.appFrame.getLocation().x;
            this.oldY = Tomahawk.this.appFrame.getLocation().y;
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (Tomahawk.this.nodePalette != null) {
                this.checkDialog((JDialog)Tomahawk.this.nodePalette, null);
            }
            this.checkDialog((JDialog)Tomahawk.this.overviewWindow, Tomahawk.this.overviewBounds);
        }

        public void checkDialog(JDialog jDialog, Rectangle rectangle) {
            int n;
            int n2;
            boolean bl = false;
            int n3 = Tomahawk.this.appFrame.getLocation().x;
            int n4 = Tomahawk.this.appFrame.getLocation().y;
            int n5 = Tomahawk.this.appFrame.getSize().width;
            int n6 = Tomahawk.this.appFrame.getSize().height;
            int n7 = 200;
            int n8 = 200;
            if (jDialog != null) {
                n2 = jDialog.getBounds().x;
                n = jDialog.getBounds().y;
                n7 = jDialog.getBounds().width;
                n8 = jDialog.getBounds().height;
            } else {
                n2 = rectangle.x;
                n = rectangle.y;
                n7 = rectangle.width;
                n8 = rectangle.height;
            }
            int n9 = n2;
            int n10 = n;
            if (n2 + n7 > n3 + n5) {
                n9 = n3 + n5 - n7;
                bl = true;
            }
            if (n + n8 > n4 + n6) {
                n10 = n4 + n6 - n6 / 2;
                bl = true;
            }
            if (bl) {
                rectangle = new Rectangle(n9, n10, n7, n8);
                if (jDialog != null) {
                    jDialog.setBounds(rectangle);
                }
            }
        }
    }

    class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            if (Tomahawk.this.hasGraphWindow()) {
                Tomahawk.this.getGraphWindow().cancelAction();
            }
            if (windowEvent.getSource() == Tomahawk.this.overviewWindow) {
                Tomahawk.this.overviewBounds = Tomahawk.this.overviewWindow.getBounds();
                Tomahawk.this.overviewWindow = null;
                Tomahawk.this.adjustCheckBoxes();
            } else if (windowEvent.getSource() == Tomahawk.this.inspectorWindow) {
                Tomahawk.this.inspectorWindow.setVisible(false);
                Tomahawk.this.inspectorWindow.getInspector().setActive(false);
                Tomahawk.this.adjustCheckBoxes();
            } else if (windowEvent.getSource() == Tomahawk.this.layoutConstraintsDialog) {
                Tomahawk.this.layoutConstraintsDialog.setVisible(false);
                Tomahawk.this.adjustCheckBoxes();
            } else if (windowEvent.getSource() == Tomahawk.this.layoutPropertiesDialog) {
                Tomahawk.this.layoutPropertiesDialog.setVisible(false);
                Tomahawk.this.adjustCheckBoxes();
            } else if (windowEvent.getSource() == Tomahawk.this.drawingPreferencesDialog) {
                Tomahawk.this.drawingPreferencesDialog.setVisible(false);
                Tomahawk.this.adjustCheckBoxes();
            } else if (windowEvent.getSource() == Tomahawk.this.nodePalette) {
                Tomahawk.this.nodePalette.setVisible(false);
                Tomahawk.this.adjustCheckBoxes();
            } else if (windowEvent.getSource() instanceof TSESaveAsImageDialog) {
                Tomahawk.this.repaint();
            } else {
                Tomahawk.this.onAppExit();
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
            if (windowEvent.getSource() instanceof TSESaveAsImageDialog) {
                Tomahawk.this.repaint();
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
            if (!Tomahawk.this.isWindowActivated()) {
                if (Tomahawk.this.isUsingInternalWindows()) {
                    try {
                        TSJInternalFrame tSJInternalFrame = Tomahawk.this.findInternalWindow(false);
                        if (tSJInternalFrame != null) {
                            tSJInternalFrame.setSelected(true);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                Tomahawk.this.setWindowActivated(true);
            }
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            if (windowEvent.getSource() == Tomahawk.this.appFrame && Tomahawk.this.hasGraphWindow() && Tomahawk.this.getGraphWindow().getDefaultTool() instanceof ExSelectTool && ((ExSelectTool)Tomahawk.this.getGraphWindow().getDefaultTool()).getActiveMenu() == null) {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                menuSelectionManager.clearSelectedPath();
            }
        }

        public void windowIconified(WindowEvent windowEvent) {
            if (Tomahawk.this.hasGraphWindow()) {
                Tomahawk.this.getGraphWindow().cancelAction();
            }
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            if (Tomahawk.this.hasGraphWindow()) {
                Tomahawk.this.getGraphWindow().cancelAction();
            }
        }
    }

    class MDIDnDListener
    implements DropTargetListener {
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dropTargetDropEvent.acceptDrop(0x40000003);
                try {
                    Object object = dropTargetDropEvent.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    if (object == null) {
                        throw new NullPointerException();
                    }
                    if (object instanceof List) {
                        Object object2;
                        Object object3 = (List)object;
                        if (!Tomahawk.getInstance().isUsingMultipleWindows()) {
                            object2 = new Vector();
                            object2.add(object3.get(0));
                            object3 = object2;
                        }
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            String string = object2.next().toString();
                            Tomahawk.getInstance().onLoadGraph(string);
                        }
                    }
                    dropTargetDropEvent.dropComplete(true);
                }
                catch (Exception exception) {
                    dropTargetDropEvent.dropComplete(false);
                }
            }
        }
    }

    class TSJInternalFrame
    extends JInternalFrame
    implements VetoableChangeListener {
        public TSJInternalFrame(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            super(string, bl, bl2, bl3, bl4);
            TSELocalization.setComponentOrientation((Component)this);
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            boolean bl;
            boolean bl2;
            if (propertyChangeEvent.getPropertyName().equals("closed") && (bl2 = ((Boolean)propertyChangeEvent.getOldValue()).booleanValue()) != (bl = ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) && bl && !Tomahawk.this.saveConfirm()) {
                throw new PropertyVetoException("Not allowed", propertyChangeEvent);
            }
        }

        public void dispose() {
            switch (this.getDefaultCloseOperation()) {
                case 2: {
                    super.dispose();
                }
            }
        }

        public void setClosed(boolean bl) {
            switch (this.getDefaultCloseOperation()) {
                case 1: {
                    try {
                        super.setClosed(bl);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
                case 2: {
                    try {
                        super.setClosed(bl);
                        this.dispose();
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
                case 0: {
                    try {
                        if (this.isIcon()) {
                            this.setIcon(false);
                        }
                        this.toFront();
                        this.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                    Tomahawk.this.onCloseGraph();
                }
            }
            this.repaint();
        }

        public ExGraphWindow getGraphWindow() {
            Container container = this.getRootPane().getContentPane();
            ExGraphWindow exGraphWindow = null;
            if (container.getComponentCount() > 0 && container.getComponent(0) instanceof ExGraphWindow) {
                exGraphWindow = (ExGraphWindow)((Object)container.getComponent(0));
            }
            return exGraphWindow;
        }
    }
}

