/*
 * Decompiled with CFR 0.152.
 */
package editor.command;

import com.tomsawyer.drawing.TSSolidGeometricObject;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEGrid;
import com.tomsawyer.util.command.TSCommand;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ExSnapToGridCommand
extends TSCommand {
    TSEGraphWindow graphWindow;
    Vector centers;
    Vector objects;

    public ExSnapToGridCommand(TSEGraphWindow tSEGraphWindow) {
        this.graphWindow = tSEGraphWindow;
        this.objects = new Vector();
        this.centers = new Vector();
        this.addToLists(tSEGraphWindow.getGraphManager().selectedNodes());
        this.addToLists(tSEGraphWindow.getGraphManager().selectedConnectors());
        this.addToLists(tSEGraphWindow.getGraphManager().selectedPathNodes(true));
        this.addToLists(tSEGraphWindow.getGraphManager().selectedNodeLabels());
        this.addToLists(tSEGraphWindow.getGraphManager().selectedConnectorLabels());
        this.addToLists(tSEGraphWindow.getGraphManager().selectedEdgeLabels(true));
        Vector vector = new Vector();
        Iterator iterator = tSEGraphWindow.getGraph().selectedEdges().iterator();
        while (iterator.hasNext()) {
            TSEEdge tSEEdge = (TSEEdge)iterator.next();
            Iterator iterator2 = tSEEdge.bendIterator();
            while (iterator2.hasNext()) {
                vector.add(iterator2.next());
            }
        }
        this.addToLists(vector);
    }

    private void addToLists(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSSolidGeometricObject tSSolidGeometricObject = (TSSolidGeometricObject)iterator.next();
            this.objects.add(tSSolidGeometricObject);
            this.centers.add(tSSolidGeometricObject.getCenter());
        }
    }

    protected void doAction() throws Throwable {
        TSEGrid tSEGrid = this.graphWindow.getGrid();
        if (tSEGrid == null || this.objects == null) {
            return;
        }
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            TSSolidGeometricObject tSSolidGeometricObject = (TSSolidGeometricObject)iterator.next();
            tSSolidGeometricObject.setCenter(tSEGrid.getNearestGridPoint(tSSolidGeometricObject.getCenter()));
        }
    }

    protected void undoAction() throws Throwable {
        if (this.objects == null || this.centers == null) {
            return;
        }
        Iterator iterator = this.objects.iterator();
        Iterator iterator2 = this.centers.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            TSSolidGeometricObject tSSolidGeometricObject = (TSSolidGeometricObject)iterator.next();
            TSConstPoint tSConstPoint = (TSConstPoint)iterator2.next();
            tSSolidGeometricObject.setCenter(tSConstPoint);
        }
    }

    public boolean isCoalesced() {
        return true;
    }
}

