/*
 * Decompiled with CFR 0.152.
 */
package editor.tool;

import com.tomsawyer.diagramming.TSMoveControl;
import com.tomsawyer.drawing.TSConnectorLabel;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSEdgeLabel;
import com.tomsawyer.drawing.TSNodeLabel;
import com.tomsawyer.drawing.TSPNode;
import com.tomsawyer.drawing.TSSolidGeometricObject;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEWindowTool;
import com.tomsawyer.editor.command.TSEMoveGroupCommand;
import com.tomsawyer.util.command.TSCommand;
import java.util.Iterator;

public class ExMoveSelectedKeyAdapter
extends TSEWindowTool {
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    public static final int MOVING = 10;
    public static final int DONE = 20;
    TSMoveControl moveControl;
    TSConstPoint startPoint;
    TSPoint endPoint;
    double xStep;
    double yStep;
    int state;
    int lastMove;
    TSPoint lastExtremePoint;

    public ExMoveSelectedKeyAdapter(TSEGraphWindow tSEGraphWindow) {
        this.setGraphWindow(tSEGraphWindow);
        this.state = 20;
        this.setXStep(this.getDefaultXStep());
        this.setYStep(this.getDefaultYStep());
    }

    public void initMove() {
        this.moveControl = new TSMoveControl();
        TSEGraphManager tSEGraphManager = this.getGraphWindow().getGraphManager();
        this.moveControl.init(tSEGraphManager.graphs(false), tSEGraphManager.selectedNodes(), tSEGraphManager.selectedPathNodes(true), tSEGraphManager.selectedEdgeLabels(true), tSEGraphManager.selectedNodeLabels(), tSEGraphManager.selectedConnectorLabels());
        TSDNode tSDNode = (TSDNode)this.getGraphWindow().getGraph().nodes().get(0);
        this.startPoint = new TSConstPoint(tSDNode.getCenterX(), tSDNode.getCenterY());
        this.endPoint = new TSPoint(this.startPoint);
        this.moveControl.onStartAt(this.startPoint.getX(), this.startPoint.getY());
        this.lastMove = 0;
        this.lastExtremePoint = new TSPoint();
    }

    public void move(int n) {
        if (this.state == 20 && this.getGraphWindow().getGraphManager().hasSelected(true)) {
            this.initMove();
            this.state = 10;
        } else if (!this.getGraphWindow().getGraphManager().hasSelected(true)) {
            return;
        }
        double d = this.endPoint.getX();
        double d2 = this.endPoint.getY();
        if (n == 1) {
            d2 = this.getAlignedWorldY(1);
        } else if (n == 2) {
            d2 = this.getAlignedWorldY(2);
        } else if (n == 3) {
            d = this.getAlignedWorldX(3);
        } else if (n == 4) {
            d = this.getAlignedWorldX(4);
        }
        this.updateGraphInvalidRegions();
        this.moveControl.onDragTo(d, d2);
        this.moveControl.updateGraphsBounds();
        this.updateGraphInvalidRegions();
        if (!this.updateVisibleArea(n, true)) {
            this.getGraphWindow().updateInvalidRegion(true);
        }
    }

    public void finalizeTool() {
        if (this.state == 10) {
            this.moveControl.onCancel();
            this.state = 20;
            this.commitMoving();
            this.lastMove = 0;
            this.lastExtremePoint = null;
        }
    }

    public int getState() {
        return this.state;
    }

    void updateGraphInvalidRegions() {
        TSEEdge tSEEdge;
        this.getGraphWindow().addInvalidRegion(this.moveControl.draggedEdges());
        Iterator iterator = this.moveControl.draggedEdges().iterator();
        while (iterator.hasNext()) {
            tSEEdge = (TSEEdge)iterator.next();
            this.getGraphWindow().addInvalidRegion(tSEEdge.labels());
        }
        this.getGraphWindow().addInvalidRegion(this.moveControl.draggedNodes());
        iterator = this.moveControl.draggedNodes().iterator();
        while (iterator.hasNext()) {
            tSEEdge = (TSENode)iterator.next();
            this.getGraphWindow().addInvalidRegion(tSEEdge.labels());
        }
        iterator = this.moveControl.draggedNodes().iterator();
        while (iterator.hasNext()) {
            tSEEdge = (TSENode)iterator.next();
            Iterator iterator2 = tSEEdge.connectors().iterator();
            while (iterator2.hasNext()) {
                TSEConnector tSEConnector = (TSEConnector)iterator2.next();
                this.getGraphWindow().addInvalidRegion(tSEConnector.labels());
            }
        }
        this.getGraphWindow().addInvalidRegion(this.moveControl.draggedEdgeLabels());
        this.getGraphWindow().addInvalidRegion(this.moveControl.draggedNodeLabels());
        this.getGraphWindow().addInvalidRegion(this.moveControl.draggedConnectorLabels());
        this.getGraphWindow().addInvalidRegion(this.moveControl.draggedPathNodes());
    }

    public double getXStep() {
        return this.xStep;
    }

    public void setXStep(double d) {
        this.xStep = d;
    }

    public double getDefaultXStep() {
        return 1.0;
    }

    public double getYStep() {
        return this.yStep;
    }

    public void setYStep(double d) {
        this.yStep = d;
    }

    public double getDefaultYStep() {
        return 1.0;
    }

    public double getNonalignedWorldX(int n) {
        if (n == 3) {
            this.endPoint.setX(this.endPoint.getX() - this.getXStep());
        } else if (n == 4) {
            this.endPoint.setX(this.endPoint.getX() + this.getXStep());
        }
        return this.endPoint.getX();
    }

    public double getNonalignedWorldY(int n) {
        if (n == 1) {
            this.endPoint.setY(this.endPoint.getY() + this.getYStep());
        } else if (n == 2) {
            this.endPoint.setY(this.endPoint.getY() - this.getYStep());
        }
        return this.endPoint.getY();
    }

    public double getAlignedWorldX(int n) {
        double d = this.getNonalignedWorldX(n);
        if (this.getGraphWindow().hasGrid()) {
            if (n == 3) {
                this.endPoint.setX(this.getGraphWindow().getGrid().getLeftNearestGridX(d));
                d = this.endPoint.getX();
            } else if (n == 4) {
                this.endPoint.setX(this.getGraphWindow().getGrid().getRightNearestGridX(d));
                d = this.endPoint.getX();
            }
        }
        return d;
    }

    public double getAlignedWorldY(int n) {
        double d = this.getNonalignedWorldY(n);
        if (this.getGraphWindow().hasGrid()) {
            if (n == 1) {
                this.endPoint.setY(this.getGraphWindow().getGrid().getUpperNearestGridY(d));
                d = this.endPoint.getY();
            } else if (n == 2) {
                this.endPoint.setY(this.getGraphWindow().getGrid().getLowerNearestGridY(d));
                d = this.endPoint.getY();
            }
        }
        return d;
    }

    public boolean updateVisibleArea(int n, boolean bl) {
        TSConstPoint tSConstPoint = this.getExtremePoint(n);
        return super.updateVisibleArea(tSConstPoint, bl);
    }

    /*
     * Unable to fully structure code
     */
    public TSConstPoint getExtremePoint(int var1_1) {
        if (this.lastMove != 0 && this.lastMove == var1_1 && this.lastExtremePoint != null) {
            return this.lastExtremePoint;
        }
        var2_2 = null;
        if (var1_1 == 1) ** GOTO lbl-1000
        if (var1_1 == 4) lbl-1000:
        // 2 sources

        {
            var3_3 = -Infinity;
        } else {
            var3_3 = Infinity;
        }
        var5_4 = this.getGraphWindow().getGraphManager();
        var6_5 = var5_4.selectedNodes().iterator();
        while (var6_5.hasNext()) {
            var7_6 = (TSDNode)var6_5.next();
            var3_3 = this.adjustExtremeValue((TSSolidGeometricObject)var7_6, var1_1, var3_3);
        }
        var6_5 = var5_4.selectedPathNodes(true).iterator();
        while (var6_5.hasNext()) {
            var7_6 = (TSPNode)var6_5.next();
            var3_3 = this.adjustExtremeValue((TSSolidGeometricObject)var7_6, var1_1, var3_3);
        }
        var6_5 = var5_4.selectedEdgeLabels(true).iterator();
        while (var6_5.hasNext()) {
            var7_6 = (TSEdgeLabel)var6_5.next();
            var3_3 = this.adjustExtremeValue((TSSolidGeometricObject)var7_6, var1_1, var3_3);
        }
        var6_5 = var5_4.selectedNodeLabels().iterator();
        while (var6_5.hasNext()) {
            var7_6 = (TSNodeLabel)var6_5.next();
            var3_3 = this.adjustExtremeValue((TSSolidGeometricObject)var7_6, var1_1, var3_3);
        }
        var6_5 = var5_4.selectedConnectorLabels().iterator();
        while (var6_5.hasNext()) {
            var7_6 = (TSConnectorLabel)var6_5.next();
            var3_3 = this.adjustExtremeValue((TSSolidGeometricObject)var7_6, var1_1, var3_3);
        }
        return this.lastExtremePoint;
    }

    double adjustExtremeValue(TSSolidGeometricObject tSSolidGeometricObject, int n, double d) {
        if (n == 1) {
            if (tSSolidGeometricObject.getTop() > d) {
                this.lastExtremePoint.setLocation(tSSolidGeometricObject.getCenterX(), tSSolidGeometricObject.getTop());
                return tSSolidGeometricObject.getTop();
            }
        } else if (n == 2) {
            if (tSSolidGeometricObject.getBottom() < d) {
                this.lastExtremePoint.setLocation(tSSolidGeometricObject.getCenterX(), tSSolidGeometricObject.getBottom());
                return tSSolidGeometricObject.getBottom();
            }
        } else if (n == 3) {
            if (tSSolidGeometricObject.getLeft() < d) {
                this.lastExtremePoint.setLocation(tSSolidGeometricObject.getLeft(), tSSolidGeometricObject.getCenterY());
                return tSSolidGeometricObject.getLeft();
            }
        } else if (n == 4 && tSSolidGeometricObject.getRight() > d) {
            this.lastExtremePoint.setLocation(tSSolidGeometricObject.getRight(), tSSolidGeometricObject.getCenterY());
            return tSSolidGeometricObject.getRight();
        }
        return d;
    }

    public void commitMoving() {
        TSEGraphManager tSEGraphManager = this.getGraphWindow().getGraphManager();
        this.getGraphWindow().transmit((TSCommand)new TSEMoveGroupCommand(tSEGraphManager.graphs(false), tSEGraphManager.selectedNodes(), tSEGraphManager.selectedPathNodes(true), tSEGraphManager.selectedEdgeLabels(true), tSEGraphManager.selectedNodeLabels(), tSEGraphManager.selectedConnectorLabels(), this.startPoint, (TSConstPoint)this.endPoint));
    }
}

