/*
 * Decompiled with CFR 0.152.
 */
package editor.tool;

import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDLicenseManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.command.TSSetTagCommand;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEConnector;
import com.tomsawyer.editor.TSEConnectorLabel;
import com.tomsawyer.editor.TSEEdge;
import com.tomsawyer.editor.TSEEdgeLabel;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEHitTesting;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSENodeLabel;
import com.tomsawyer.editor.TSEObject;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEPNode;
import com.tomsawyer.editor.TSESolidObject;
import com.tomsawyer.editor.TSEWindowTool;
import com.tomsawyer.editor.command.TSEAddChildGraphCommand;
import com.tomsawyer.editor.command.TSEDeleteChildGraphCommand;
import com.tomsawyer.editor.command.TSEDeleteConnectorCommand;
import com.tomsawyer.editor.command.TSEViewRootGraphCommand;
import com.tomsawyer.editor.complexity.TSEHidingManager;
import com.tomsawyer.editor.complexity.command.TSECollapseCommand;
import com.tomsawyer.editor.complexity.command.TSEExpandCommand;
import com.tomsawyer.editor.complexity.command.TSEFoldCommand;
import com.tomsawyer.editor.complexity.command.TSEHideCommand;
import com.tomsawyer.editor.complexity.command.TSEUnfoldCommand;
import com.tomsawyer.editor.complexity.command.TSEUnhideCommand;
import com.tomsawyer.editor.tool.TSEEditTextTool;
import com.tomsawyer.editor.tool.TSESelectTool;
import com.tomsawyer.editor.ui.TSELabelUI;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.util.TSLicenseRuntimeException;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.util.command.TSGroupCommand;
import editor.Tomahawk;
import editor.ui.ExCompositeNodeUI;
import editor.ui.ExCompositeUIEditor;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;

public class ExSelectTool
extends TSESelectTool
implements ActionListener {
    protected static final int PARENTS = 1;
    protected static final int CHILDREN = 2;
    protected static final int NEIGHBORS = 3;
    static PopupMenuController popupMenuController;
    static Hashtable menus;
    TSEGraph hitGraph;
    TSEObject hitObject;
    TSConstPoint hitPosition;
    Point clickPoint;
    String activeMenuName;
    TSENode draggedNode;
    boolean previewDraggedNode;
    boolean isPopupMenuListening;
    static /* synthetic */ Class class$java$lang$String;

    public ExSelectTool() {
        popupMenuController = this.getPopupMenuController();
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupTriggered(mouseEvent);
        } else {
            TSEHitTesting tSEHitTesting = this.getHitTesting();
            TSConstPoint tSConstPoint = this.getNonalignedWorldPoint(mouseEvent);
            TSEObject tSEObject = tSEHitTesting.getGraphObjectAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
            TSENode tSENode = null;
            TSENodeUI tSENodeUI = null;
            if (tSEObject instanceof TSENode) {
                tSENode = (TSENode)tSEObject;
                tSENodeUI = tSENode.getNodeUI();
            }
            if (!(mouseEvent.getClickCount() != 2 || tSENode == null || !tSENode.isFolderNode() || tSENodeUI == null || tSENodeUI.hasHideMark() && tSENodeUI.getHideMarkBounds().contains(tSConstPoint))) {
                this.hitObject = tSENode;
                this.onUnfold();
            } else {
                super.onMousePressed(mouseEvent);
            }
        }
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupTriggered(mouseEvent);
        } else {
            super.onMouseReleased(mouseEvent);
        }
    }

    public void popupTriggered(MouseEvent mouseEvent) {
        TSESolidObject tSESolidObject;
        this.getGraphWindow().cancelAction();
        this.clickPoint = mouseEvent.getPoint();
        SwingUtilities.convertPointToScreen(this.clickPoint, mouseEvent.getComponent());
        TSConstPoint tSConstPoint = this.getNonalignedWorldPoint(mouseEvent);
        TSEHitTesting tSEHitTesting = this.getHitTesting();
        TSEObject tSEObject = tSEHitTesting.getGraphObjectAt(tSConstPoint, this.getGraph(), this.getGraphWindow().isNestedGraphEditingEnabled());
        this.hitGraph = this.getGraphWindow().isNestedGraphEditingEnabled() ? tSEHitTesting.getGraphAt(tSConstPoint, this.getGraph()) : this.getGraph();
        if (tSEObject != null) {
            this.hitGraph = (TSEGraph)tSEObject.getOwnerGraph();
        }
        if (tSEObject == null && (tSESolidObject = tSEHitTesting.getOwnerOfGrappleAt(tSConstPoint, this.getGraph(), true)) != null && tSESolidObject.isSelected()) {
            tSEObject = tSESolidObject;
        }
        if (tSEObject == null && this.hitGraph != this.getGraph() && (tSESolidObject = (TSENode)this.hitGraph.getParent()).intersectsNodeFrame(tSConstPoint)) {
            tSEObject = tSESolidObject;
        }
        this.hitGraph.setSelected(true);
        if (tSEObject == null) {
            this.hitObject = null;
            this.showPopup("GRAPH_POPUP", mouseEvent.getPoint());
        } else {
            if (!tSEObject.isSelected()) {
                if (!mouseEvent.isControlDown()) {
                    this.getGraphWindow().deselectAll(false);
                }
                this.getGraphWindow().selectObject(tSEObject, true);
            }
            this.hitPosition = tSConstPoint;
            if (tSEObject instanceof TSENode) {
                this.hitObject = tSEObject;
                this.showPopup("NODE_POPUP", mouseEvent.getPoint());
            } else if (tSEObject instanceof TSEConnector) {
                this.hitObject = tSEObject;
                this.showPopup("CONNECTOR_POPUP", mouseEvent.getPoint());
            } else if (tSEObject instanceof TSEEdge) {
                this.hitObject = tSEObject;
                this.showPopup("EDGE_POPUP", mouseEvent.getPoint());
            } else if (tSEObject instanceof TSEEdgeLabel) {
                this.hitObject = tSEObject;
                this.showPopup("EDGE_LABEL_POPUP", mouseEvent.getPoint());
            } else if (tSEObject instanceof TSENodeLabel) {
                this.hitObject = tSEObject;
                this.showPopup("NODE_LABEL_POPUP", mouseEvent.getPoint());
            } else if (tSEObject instanceof TSEConnectorLabel) {
                this.hitObject = tSEObject;
                this.showPopup("CONNECTOR_LABEL_POPUP", mouseEvent.getPoint());
            } else if (tSEObject instanceof TSEPNode) {
                this.hitObject = tSEObject;
                this.showPopup("BEND_POPUP", mouseEvent.getPoint());
            }
        }
    }

    public void resetTool() {
        JPopupMenu jPopupMenu;
        this.hitObject = null;
        if (this.getActiveMenu() != null) {
            jPopupMenu = (JPopupMenu)menus.get(this.getActiveMenu());
            this.hidePopupMenu(jPopupMenu);
            this.setActiveMenu(null);
            jPopupMenu.setInvoker(null);
        }
        if ((jPopupMenu = (JPopupMenu)menus.get("NODE_POPUP")).getInvoker() == this.getGraphWindow()) {
            jPopupMenu.setInvoker(null);
        }
        if ((jPopupMenu = (JPopupMenu)menus.get("CONNECTOR_POPUP")).getInvoker() == this.getGraphWindow()) {
            jPopupMenu.setInvoker(null);
        }
        if ((jPopupMenu = (JPopupMenu)menus.get("EDGE_POPUP")).getInvoker() == this.getGraphWindow()) {
            jPopupMenu.setInvoker(null);
        }
        if ((jPopupMenu = (JPopupMenu)menus.get("EDGE_LABEL_POPUP")).getInvoker() == this.getGraphWindow()) {
            jPopupMenu.setInvoker(null);
        }
        if ((jPopupMenu = (JPopupMenu)menus.get("NODE_LABEL_POPUP")).getInvoker() == this.getGraphWindow()) {
            jPopupMenu.setInvoker(null);
        }
        if ((jPopupMenu = (JPopupMenu)menus.get("CONNECTOR_LABEL_POPUP")).getInvoker() == this.getGraphWindow()) {
            jPopupMenu.setInvoker(null);
        }
        if ((jPopupMenu = (JPopupMenu)menus.get("BEND_POPUP")).getInvoker() == this.getGraphWindow()) {
            jPopupMenu.setInvoker(null);
        }
        if ((jPopupMenu = (JPopupMenu)menus.get("GRAPH_POPUP")).getInvoker() == this.getGraphWindow()) {
            jPopupMenu.setInvoker(null);
        }
        if ((jPopupMenu = (JPopupMenu)menus.get("TAB_POPUP")).getInvoker() == this.getGraphWindow()) {
            jPopupMenu.setInvoker(null);
        }
        Tomahawk.getInstance().showWindowStatus(Tomahawk.getResources().getStringResource("tools.select.status"));
        Tomahawk.getInstance().correlateButtonSelection("SELECT_TOOL", true);
        super.resetTool();
    }

    public void showPopup(String string, Point point) {
        JPopupMenu jPopupMenu = (JPopupMenu)menus.get(string);
        if (jPopupMenu != null) {
            this.setPopupState(jPopupMenu);
            jPopupMenu.show((Component)this.getGraphWindow(), point.x, point.y);
        }
        this.setActiveMenu(string);
        if (Tomahawk.getInstance().isUsingInternalWindows()) {
            try {
                Tomahawk.getInstance().getFrameForGraphWindow(this.getGraphWindow()).setSelected(true);
                Tomahawk.getInstance().onGraphWindowChanged();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void hidePopupMenu(JPopupMenu jPopupMenu) {
        MenuElement[] menuElementArray = jPopupMenu.getSubElements();
        jPopupMenu.setVisible(false);
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (!(menuElementArray[i] instanceof JMenu)) continue;
            this.hidePopupMenu(((JMenu)menuElementArray[i]).getPopupMenu());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (Tomahawk.getInstance().getGraphWindow() != this.getGraphWindow()) {
            return;
        }
        String string = actionEvent.getActionCommand();
        if (string.startsWith("ADD_EDGE_LABEL")) {
            this.onAddEdgeLabel(string);
        } else if (string.startsWith("ADD_NODE_LABEL")) {
            this.onAddNodeLabel(string);
        } else if ("ADD_NODE_CONNECTOR".equals(string)) {
            this.onAddConnector();
        } else if ("DELETE_NODE_CONNECTORS".equals(string)) {
            this.onDeleteAllConnectors();
        } else if (string.startsWith("ADD_CONNECTOR_LABEL")) {
            this.onAddConnectorLabel(string);
        } else if ("OPEN_URL".equals(string)) {
            this.onOpenURL();
        } else if ("CREATE_CHILD_GRAPH".equals(string)) {
            this.onCreateChildGraph();
        } else if ("DELETE_CHILD_GRAPH".equals(string)) {
            this.onDeleteChildGraph();
        } else if ("EDIT_TEXT".equals(string)) {
            this.onEditText();
        } else if ("GOTO_CHILD".equals(string)) {
            this.onGoToChildGraph();
        } else if ("GOTO_PARENT".equals(string)) {
            this.onGoToParentGraph();
        } else if ("GOTO_ROOT".equals(string)) {
            this.onGoToRootGraph();
        } else if ("EXPAND".equals(string)) {
            this.onExpand();
        } else if ("COLLAPSE".equals(string)) {
            this.onCollapse();
        } else if ("INSPECTOR_WINDOW".equals(string)) {
            if (this.clickPoint != null) {
                Tomahawk.getInstance().showInspectorWindow(this.clickPoint.x, this.clickPoint.y);
            }
        } else if ("LAYOUT_PROPERTIES".equals(string)) {
            Tomahawk.getInstance().showLayoutProperties();
        } else if ("HIDE_CHILDREN_ONE_LEVEL".equals(string)) {
            this.onHideOneLevel(2);
        } else if ("HIDE_CHILDREN_N_LEVEL".equals(string)) {
            this.onHideNLevel(2, "Number of Children Levels to Hide");
        } else if ("HIDE_CHILDREN_ALL_LEVEL".equals(string)) {
            this.onHideAllLevel(2);
        } else if ("HIDE_PARENTS_ONE_LEVEL".equals(string)) {
            this.onHideOneLevel(1);
        } else if ("HIDE_PARENTS_N_LEVEL".equals(string)) {
            this.onHideNLevel(1, "Number of Parent Levels to Hide");
        } else if ("HIDE_PARENTS_ALL_LEVEL".equals(string)) {
            this.onHideAllLevel(1);
        } else if ("HIDE_NEIGHBORS_ONE_LEVEL".equals(string)) {
            this.onHideOneLevel(3);
        } else if ("HIDE_NEIGHBORS_N_LEVEL".equals(string)) {
            this.onHideNLevel(3, "Number of Neighbor Levels to Hide");
        } else if ("HIDE_NEIGHBORS_ALL_LEVEL".equals(string)) {
            this.onHideAllLevel(3);
        } else if ("HIDE_INCIDENT_EDGES".equals(string)) {
            this.onHideIncidentEdges();
        } else if ("UNHIDE_CHILDREN_ONE_LEVEL".equals(string)) {
            this.onUnhideOneLevel(2);
        } else if ("UNHIDE_CHILDREN_N_LEVEL".equals(string)) {
            this.onUnhideNLevel(2, "Number of Children Levels to Unhide");
        } else if ("UNHIDE_CHILDREN_ALL_LEVEL".equals(string)) {
            this.onUnhideAllLevel(2);
        } else if ("UNHIDE_PARENTS_ONE_LEVEL".equals(string)) {
            this.onUnhideOneLevel(1);
        } else if ("UNHIDE_PARENTS_N_LEVEL".equals(string)) {
            this.onUnhideNLevel(1, "Number of Parent Levels to Unhide");
        } else if ("UNHIDE_PARENTS_ALL_LEVEL".equals(string)) {
            this.onUnhideAllLevel(1);
        } else if ("UNHIDE_NEIGHBORS_ONE_LEVEL".equals(string)) {
            this.onUnhideOneLevel(3);
        } else if ("UNHIDE_NEIGHBORS_N_LEVEL".equals(string)) {
            this.onUnhideNLevel(3, "Number of Neighbor Levels to Unhide");
        } else if ("UNHIDE_NEIGHBORS_ALL_LEVEL".equals(string)) {
            this.onUnhideAllLevel(3);
        } else if ("UNHIDE_INCIDENT_EDGES".equals(string)) {
            this.onUnhideIncidentEdges();
        } else if ("FOLD_CHILDREN_ONE_LEVEL".equals(string)) {
            this.onFoldOneLevel(2);
        } else if ("FOLD_CHILDREN_N_LEVEL".equals(string)) {
            this.onFoldNLevel(2, "Number of Children Levels to Fold");
        } else if ("FOLD_CHILDREN_ALL_LEVEL".equals(string)) {
            this.onFoldAllLevel(2);
        } else if ("FOLD_PARENTS_ONE_LEVEL".equals(string)) {
            this.onFoldOneLevel(1);
        } else if ("FOLD_PARENTS_N_LEVEL".equals(string)) {
            this.onFoldNLevel(1, "Number of Parent Levels to Fold");
        } else if ("FOLD_PARENTS_ALL_LEVEL".equals(string)) {
            this.onFoldAllLevel(1);
        } else if ("FOLD_NEIGHBORS_ONE_LEVEL".equals(string)) {
            this.onFoldOneLevel(3);
        } else if ("FOLD_NEIGHBORS_N_LEVEL".equals(string)) {
            this.onFoldNLevel(3, "Number of Neighbor Levels to Fold");
        } else if ("FOLD_NEIGHBORS_ALL_LEVEL".equals(string)) {
            this.onFoldAllLevel(3);
        } else if ("UNFOLD".equals(string)) {
            this.onUnfold();
        } else {
            Tomahawk.getActions().actionPerformed(actionEvent);
        }
    }

    public void setPopupState(JPopupMenu jPopupMenu) {
        for (int i = jPopupMenu.getComponentCount() - 1; i >= 0; --i) {
            Component component = jPopupMenu.getComponent(i);
            if (component instanceof JMenu) {
                this.setMenuState((JMenu)component);
                continue;
            }
            if (!(component instanceof JMenuItem)) continue;
            this.chooseState((JMenuItem)component);
        }
    }

    public void setMenuState(JMenu jMenu) {
        for (int i = jMenu.getMenuComponentCount() - 1; i >= 0; --i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null) continue;
            if (jMenuItem != jMenu && jMenuItem instanceof JMenu) {
                this.setMenuState((JMenu)jMenuItem);
                continue;
            }
            this.chooseState(jMenuItem);
        }
    }

    public void chooseState(AbstractButton abstractButton) {
        String string = abstractButton.getActionCommand();
        TSEHidingManager tSEHidingManager = (TSEHidingManager)TSEHidingManager.getManager((TSDGraphManager)this.getGraphWindow().getGraphManager());
        if ("CREATE_CHILD_GRAPH".equals(string)) {
            TSGraphMember tSGraphMember = (TSGraphMember)this.hitObject;
            if (tSGraphMember instanceof TSENode) {
                abstractButton.setEnabled(!tSGraphMember.hasChildGraph());
            } else if (tSGraphMember instanceof TSEEdge) {
                abstractButton.setEnabled(!tSGraphMember.hasChildGraph() && !((TSEEdge)tSGraphMember).isMetaEdge());
            }
        } else if ("DELETE_CHILD_GRAPH".equals(string) || "GOTO_CHILD".equals(string)) {
            TSGraphMember tSGraphMember = (TSGraphMember)this.hitObject;
            if (tSGraphMember instanceof TSENode) {
                abstractButton.setEnabled(tSGraphMember.hasChildGraph() && (!((TSENode)tSGraphMember).isFolderNode() || !"DELETE_CHILD_GRAPH".equals(string)));
            } else if (tSGraphMember instanceof TSEEdge) {
                abstractButton.setEnabled(tSGraphMember.hasChildGraph() && !((TSEEdge)tSGraphMember).isMetaEdge());
            } else if (tSGraphMember == null) {
                abstractButton.setEnabled(this.hitGraph.isChildGraph() && !this.hitGraph.isMainDisplayGraph());
            }
        } else if ("GOTO_PARENT".equals(string)) {
            abstractButton.setEnabled(this.getGraph().isOwned() && this.getGraph().getParent() != null && this.getGraph().getParent().isOwned());
        } else if ("GOTO_ROOT".equals(string)) {
            abstractButton.setEnabled(this.getGraph().isOwned() && this.getGraph().getParent() != null && this.getGraph().getParent().isOwned());
        } else if ("EXPAND".equals(string)) {
            TSGraphMember tSGraphMember = (TSGraphMember)this.hitObject;
            if (tSGraphMember instanceof TSENode) {
                TSENode tSENode = (TSENode)tSGraphMember;
                abstractButton.setEnabled(tSENode.hasChildGraph() && !tSENode.isExpanded());
            }
        } else if ("COLLAPSE".equals(string)) {
            TSGraphMember tSGraphMember = (TSGraphMember)this.hitObject;
            if (tSGraphMember instanceof TSENode) {
                TSENode tSENode = (TSENode)tSGraphMember;
                abstractButton.setEnabled(tSENode.hasChildGraph() && tSENode.isExpanded());
            } else if (tSGraphMember == null) {
                abstractButton.setEnabled(this.hitGraph.isChildGraph() && !this.hitGraph.isMainDisplayGraph());
            }
        } else if ("ADD_NODE_CONNECTOR".equals(string)) {
            TSGraphMember tSGraphMember = (TSGraphMember)this.hitObject;
            boolean bl = false;
            if (tSGraphMember instanceof TSENode) {
                TSENode tSENode = (TSENode)tSGraphMember;
                bl = true;
                Iterator iterator = tSENode.connectors().iterator();
                while (iterator.hasNext() && bl) {
                    TSEConnector tSEConnector = (TSEConnector)iterator.next();
                    if (!tSEConnector.getBounds().contains(this.hitPosition)) continue;
                    bl = false;
                }
            }
            abstractButton.setEnabled(bl);
        } else if (string.startsWith("DELETE_NODE_CONNECTORS")) {
            TSENode tSENode;
            TSEObject tSEObject = this.hitObject;
            boolean bl = false;
            if (tSEObject instanceof TSENode && (tSENode = (TSENode)tSEObject).connectors().size() > 0) {
                bl = true;
            }
            abstractButton.setEnabled(bl);
        } else if (string.startsWith("ADD_EDGE_LABEL")) {
            abstractButton.setEnabled(true);
        } else if ("HIDE_CHILDREN_ONE_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findChildren(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("HIDE_CHILDREN_N_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findChildren(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("HIDE_CHILDREN_ALL_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findChildren(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("HIDE_PARENTS_ONE_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findParents(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("HIDE_PARENTS_N_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findParents(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("HIDE_PARENTS_ALL_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findParents(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("HIDE_NEIGHBORS_ONE_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findNeighbors(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("HIDE_NEIGHBORS_N_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findNeighbors(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("HIDE_NEIGHBORS_ALL_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findNeighbors(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("HIDE_INCIDENT_EDGES".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            abstractButton.setEnabled(tSENode.inDegree() + tSENode.outDegree() > 0);
        } else if ("UNHIDE_CHILDREN_ONE_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            abstractButton.setEnabled(tSEHidingManager.hasHiddenChildren((TSDNode)tSENode));
        } else if ("UNHIDE_CHILDREN_N_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            abstractButton.setEnabled(tSEHidingManager.hasHiddenChildren((TSDNode)tSENode));
        } else if ("UNHIDE_CHILDREN_ALL_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            abstractButton.setEnabled(tSEHidingManager.hasHiddenChildren((TSDNode)tSENode));
        } else if ("UNHIDE_PARENTS_ONE_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            abstractButton.setEnabled(tSEHidingManager.hasHiddenParents((TSDNode)tSENode));
        } else if ("UNHIDE_PARENTS_N_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            abstractButton.setEnabled(tSEHidingManager.hasHiddenParents((TSDNode)tSENode));
        } else if ("UNHIDE_PARENTS_ALL_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            abstractButton.setEnabled(tSEHidingManager.hasHiddenParents((TSDNode)tSENode));
        } else if ("UNHIDE_NEIGHBORS_ONE_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            abstractButton.setEnabled(tSEHidingManager.hasHiddenNeighbors((TSDNode)tSENode));
        } else if ("UNHIDE_NEIGHBORS_N_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            abstractButton.setEnabled(tSEHidingManager.hasHiddenNeighbors((TSDNode)tSENode));
        } else if ("UNHIDE_NEIGHBORS_ALL_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            abstractButton.setEnabled(tSEHidingManager.hasHiddenNeighbors((TSDNode)tSENode));
        } else if ("UNHIDE_INCIDENT_EDGES".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            abstractButton.setEnabled(tSEHidingManager.hasHiddenIncidentEdges((TSDNode)tSENode));
        } else if ("FOLD_CHILDREN_ONE_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findChildren(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("FOLD_CHILDREN_N_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findChildren(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("FOLD_CHILDREN_ALL_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findChildren(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("FOLD_PARENTS_ONE_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findParents(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("FOLD_PARENTS_N_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findParents(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("FOLD_PARENTS_ALL_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findParents(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("FOLD_NEIGHBORS_ONE_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findNeighbors(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("FOLD_NEIGHBORS_N_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findNeighbors(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("FOLD_NEIGHBORS_ALL_LEVEL".equals(string)) {
            TSENode tSENode = (TSENode)this.hitObject;
            Vector vector = new Vector();
            tSENode.findNeighbors(vector, null, 1L);
            abstractButton.setEnabled(!vector.isEmpty());
        } else if ("UNFOLD".equals(string)) {
            abstractButton.setEnabled(this.hitObject instanceof TSENode && ((TSENode)this.hitObject).isFolderNode());
        } else if ("OPEN_URL".equals(string)) {
            if (this.hitObject != null) {
                abstractButton.setEnabled(this.hitObject.getURL() != null);
            } else {
                abstractButton.setEnabled(this.getGraph().getURL() != null);
            }
        } else {
            Tomahawk.getInstance().chooseState(abstractButton);
        }
    }

    public void onEditText() {
        String string = this.getActiveMenu();
        if (string == "NODE_POPUP" || string == "EDGE_LABEL_POPUP" || string == "NODE_LABEL_POPUP" || string == "CONNECTOR_LABEL_POPUP") {
            this.editText((TSESolidObject)this.hitObject);
        }
    }

    public void editText(TSESolidObject tSESolidObject) {
        if (!(tSESolidObject.getUI() instanceof ExCompositeNodeUI)) {
            super.editText(tSESolidObject);
        } else {
            String string = ExCompositeUIEditor.showDialog(SwingUtilities.getRootPane((Component)this.getGraphWindow()), (ExCompositeNodeUI)tSESolidObject.getUI());
            if (string != null) {
                this.getGraphWindow().transmit((TSCommand)new TSSetTagCommand((TSGraphObject)tSESolidObject, (Object)string));
            }
        }
    }

    public void onDeleteSelected() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDIT_DELETE)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            this.getGraphWindow().deleteSelected();
        }
    }

    public void onAddEdgeLabel(String string) {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDIT_ADD)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            TSELabelUI tSELabelUI;
            String string2;
            if (string.indexOf(46) > 0) {
                string2 = string.substring(string.indexOf(46) + 1);
                tSELabelUI = Tomahawk.getInstance().getLabelUI(string2);
                if (tSELabelUI == null) {
                    try {
                        String string3 = Tomahawk.getResources().getStringResource(string2 + ".class");
                        tSELabelUI = (TSELabelUI)Class.forName(string3).newInstance();
                        Tomahawk.getInstance().setUIAttributes(string2, (TSEObjectUI)tSELabelUI);
                        Tomahawk.getInstance().addLabelUI(string2, tSELabelUI);
                    }
                    catch (Exception exception) {
                        tSELabelUI = Tomahawk.getInstance().getLabelUI("labelUI.default");
                    }
                }
                if (tSELabelUI != null) {
                    Tomahawk.getInstance().getGraphWindow().setCurrentLabelUI(tSELabelUI);
                }
            }
            try {
                if (this.getActiveMenu() == "EDGE_POPUP" && (string2 = this.getGraphWindow().addEdgeLabel((TSEEdge)this.hitObject, this.hitPosition.getX(), this.hitPosition.getY(), null, null)).isOwned()) {
                    tSELabelUI = new TSEEditTextTool(this.getGraphWindow().getCurrentTool(), (TSESolidObject)string2);
                    this.getGraphWindow().getCurrentTool().setTool((TSEWindowTool)tSELabelUI);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onAddNodeLabel(String string) {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDIT_ADD)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            TSELabelUI tSELabelUI;
            String string2;
            if (string.indexOf(46) > 0) {
                string2 = string.substring(string.indexOf(46) + 1);
                tSELabelUI = Tomahawk.getInstance().getLabelUI(string2);
                if (tSELabelUI == null) {
                    try {
                        String string3 = Tomahawk.getResources().getStringResource(string2 + ".class");
                        tSELabelUI = (TSELabelUI)Class.forName(string3).newInstance();
                        Tomahawk.getInstance().setUIAttributes(string2, (TSEObjectUI)tSELabelUI);
                        Tomahawk.getInstance().addLabelUI(string2, tSELabelUI);
                    }
                    catch (Exception exception) {
                        tSELabelUI = Tomahawk.getInstance().getLabelUI("labelUI.default");
                    }
                }
                if (tSELabelUI != null) {
                    Tomahawk.getInstance().getGraphWindow().setCurrentLabelUI(tSELabelUI);
                }
            }
            try {
                if (this.getActiveMenu() == "NODE_POPUP" && (string2 = this.getGraphWindow().addNodeLabel((TSENode)this.hitObject, "bottom", 10.0, null, null)).isOwned()) {
                    tSELabelUI = new TSEEditTextTool(this.getGraphWindow().getCurrentTool(), (TSESolidObject)string2);
                    this.getGraphWindow().getCurrentTool().setTool((TSEWindowTool)tSELabelUI);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void onAddConnector() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDIT_ADD)) {
            Tomahawk.showLicenseErrorMessage();
        } else if (this.getActiveMenu() == "NODE_POPUP") {
            TSENode tSENode = (TSENode)this.hitObject;
            double d = tSENode.getCenterX() - this.hitPosition.getX();
            double d2 = tSENode.getCenterY() - this.hitPosition.getY();
            double d3 = d / (tSENode.getWidth() / 2.0);
            double d4 = d2 / (tSENode.getHeight() / 2.0);
            this.getGraphWindow().addConnector(tSENode, 5.0, 5.0, 0.0, 0.0, -0.5 * d3, -0.5 * d4, null);
        }
    }

    public void onDeleteAllConnectors() {
        TSENode tSENode;
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.EDIT_DELETE)) {
            Tomahawk.showLicenseErrorMessage();
        } else if (this.getActiveMenu() == "NODE_POPUP" && (tSENode = (TSENode)this.hitObject).connectors().size() > 0) {
            TSGroupCommand tSGroupCommand = new TSGroupCommand();
            Iterator iterator = tSENode.connectors().iterator();
            while (iterator.hasNext()) {
                TSEConnector tSEConnector = (TSEConnector)iterator.next();
                TSEDeleteConnectorCommand tSEDeleteConnectorCommand = new TSEDeleteConnectorCommand(tSEConnector);
                tSGroupCommand.add((TSCommand)tSEDeleteConnectorCommand);
            }
            this.getGraphWindow().transmit((TSCommand)tSGroupCommand);
        }
    }

    public void onOpenURL(URL uRL) {
        SystemBrowserDisplay.openURL(uRL.toExternalForm());
    }

    public void onOpenURL() {
        TSEObject tSEObject = this.hitObject;
        if (tSEObject == null && this.getActiveMenu() == "GRAPH_POPUP") {
            tSEObject = this.getGraph();
        }
        if (tSEObject != null && tSEObject.getURL() != null) {
            this.onOpenURL(tSEObject.getURL());
        }
    }

    public void onAddConnectorLabel(String string) {
        TSELabelUI tSELabelUI;
        String string2;
        if (string.indexOf(46) > 0) {
            string2 = string.substring(string.indexOf(46) + 1);
            tSELabelUI = Tomahawk.getInstance().getLabelUI(string2);
            if (tSELabelUI == null) {
                try {
                    String string3 = Tomahawk.getResources().getStringResource(string2 + ".class");
                    tSELabelUI = (TSELabelUI)Class.forName(string3).newInstance();
                    Tomahawk.getInstance().setUIAttributes(string2, (TSEObjectUI)tSELabelUI);
                    Tomahawk.getInstance().addLabelUI(string2, tSELabelUI);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    tSELabelUI = Tomahawk.getInstance().getLabelUI("labelUI.default");
                }
            }
            if (tSELabelUI != null) {
                Tomahawk.getInstance().getGraphWindow().setCurrentLabelUI(tSELabelUI);
            }
        }
        if (this.getActiveMenu() == "CONNECTOR_POPUP" && (string2 = this.getGraphWindow().addConnectorLabel((TSEConnector)this.hitObject, "bottom", 10.0, null, null)).isOwned()) {
            tSELabelUI = new TSEEditTextTool(this.getGraphWindow().getCurrentTool(), (TSESolidObject)string2);
            this.getGraphWindow().getCurrentTool().setTool((TSEWindowTool)tSELabelUI);
        }
    }

    public void onExpand() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.NESTING)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            TSEExpandCommand tSEExpandCommand = new TSEExpandCommand((TSDNode)((TSENode)this.hitObject));
            this.getGraphWindow().transmit((TSCommand)tSEExpandCommand);
        }
    }

    public void onCollapse() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.NESTING)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            TSECollapseCommand tSECollapseCommand = null;
            tSECollapseCommand = this.hitObject != null ? new TSECollapseCommand((TSDNode)((TSENode)this.hitObject)) : new TSECollapseCommand((TSDNode)((TSENode)this.hitGraph.getParent()));
            this.getGraphWindow().transmit((TSCommand)tSECollapseCommand);
        }
    }

    public void onGoToChildGraph() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.DRILL_DOWN)) {
            Tomahawk.showLicenseErrorMessage();
        } else if (this.getActiveMenu() == "NODE_POPUP" || this.getActiveMenu() == "EDGE_POPUP") {
            TSGraphMember tSGraphMember = (TSGraphMember)this.hitObject;
            this.goToChildGraph(tSGraphMember);
            Tomahawk.getInstance().correlateButtonAbility("GOTO_PARENT", true);
        } else if (this.getActiveMenu() == "GRAPH_POPUP") {
            this.goToChildGraph(this.hitGraph.getParent());
            Tomahawk.getInstance().correlateButtonAbility("GOTO_PARENT", true);
        }
    }

    public void onGoToParentGraph() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.DRILL_DOWN)) {
            Tomahawk.showLicenseErrorMessage();
        } else if (this.getActiveMenu() == "GRAPH_POPUP") {
            this.goToParentGraph();
        }
    }

    public void onGoToRootGraph() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.DRILL_DOWN)) {
            Tomahawk.showLicenseErrorMessage();
        } else if (this.getActiveMenu() == "GRAPH_POPUP") {
            this.getGraphWindow().transmit((TSCommand)new TSEViewRootGraphCommand(this.getGraphWindow(), this.getGraph()));
        }
    }

    public void onCreateChildGraph() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.DRILL_DOWN)) {
            Tomahawk.showLicenseErrorMessage();
        } else if (this.getActiveMenu() == "NODE_POPUP" || this.getActiveMenu() == "EDGE_POPUP") {
            TSGraphMember tSGraphMember = (TSGraphMember)this.hitObject;
            TSEAddChildGraphCommand tSEAddChildGraphCommand = new TSEAddChildGraphCommand(tSGraphMember);
            this.getGraphWindow().transmit((TSCommand)tSEAddChildGraphCommand);
        }
    }

    public void onDeleteChildGraph() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.DRILL_DOWN)) {
            Tomahawk.showLicenseErrorMessage();
        } else if (this.getActiveMenu() == "NODE_POPUP" || this.getActiveMenu() == "EDGE_POPUP") {
            TSGraphMember tSGraphMember = (TSGraphMember)this.hitObject;
            TSEDeleteChildGraphCommand tSEDeleteChildGraphCommand = new TSEDeleteChildGraphCommand(tSGraphMember);
            this.getGraphWindow().transmit((TSCommand)tSEDeleteChildGraphCommand);
        }
    }

    protected void expandNode(TSENode tSENode) {
        try {
            super.expandNode(tSENode);
        }
        catch (TSLicenseRuntimeException tSLicenseRuntimeException) {
            Tomahawk.showLicenseErrorMessage();
        }
    }

    public void onHideOneLevel(int n) {
        this.hideNeighbors(n, 1);
    }

    public void onHideNLevel(int n, String string) {
        int n2 = this.getDepth("Hide Levels:", string);
        if (n2 > 0) {
            this.hideNeighbors(n, n2);
        }
    }

    public void onHideAllLevel(int n) {
        this.hideNeighbors(n, -2);
    }

    void hideNeighbors(int n, int n2) {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.HIDING)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            LinkedList linkedList = new LinkedList();
            LinkedList linkedList2 = new LinkedList();
            if (n == 2) {
                ((TSENode)this.hitObject).findChildren(linkedList, linkedList2, (long)n2);
            } else if (n == 1) {
                ((TSENode)this.hitObject).findParents(linkedList, linkedList2, (long)n2);
            } else if (n == 3) {
                ((TSENode)this.hitObject).findNeighbors(linkedList, linkedList2, (long)n2);
            }
            if (!linkedList.isEmpty() || !linkedList2.isEmpty()) {
                Cursor cursor = this.getGraphWindow().getCanvas().getCursor();
                this.getGraphWindow().getCanvas().setCursor(Cursor.getPredefinedCursor(3));
                TSEHideCommand tSEHideCommand = new TSEHideCommand(linkedList, linkedList2);
                this.getGraphWindow().transmit((TSCommand)tSEHideCommand);
                this.getCanvas().setCursor(cursor);
            }
        }
    }

    int getDepth(String string, String string2) {
        String string3 = "";
        int n = -1;
        while (n <= 0) {
            try {
                string3 = JOptionPane.showInputDialog((Component)this.getGraphWindow(), string, string2, -1);
                if (string3 == null) break;
                n = Integer.parseInt(string3);
                if (n > 0) continue;
                JOptionPane.showMessageDialog((Component)this.getGraphWindow(), "Please enter a positive integer");
            }
            catch (NumberFormatException numberFormatException) {
                if (string3 == null) {
                    n = 0;
                    continue;
                }
                JOptionPane.showMessageDialog((Component)this.getGraphWindow(), "Please enter a positive integer");
            }
        }
        return n;
    }

    public void onHideIncidentEdges() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.HIDING)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            List list = ((TSENode)this.hitObject).buildInOutEdges(1);
            if (!list.isEmpty()) {
                Cursor cursor = this.getGraphWindow().getCanvas().getCursor();
                this.getGraphWindow().getCanvas().setCursor(Cursor.getPredefinedCursor(3));
                TSEHideCommand tSEHideCommand = new TSEHideCommand(null, list);
                this.getGraphWindow().transmit((TSCommand)tSEHideCommand);
                this.getCanvas().setCursor(cursor);
            }
        }
    }

    public void onUnhideOneLevel(int n) {
        this.unhideNeighbors(n, 1);
    }

    public void onUnhideNLevel(int n, String string) {
        this.unhideNeighbors(n, this.getDepth("Unhide Levels:", string));
    }

    public void onUnhideAllLevel(int n) {
        this.unhideNeighbors(n, -2);
    }

    public void onUnhideIncidentEdges() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.HIDING)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            TSEHidingManager tSEHidingManager = (TSEHidingManager)TSEHidingManager.getManager((TSDGraphManager)this.getGraphWindow().getGraphManager());
            tSEHidingManager.findHiddenIncidentEdgeList((TSDNode)((TSENode)this.hitObject));
            TSEUnhideCommand tSEUnhideCommand = new TSEUnhideCommand(tSEHidingManager.getResultNodeList(), tSEHidingManager.getResultEdgeList());
            this.getGraphWindow().transmit((TSCommand)tSEUnhideCommand);
        }
    }

    void unhideNeighbors(int n, int n2) {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.HIDING)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            TSEHidingManager tSEHidingManager = (TSEHidingManager)TSEHidingManager.getManager((TSDGraphManager)this.getGraphWindow().getGraphManager());
            if (n == 2) {
                tSEHidingManager.findHiddenChildren((TSDNode)((TSENode)this.hitObject), (long)n2);
                tSEHidingManager.findHiddenIncidentOutgoingEdgeList((TSDNode)((TSENode)this.hitObject));
            } else if (n == 1) {
                tSEHidingManager.findHiddenParents((TSDNode)((TSENode)this.hitObject), (long)n2);
                tSEHidingManager.findHiddenIncidentIncomingEdgeList((TSDNode)((TSENode)this.hitObject));
            } else if (n == 3) {
                tSEHidingManager.findHiddenNeighbors((TSDNode)((TSENode)this.hitObject), (long)n2);
            }
            if (!tSEHidingManager.getResultNodeList().isEmpty() || !tSEHidingManager.getResultEdgeList().isEmpty()) {
                TSEUnhideCommand tSEUnhideCommand = new TSEUnhideCommand(tSEHidingManager.getResultNodeList(), tSEHidingManager.getResultEdgeList());
                this.getGraphWindow().transmit((TSCommand)tSEUnhideCommand);
            }
        }
    }

    protected void onFoldOneLevel(int n) {
        this.foldNeighbors(n, 1);
    }

    protected void onFoldNLevel(int n, String string) {
        int n2 = this.getDepth("Fold Levels:", string);
        if (n2 > 0) {
            this.foldNeighbors(n, n2);
        }
    }

    protected void onFoldAllLevel(int n) {
        this.foldNeighbors(n, -2);
    }

    void foldNeighbors(int n, int n2) {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.FOLDING)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            LinkedList linkedList = new LinkedList();
            if (n == 2) {
                ((TSENode)this.hitObject).findChildren(linkedList, null, (long)n2);
            } else if (n == 1) {
                ((TSENode)this.hitObject).findParents(linkedList, null, (long)n2);
            } else if (n == 3) {
                ((TSENode)this.hitObject).findNeighbors(linkedList, null, (long)n2);
            }
            if (!linkedList.isEmpty()) {
                TSEFoldCommand tSEFoldCommand = new TSEFoldCommand(linkedList);
                this.getGraphWindow().transmit((TSCommand)tSEFoldCommand);
            }
        }
    }

    public void onUnfold() {
        if (!TSDLicenseManager.checkLicense((String)TSDLicenseManager.FOLDING)) {
            Tomahawk.showLicenseErrorMessage();
        } else {
            TSEUnfoldCommand tSEUnfoldCommand = new TSEUnfoldCommand((TSENode)this.hitObject);
            this.getGraphWindow().transmit((TSCommand)tSEUnfoldCommand);
        }
    }

    public String getActiveMenu() {
        return this.activeMenuName;
    }

    public void setActiveMenu(String string) {
        this.activeMenuName = string;
    }

    private boolean isDragFlavorSupported(DropTargetDragEvent dropTargetDragEvent) {
        boolean bl = false;
        if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            bl = true;
        }
        return bl;
    }

    private DataFlavor chooseDropFlavor(DropTargetDropEvent dropTargetDropEvent) {
        if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return DataFlavor.javaFileListFlavor;
        }
        if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return DataFlavor.stringFlavor;
        }
        return null;
    }

    private boolean isDragOk(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragFlavorSupported(dropTargetDragEvent)) {
            return false;
        }
        int n = dropTargetDragEvent.getDropAction();
        return (n & this.getGraphWindow().getAcceptableDropActions()) != 0;
    }

    public void onDragEnter(DropTargetDragEvent dropTargetDragEvent) {
        String string;
        try {
            if (!this.isDragOk(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
                return;
            }
        }
        catch (Exception exception) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        DropTargetDropEvent dropTargetDropEvent = new DropTargetDropEvent(dropTargetDragEvent.getDropTargetContext(), dropTargetDragEvent.getLocation(), dropTargetDragEvent.getDropAction(), dropTargetDragEvent.getSourceActions());
        DataFlavor dataFlavor = this.chooseDropFlavor(dropTargetDropEvent);
        if (dataFlavor == null) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        Object object = null;
        try {
            if (System.getProperty("os.name").startsWith("Mac")) {
                throw new Exception();
            }
            object = dropTargetDropEvent.getTransferable().getTransferData(dataFlavor);
            this.previewDraggedNode = true;
        }
        catch (Exception exception) {
            this.previewDraggedNode = false;
        }
        if (object instanceof String && (string = (String)object).startsWith("nodeUI")) {
            TSENodeUI tSENodeUI = this.getUIFromString(string);
            int n = this.getTypeFromString(string);
            this.draggedNode = (TSENode)this.getGraphWindow().getGraph().addNode(n);
            this.draggedNode.setCenter(this.getGraphWindow().getWorldPoint(dropTargetDragEvent.getLocation()));
            this.draggedNode.setUI((TSEObjectUI)((TSENodeUI)tSENodeUI.clone()));
            this.draggedNode.setSelected(true);
            this.draggedNode.setDragged(true);
        }
        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
    }

    public void onDragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        if (this.draggedNode != null && this.previewDraggedNode) {
            TSEGraphWindow tSEGraphWindow = this.getGraphWindow();
            TSConstPoint tSConstPoint = this.draggedNode.getCenter();
            TSConstPoint tSConstPoint2 = tSEGraphWindow.getWorldPoint(dropTargetDragEvent.getLocation());
            TSEGraph tSEGraph = (TSEGraph)this.draggedNode.getOwner();
            if (!tSConstPoint.equals((Object)tSConstPoint2)) {
                tSEGraphWindow.addInvalidRegion(this.draggedNode.getNodeUI().getInvalidRegion());
                boolean bl = tSEGraph.isFiringEvents();
                tSEGraph.setFireEvents(false);
                this.draggedNode.setCenter(tSConstPoint2);
                tSEGraph.setFireEvents(bl);
                tSEGraphWindow.addInvalidRegion(this.draggedNode.getNodeUI().getInvalidRegion());
                tSEGraphWindow.updateInvalidRegion(true);
            }
        }
    }

    public void onDropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOk(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
    }

    public void onDragExit(DropTargetEvent dropTargetEvent) {
        if (this.previewDraggedNode) {
            if (this.draggedNode != null && this.draggedNode.isOwned()) {
                this.draggedNode.getOwnerGraph().remove((TSNode)this.draggedNode);
            }
            this.getGraphWindow().drawGraph();
            this.getGraphWindow().fastRepaint();
        }
    }

    public void onDrop(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor dataFlavor = this.chooseDropFlavor(dropTargetDropEvent);
        TSEGraphWindow tSEGraphWindow = this.getGraphWindow();
        if (dataFlavor == null) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        int n = dropTargetDropEvent.getSourceActions();
        if ((n & tSEGraphWindow.getAcceptableDropActions()) == 0) {
            dropTargetDropEvent.rejectDrop();
            return;
        }
        Object object = null;
        try {
            dropTargetDropEvent.acceptDrop(tSEGraphWindow.getAcceptableDropActions());
            object = dropTargetDropEvent.getTransferable().getTransferData(dataFlavor);
            if (object == null) {
                throw new NullPointerException();
            }
        }
        catch (Throwable throwable) {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        if (object instanceof List) {
            Iterator iterator;
            List list = (List)object;
            if (!Tomahawk.getInstance().isUsingMultipleWindows()) {
                iterator = list.get(0);
                list.clear();
                list.add(iterator);
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString();
                boolean bl = Tomahawk.getInstance().onLoadGraph(string);
                if (bl) continue;
                tSEGraphWindow.fastRepaint();
            }
        } else if (object instanceof String) {
            this.insertNode((String)object, dropTargetDropEvent.getLocation());
        } else {
            dropTargetDropEvent.dropComplete(false);
            return;
        }
        dropTargetDropEvent.dropComplete(true);
    }

    public void insertNode(String string, Point point) {
        TSEGraphWindow tSEGraphWindow = this.getGraphWindow();
        tSEGraphWindow.deselectAll(false);
        TSConstPoint tSConstPoint = tSEGraphWindow.getWorldPoint(point);
        TSEHitTesting tSEHitTesting = this.getHitTesting();
        TSEGraph tSEGraph = this.getGraph();
        if (this.getGraphWindow().isNestedGraphEditingEnabled()) {
            tSEGraph = tSEHitTesting.getGraphAt(tSConstPoint, this.getGraph());
        }
        tSEGraph.setSelected(true);
        if (string.startsWith("nodeUI")) {
            if (this.previewDraggedNode) {
                if (this.draggedNode.isOwned()) {
                    this.draggedNode.getOwnerGraph().remove((TSNode)this.draggedNode);
                }
                tSEGraphWindow.insertNode(this.draggedNode, tSEGraph);
                this.draggedNode.setCenter(tSConstPoint);
                this.draggedNode.setDragged(false);
                tSEGraphWindow.drawGraph();
                tSEGraphWindow.repaint();
            } else {
                tSEGraphWindow.addNode(this.getTypeFromString(string), tSEGraphWindow.getWorldX(point), tSEGraphWindow.getWorldY(point), this.getUIFromString(string), tSEGraph);
            }
        }
        this.draggedNode = null;
    }

    public TSENodeUI getUIFromString(String string) {
        string = string.substring(string.indexOf(".") + 1, string.length());
        string = string.substring(string.indexOf(".") + 1, string.length());
        string = "nodeUI." + string;
        TSENodeUI tSENodeUI = Tomahawk.getInstance().getNodeUI(string);
        if (tSENodeUI == null) {
            String string2 = Tomahawk.getResources().getStringResource(string + ".class");
            try {
                tSENodeUI = (TSENodeUI)Class.forName(string2).newInstance();
                Tomahawk.getInstance().setUIAttributes(string, (TSEObjectUI)tSENodeUI);
                Tomahawk.getInstance().addNodeUI(string, tSENodeUI);
            }
            catch (Exception exception) {
                System.err.println("Failed to instantiate node UI " + string2);
                tSENodeUI = Tomahawk.getInstance().getNodeUI("nodeUI.default");
            }
        }
        return tSENodeUI;
    }

    public int getTypeFromString(String string) {
        int n;
        try {
            n = Integer.parseInt(Tomahawk.getResources().getStringResource("nodeType." + string.substring(string.indexOf(".") + 1, string.length())));
        }
        catch (Exception exception) {
            n = 0;
        }
        return n;
    }

    public void nullifyReferences() {
        this.hitGraph = null;
        this.hitObject = null;
        this.draggedNode = null;
        this.selectedGraph = null;
    }

    PopupMenuController getPopupMenuController() {
        if (popupMenuController == null) {
            popupMenuController = new PopupMenuController();
        }
        return popupMenuController;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class PopupMenuController
    implements ActionListener {
        public PopupMenuController() {
            menus = new Hashtable(10, 0.8f);
            JPopupMenu jPopupMenu = Tomahawk.getResources().createPopup("popup.node");
            if (jPopupMenu != null) {
                menus.put("NODE_POPUP", jPopupMenu);
            }
            if ((jPopupMenu = Tomahawk.getResources().createPopup("popup.connector")) != null) {
                menus.put("CONNECTOR_POPUP", jPopupMenu);
            }
            if ((jPopupMenu = Tomahawk.getResources().createPopup("popup.edge")) != null) {
                menus.put("EDGE_POPUP", jPopupMenu);
            }
            if ((jPopupMenu = Tomahawk.getResources().createPopup("popup.edgeLabel")) != null) {
                menus.put("EDGE_LABEL_POPUP", jPopupMenu);
            }
            if ((jPopupMenu = Tomahawk.getResources().createPopup("popup.nodeLabel")) != null) {
                menus.put("NODE_LABEL_POPUP", jPopupMenu);
            }
            if ((jPopupMenu = Tomahawk.getResources().createPopup("popup.connectorLabel")) != null) {
                menus.put("CONNECTOR_LABEL_POPUP", jPopupMenu);
            }
            if ((jPopupMenu = Tomahawk.getResources().createPopup("popup.bend")) != null) {
                menus.put("BEND_POPUP", jPopupMenu);
            }
            if ((jPopupMenu = Tomahawk.getResources().createPopup("popup.graph")) != null) {
                menus.put("GRAPH_POPUP", jPopupMenu);
            }
            if ((jPopupMenu = Tomahawk.getInstance().getTabPopupMenu()) != null) {
                menus.put("TAB_POPUP", jPopupMenu);
            }
            this.setPopupMenuListening();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Tomahawk tomahawk = Tomahawk.getInstance();
            if (tomahawk.hasGraphWindow()) {
                ExSelectTool exSelectTool = (ExSelectTool)tomahawk.getGraphWindow().getDefaultTool();
                exSelectTool.actionPerformed(actionEvent);
                String string = exSelectTool.getActiveMenu();
                if (string != null) {
                    JPopupMenu jPopupMenu = (JPopupMenu)menus.get(string);
                    if (jPopupMenu != null) {
                        jPopupMenu.setInvoker(null);
                    }
                    exSelectTool.setActiveMenu(null);
                }
            }
        }

        public void setPopupMenuListening() {
            if (menus != null) {
                Enumeration enumeration = menus.elements();
                while (enumeration.hasMoreElements()) {
                    JPopupMenu jPopupMenu = (JPopupMenu)enumeration.nextElement();
                    this.setMenuElementListening(jPopupMenu);
                }
            }
        }

        void setMenuElementListening(MenuElement menuElement) {
            if (menuElement != null) {
                if (menuElement instanceof JPopupMenu || menuElement instanceof JMenu) {
                    MenuElement[] menuElementArray = menuElement.getSubElements();
                    for (int i = 0; i < menuElementArray.length; ++i) {
                        if (menuElementArray[i] instanceof JSeparator) continue;
                        this.setMenuElementListening(menuElementArray[i]);
                    }
                } else if (menuElement instanceof JMenuItem) {
                    ((JMenuItem)menuElement).addActionListener(this);
                }
            }
        }
    }

    static class SystemBrowserDisplay {
        private static final String WIN_ID = "Windows";
        private static final String MAC_ID = "Mac";
        private static final String MAC_OS_X_ID = "Mac OS X";
        private static final String WIN_PATH = "rundll32";
        private static final String WIN_FLAG = "url.dll,FileProtocolHandler javascript:location.href=";
        private static final String UNIX_PATH = "netscape";
        private static final String UNIX_FLAG = "-remote xfeDoCommand(openBrowser)";
        private static final String UNIX_FLAG2 = "-remote openURL";

        SystemBrowserDisplay() {
        }

        public static void openURL(String string) {
            Process process = null;
            String string2 = null;
            boolean bl = SystemBrowserDisplay.isWindowsPlatform();
            boolean bl2 = SystemBrowserDisplay.isMacPlatform();
            try {
                Tomahawk.getInstance();
                if (Tomahawk.isApplet()) {
                    Tomahawk.getInstance().getAppletContext().showDocument(new URL(string), "_blank");
                } else if (bl) {
                    if (!string.startsWith("file://")) {
                        if (string.endsWith(".html")) {
                            string = string.substring(0, string.length() - 1) + "%6C";
                        } else if (string.endsWith(".htm")) {
                            string = string.substring(0, string.length() - 1) + "%6D";
                        }
                    }
                    string2 = "rundll32 url.dll,FileProtocolHandler javascript:location.href=\"" + string + "\"";
                    process = Runtime.getRuntime().exec(string2);
                } else if (bl2) {
                    if (SystemBrowserDisplay.isMacOSX()) {
                        Method method = null;
                        try {
                            Class<?> clazz = Class.forName("com.apple.mrj.MRJFileUtils");
                            method = clazz.getDeclaredMethod("openURL", class$java$lang$String == null ? (class$java$lang$String = ExSelectTool.class$("java.lang.String")) : class$java$lang$String);
                            method.invoke(null, string);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            System.err.println("InvocationTargetException while calling openURL: " + invocationTargetException.getMessage());
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            System.err.println("IllegalAccessException while calling openURL: " + illegalAccessException.getMessage());
                        }
                        catch (Exception exception) {
                            System.err.println("Could not find system browser");
                            System.err.println("Caught: " + exception);
                        }
                    } else {
                        String[] stringArray = new String[]{UNIX_PATH, string};
                        process = Runtime.getRuntime().exec(stringArray);
                    }
                } else {
                    string2 = "netscape -remote xfeDoCommand(openBrowser)";
                    Process process2 = process = Runtime.getRuntime().exec(string2);
                    String string3 = string;
                    String string4 = string2;
                    Thread thread = new Thread(process2, string3){
                        private final /* synthetic */ Process val$processForThread;
                        private final /* synthetic */ String val$urlForThread;
                        {
                            this.val$processForThread = process;
                            this.val$urlForThread = string;
                        }

                        public void run() {
                            String string = null;
                            try {
                                int n = this.val$processForThread.waitFor();
                                string = n != 0 ? "netscape " + this.val$urlForThread : "netscape -remote openURL(\"" + this.val$urlForThread + "\")";
                                Runtime.getRuntime().exec(string);
                            }
                            catch (Exception exception) {
                                System.err.println("Error executing browser with command '" + string + "'");
                                System.err.println("Caught: " + exception);
                            }
                        }
                    };
                    thread.start();
                }
            }
            catch (IOException iOException) {
                System.err.println("Could not invoke browser with command " + string2);
                System.err.println("Caught: " + iOException);
            }
        }

        public static boolean isWindowsPlatform() {
            boolean bl = false;
            String string = System.getProperty("os.name");
            if (string != null && string.startsWith(WIN_ID)) {
                bl = true;
            }
            return bl;
        }

        public static boolean isMacPlatform() {
            boolean bl = false;
            String string = System.getProperty("os.name");
            if (string != null && string.startsWith(MAC_ID)) {
                bl = true;
            }
            return bl;
        }

        public static boolean isMacOSX() {
            boolean bl = false;
            String string = System.getProperty("os.name");
            if (string != null && string.equals(MAC_OS_X_ID)) {
                bl = true;
            }
            return bl;
        }
    }
}

