/*
 * Decompiled with CFR 0.152.
 */
package editor.ui;

import com.tomsawyer.editor.TSEColor;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSTransform;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.ui.TSEAnnotatedUI;
import com.tomsawyer.editor.ui.TSENodeUI;
import com.tomsawyer.util.TSProperty;
import editor.Tomahawk;
import java.util.List;

public class ExBusNodeUI
extends TSENodeUI {
    public static TSEInspectorPropertyID END_COLOR_ID = new TSEInspectorPropertyID(Tomahawk.getResources().getStringResource("string.End_Color"), class$com$tomsawyer$editor$TSEColor == null ? (class$com$tomsawyer$editor$TSEColor = ExBusNodeUI.class$("com.tomsawyer.editor.TSEColor")) : class$com$tomsawyer$editor$TSEColor);
    public static final String END_COLOR = "endColor";
    public static final double WIDTH = 80.0;
    public static final double HEIGHT = 6.0;
    TSEColor endColor;
    static /* synthetic */ Class class$com$tomsawyer$editor$TSEColor;

    public void reset() {
        super.reset();
        this.setEndColor(this.getDefaultEndColor());
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        ExBusNodeUI exBusNodeUI = (ExBusNodeUI)tSEObjectUI;
        this.setEndColor(exBusNodeUI.getEndColor());
    }

    public void draw(TSEGraphics tSEGraphics) {
        TSTransform tSTransform = tSEGraphics.getTSTransform();
        TSENode tSENode = this.getOwnerNode();
        int n = tSTransform.xToDevice(tSENode.getLocalLeft());
        int n2 = tSTransform.yToDevice(tSENode.getLocalTop());
        int n3 = tSTransform.widthToDevice(tSENode.getLocalWidth());
        int n4 = tSTransform.heightToDevice(tSENode.getLocalHeight());
        if (!this.isTransparent()) {
            if (n3 > 2 * n4) {
                tSEGraphics.setColor(this.getEndColor());
                tSEGraphics.fillRect(tSENode.getLocalBounds());
                tSEGraphics.fillRect(n + n3 - n4, n2, n4, n4);
                tSEGraphics.setColor(this.getFillColor());
                tSEGraphics.fillRect(n + n4, n2, n3 - 2 * n4, n4);
            } else {
                tSEGraphics.setColor(this.getEndColor());
                tSEGraphics.fillRect(tSENode.getLocalBounds());
            }
        }
        if (this.isBorderDrawn()) {
            tSEGraphics.setColor(this.getBorderColor().getColor());
            tSEGraphics.drawRect(tSENode.getLocalBounds());
            if (n3 > 2 * n4) {
                tSEGraphics.drawLine(n + n4, n2, n + n4, n2 + n4);
                tSEGraphics.drawLine(n + n3 - n4, n2, n + n3 - n4, n2 + n4);
            }
        }
        if (tSENode.hasChildGraph()) {
            this.drawChildGraphMark(tSEGraphics);
        }
        if (this.hasHideMark()) {
            this.drawHideMark(tSEGraphics);
        }
        this.drawConstraintBadge(tSEGraphics);
    }

    public boolean isAnnotationEditable() {
        return false;
    }

    public void setOwner(TSENode tSENode) {
        super.setOwner(tSENode);
        if (tSENode != null) {
            if ((tSENode.getResizability() & 0x1000000) == 0) {
                tSENode.setResizability(this.getDefaultResizability());
            }
            tSENode.setLocalAdjustedSize(this.getDefaultWidth(), this.getTightHeight());
            tSENode.setLocalAdjustedOriginalSize(this.getDefaultWidth(), this.getTightHeight());
        }
    }

    public int getDefaultResizability() {
        return 2;
    }

    public double getTightHeight() {
        return 6.0;
    }

    public double getMinimumHeight() {
        return 6.0;
    }

    public double getMinimumWidth() {
        return 6.0 * 2.0;
    }

    public double getDefaultWidth() {
        return 80.0;
    }

    public TSEColor getEndColor() {
        return this.endColor;
    }

    public void setEndColor(TSEColor tSEColor) {
        TSEColor tSEColor2 = this.endColor;
        this.endColor = tSEColor;
        this.firePropertyChangedEvent(END_COLOR, tSEColor2, tSEColor);
    }

    public TSEColor getDefaultEndColor() {
        return TSEColor.darkGray;
    }

    public List getProperties() {
        List list = super.getProperties();
        list.add(new TSProperty(END_COLOR, (Object)this.getEndColor()));
        return list;
    }

    public void setProperty(TSProperty tSProperty) {
        if (END_COLOR.equals(tSProperty.getName())) {
            if (tSProperty.getValue() instanceof TSEColor) {
                this.setEndColor((TSEColor)tSProperty.getValue());
            } else {
                this.setEndColor(new TSEColor(tSProperty.getValue().toString()));
            }
        } else {
            super.setProperty(tSProperty);
        }
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        if (!this.getDefaultEndColor().equals((Object)this.getEndColor())) {
            list.add(new TSProperty(END_COLOR, (Object)this.getEndColor()));
        }
        return list;
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(END_COLOR_ID);
        super.getInspectorPropertyIDs(list);
        list.remove(TSEAnnotatedUI.FONT_ID);
        list.remove(TSEAnnotatedUI.TEXT_COLOR_ID);
        list.remove(TSEAnnotatedUI.JUSTIFICATION_ID);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        TSEInspectorProperty tSEInspectorProperty = tSEInspectorPropertyID.equals((Object)END_COLOR_ID) ? new TSEInspectorProperty((Object)this.getEndColor()) : super.getInspectorProperty(tSEInspectorPropertyID);
        return tSEInspectorProperty;
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        int n;
        if (tSEInspectorPropertyID.equals((Object)END_COLOR_ID)) {
            this.setEndColor((TSEColor)tSEInspectorProperty.getValue());
            n = 1;
        } else {
            n = super.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

