/*
 * Decompiled with CFR 0.152.
 */
package editor.ui;

import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.inspector.TSEInspectorProperty;
import com.tomsawyer.editor.inspector.TSEInspectorPropertyID;
import com.tomsawyer.editor.inspector.TSEKeyValueInspectorProperty;
import com.tomsawyer.editor.inspector.TSENumericInspectorProperty;
import com.tomsawyer.editor.ui.TSEAnnotatedUI;
import com.tomsawyer.editor.ui.TSEJComponentNodeUI;
import com.tomsawyer.util.TSProperty;
import com.tomsawyer.util.TSSystem;
import editor.Tomahawk;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class ExJTableNodeUI
extends TSEJComponentNodeUI
implements FocusListener,
MouseListener {
    public static TSEInspectorPropertyID AUTO_RESIZE_MODE_ID = new TSEInspectorPropertyID(Tomahawk.getResources().getStringResource("string.Auto_Resize_Mode"), class$java$lang$Integer == null ? (class$java$lang$Integer = ExJTableNodeUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static final String OFF_STRING = Tomahawk.getResources().getStringResource("string.Off");
    public static final String NEXT_COLUMN_STRING = Tomahawk.getResources().getStringResource("string.Next_Column");
    public static final String SUBSEQUENT_COLUMNS_STRING = Tomahawk.getResources().getStringResource("string.Subsequent_Columns");
    public static final String LAST_COLUMN_STRING = Tomahawk.getResources().getStringResource("string.Last_Column");
    public static final String ALL_COLUMNS_STRING = Tomahawk.getResources().getStringResource("string.All_Columns");
    public static TSEInspectorPropertyID SCROLLBAR_SIZE_ID = new TSEInspectorPropertyID(Tomahawk.getResources().getStringResource("string.Scrollbar_Size"), class$java$lang$Integer == null ? (class$java$lang$Integer = ExJTableNodeUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static TSEInspectorPropertyID ROW_NUMBER_ID = new TSEInspectorPropertyID(Tomahawk.getResources().getStringResource("string.Number_of_Rows"), class$java$lang$Integer == null ? (class$java$lang$Integer = ExJTableNodeUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static TSEInspectorPropertyID COLUMN_NUMBER_ID = new TSEInspectorPropertyID(Tomahawk.getResources().getStringResource("string.Number_of_Columns"), class$java$lang$Integer == null ? (class$java$lang$Integer = ExJTableNodeUI.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static final String COLUMN_NAME_TEMPLATE = Tomahawk.getResources().getStringResource("string.Column_%X%_Name");
    public static final String ROWS = "rows";
    public static final String COLUMNS = "columns";
    public static final String COLUMN = "column";
    public static final String INDEX = "index";
    public static final String CLASS = "class";
    public static final String CELL = "cell";
    public static final String AUTORESIZEMODE = "autoResizeMode";
    public static final String SCROLLBARSIZE = "scrollBarSize";
    JTable table;
    JScrollPane scrollPane;
    int columnCount;
    int rowCount;
    int currentRowIndex;
    int currentColumnIndex;
    Vector columnNames;
    Vector columnClasses;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;

    public JComponent newJComponent() {
        this.table = new JTable();
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setCursor(Cursor.getDefaultCursor());
        this.setAutoResizeMode(this.getDefaultAutoResizeMode());
        this.setScrollBarSize(this.getDefaultScrollBarSize());
        this.table.setOpaque(true);
        this.table.setModel(new DefaultTableModel(){

            public Class getColumnClass(int n) {
                if (this.getRowCount() > 0 && this.getColumnCount() > n && this.getValueAt(0, n) != null) {
                    return this.getValueAt(0, n).getClass();
                }
                return class$java$lang$Object == null ? (class$java$lang$Object = ExJTableNodeUI.class$("java.lang.Object")) : class$java$lang$Object;
            }
        });
        this.columnCount = this.getDefaultColumnCount();
        this.rowCount = this.getDefaultRowCount();
        this.allocateModel();
        return this.scrollPane;
    }

    private Object deepCopy(Object object) {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object2 = objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object2;
    }

    protected void addToCanvas() {
        this.table.addFocusListener(this);
        this.table.addMouseListener(this);
        this.scrollPane.addFocusListener(this);
        this.scrollPane.addMouseListener(this);
        super.addToCanvas();
    }

    protected void removeFromCanvas() {
        this.table.removeFocusListener(this);
        this.table.removeMouseListener(this);
        this.scrollPane.removeFocusListener(this);
        this.scrollPane.removeMouseListener(this);
        if (this.table != null) {
            this.table.removeEditor();
        }
        super.removeFromCanvas();
    }

    public void copy(TSEObjectUI tSEObjectUI) {
        super.copy(tSEObjectUI);
        ExJTableNodeUI exJTableNodeUI = (ExJTableNodeUI)tSEObjectUI;
        if (exJTableNodeUI.table != null && exJTableNodeUI.table.getModel() instanceof DefaultTableModel) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)exJTableNodeUI.table.getModel();
            DefaultTableModel defaultTableModel2 = (DefaultTableModel)this.table.getModel();
            Vector<String> vector = new Vector<String>(defaultTableModel.getColumnCount());
            vector.setSize(defaultTableModel.getColumnCount());
            for (int i = 0; i < defaultTableModel.getColumnCount(); ++i) {
                vector.setElementAt(new String(defaultTableModel.getColumnName(i)), i);
            }
            defaultTableModel2.setDataVector((Vector)this.deepCopy(defaultTableModel.getDataVector()), vector);
        }
        this.setScrollBarSize(exJTableNodeUI.getScrollBarSize());
    }

    public List getProperties() {
        List list = super.getProperties();
        list.add(new TSProperty(AUTORESIZEMODE, (Object)new Integer(this.getAutoResizeMode())));
        list.add(new TSProperty(SCROLLBARSIZE, (Object)new Integer(this.getScrollBarSize())));
        if (this.table != null) {
            list.add(new TSProperty(ROWS, (Object)new Integer(this.table.getRowCount())));
            list.add(new TSProperty(COLUMNS, (Object)new Integer(this.table.getColumnCount())));
        }
        return list;
    }

    public List getChangedProperties() {
        List list = super.getChangedProperties();
        if (this.getAutoResizeMode() != this.getDefaultAutoResizeMode()) {
            list.add(new TSProperty(AUTORESIZEMODE, (Object)new Integer(this.getAutoResizeMode())));
        }
        if (this.getScrollBarSize() != this.getDefaultScrollBarSize()) {
            list.add(new TSProperty(SCROLLBARSIZE, (Object)new Integer(this.getScrollBarSize())));
        }
        if (this.table != null && this.table.getModel() instanceof DefaultTableModel && this.table.getColumnModel() instanceof DefaultTableColumnModel) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
            DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)this.table.getColumnModel();
            list.add(new TSProperty(ROWS, (Object)new Integer(this.table.getRowCount())));
            list.add(new TSProperty(COLUMNS, (Object)new Integer(this.table.getColumnCount())));
            for (int i = 0; i < defaultTableModel.getColumnCount(); ++i) {
                list.add(new TSProperty(COLUMN, (Object)this.table.getColumnName(i)));
                TableColumn tableColumn = defaultTableColumnModel.getColumn(i);
                list.add(new TSProperty(INDEX, (Object)new Integer(tableColumn.getModelIndex())));
                list.add(new TSProperty(CLASS, (Object)this.table.getColumnClass(i).getName()));
                for (int j = 0; j < defaultTableModel.getRowCount(); ++j) {
                    list.add(new TSProperty(CELL, defaultTableModel.getValueAt(j, i)));
                }
            }
        }
        return list;
    }

    private void allocateModel() {
        Vector vector = new Vector(this.rowCount);
        vector.setSize(this.rowCount);
        for (int i = 0; i < this.rowCount; ++i) {
            Vector vector2 = new Vector(this.columnCount);
            vector2.setSize(this.columnCount);
            vector.setElementAt(vector2, i);
        }
        this.columnNames = new Vector(this.columnCount);
        this.columnNames.setSize(this.columnCount);
        this.columnClasses = new Vector(this.columnCount);
        this.columnClasses.setSize(this.columnCount);
        this.currentRowIndex = -1;
        this.currentColumnIndex = -1;
        if (this.table != null && this.table.getModel() instanceof DefaultTableModel) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
            defaultTableModel.setDataVector(vector, this.columnNames);
        }
    }

    public void setRowCount(int n) {
        this.rowCount = n;
        this.allocateModel();
    }

    public void setColumnCount(int n) {
        this.columnCount = n;
        this.allocateModel();
    }

    public double getTightWidth() {
        if (this.table != null) {
            return this.table.getPreferredSize().width + 2 * this.getMarginSize();
        }
        return super.getTightWidth();
    }

    public double getTightHeight() {
        if (this.table != null) {
            return this.table.getPreferredSize().height + 2 * this.getMarginSize();
        }
        return super.getTightHeight();
    }

    public void setProperty(TSProperty tSProperty) {
        if (AUTORESIZEMODE.equals(tSProperty.getName())) {
            this.setAutoResizeMode(Integer.parseInt(tSProperty.getValue().toString()));
        }
        if (SCROLLBARSIZE.equals(tSProperty.getName())) {
            this.setScrollBarSize(Integer.parseInt(tSProperty.getValue().toString()));
        }
        if (this.table != null && this.table.getModel() instanceof DefaultTableModel && this.table.getColumnModel() instanceof DefaultTableColumnModel) {
            TSProperty tSProperty2 = this.getProperty(tSProperty.getName());
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
            DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)this.table.getColumnModel();
            try {
                Serializable serializable;
                if (ROWS.equals(tSProperty.getName())) {
                    this.setRowCount(Integer.parseInt(tSProperty.getValue().toString()));
                    return;
                }
                if (COLUMNS.equals(tSProperty.getName())) {
                    this.setColumnCount(Integer.parseInt(tSProperty.getValue().toString()));
                    return;
                }
                if (COLUMN.equals(tSProperty.getName())) {
                    ++this.currentColumnIndex;
                    this.currentRowIndex = 0;
                    this.columnNames.setElementAt(tSProperty.getValue().toString(), this.currentColumnIndex);
                    if (this.currentColumnIndex == this.columnCount - 1) {
                        defaultTableModel.setColumnIdentifiers(this.columnNames);
                    }
                    return;
                }
                if (CLASS.equals(tSProperty.getName())) {
                    this.columnClasses.setElementAt(Class.forName(tSProperty.getValue().toString()), this.currentColumnIndex);
                    return;
                }
                if (INDEX.equals(tSProperty.getName())) {
                    serializable = defaultTableColumnModel.getColumn(this.currentColumnIndex);
                    int n = Integer.parseInt(tSProperty.getValue().toString());
                    serializable.setModelIndex(n);
                }
                if (CELL.equals(tSProperty.getName())) {
                    if (!tSProperty.getValue().toString().equals("null")) {
                        if ((class$java$lang$Byte == null ? (class$java$lang$Byte = ExJTableNodeUI.class$("java.lang.Byte")) : class$java$lang$Byte).equals(serializable = (Class)this.columnClasses.elementAt(this.currentColumnIndex))) {
                            defaultTableModel.setValueAt(new Byte(tSProperty.getValue().toString()), this.currentRowIndex, this.currentColumnIndex);
                        } else if ((class$java$lang$Double == null ? (class$java$lang$Double = ExJTableNodeUI.class$("java.lang.Double")) : class$java$lang$Double).equals(serializable)) {
                            defaultTableModel.setValueAt(new Double(tSProperty.getValue().toString()), this.currentRowIndex, this.currentColumnIndex);
                        } else if ((class$java$lang$Float == null ? (class$java$lang$Float = ExJTableNodeUI.class$("java.lang.Float")) : class$java$lang$Float).equals(serializable)) {
                            defaultTableModel.setValueAt(new Float(tSProperty.getValue().toString()), this.currentRowIndex, this.currentColumnIndex);
                        } else if ((class$java$lang$Integer == null ? (class$java$lang$Integer = ExJTableNodeUI.class$("java.lang.Integer")) : class$java$lang$Integer).equals(serializable)) {
                            defaultTableModel.setValueAt(new Integer(tSProperty.getValue().toString()), this.currentRowIndex, this.currentColumnIndex);
                        } else if ((class$java$lang$Long == null ? (class$java$lang$Long = ExJTableNodeUI.class$("java.lang.Long")) : class$java$lang$Long).equals(serializable)) {
                            defaultTableModel.setValueAt(new Long(tSProperty.getValue().toString()), this.currentRowIndex, this.currentColumnIndex);
                        } else if ((class$java$lang$Short == null ? (class$java$lang$Short = ExJTableNodeUI.class$("java.lang.Short")) : class$java$lang$Short).equals(serializable)) {
                            defaultTableModel.setValueAt(new Short(tSProperty.getValue().toString()), this.currentRowIndex, this.currentColumnIndex);
                        } else {
                            defaultTableModel.setValueAt(tSProperty.getValue().toString(), this.currentRowIndex, this.currentColumnIndex);
                        }
                    }
                    ++this.currentRowIndex;
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.firePropertyChangedEvent(tSProperty.getName(), tSProperty2, tSProperty.getValue());
        }
        super.setProperty(tSProperty);
    }

    public int getScrollBarSize() {
        if (this.scrollPane != null) {
            return Math.max(this.scrollPane.getVerticalScrollBar().getPreferredSize().width, this.scrollPane.getHorizontalScrollBar().getPreferredSize().height);
        }
        return this.getDefaultScrollBarSize();
    }

    public void setScrollBarSize(int n) {
        if (this.scrollPane != null && n > 0) {
            Dimension dimension = this.scrollPane.getVerticalScrollBar().getPreferredSize();
            this.scrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(n, 0));
            this.scrollPane.getHorizontalScrollBar().setPreferredSize(new Dimension(0, n));
            this.scrollPane.revalidate();
            this.firePropertyChangedEvent(SCROLLBARSIZE, dimension, this.scrollPane.getVerticalScrollBar().getPreferredSize());
        }
    }

    public int getDefaultScrollBarSize() {
        return 10;
    }

    public boolean isTransparentByDefault() {
        return true;
    }

    public boolean isAnnotationEditable() {
        return false;
    }

    public int getAutoResizeMode() {
        if (this.table != null) {
            return this.table.getAutoResizeMode();
        }
        return this.getDefaultAutoResizeMode();
    }

    public void setAutoResizeMode(int n) {
        if (this.table != null) {
            Integer n2 = new Integer(this.table.getAutoResizeMode());
            this.table.setAutoResizeMode(n);
            this.firePropertyChangedEvent(AUTORESIZEMODE, n2, new Integer(n));
        }
    }

    public int getDefaultAutoResizeMode() {
        return 4;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        ((JLayeredPane)this.getParentWindow().getCanvas()).moveToFront(this.scrollPane);
    }

    public void focusGained(FocusEvent focusEvent) {
        ((JLayeredPane)this.getParentWindow().getCanvas()).moveToFront(this.scrollPane);
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected String buildColumnName(int n) {
        return TSSystem.replace((String)COLUMN_NAME_TEMPLATE, (String)"%X%", (String)("" + (n + 1)));
    }

    public void getInspectorPropertyIDs(List list) {
        list.add(ROW_NUMBER_ID);
        list.add(COLUMN_NUMBER_ID);
        if (this.table != null) {
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                list.add(new TSEInspectorPropertyID(this.buildColumnName(i), class$java$lang$String == null ? ExJTableNodeUI.class$("java.lang.String") : class$java$lang$String));
            }
        }
        list.add(AUTO_RESIZE_MODE_ID);
        list.add(SCROLLBAR_SIZE_ID);
        super.getInspectorPropertyIDs(list);
        list.remove(TSENode.NAME_ID);
        list.remove(TSEAnnotatedUI.FONT_ID);
        list.remove(TSEAnnotatedUI.TEXT_COLOR_ID);
        list.remove(TSEAnnotatedUI.JUSTIFICATION_ID);
    }

    public TSEInspectorProperty getInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID) {
        if (tSEInspectorPropertyID.equals((Object)AUTO_RESIZE_MODE_ID)) {
            TSEKeyValueInspectorProperty tSEKeyValueInspectorProperty = new TSEKeyValueInspectorProperty((Object)new Integer(this.getAutoResizeMode()));
            tSEKeyValueInspectorProperty.put((Object)OFF_STRING, (Object)new Integer(0));
            tSEKeyValueInspectorProperty.put((Object)NEXT_COLUMN_STRING, (Object)new Integer(1));
            tSEKeyValueInspectorProperty.put((Object)SUBSEQUENT_COLUMNS_STRING, (Object)new Integer(2));
            tSEKeyValueInspectorProperty.put((Object)LAST_COLUMN_STRING, (Object)new Integer(3));
            tSEKeyValueInspectorProperty.put((Object)ALL_COLUMNS_STRING, (Object)new Integer(4));
            return tSEKeyValueInspectorProperty;
        }
        if (tSEInspectorPropertyID.equals((Object)SCROLLBAR_SIZE_ID)) {
            return new TSENumericInspectorProperty((Number)new Integer(this.getScrollBarSize()), (Number)new Integer(0), (Number)new Integer(99));
        }
        if (this.table != null) {
            if (tSEInspectorPropertyID.equals((Object)ROW_NUMBER_ID)) {
                return new TSENumericInspectorProperty((Number)new Integer(this.table.getRowCount()), (Number)new Integer(1), (Number)new Integer(99));
            }
            if (tSEInspectorPropertyID.equals((Object)COLUMN_NUMBER_ID)) {
                return new TSENumericInspectorProperty((Number)new Integer(this.table.getColumnCount()), (Number)new Integer(1), (Number)new Integer(99));
            }
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                TSEInspectorPropertyID tSEInspectorPropertyID2 = new TSEInspectorPropertyID(this.buildColumnName(i), class$java$lang$String == null ? ExJTableNodeUI.class$("java.lang.String") : class$java$lang$String);
                if (!tSEInspectorPropertyID.equals((Object)tSEInspectorPropertyID2)) continue;
                return new TSEInspectorProperty((Object)this.table.getColumnName(i));
            }
        }
        return super.getInspectorProperty(tSEInspectorPropertyID);
    }

    private Vector getColumnIdentifiers(DefaultTableModel defaultTableModel) {
        Vector<String> vector = new Vector<String>(defaultTableModel.getColumnCount());
        vector.setSize(defaultTableModel.getColumnCount());
        for (int i = 0; i < defaultTableModel.getColumnCount(); ++i) {
            vector.setElementAt(defaultTableModel.getColumnName(i), i);
        }
        return vector;
    }

    public int setInspectorProperty(TSEInspectorPropertyID tSEInspectorPropertyID, TSEInspectorProperty tSEInspectorProperty) {
        if (tSEInspectorPropertyID.equals((Object)AUTO_RESIZE_MODE_ID)) {
            this.setAutoResizeMode((Integer)tSEInspectorProperty.getValue());
            return 1;
        }
        if (tSEInspectorPropertyID.equals((Object)SCROLLBAR_SIZE_ID)) {
            this.setScrollBarSize((Integer)tSEInspectorProperty.getValue());
            return 1;
        }
        if (this.table != null) {
            if (tSEInspectorPropertyID.equals((Object)ROW_NUMBER_ID)) {
                if (this.table.getModel() instanceof DefaultTableModel) {
                    DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
                    Vector vector = this.getColumnIdentifiers(defaultTableModel);
                    Vector<Vector> vector2 = defaultTableModel.getDataVector();
                    int n = defaultTableModel.getRowCount();
                    int n2 = (Integer)tSEInspectorProperty.getValue();
                    vector2.setSize(n2);
                    for (int i = n; i < n2; ++i) {
                        Vector vector3 = new Vector(defaultTableModel.getColumnCount());
                        vector3.setSize(defaultTableModel.getColumnCount());
                        vector2.setElementAt(vector3, i);
                    }
                    defaultTableModel.setDataVector(vector2, vector);
                    this.table.revalidate();
                    return 1;
                }
                return 0;
            }
            if (tSEInspectorPropertyID.equals((Object)COLUMN_NUMBER_ID)) {
                if (this.table.getModel() instanceof DefaultTableModel) {
                    DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
                    Vector vector = this.getColumnIdentifiers(defaultTableModel);
                    Vector<Vector> vector4 = defaultTableModel.getDataVector();
                    int n = (Integer)tSEInspectorProperty.getValue();
                    for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                        Vector vector5 = vector4.elementAt(i);
                        vector5.setSize(n);
                    }
                    vector.setSize(n);
                    defaultTableModel.setDataVector(vector4, vector);
                    this.table.revalidate();
                    return 2;
                }
                return 0;
            }
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                TSEInspectorPropertyID tSEInspectorPropertyID2 = new TSEInspectorPropertyID(this.buildColumnName(i), class$java$lang$String == null ? ExJTableNodeUI.class$("java.lang.String") : class$java$lang$String);
                if (!tSEInspectorPropertyID.equals((Object)tSEInspectorPropertyID2)) continue;
                if (this.table.getModel() instanceof DefaultTableModel) {
                    DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
                    Vector vector = this.getColumnIdentifiers(defaultTableModel);
                    vector.setElementAt(tSEInspectorProperty.getValue(), i);
                    defaultTableModel.setColumnIdentifiers(vector);
                    this.table.revalidate();
                    return 1;
                }
                return 0;
            }
        }
        return super.setInspectorProperty(tSEInspectorPropertyID, tSEInspectorProperty);
    }

    public int getDefaultRowCount() {
        return 4;
    }

    public int getDefaultColumnCount() {
        return 3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

