/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.apache.batik.bridge.AbstractSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeMutationEvent;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.FilterPrimitiveBridge;
import org.apache.batik.bridge.PaintServer;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.css.CSSOMReadOnlyStyleDeclaration;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.FilterAlphaRable;
import org.apache.batik.ext.awt.image.renderable.FilterColorInterpolation;
import org.apache.batik.ext.awt.image.renderable.FloodRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.filter.BackgroundRable8Bit;
import org.w3c.dom.Element;

public abstract class AbstractSVGFilterPrimitiveElementBridge
extends AbstractSVGBridge
implements FilterPrimitiveBridge,
ErrorConstants {
    static final Rectangle2D INFINITE_FILTER_REGION = new Rectangle2D.Float(-1.7014117E38f, -1.7014117E38f, Float.MAX_VALUE, Float.MAX_VALUE);

    protected AbstractSVGFilterPrimitiveElementBridge() {
    }

    protected static Filter getIn(Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Map map, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "in");
        if (string.length() == 0) {
            return filter;
        }
        return AbstractSVGFilterPrimitiveElementBridge.getFilterSource(element, string, element2, graphicsNode, map, bridgeContext);
    }

    protected static Filter getIn2(Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Map map, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "in2");
        if (string.length() == 0) {
            throw new BridgeException(element, "attribute.missing", new Object[]{"in2"});
        }
        return AbstractSVGFilterPrimitiveElementBridge.getFilterSource(element, string, element2, graphicsNode, map, bridgeContext);
    }

    protected static void updateFilterMap(Element element, Filter filter, Map map) {
        String string = element.getAttributeNS(null, "result");
        if (string.length() != 0 && string.trim().length() != 0) {
            map.put(string, filter);
        }
    }

    protected static void handleColorInterpolationFilters(Filter filter, Element element) {
        if (filter instanceof FilterColorInterpolation) {
            boolean bl = CSSUtilities.convertColorInterpolationFilters(element);
            ((FilterColorInterpolation)filter).setColorSpaceLinear(bl);
        }
    }

    static Filter getFilterSource(Element element, String string, Element element2, GraphicsNode graphicsNode, Map map, BridgeContext bridgeContext) {
        int n = string.length();
        Filter filter = null;
        switch (n) {
            case 13: {
                if (!"SourceGraphic".equals(string)) break;
                filter = (Filter)map.get("SourceGraphic");
                break;
            }
            case 11: {
                if (string.charAt(1) == "SourceAlpha".charAt(1)) {
                    if (!"SourceAlpha".equals(string)) break;
                    filter = (Filter)map.get("SourceGraphic");
                    filter = new FilterAlphaRable(filter);
                    break;
                }
                if (!"StrokePaint".equals(string)) break;
                CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element2);
                Paint paint = PaintServer.convertStrokePaint(element2, graphicsNode, bridgeContext);
                filter = new FloodRable8Bit(INFINITE_FILTER_REGION, paint);
                break;
            }
            case 15: {
                if (string.charAt(10) == "BackgroundImage".charAt(10)) {
                    if (!"BackgroundImage".equals(string)) break;
                    filter = new BackgroundRable8Bit(graphicsNode);
                    break;
                }
                if (!"BackgroundAlpha".equals(string)) break;
                filter = new BackgroundRable8Bit(graphicsNode);
                filter = new FilterAlphaRable(filter);
                break;
            }
            case 9: {
                if (!"FillPaint".equals(string)) break;
                CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element2);
                Paint paint = PaintServer.convertFillPaint(element2, graphicsNode, bridgeContext);
                if (paint == null) {
                    paint = new Color(0, 0, 0, 0);
                }
                filter = new FloodRable8Bit(INFINITE_FILTER_REGION, paint);
            }
        }
        if (filter == null) {
            filter = (Filter)map.get(string);
        }
        return filter;
    }

    protected static int convertInteger(Element element, String string, int n) {
        String string2 = element.getAttributeNS(null, string);
        if (string2.length() == 0) {
            return n;
        }
        try {
            return SVGUtilities.convertSVGInteger(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{string, string2});
        }
    }

    protected static float convertNumber(Element element, String string, float f) {
        String string2 = element.getAttributeNS(null, string);
        if (string2.length() == 0) {
            return f;
        }
        try {
            return SVGUtilities.convertSVGNumber(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(element, "attribute.malformed", new Object[]{string, string2, numberFormatException});
        }
    }

    public void update(BridgeMutationEvent bridgeMutationEvent) {
        throw new Error("Not implemented");
    }

    public abstract Filter createFilter(BridgeContext var1, Element var2, Element var3, GraphicsNode var4, Filter var5, Rectangle2D var6, Map var7);
}

