/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.bridge.SVGBridgeExtension;
import org.apache.batik.bridge.StyleReference;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentViewport;
import org.apache.batik.bridge.Viewport;
import org.apache.batik.css.HiddenChildElementSupport;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.script.InterpreterPool;
import org.apache.batik.util.Service;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class BridgeContext
implements ErrorConstants {
    protected GVTBuilder gvtBuilder;
    protected Map viewportMap = new HashMap();
    protected List viewportStack = new LinkedList();
    protected UserAgent userAgent;
    protected HashMap elementNodeMap;
    protected HashMap nodeElementMap;
    protected HashMap elementStyleAttMap;
    protected HashMap nodeStyleMap;
    protected HashMap namespaceURIMap;
    protected InterpreterPool interpreterPool;
    protected DocumentLoader documentLoader;
    protected Dimension2D documentSize;
    protected TextPainter textPainter;
    private static InterpreterPool sharedPool = new InterpreterPool();
    static List extensions = null;
    static /* synthetic */ Class class$org$apache$batik$bridge$BridgeExtension;

    protected BridgeContext() {
    }

    public BridgeContext(UserAgent userAgent) {
        this(userAgent, sharedPool, new DocumentLoader(userAgent));
    }

    public BridgeContext(UserAgent userAgent, DocumentLoader documentLoader) {
        this(userAgent, sharedPool, documentLoader);
    }

    public BridgeContext(UserAgent userAgent, InterpreterPool interpreterPool, DocumentLoader documentLoader) {
        this.userAgent = userAgent;
        this.viewportMap.put(userAgent, new UserAgentViewport(userAgent));
        this.interpreterPool = interpreterPool;
        this.documentLoader = documentLoader;
        BridgeContext.registerSVGBridges(this);
    }

    public void setTextPainter(TextPainter textPainter) {
        this.textPainter = textPainter;
    }

    public TextPainter getTextPainter() {
        return this.textPainter;
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    protected void setUserAgent(UserAgent userAgent) {
        this.userAgent = userAgent;
    }

    protected void setGVTBuilder(GVTBuilder gVTBuilder) {
        this.gvtBuilder = gVTBuilder;
    }

    public GVTBuilder getGVTBuilder() {
        return this.gvtBuilder;
    }

    public InterpreterPool getInterpreterPool() {
        return this.interpreterPool;
    }

    protected void setInterpreterPool(InterpreterPool interpreterPool) {
        this.interpreterPool = interpreterPool;
    }

    public DocumentLoader getDocumentLoader() {
        return this.documentLoader;
    }

    protected void setDocumentLoader(DocumentLoader documentLoader) {
        this.documentLoader = documentLoader;
    }

    public Element getReferencedElement(Element element, String string) {
        try {
            SVGDocument sVGDocument = (SVGDocument)element.getOwnerDocument();
            URIResolver uRIResolver = new URIResolver(sVGDocument, this.documentLoader);
            Element element2 = uRIResolver.getElement(string, element);
            if (element2 == null) {
                throw new BridgeException(element, "uri.badTarget", new Object[]{string});
            }
            return element2;
        }
        catch (MalformedURLException malformedURLException) {
            throw new BridgeException(element, "uri.malformed", new Object[]{string});
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new InterruptedBridgeException();
        }
        catch (IOException iOException) {
            throw new BridgeException(element, "uri.io", new Object[]{string});
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new BridgeException(element, "uri.referenceDocument", new Object[]{string});
        }
    }

    public Dimension2D getDocumentSize() {
        return this.documentSize;
    }

    protected void setDocumentSize(Dimension2D dimension2D) {
        this.documentSize = dimension2D;
    }

    public Viewport getViewport(Element element) {
        if (this.viewportStack != null) {
            if (this.viewportStack.size() > 0) {
                return (Viewport)this.viewportStack.get(0);
            }
            return (Viewport)this.viewportMap.get(this.userAgent);
        }
        element = HiddenChildElementSupport.getParentElement(element);
        while (element != null) {
            Viewport viewport = (Viewport)this.viewportMap.get(element);
            if (viewport != null) {
                return viewport;
            }
            element = HiddenChildElementSupport.getParentElement(element);
        }
        return (Viewport)this.viewportMap.get(this.userAgent);
    }

    public void openViewport(Element element, Viewport viewport) {
        this.viewportMap.put(element, viewport);
        this.viewportStack.add(0, viewport);
    }

    public void closeViewport(Element element) {
        this.viewportMap.remove(element);
        this.viewportStack.remove(0);
    }

    public boolean isDynamic() {
        return true;
    }

    public void bind(Element element, GraphicsNode graphicsNode) {
        if (this.elementNodeMap == null) {
            this.elementNodeMap = new HashMap();
            this.nodeElementMap = new HashMap();
        }
        this.elementNodeMap.put(element, graphicsNode);
        this.nodeElementMap.put(graphicsNode, element);
    }

    public void unbind(Element element) {
        if (this.elementNodeMap == null) {
            return;
        }
        GraphicsNode graphicsNode = (GraphicsNode)this.elementNodeMap.get(element);
        this.elementNodeMap.remove(element);
        this.nodeElementMap.remove(graphicsNode);
        this.removeStyleReferences(graphicsNode);
    }

    public GraphicsNode getGraphicsNode(Element element) {
        if (this.elementNodeMap != null) {
            return (GraphicsNode)this.elementNodeMap.get(element);
        }
        return null;
    }

    public Element getElement(GraphicsNode graphicsNode) {
        if (this.nodeElementMap != null) {
            return (Element)this.nodeElementMap.get(graphicsNode);
        }
        return null;
    }

    public void bind(Element element, StyleReference styleReference) {
        GraphicsNode graphicsNode;
        LinkedList<StyleReference> linkedList;
        if (this.elementStyleAttMap == null) {
            this.elementStyleAttMap = new HashMap();
        }
        if ((linkedList = (LinkedList<StyleReference>)this.elementStyleAttMap.get(element)) == null) {
            linkedList = new LinkedList<StyleReference>();
            this.elementStyleAttMap.put(element, linkedList);
        }
        linkedList.add(styleReference);
        if (this.nodeStyleMap == null) {
            this.nodeStyleMap = new HashMap();
        }
        if ((linkedList = (LinkedList<StyleReference>)this.nodeStyleMap.get(graphicsNode = styleReference.getGraphicsNode())) == null) {
            linkedList = new LinkedList<StyleReference>();
            this.nodeStyleMap.put(graphicsNode, linkedList);
        }
        linkedList.add((StyleReference)((Object)element));
    }

    public List getStyleReferenceList(Element element) {
        if (this.elementStyleAttMap == null) {
            return Collections.EMPTY_LIST;
        }
        LinkedList linkedList = (LinkedList)this.elementStyleAttMap.get(element);
        if (linkedList != null) {
            return linkedList;
        }
        return Collections.EMPTY_LIST;
    }

    private void removeStyleReferences(GraphicsNode graphicsNode) {
        if (this.nodeStyleMap == null) {
            return;
        }
        List list = (List)this.nodeStyleMap.get(graphicsNode);
        if (list != null) {
            this.nodeStyleMap.remove(graphicsNode);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            this.removeStyleReference(graphicsNode, element);
        }
    }

    private void removeStyleReference(GraphicsNode graphicsNode, Element element) {
        Object object;
        if (this.elementStyleAttMap == null) {
            return;
        }
        LinkedList linkedList = (LinkedList)this.elementStyleAttMap.get(element);
        LinkedList<Object> linkedList2 = null;
        if (linkedList == null) {
            return;
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            object = (StyleReference)iterator.next();
            if (((StyleReference)object).getGraphicsNode() != graphicsNode) continue;
            if (linkedList2 == null) {
                linkedList2 = new LinkedList<Object>();
            }
            linkedList2.add(object);
        }
        if (linkedList2 != null) {
            object = linkedList2.iterator();
            while (object.hasNext()) {
                linkedList.remove(object.next());
            }
        }
        if (linkedList.size() == 0) {
            this.elementStyleAttMap.remove(element);
        }
    }

    public Bridge getBridge(Element element) {
        if (this.namespaceURIMap == null || element == null) {
            return null;
        }
        String string = element.getNamespaceURI();
        String string2 = element.getLocalName();
        HashMap hashMap = (HashMap)this.namespaceURIMap.get(string = string == null ? "" : string);
        if (hashMap == null) {
            return null;
        }
        return (Bridge)hashMap.get(string2);
    }

    public Bridge getBridge(String string, String string2) {
        HashMap hashMap = (HashMap)this.namespaceURIMap.get(string);
        if (hashMap == null) {
            return null;
        }
        return (Bridge)hashMap.get(string2);
    }

    public void putBridge(String string, String string2, Bridge bridge) {
        HashMap<String, Bridge> hashMap;
        if (!string.equals(bridge.getNamespaceURI()) || !string2.equals(bridge.getLocalName())) {
            throw new Error("Invalid Bridge: " + string + "/" + bridge.getNamespaceURI() + " " + string2 + "/" + bridge.getLocalName() + " " + bridge.getClass());
        }
        if (this.namespaceURIMap == null) {
            this.namespaceURIMap = new HashMap();
        }
        if ((hashMap = (HashMap<String, Bridge>)this.namespaceURIMap.get(string = string == null ? "" : string)) == null) {
            hashMap = new HashMap<String, Bridge>();
            this.namespaceURIMap.put(string, hashMap);
        }
        hashMap.put(string2, bridge);
    }

    public void putBridge(Bridge bridge) {
        this.putBridge(bridge.getNamespaceURI(), bridge.getLocalName(), bridge);
    }

    public void removeBridge(String string, String string2) {
        if (this.namespaceURIMap == null) {
            return;
        }
        HashMap hashMap = (HashMap)this.namespaceURIMap.get(string = string == null ? "" : string);
        if (hashMap != null) {
            hashMap.remove(string2);
            if (hashMap.isEmpty()) {
                this.namespaceURIMap.remove(string);
                if (this.namespaceURIMap.isEmpty()) {
                    this.namespaceURIMap = null;
                }
            }
        }
    }

    public static void registerSVGBridges(BridgeContext bridgeContext) {
        UserAgent userAgent = bridgeContext.getUserAgent();
        Iterator iterator = BridgeContext.getBridgeExtensions().iterator();
        while (iterator.hasNext()) {
            BridgeExtension bridgeExtension = (BridgeExtension)iterator.next();
            bridgeExtension.registerTags(bridgeContext);
            userAgent.registerExtension(bridgeExtension);
        }
    }

    public static synchronized List getBridgeExtensions() {
        if (extensions != null) {
            return extensions;
        }
        extensions = new LinkedList();
        extensions.add(new SVGBridgeExtension());
        Iterator iterator = Service.providers(class$org$apache$batik$bridge$BridgeExtension == null ? (class$org$apache$batik$bridge$BridgeExtension = BridgeContext.class$("org.apache.batik.bridge.BridgeExtension")) : class$org$apache$batik$bridge$BridgeExtension);
        block0: while (iterator.hasNext()) {
            BridgeExtension bridgeExtension;
            BridgeExtension bridgeExtension2 = (BridgeExtension)iterator.next();
            float f = bridgeExtension2.getPriority();
            ListIterator<BridgeExtension> listIterator = extensions.listIterator();
            do {
                if (listIterator.hasNext()) continue;
                listIterator.add(bridgeExtension2);
                continue block0;
            } while (!((bridgeExtension = (BridgeExtension)listIterator.next()).getPriority() > f));
            listIterator.previous();
            listIterator.add(bridgeExtension2);
        }
        return extensions;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

