/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.MarkerBridge;
import org.apache.batik.bridge.PaintBridge;
import org.apache.batik.bridge.SVGColorProfileElementBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.css.CSSOMReadOnlyStyleDeclaration;
import org.apache.batik.css.CSSOMReadOnlyValue;
import org.apache.batik.ext.awt.color.ICCColorSpaceExt;
import org.apache.batik.gvt.CompositeShapePainter;
import org.apache.batik.gvt.FillShapePainter;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.Marker;
import org.apache.batik.gvt.MarkerShapePainter;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.apache.batik.gvt.StrokeShapePainter;
import org.apache.batik.util.CSSConstants;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.svg.SVGColor;
import org.w3c.dom.svg.SVGICCColor;
import org.w3c.dom.svg.SVGPaint;

public abstract class PaintServer
implements SVGConstants,
CSSConstants,
ErrorConstants {
    protected PaintServer() {
    }

    public static ShapePainter convertMarkers(Element element, ShapeNode shapeNode, BridgeContext bridgeContext) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("marker-start");
        Marker marker = PaintServer.convertMarker(element, cSSOMReadOnlyValue, bridgeContext);
        cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("marker-mid");
        Marker marker2 = PaintServer.convertMarker(element, cSSOMReadOnlyValue, bridgeContext);
        cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("marker-end");
        Marker marker3 = PaintServer.convertMarker(element, cSSOMReadOnlyValue, bridgeContext);
        if (marker != null || marker2 != null || marker3 != null) {
            MarkerShapePainter markerShapePainter = new MarkerShapePainter(shapeNode.getShape());
            markerShapePainter.setStartMarker(marker);
            markerShapePainter.setMiddleMarker(marker2);
            markerShapePainter.setEndMarker(marker3);
            return markerShapePainter;
        }
        return null;
    }

    public static Marker convertMarker(Element element, CSSPrimitiveValue cSSPrimitiveValue, BridgeContext bridgeContext) {
        if (cSSPrimitiveValue.getPrimitiveType() == 21) {
            return null;
        }
        String string = cSSPrimitiveValue.getStringValue();
        Element element2 = bridgeContext.getReferencedElement(element, string);
        Bridge bridge = bridgeContext.getBridge(element2);
        if (bridge == null || !(bridge instanceof MarkerBridge)) {
            throw new BridgeException(element, "css.uri.badTarget", new Object[]{string});
        }
        return ((MarkerBridge)bridge).createMarker(bridgeContext, element2, element);
    }

    public static ShapePainter convertFillAndStroke(Element element, ShapeNode shapeNode, BridgeContext bridgeContext) {
        Paint paint = PaintServer.convertFillPaint(element, shapeNode, bridgeContext);
        Paint paint2 = PaintServer.convertStrokePaint(element, shapeNode, bridgeContext);
        Shape shape = shapeNode.getShape();
        if (paint != null && paint2 != null) {
            FillShapePainter fillShapePainter = new FillShapePainter(shape);
            fillShapePainter.setPaint(paint);
            StrokeShapePainter strokeShapePainter = new StrokeShapePainter(shape);
            strokeShapePainter.setStroke(PaintServer.convertStroke(element, bridgeContext));
            strokeShapePainter.setPaint(paint2);
            CompositeShapePainter compositeShapePainter = new CompositeShapePainter(shape);
            compositeShapePainter.addShapePainter(fillShapePainter);
            compositeShapePainter.addShapePainter(strokeShapePainter);
            return compositeShapePainter;
        }
        if (paint2 != null) {
            StrokeShapePainter strokeShapePainter = new StrokeShapePainter(shape);
            strokeShapePainter.setStroke(PaintServer.convertStroke(element, bridgeContext));
            strokeShapePainter.setPaint(paint2);
            return strokeShapePainter;
        }
        if (paint != null) {
            FillShapePainter fillShapePainter = new FillShapePainter(shape);
            fillShapePainter.setPaint(paint);
            return fillShapePainter;
        }
        return null;
    }

    public static Paint convertStrokePaint(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        float f = PaintServer.convertOpacity(cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("stroke-opacity"));
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("stroke");
        return PaintServer.convertPaint(element, graphicsNode, cSSOMReadOnlyValue, f, bridgeContext);
    }

    public static Paint convertFillPaint(Element element, GraphicsNode graphicsNode, BridgeContext bridgeContext) {
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        float f = PaintServer.convertOpacity(cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("fill-opacity"));
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("fill");
        return PaintServer.convertPaint(element, graphicsNode, cSSOMReadOnlyValue, f, bridgeContext);
    }

    protected static Paint convertPaint(Element element, GraphicsNode graphicsNode, CSSValue cSSValue, float f, BridgeContext bridgeContext) {
        if (cSSValue.getCssValueType() == 1) {
            CSSPrimitiveValue cSSPrimitiveValue = (CSSPrimitiveValue)cSSValue;
            switch (cSSPrimitiveValue.getPrimitiveType()) {
                case 21: {
                    return null;
                }
                case 25: {
                    return PaintServer.convertColor(cSSPrimitiveValue.getRGBColorValue(), f);
                }
                case 20: {
                    return PaintServer.convertURIPaint(element, graphicsNode, cSSValue, f, bridgeContext);
                }
            }
            throw new Error();
        }
        SVGPaint sVGPaint = (SVGPaint)cSSValue;
        Paint paint = null;
        switch (sVGPaint.getPaintType()) {
            case 101: {
                return null;
            }
            case 1: {
                return PaintServer.convertColor(sVGPaint.getRGBColor(), f);
            }
            case 2: {
                return PaintServer.convertRGBICCColor(element, (SVGColor)cSSValue, f, bridgeContext);
            }
            case 103: {
                return PaintServer.silentConvertURIPaint(element, graphicsNode, (SVGPaint)cSSValue, f, bridgeContext);
            }
            case 104: {
                paint = PaintServer.silentConvertURIPaint(element, graphicsNode, (SVGPaint)cSSValue, f, bridgeContext);
                if (paint == null) {
                    CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
                    CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("color");
                    paint = PaintServer.convertColor(((CSSPrimitiveValue)cSSOMReadOnlyValue).getRGBColorValue(), f);
                }
                return paint;
            }
            case 105: {
                paint = PaintServer.silentConvertURIPaint(element, graphicsNode, (SVGPaint)cSSValue, f, bridgeContext);
                if (paint == null) {
                    paint = PaintServer.convertColor(sVGPaint.getRGBColor(), f);
                }
                return paint;
            }
            case 106: {
                paint = PaintServer.silentConvertURIPaint(element, graphicsNode, (SVGPaint)cSSValue, f, bridgeContext);
                if (paint == null) {
                    paint = PaintServer.convertRGBICCColor(element, (SVGColor)cSSValue, f, bridgeContext);
                }
                return paint;
            }
        }
        throw new Error();
    }

    public static Paint silentConvertURIPaint(Element element, GraphicsNode graphicsNode, CSSValue cSSValue, float f, BridgeContext bridgeContext) {
        Paint paint = null;
        try {
            paint = PaintServer.convertURIPaint(element, graphicsNode, cSSValue, f, bridgeContext);
        }
        catch (BridgeException bridgeException) {
            // empty catch block
        }
        return paint;
    }

    public static Paint convertURIPaint(Element element, GraphicsNode graphicsNode, CSSValue cSSValue, float f, BridgeContext bridgeContext) {
        String string = ((CSSPrimitiveValue)cSSValue).getStringValue();
        Element element2 = bridgeContext.getReferencedElement(element, string);
        Bridge bridge = bridgeContext.getBridge(element2);
        if (bridge == null || !(bridge instanceof PaintBridge)) {
            throw new BridgeException(element, "css.uri.badTarget", new Object[]{string});
        }
        return ((PaintBridge)bridge).createPaint(bridgeContext, element2, element, graphicsNode, f);
    }

    public static Color convertRGBICCColor(Element element, SVGColor sVGColor, float f, BridgeContext bridgeContext) {
        SVGICCColor sVGICCColor = sVGColor.getICCColor();
        Color color = null;
        if (sVGICCColor != null) {
            color = PaintServer.convertICCColor(element, sVGICCColor, f, bridgeContext);
        }
        if (color == null) {
            color = PaintServer.convertColor(sVGColor.getRGBColor(), f);
        }
        return color;
    }

    public static Color convertICCColor(Element element, SVGICCColor sVGICCColor, float f, BridgeContext bridgeContext) {
        String string = sVGICCColor.getColorProfile();
        if (string == null) {
            return null;
        }
        SVGColorProfileElementBridge sVGColorProfileElementBridge = (SVGColorProfileElementBridge)bridgeContext.getBridge("http://www.w3.org/2000/svg", "color-profile");
        if (sVGColorProfileElementBridge == null) {
            return null;
        }
        ICCColorSpaceExt iCCColorSpaceExt = sVGColorProfileElementBridge.createICCColorSpaceExt(bridgeContext, element, string);
        if (iCCColorSpaceExt == null) {
            return null;
        }
        float[] fArray = SVGUtilities.convertSVGNumberList(sVGICCColor.getColors());
        if (fArray == null) {
            return null;
        }
        float[] fArray2 = iCCColorSpaceExt.intendedToRGB(fArray);
        return new Color(fArray2[0], fArray2[1], fArray2[2], f);
    }

    public static Color convertColor(RGBColor rGBColor, float f) {
        int n = PaintServer.resolveColorComponent(rGBColor.getRed());
        int n2 = PaintServer.resolveColorComponent(rGBColor.getGreen());
        int n3 = PaintServer.resolveColorComponent(rGBColor.getBlue());
        return new Color(n, n2, n3, Math.round(f * 255.0f));
    }

    public static Stroke convertStroke(Element element, BridgeContext bridgeContext) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration = CSSUtilities.getComputedStyle(element);
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("stroke-width");
        float f = UnitProcessor.cssOtherLengthToUserSpace(cSSOMReadOnlyValue, "stroke-width", context);
        cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("stroke-linecap");
        int n = PaintServer.convertStrokeLinecap(cSSOMReadOnlyValue);
        cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("stroke-linejoin");
        int n2 = PaintServer.convertStrokeLinejoin(cSSOMReadOnlyValue);
        cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("stroke-miterlimit");
        float f2 = PaintServer.convertStrokeMiterlimit(cSSOMReadOnlyValue);
        cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("stroke-dasharray");
        float[] fArray = PaintServer.convertStrokeDasharray(cSSOMReadOnlyValue, context);
        float f3 = 0.0f;
        if (fArray != null) {
            cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("stroke-dashoffset");
            f3 = UnitProcessor.cssOtherLengthToUserSpace(cSSOMReadOnlyValue, "stroke-dashoffset", context);
        }
        return new BasicStroke(f, n, n2, f2, fArray, f3);
    }

    public static float[] convertStrokeDasharray(CSSValue cSSValue, UnitProcessor.Context context) {
        float[] fArray = null;
        if (cSSValue.getCssValueType() == 2) {
            CSSValueList cSSValueList = (CSSValueList)cSSValue;
            int n = cSSValueList.getLength();
            fArray = new float[n];
            float f = 0.0f;
            int n2 = 0;
            while (n2 < fArray.length) {
                float f2;
                CSSValue cSSValue2 = cSSValueList.item(n2);
                fArray[n2] = f2 = UnitProcessor.cssOtherLengthToUserSpace(cSSValue2, "stroke-dasharray", context);
                f += f2;
                ++n2;
            }
            if (f == 0.0f) {
                fArray = null;
            }
        }
        return fArray;
    }

    public static float convertStrokeMiterlimit(CSSPrimitiveValue cSSPrimitiveValue) {
        float f = cSSPrimitiveValue.getFloatValue((short)1);
        return f < 1.0f ? 1.0f : f;
    }

    public static int convertStrokeLinecap(CSSPrimitiveValue cSSPrimitiveValue) {
        String string = cSSPrimitiveValue.getStringValue();
        switch (string.charAt(0)) {
            case 'b': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 's': {
                return 2;
            }
        }
        throw new Error();
    }

    public static int convertStrokeLinejoin(CSSPrimitiveValue cSSPrimitiveValue) {
        String string = cSSPrimitiveValue.getStringValue();
        switch (string.charAt(0)) {
            case 'm': {
                return 0;
            }
            case 'r': {
                return 1;
            }
            case 'b': {
                return 2;
            }
        }
        throw new Error();
    }

    public static int resolveColorComponent(CSSPrimitiveValue cSSPrimitiveValue) {
        switch (cSSPrimitiveValue.getPrimitiveType()) {
            case 2: {
                float f = cSSPrimitiveValue.getFloatValue((short)2);
                f = f > 100.0f ? 100.0f : (f < 0.0f ? 0.0f : f);
                return Math.round(255.0f * f / 100.0f);
            }
            case 1: {
                float f = cSSPrimitiveValue.getFloatValue((short)1);
                f = f > 255.0f ? 255.0f : (f < 0.0f ? 0.0f : f);
                return Math.round(f);
            }
        }
        throw new Error();
    }

    public static float convertOpacity(CSSValue cSSValue) {
        float f = ((CSSPrimitiveValue)cSSValue).getFloatValue((short)1);
        return f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
    }
}

