/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.RenderingHints;
import java.util.Map;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.PaintServer;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.w3c.dom.Element;

public abstract class SVGShapeElementBridge
extends AbstractGraphicsNodeBridge {
    protected SVGShapeElementBridge() {
    }

    public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element) {
        ShapeNode shapeNode = (ShapeNode)super.createGraphicsNode(bridgeContext, element);
        if (shapeNode == null) {
            return null;
        }
        this.buildShape(bridgeContext, element, shapeNode);
        if (shapeNode.getShape() == null) {
            return null;
        }
        Map map = CSSUtilities.convertShapeRendering(element);
        Map map2 = CSSUtilities.convertColorRendering(element);
        if (map != null || map2 != null) {
            RenderingHints renderingHints;
            if (map == null) {
                renderingHints = new RenderingHints(map2);
            } else if (map2 == null) {
                renderingHints = new RenderingHints(map);
            } else {
                renderingHints = new RenderingHints(map);
                renderingHints.putAll((Map<?, ?>)map2);
            }
            shapeNode.setRenderingHints(renderingHints);
        }
        return shapeNode;
    }

    protected GraphicsNode instantiateGraphicsNode() {
        return new ShapeNode();
    }

    public void buildGraphicsNode(BridgeContext bridgeContext, Element element, GraphicsNode graphicsNode) {
        ShapeNode shapeNode = (ShapeNode)graphicsNode;
        shapeNode.setShapePainter(this.createShapePainter(bridgeContext, element, shapeNode));
        super.buildGraphicsNode(bridgeContext, element, graphicsNode);
    }

    protected ShapePainter createShapePainter(BridgeContext bridgeContext, Element element, ShapeNode shapeNode) {
        return PaintServer.convertFillAndStroke(element, shapeNode, bridgeContext);
    }

    protected abstract void buildShape(BridgeContext var1, Element var2, ShapeNode var3);

    public boolean isComposite() {
        return false;
    }
}

