/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.css.CSSOMReadOnlyStyleDeclaration;
import org.apache.batik.css.CSSOMReadOnlyValue;
import org.apache.batik.util.CSSConstants;
import org.w3c.dom.Element;

public abstract class TextUtilities
implements CSSConstants,
ErrorConstants {
    public static float[] svgHorizontalCoordinateArrayToUserSpace(Element element, String string, String string2, BridgeContext bridgeContext) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        ArrayList<Float> arrayList = new ArrayList<Float>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ", false);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(new Float(UnitProcessor.svgHorizontalCoordinateToUserSpace(stringTokenizer.nextToken(), string, context)));
            ++n;
        }
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = ((Float)arrayList.get(n2)).floatValue();
            ++n2;
        }
        return fArray;
    }

    public static float[] svgVerticalCoordinateArrayToUserSpace(Element element, String string, String string2, BridgeContext bridgeContext) {
        UnitProcessor.Context context = UnitProcessor.createContext(bridgeContext, element);
        ArrayList<Float> arrayList = new ArrayList<Float>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ", false);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(new Float(UnitProcessor.svgVerticalCoordinateToUserSpace(stringTokenizer.nextToken(), string, context)));
            ++n;
        }
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = ((Float)arrayList.get(n2)).floatValue();
            ++n2;
        }
        return fArray;
    }

    public static float[] svgRotateArrayToFloats(Element element, String string, String string2, BridgeContext bridgeContext) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ", false);
        float[] fArray = new float[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string3 = stringTokenizer.nextToken();
                fArray[n] = (float)Math.toRadians(SVGUtilities.convertSVGNumber(string3));
                ++n;
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(element, "attribute.malformed", new Object[]{string, string2});
            }
        }
        return fArray;
    }

    public static float convertFontSize(Element element, BridgeContext bridgeContext, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration, UnitProcessor.Context context) {
        CSSOMReadOnlyValue cSSOMReadOnlyValue = cSSOMReadOnlyStyleDeclaration.getPropertyCSSValueInternal("font-size");
        short s = cSSOMReadOnlyValue.getPrimitiveType();
        switch (s) {
            case 21: {
                float f = context.getMediumFontSize();
                f = TextUtilities.parseFontSize(cSSOMReadOnlyValue.getStringValue(), f);
                return UnitProcessor.cssToUserSpace(f, (short)9, (short)1, context);
            }
        }
        return UnitProcessor.cssToUserSpace(cSSOMReadOnlyValue.getFloatValue(s), s, (short)1, context);
    }

    public static float parseFontSize(String string, float f) {
        switch (string.charAt(0)) {
            case 'm': {
                return f;
            }
            case 's': {
                return (float)((double)f / 1.2);
            }
            case 'l': {
                return (float)((double)f * 1.2);
            }
        }
        switch (string.charAt(1)) {
            case 'x': {
                switch (string.charAt(3)) {
                    case 's': {
                        return (float)((double)f / 1.2 / 1.2 / 1.2);
                    }
                }
                return (float)((double)f * 1.2 * 1.2 * 1.2);
            }
        }
        switch (string.charAt(2)) {
            case 's': {
                return (float)((double)f / 1.2 / 1.2);
            }
        }
        return (float)((double)f * 1.2 * 1.2);
    }
}

