/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.svg;

import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.CSSOMValue;
import org.apache.batik.css.svg.ImmutableSVGColorValue;
import org.apache.batik.css.svg.SVGCSSNumber;
import org.apache.batik.css.svg.SVGCSSNumberList;
import org.apache.batik.css.svg.SVGColorFactory;
import org.apache.batik.css.svg.SVGValueConstants;
import org.apache.batik.css.value.AbstractRGBColorFactory;
import org.apache.batik.css.value.ImmutableFloat;
import org.apache.batik.css.value.ImmutableRGBColor;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.SystemColorResolver;
import org.apache.batik.css.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class SimpleColorFactory
extends SVGColorFactory
implements SVGValueConstants {
    public SimpleColorFactory(Parser parser, String string, SystemColorResolver systemColorResolver) {
        super(parser, string, systemColorResolver);
    }

    public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT;
            }
            case 35: {
                String string = lexicalUnit.getStringValue().toLowerCase().intern();
                if (string == "currentcolor") {
                    return SVGValueConstants.CURRENTCOLOR_VALUE;
                }
                return super.createValue(lexicalUnit);
            }
            case 27: {
                LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
                AbstractRGBColorFactory.ColorComponentFactory colorComponentFactory = new AbstractRGBColorFactory.ColorComponentFactory(this, this.getParser());
                CSSOMValue cSSOMValue = new CSSOMValue(colorComponentFactory, this.createColorValue(lexicalUnit2));
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit().getNextLexicalUnit();
                CSSOMValue cSSOMValue2 = new CSSOMValue(colorComponentFactory, this.createColorValue(lexicalUnit2));
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit().getNextLexicalUnit();
                CSSOMValue cSSOMValue3 = new CSSOMValue(colorComponentFactory, this.createColorValue(lexicalUnit2));
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
                if (lexicalUnit == null) {
                    return new ImmutableRGBColor(cSSOMValue, cSSOMValue2, cSSOMValue3);
                }
                if (lexicalUnit.getLexicalUnitType() != 41) {
                    throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.lexical.unit", new Object[]{new Integer(lexicalUnit.getLexicalUnitType()), this.getPropertyName()});
                }
                if (!lexicalUnit.getFunctionName().toLowerCase().equals("icc-color")) {
                    throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.lexical.unit", new Object[]{new Integer(lexicalUnit.getLexicalUnitType()), this.getPropertyName()});
                }
                if ((lexicalUnit = lexicalUnit.getParameters()).getLexicalUnitType() != 35) {
                    throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.lexical.unit", new Object[]{new Integer(lexicalUnit.getLexicalUnitType()), this.getPropertyName()});
                }
                String string = lexicalUnit.getStringValue();
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
                SVGCSSNumberList sVGCSSNumberList = new SVGCSSNumberList();
                while (lexicalUnit != null) {
                    if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null) {
                        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.lexical.unit", new Object[]{new Integer(0), this.getPropertyName()});
                    }
                    sVGCSSNumberList.appendItem(new SVGCSSNumber(this.getColorValue(lexicalUnit)));
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                }
                return new ImmutableSVGColorValue(2, cSSOMValue, cSSOMValue2, cSSOMValue3, string, sVGCSSNumberList);
            }
        }
        return super.createValue(lexicalUnit);
    }

    protected ImmutableValue createColorValue(LexicalUnit lexicalUnit) {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 13: {
                return new ImmutableFloat(1, lexicalUnit.getIntegerValue());
            }
            case 14: {
                return new ImmutableFloat(1, lexicalUnit.getFloatValue());
            }
            case 23: {
                return new ImmutableFloat(2, lexicalUnit.getFloatValue());
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.lexical.unit", new Object[]{new Integer(lexicalUnit.getLexicalUnitType()), this.getPropertyName()});
    }

    protected float getColorValue(LexicalUnit lexicalUnit) {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 13: {
                return lexicalUnit.getIntegerValue();
            }
            case 14: {
                return lexicalUnit.getFloatValue();
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.lexical.unit", new Object[]{new Integer(lexicalUnit.getLexicalUnitType()), this.getPropertyName()});
    }
}

