/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.value;

import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.CSSOMValue;
import org.apache.batik.css.PropertyMap;
import org.apache.batik.css.value.AbstractRGBColorFactory;
import org.apache.batik.css.value.ImmutableFloat;
import org.apache.batik.css.value.ImmutableRGBColor;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.SystemColorResolver;
import org.apache.batik.css.value.ValueConstants;
import org.apache.batik.css.value.ValueFactory;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class ColorFactory
extends AbstractRGBColorFactory
implements ValueConstants {
    public final ValueFactory RGB_FACTORY = new AbstractRGBColorFactory.ColorComponentFactory(this.getParser());
    public String property;
    protected final PropertyMap factories = new PropertyMap();

    public ColorFactory(Parser parser, String string, SystemColorResolver systemColorResolver) {
        super(parser);
        this.factories.put("black", new SimpleRGBColorFactory(0.0f, 0.0f, 0.0f));
        this.factories.put("silver", new SimpleRGBColorFactory(192.0f, 192.0f, 192.0f));
        this.factories.put("gray", new SimpleRGBColorFactory(128.0f, 128.0f, 128.0f));
        this.factories.put("white", new SimpleRGBColorFactory(255.0f, 255.0f, 255.0f));
        this.factories.put("maroon", new SimpleRGBColorFactory(128.0f, 0.0f, 0.0f));
        this.factories.put("red", new SimpleRGBColorFactory(255.0f, 0.0f, 0.0f));
        this.factories.put("purple", new SimpleRGBColorFactory(128.0f, 0.0f, 128.0f));
        this.factories.put("fuchsia", new SimpleRGBColorFactory(255.0f, 0.0f, 255.0f));
        this.factories.put("green", new SimpleRGBColorFactory(0.0f, 128.0f, 0.0f));
        this.factories.put("lime", new SimpleRGBColorFactory(0.0f, 255.0f, 0.0f));
        this.factories.put("olive", new SimpleRGBColorFactory(128.0f, 128.0f, 0.0f));
        this.factories.put("yellow", new SimpleRGBColorFactory(255.0f, 255.0f, 0.0f));
        this.factories.put("navy", new SimpleRGBColorFactory(0.0f, 0.0f, 128.0f));
        this.factories.put("blue", new SimpleRGBColorFactory(0.0f, 0.0f, 255.0f));
        this.factories.put("teal", new SimpleRGBColorFactory(0.0f, 128.0f, 128.0f));
        this.factories.put("aqua", new SimpleRGBColorFactory(0.0f, 255.0f, 255.0f));
        this.property = string;
        this.factories.put("activeborder", new SystemRGBColorFactory(systemColorResolver.activeBorder()));
        this.factories.put("activecaption", new SystemRGBColorFactory(systemColorResolver.activeCaption()));
        this.factories.put("appworkspace", new SystemRGBColorFactory(systemColorResolver.appWorkspace()));
        this.factories.put("background", new SystemRGBColorFactory(systemColorResolver.background()));
        this.factories.put("buttonface", new SystemRGBColorFactory(systemColorResolver.buttonFace()));
        this.factories.put("buttonhighlight", new SystemRGBColorFactory(systemColorResolver.buttonHighlight()));
        this.factories.put("buttonshadow", new SystemRGBColorFactory(systemColorResolver.buttonShadow()));
        this.factories.put("buttontext", new SystemRGBColorFactory(systemColorResolver.buttonText()));
        this.factories.put("captiontext", new SystemRGBColorFactory(systemColorResolver.captionText()));
        this.factories.put("graytext", new SystemRGBColorFactory(systemColorResolver.grayText()));
        this.factories.put("highlight", new SystemRGBColorFactory(systemColorResolver.highlight()));
        this.factories.put("highlighttext", new SystemRGBColorFactory(systemColorResolver.highlightText()));
        this.factories.put("inactiveborder", new SystemRGBColorFactory(systemColorResolver.inactiveBorder()));
        this.factories.put("inactivecaption", new SystemRGBColorFactory(systemColorResolver.inactiveCaption()));
        this.factories.put("inactivecaptiontext", new SystemRGBColorFactory(systemColorResolver.inactiveCaptionText()));
        this.factories.put("infobackground", new SystemRGBColorFactory(systemColorResolver.infoBackground()));
        this.factories.put("infotext", new SystemRGBColorFactory(systemColorResolver.infoText()));
        this.factories.put("menu", new SystemRGBColorFactory(systemColorResolver.menu()));
        this.factories.put("menutext", new SystemRGBColorFactory(systemColorResolver.menuText()));
        this.factories.put("scrollbar", new SystemRGBColorFactory(systemColorResolver.scrollbar()));
        this.factories.put("threeddarkshadow", new SystemRGBColorFactory(systemColorResolver.threeDDarkShadow()));
        this.factories.put("threedface", new SystemRGBColorFactory(systemColorResolver.threeDFace()));
        this.factories.put("threedhighlight", new SystemRGBColorFactory(systemColorResolver.threeDHighlight()));
        this.factories.put("threedlightshadow", new SystemRGBColorFactory(systemColorResolver.threeDLightShadow()));
        this.factories.put("threedshadow", new SystemRGBColorFactory(systemColorResolver.threeDShadow()));
        this.factories.put("window", new SystemRGBColorFactory(systemColorResolver.window()));
        this.factories.put("windowframe", new SystemRGBColorFactory(systemColorResolver.windowFrame()));
        this.factories.put("windowtext", new SystemRGBColorFactory(systemColorResolver.windowText()));
    }

    public String getPropertyName() {
        return this.property;
    }

    public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT;
            }
            case 35: {
                String string = lexicalUnit.getStringValue().toLowerCase().intern();
                Object object = this.factories.get(string);
                if (object != null) {
                    return ((RGBColorFactory)object).create();
                }
                throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.identifier", new Object[]{lexicalUnit.getStringValue(), this.getPropertyName()});
            }
        }
        return super.createValue(lexicalUnit);
    }

    public ImmutableValue createStringValue(short s, String string) throws DOMException {
        if (s != 21) {
            throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.identifier", new Object[]{string, this.getPropertyName()});
        }
        String string2 = string.toLowerCase().intern();
        Object object = this.factories.get(string2);
        if (object != null) {
            return ((RGBColorFactory)object).create();
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.identifier", new Object[]{string, this.getPropertyName()});
    }

    protected ImmutableRGBColor createImmutableRGBColor(float f, float f2, float f3) {
        ImmutableFloat immutableFloat = new ImmutableFloat(1, f);
        ImmutableFloat immutableFloat2 = new ImmutableFloat(1, f2);
        ImmutableFloat immutableFloat3 = new ImmutableFloat(1, f3);
        return new ImmutableRGBColor(new CSSOMValue(this.RGB_FACTORY, immutableFloat), new CSSOMValue(this.RGB_FACTORY, immutableFloat2), new CSSOMValue(this.RGB_FACTORY, immutableFloat3));
    }

    protected class SystemRGBColorFactory
    implements RGBColorFactory {
        protected SystemColorResolver.Color color;

        public SystemRGBColorFactory(SystemColorResolver.Color color) {
            this.color = color;
        }

        public ImmutableValue create() {
            return ColorFactory.this.createImmutableRGBColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        }
    }

    protected class SimpleRGBColorFactory
    implements RGBColorFactory {
        protected float red;
        protected float green;
        protected float blue;

        public SimpleRGBColorFactory(float f, float f2, float f3) {
            this.red = f;
            this.green = f2;
            this.blue = f3;
        }

        public ImmutableValue create() {
            return ColorFactory.this.createImmutableRGBColor(this.red, this.green, this.blue);
        }
    }

    protected static interface RGBColorFactory {
        public ImmutableValue create();
    }
}

