/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.value;

import org.apache.batik.css.PropertyMap;
import org.apache.batik.css.value.ClipFactory;
import org.apache.batik.css.value.ColorFactory;
import org.apache.batik.css.value.CursorFactory;
import org.apache.batik.css.value.DefaultSystemColorResolver;
import org.apache.batik.css.value.DirectionFactory;
import org.apache.batik.css.value.DisplayFactory;
import org.apache.batik.css.value.FontFamilyFactory;
import org.apache.batik.css.value.FontSizeAdjustFactory;
import org.apache.batik.css.value.FontSizeFactory;
import org.apache.batik.css.value.FontStretchFactory;
import org.apache.batik.css.value.FontStyleFactory;
import org.apache.batik.css.value.FontVariantFactory;
import org.apache.batik.css.value.FontWeightFactory;
import org.apache.batik.css.value.OverflowFactory;
import org.apache.batik.css.value.SpacingFactory;
import org.apache.batik.css.value.SystemColorResolver;
import org.apache.batik.css.value.TextDecorationFactory;
import org.apache.batik.css.value.UnicodeBidiFactory;
import org.apache.batik.css.value.ValueConstants;
import org.apache.batik.css.value.ValueFactory;
import org.apache.batik.css.value.ValueFactoryMap;
import org.apache.batik.css.value.VisibilityFactory;
import org.w3c.css.sac.Parser;

public class CommonValueFactoryMap
implements ValueFactoryMap,
ValueConstants {
    protected PropertyMap table = new PropertyMap();

    public CommonValueFactoryMap(Parser parser) {
        this(parser, new DefaultSystemColorResolver());
    }

    public CommonValueFactoryMap(Parser parser, SystemColorResolver systemColorResolver) {
        this.put("clip", new ClipFactory(parser));
        this.put("color", new ColorFactory(parser, "color", systemColorResolver));
        this.put("cursor", new CursorFactory(parser));
        this.put("direction", new DirectionFactory(parser));
        this.put("display", new DisplayFactory(parser));
        this.put("font-family", new FontFamilyFactory(parser));
        this.put("font-size", new FontSizeFactory(parser));
        this.put("font-size-adjust", new FontSizeAdjustFactory(parser));
        this.put("font-stretch", new FontStretchFactory(parser));
        this.put("font-style", new FontStyleFactory(parser));
        this.put("font-variant", new FontVariantFactory(parser));
        this.put("font-weight", new FontWeightFactory(parser));
        this.put("letter-spacing", new SpacingFactory(parser, "letter-spacing"));
        this.put("overflow", new OverflowFactory(parser));
        this.put("text-decoration", new TextDecorationFactory(parser));
        this.put("unicode-bidi", new UnicodeBidiFactory(parser));
        this.put("visibility", new VisibilityFactory(parser));
        this.put("word-spacing", new SpacingFactory(parser, "word-spacing"));
    }

    public ValueFactory get(String string) {
        return (ValueFactory)this.table.get(string.toLowerCase().intern());
    }

    public void put(String string, ValueFactory valueFactory) {
        this.table.put(string.toLowerCase().intern(), valueFactory);
    }
}

