/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.value;

import org.apache.batik.css.CSSDOMExceptionFactory;
import org.apache.batik.css.value.AbstractValueFactory;
import org.apache.batik.css.value.ImmutableFloat;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class FontSizeAdjustFactory
extends AbstractValueFactory {
    public FontSizeAdjustFactory(Parser parser) {
        super(parser);
    }

    public String getPropertyName() {
        return "font-size-adjust";
    }

    public ImmutableValue createValue(LexicalUnit lexicalUnit) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 12: {
                return ValueConstants.INHERIT;
            }
            case 35: {
                if (!lexicalUnit.getStringValue().equalsIgnoreCase("none")) break;
                return ValueConstants.NONE_VALUE;
            }
            case 13: {
                return this.createFloatValue((short)1, lexicalUnit.getIntegerValue());
            }
            case 14: {
                return this.createFloatValue((short)1, lexicalUnit.getFloatValue());
            }
        }
        throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.lexical.unit", new Object[]{new Integer(lexicalUnit.getLexicalUnitType()), this.getPropertyName()});
    }

    public ImmutableValue createFloatValue(short s, float f) throws DOMException {
        if (s != 1) {
            throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.primitive.unit", new Object[]{new Integer(s), this.getPropertyName()});
        }
        return new ImmutableFloat(s, f);
    }

    public ImmutableValue createStringValue(short s, String string) throws DOMException {
        if (s != 21 || !string.equalsIgnoreCase("none")) {
            throw CSSDOMExceptionFactory.createDOMException((short)15, "invalid.identifier", new Object[]{string, this.getPropertyName()});
        }
        return ValueConstants.NONE_VALUE;
    }
}

