/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.value;

import org.apache.batik.css.CSSOMReadOnlyStyleDeclaration;
import org.apache.batik.css.CSSOMReadOnlyValue;
import org.apache.batik.css.HiddenChildElementSupport;
import org.apache.batik.css.value.ImmutableFloat;
import org.apache.batik.css.value.ImmutableValue;
import org.apache.batik.css.value.RelativeValueResolver;
import org.apache.batik.css.value.ValueConstants;
import org.w3c.dom.Element;
import org.w3c.dom.css.ViewCSS;

public class FontSizeResolver
implements RelativeValueResolver {
    public boolean isInheritedProperty() {
        return true;
    }

    public String getPropertyName() {
        return "font-size";
    }

    public CSSOMReadOnlyValue getDefaultValue() {
        return new CSSOMReadOnlyValue(ValueConstants.MEDIUM_VALUE);
    }

    public void resolveValue(Element element, String string, ViewCSS viewCSS, CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration, CSSOMReadOnlyValue cSSOMReadOnlyValue, String string2, int n) {
        ImmutableValue immutableValue = cSSOMReadOnlyValue.getImmutableValue();
        boolean bl = immutableValue == ValueConstants.SMALLER_VALUE;
        CSSOMReadOnlyValue cSSOMReadOnlyValue2 = null;
        if (bl || immutableValue == ValueConstants.LARGER_VALUE) {
            Element element2 = HiddenChildElementSupport.getParentElement(element);
            if (element2 == null) {
                cSSOMReadOnlyValue2 = new CSSOMReadOnlyValue(bl ? ValueConstants.SMALL_VALUE : ValueConstants.LARGE_VALUE);
            } else {
                CSSOMReadOnlyStyleDeclaration cSSOMReadOnlyStyleDeclaration2 = (CSSOMReadOnlyStyleDeclaration)viewCSS.getComputedStyle(element2, null);
                CSSOMReadOnlyValue cSSOMReadOnlyValue3 = (CSSOMReadOnlyValue)cSSOMReadOnlyStyleDeclaration2.getPropertyCSSValue(this.getPropertyName());
                immutableValue = cSSOMReadOnlyValue3.getImmutableValue();
                if (immutableValue == ValueConstants.LARGE_VALUE) {
                    cSSOMReadOnlyValue2 = new CSSOMReadOnlyValue(bl ? ValueConstants.MEDIUM_VALUE : ValueConstants.X_LARGE_VALUE);
                } else if (immutableValue == ValueConstants.MEDIUM_VALUE) {
                    cSSOMReadOnlyValue2 = new CSSOMReadOnlyValue(bl ? ValueConstants.SMALL_VALUE : ValueConstants.LARGE_VALUE);
                } else if (immutableValue == ValueConstants.SMALL_VALUE) {
                    cSSOMReadOnlyValue2 = new CSSOMReadOnlyValue(bl ? ValueConstants.MEDIUM_VALUE : ValueConstants.X_LARGE_VALUE);
                } else if (immutableValue == ValueConstants.X_LARGE_VALUE) {
                    cSSOMReadOnlyValue2 = new CSSOMReadOnlyValue(bl ? ValueConstants.LARGE_VALUE : ValueConstants.XX_LARGE_VALUE);
                } else if (immutableValue == ValueConstants.X_SMALL_VALUE) {
                    cSSOMReadOnlyValue2 = new CSSOMReadOnlyValue(bl ? ValueConstants.XX_SMALL_VALUE : ValueConstants.SMALL_VALUE);
                } else if (immutableValue == ValueConstants.XX_LARGE_VALUE) {
                    cSSOMReadOnlyValue2 = new CSSOMReadOnlyValue(bl ? ValueConstants.X_LARGE_VALUE : ValueConstants.XX_LARGE_VALUE);
                } else if (immutableValue == ValueConstants.XX_SMALL_VALUE) {
                    cSSOMReadOnlyValue2 = new CSSOMReadOnlyValue(bl ? ValueConstants.XX_SMALL_VALUE : ValueConstants.X_SMALL_VALUE);
                } else if (immutableValue instanceof ImmutableFloat) {
                    short s = ((ImmutableFloat)immutableValue).getPrimitiveType();
                    float f = ((ImmutableFloat)immutableValue).getFloatValue(s);
                    if (s == 2) {
                        throw new RuntimeException("!!! TODO %");
                    }
                    cSSOMReadOnlyValue2 = new CSSOMReadOnlyValue(new ImmutableFloat(s, bl ? f / 1.2f : f * 1.2f));
                }
                if (cSSOMReadOnlyValue2 != null) {
                    cSSOMReadOnlyStyleDeclaration.setPropertyCSSValue(this.getPropertyName(), cSSOMReadOnlyValue2, string2, n);
                }
            }
        }
    }
}

