/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.value;

import org.apache.batik.css.CSSOMValue;
import org.apache.batik.css.value.AbstractImmutableValue;
import org.apache.batik.css.value.ImmutableValue;
import org.w3c.dom.css.CSSValue;

public class ImmutableValueList
extends AbstractImmutableValue {
    protected CSSValue[] table = new CSSValue[5];
    protected int length;
    protected char separator = (char)44;

    public ImmutableValueList() {
    }

    public ImmutableValueList(char c) {
        this.separator = c;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ImmutableValueList)) {
            return false;
        }
        ImmutableValueList immutableValueList = (ImmutableValueList)object;
        if (this.length != immutableValueList.length) {
            return false;
        }
        int n = 0;
        while (n < this.length) {
            CSSValue cSSValue = this.table[n];
            CSSValue cSSValue2 = immutableValueList.table[n];
            if (cSSValue == null) {
                return cSSValue2 == null;
            }
            if (!cSSValue.equals(cSSValue2)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public ImmutableValue createReadOnlyCopy() {
        ImmutableValueList immutableValueList = new ImmutableValueList(this.separator);
        int n = 0;
        while (n < this.length) {
            immutableValueList.append(((CSSOMValue)this.table[n]).createReadOnlyCopy());
            ++n;
        }
        return immutableValueList;
    }

    public String getCssText() {
        String string = "";
        if (this.length > 0) {
            string = string + this.table[0].getCssText();
        }
        int n = 1;
        while (n < this.length) {
            string = string + this.separator + this.table[n].getCssText();
            ++n;
        }
        return string;
    }

    public short getCssValueType() {
        return 2;
    }

    public int getLength() {
        return this.length;
    }

    public CSSValue item(int n) {
        if (n < 0 || n > this.length) {
            return null;
        }
        return this.table[n];
    }

    public void append(CSSValue cSSValue) {
        if (this.table.length == this.length) {
            CSSValue[] cSSValueArray = this.table;
            this.table = new CSSValue[this.length * 2 + 1];
            int n = 0;
            while (n < this.length) {
                this.table[n] = cSSValueArray[n];
                ++n;
            }
        }
        this.table[this.length++] = cSSValue;
    }
}

