/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.ext.awt.image.SVGComposite;
import org.apache.batik.ext.awt.image.renderable.PaintRable;
import org.apache.batik.ext.awt.image.rendered.AffineRed;
import org.apache.batik.ext.awt.image.rendered.Any2LsRGBRed;
import org.apache.batik.ext.awt.image.rendered.Any2sRGBRed;
import org.apache.batik.ext.awt.image.rendered.BufferedImageCachableRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;
import org.apache.batik.ext.awt.image.rendered.FormatRed;
import org.apache.batik.ext.awt.image.rendered.RenderedImageCachableRed;
import org.apache.batik.ext.awt.image.rendered.TranslateRed;

public class GraphicsUtil {
    public static boolean useMacOSXHacks = "Mac OS X".equals(System.getProperty("os.name"));
    public static AffineTransform IDENTITY = new AffineTransform();
    public static final boolean WARN_DESTINATION = true;
    public static final ColorModel Linear_sRGB = new DirectColorModel(ColorSpace.getInstance(1004), 24, 0xFF0000, 65280, 255, 0, false, 3);
    public static final ColorModel Linear_sRGB_Pre = new DirectColorModel(ColorSpace.getInstance(1004), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    public static final ColorModel Linear_sRGB_Unpre = new DirectColorModel(ColorSpace.getInstance(1004), 32, 0xFF0000, 65280, 255, -16777216, false, 3);
    public static final ColorModel sRGB = new DirectColorModel(ColorSpace.getInstance(1000), 24, 0xFF0000, 65280, 255, 0, false, 3);
    public static final ColorModel sRGB_Pre = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    public static final ColorModel sRGB_Unpre = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, false, 3);

    public static void drawImage(Graphics2D graphics2D, RenderedImage renderedImage) {
        GraphicsUtil.drawImage(graphics2D, GraphicsUtil.wrap(renderedImage));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void drawImage(Graphics2D graphics2D, CachableRed cachableRed) {
        Composite composite;
        Object object;
        block35: {
            block34: {
                ColorModel colorModel;
                ColorSpace colorSpace;
                ColorModel colorModel2 = cachableRed.getColorModel();
                Object object2 = null;
                while (true) {
                    if (cachableRed instanceof AffineRed) {
                        object = (AffineRed)cachableRed;
                        if (object2 == null) {
                            object2 = ((AffineRed)object).getTransform();
                        } else {
                            ((AffineTransform)object2).concatenate(((AffineRed)object).getTransform());
                        }
                        cachableRed = ((AffineRed)object).getSource();
                        continue;
                    }
                    if (!(cachableRed instanceof TranslateRed)) break;
                    object = (TranslateRed)cachableRed;
                    int n = ((TranslateRed)object).getDeltaX();
                    int n2 = ((TranslateRed)object).getDeltaY();
                    if (object2 == null) {
                        object2 = AffineTransform.getTranslateInstance(n, n2);
                    } else {
                        ((AffineTransform)object2).translate(n, n2);
                    }
                    cachableRed = ((TranslateRed)object).getSource();
                }
                object = graphics2D.getTransform();
                if (object2 == null || ((AffineTransform)object2).isIdentity()) {
                    object2 = object;
                } else {
                    ((AffineTransform)object2).preConcatenate((AffineTransform)object);
                }
                composite = graphics2D.getComposite();
                double d = ((AffineTransform)object2).getDeterminant();
                if (!((AffineTransform)object2).isIdentity() && d <= 1.0) {
                    if (((AffineTransform)object2).getType() != 1) {
                        cachableRed = new AffineRed(cachableRed, (AffineTransform)object2, graphics2D.getRenderingHints());
                    } else {
                        int n = cachableRed.getMinX() + (int)((AffineTransform)object2).getTranslateX();
                        int n3 = cachableRed.getMinY() + (int)((AffineTransform)object2).getTranslateY();
                        cachableRed = new TranslateRed(cachableRed, n, n3);
                    }
                }
                if ((colorSpace = GraphicsUtil.getDestinationColorSpace(graphics2D)) == null) {
                    colorSpace = ColorSpace.getInstance(1000);
                }
                if (colorSpace != colorModel2.getColorSpace()) {
                    if (colorSpace == ColorSpace.getInstance(1000)) {
                        cachableRed = GraphicsUtil.convertTosRGB(cachableRed);
                    } else if (colorSpace == ColorSpace.getInstance(1004)) {
                        cachableRed = GraphicsUtil.convertToLsRGB(cachableRed);
                    }
                }
                colorModel2 = cachableRed.getColorModel();
                ColorModel colorModel3 = colorModel = GraphicsUtil.getDestinationColorModel(graphics2D);
                if (colorModel == null) {
                    colorModel3 = sRGB_Unpre;
                } else if (colorModel3.hasAlpha() && colorModel.hasAlpha() && colorModel3.isAlphaPremultiplied() != colorModel.isAlphaPremultiplied()) {
                    colorModel3 = GraphicsUtil.coerceColorModel(colorModel3, colorModel.isAlphaPremultiplied());
                }
                cachableRed = FormatRed.construct(cachableRed, colorModel3);
                if (!((AffineTransform)object2).isIdentity() && d > 1.0) {
                    cachableRed = new AffineRed(cachableRed, (AffineTransform)object2, graphics2D.getRenderingHints());
                }
                graphics2D.setTransform(IDENTITY);
                if (graphics2D.getRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING) == RenderingHintsKeyExt.VALUE_TRANSCODING_PRINTING && SVGComposite.OVER.equals(composite)) {
                    graphics2D.setComposite(SVGComposite.OVER);
                }
                Rectangle rectangle = cachableRed.getBounds();
                Shape shape = graphics2D.getClip();
                try {
                    Rectangle rectangle2;
                    if (shape == null) {
                        shape = rectangle;
                        rectangle2 = rectangle;
                    } else {
                        rectangle2 = shape.getBounds();
                        if (!rectangle2.intersects(rectangle)) {
                            Object var42_17 = null;
                            graphics2D.setTransform((AffineTransform)object);
                            graphics2D.setComposite(composite);
                            return;
                        }
                        rectangle2 = rectangle2.intersection(rectangle);
                    }
                    Rectangle rectangle3 = GraphicsUtil.getDestinationBounds(graphics2D);
                    if (rectangle3 != null) {
                        if (!rectangle2.intersects(rectangle3)) {
                            break block34;
                        }
                        rectangle2 = rectangle2.intersection(rectangle3);
                    }
                    long l = System.currentTimeMillis();
                    if (useMacOSXHacks) {
                        graphics2D.drawRenderedImage(cachableRed, IDENTITY);
                    } else {
                        colorModel2 = cachableRed.getColorModel();
                        SampleModel sampleModel = cachableRed.getSampleModel();
                        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
                        BufferedImage bufferedImage = new BufferedImage(colorModel2, writableRaster, colorModel2.isAlphaPremultiplied(), null);
                        int n = cachableRed.getMinTileX();
                        int n4 = n + cachableRed.getNumXTiles();
                        int n5 = cachableRed.getMinTileY();
                        int n6 = n5 + cachableRed.getNumYTiles();
                        int n7 = sampleModel.getWidth();
                        int n8 = sampleModel.getHeight();
                        Rectangle rectangle4 = new Rectangle(0, 0, n7, n8);
                        Rectangle rectangle5 = new Rectangle(0, 0, 0, 0);
                        DataBuffer dataBuffer = writableRaster.getDataBuffer();
                        int n9 = n5 * n8 + cachableRed.getTileGridYOffset();
                        int n10 = (rectangle2.y - n9) / n8;
                        if (n10 < 0) {
                            n10 = 0;
                        }
                        n5 += n10;
                        int n11 = n * n7 + cachableRed.getTileGridXOffset();
                        n10 = (rectangle2.x - n11) / n7;
                        if (n10 < 0) {
                            n10 = 0;
                        }
                        int n12 = rectangle2.x + rectangle2.width - 1;
                        int n13 = rectangle2.y + rectangle2.height - 1;
                        n9 = n5 * n8 + cachableRed.getTileGridYOffset();
                        int n14 = (n += n10) * n7 + cachableRed.getTileGridXOffset();
                        int n15 = n7;
                        n11 = n14;
                        int n16 = n5;
                        while (n16 < n6 && n9 <= n13) {
                            int n17 = n;
                            while (n17 < n4 && n11 >= n14 && n11 <= n12) {
                                rectangle4.x = n11;
                                rectangle4.y = n9;
                                Rectangle2D.intersect(rectangle, rectangle4, rectangle5);
                                WritableRaster writableRaster2 = writableRaster.createWritableChild(0, 0, rectangle5.width, rectangle5.height, rectangle5.x, rectangle5.y, null);
                                cachableRed.copyData(writableRaster2);
                                BufferedImage bufferedImage2 = bufferedImage.getSubimage(0, 0, rectangle5.width, rectangle5.height);
                                AffineTransform affineTransform = AffineTransform.getTranslateInstance(rectangle5.x, rectangle5.y);
                                graphics2D.drawImage(bufferedImage2, affineTransform, null);
                                ++n17;
                                n11 += n15;
                            }
                            n15 = -n15;
                            n11 += n15;
                            ++n16;
                            n9 += n8;
                        }
                    }
                    long l2 = System.currentTimeMillis();
                    break block35;
                }
                catch (Throwable throwable) {
                    Object var42_20 = null;
                    graphics2D.setTransform((AffineTransform)object);
                    graphics2D.setComposite(composite);
                    throw throwable;
                }
            }
            Object var42_18 = null;
            graphics2D.setTransform((AffineTransform)object);
            graphics2D.setComposite(composite);
            return;
        }
        Object var42_19 = null;
        graphics2D.setTransform((AffineTransform)object);
        graphics2D.setComposite(composite);
    }

    public static void drawImage(Graphics2D graphics2D, RenderableImage renderableImage, RenderContext renderContext) {
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        Shape shape2 = renderContext.getAreaOfInterest();
        if (shape2 != null) {
            graphics2D.clip(shape2);
        }
        graphics2D.transform(renderContext.getTransform());
        graphics2D.setRenderingHints(renderContext.getRenderingHints());
        GraphicsUtil.drawImage(graphics2D, renderableImage);
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
        graphics2D.setRenderingHints(renderingHints);
    }

    public static void drawImage(Graphics2D graphics2D, RenderableImage renderableImage) {
        Object object;
        if (renderableImage instanceof PaintRable && (object = (PaintRable)((Object)renderableImage)).paintRable(graphics2D)) {
            return;
        }
        object = graphics2D.getTransform();
        RenderedImage renderedImage = renderableImage.createRendering(new RenderContext((AffineTransform)object, graphics2D.getClip(), graphics2D.getRenderingHints()));
        if (renderedImage == null) {
            return;
        }
        graphics2D.setTransform(IDENTITY);
        GraphicsUtil.drawImage(graphics2D, GraphicsUtil.wrap(renderedImage));
        graphics2D.setTransform((AffineTransform)object);
    }

    public static Graphics2D createGraphics(BufferedImage bufferedImage, RenderingHints renderingHints) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (renderingHints != null) {
            graphics2D.addRenderingHints(renderingHints);
        }
        graphics2D.setRenderingHint(RenderingHintsKeyExt.KEY_BUFFERED_IMAGE, new WeakReference<BufferedImage>(bufferedImage));
        graphics2D.clip(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        return graphics2D;
    }

    public static Graphics2D createGraphics(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHintsKeyExt.KEY_BUFFERED_IMAGE, new WeakReference<BufferedImage>(bufferedImage));
        graphics2D.clip(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        return graphics2D;
    }

    public static BufferedImage getDestination(Graphics2D graphics2D) {
        Object object = graphics2D.getRenderingHint(RenderingHintsKeyExt.KEY_BUFFERED_IMAGE);
        if (object != null) {
            return (BufferedImage)((Reference)object).get();
        }
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        if (graphicsDevice.getType() == 2 && graphics2D.getRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING) != RenderingHintsKeyExt.VALUE_TRANSCODING_PRINTING) {
            System.out.println("Graphics2D from BufferedImage lacks BUFFERED_IMAGE hint");
        }
        return null;
    }

    public static ColorModel getDestinationColorModel(Graphics2D graphics2D) {
        BufferedImage bufferedImage = GraphicsUtil.getDestination(graphics2D);
        if (bufferedImage != null) {
            return bufferedImage.getColorModel();
        }
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        if (graphicsConfiguration.getDevice().getType() == 2) {
            if (graphics2D.getRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING) == RenderingHintsKeyExt.VALUE_TRANSCODING_PRINTING) {
                return sRGB_Unpre;
            }
            return null;
        }
        return graphicsConfiguration.getColorModel();
    }

    public static ColorSpace getDestinationColorSpace(Graphics2D graphics2D) {
        ColorModel colorModel = GraphicsUtil.getDestinationColorModel(graphics2D);
        if (colorModel != null) {
            return colorModel.getColorSpace();
        }
        return null;
    }

    public static Rectangle getDestinationBounds(Graphics2D graphics2D) {
        BufferedImage bufferedImage = GraphicsUtil.getDestination(graphics2D);
        if (bufferedImage != null) {
            return new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        if (graphicsConfiguration.getDevice().getType() == 2) {
            return null;
        }
        return null;
    }

    public static ColorModel makeLinear_sRGBCM(boolean bl) {
        if (bl) {
            return Linear_sRGB_Pre;
        }
        return Linear_sRGB_Unpre;
    }

    public static BufferedImage makeLinearBufferedImage(int n, int n2, boolean bl) {
        ColorModel colorModel = GraphicsUtil.makeLinear_sRGBCM(bl);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new BufferedImage(colorModel, writableRaster, bl, null);
    }

    public static CachableRed convertToLsRGB(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorSpace == ColorSpace.getInstance(1004)) {
            return cachableRed;
        }
        return new Any2LsRGBRed(cachableRed);
    }

    public static CachableRed convertTosRGB(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        ColorSpace colorSpace = colorModel.getColorSpace();
        if (colorSpace == ColorSpace.getInstance(1000)) {
            return cachableRed;
        }
        return new Any2sRGBRed(cachableRed);
    }

    public static CachableRed wrap(RenderedImage renderedImage) {
        if (renderedImage instanceof CachableRed) {
            return (CachableRed)renderedImage;
        }
        if (renderedImage instanceof BufferedImage) {
            return new BufferedImageCachableRed((BufferedImage)renderedImage);
        }
        return new RenderedImageCachableRed(renderedImage);
    }

    public static void copyData_INT_PACK(Raster raster, WritableRaster writableRaster) {
        int n;
        int n2;
        int n3;
        int n4 = writableRaster.getMinX();
        if (n4 < raster.getMinX()) {
            n4 = raster.getMinX();
        }
        if ((n3 = writableRaster.getMinY()) < raster.getMinY()) {
            n3 = raster.getMinY();
        }
        if ((n2 = writableRaster.getMinX() + writableRaster.getWidth() - 1) > raster.getMinX() + raster.getWidth() - 1) {
            n2 = raster.getMinX() + raster.getWidth() - 1;
        }
        if ((n = writableRaster.getMinY() + writableRaster.getHeight() - 1) > raster.getMinY() + raster.getHeight() - 1) {
            n = raster.getMinY() + raster.getHeight() - 1;
        }
        int n5 = n2 - n4 + 1;
        int n6 = n - n3 + 1;
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)raster.getSampleModel();
        int n7 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        int n8 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n4 - raster.getSampleModelTranslateX(), n3 - raster.getSampleModelTranslateY());
        SinglePixelPackedSampleModel singlePixelPackedSampleModel2 = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n9 = singlePixelPackedSampleModel2.getScanlineStride();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray2 = dataBufferInt2.getBankData()[0];
        int n10 = dataBufferInt2.getOffset() + singlePixelPackedSampleModel2.getOffset(n4 - writableRaster.getSampleModelTranslateX(), n3 - writableRaster.getSampleModelTranslateY());
        if (n7 == n9 && n7 == n5) {
            System.arraycopy(nArray, n8, nArray2, n10, n5 * n6);
        } else if (n5 > 128) {
            int n11 = n8;
            int n12 = n10;
            int n13 = 0;
            while (n13 < n6) {
                System.arraycopy(nArray, n11, nArray2, n12, n5);
                n11 += n7;
                n12 += n9;
                ++n13;
            }
        } else {
            int n14 = 0;
            while (n14 < n6) {
                int n15 = n8 + n14 * n7;
                int n16 = n10 + n14 * n9;
                int n17 = 0;
                while (n17 < n5) {
                    nArray2[n16++] = nArray[n15++];
                    ++n17;
                }
                ++n14;
            }
        }
    }

    public static void copyData_FALLBACK(Raster raster, WritableRaster writableRaster) {
        int n;
        int n2;
        int n3;
        int n4 = writableRaster.getMinX();
        if (n4 < raster.getMinX()) {
            n4 = raster.getMinX();
        }
        if ((n3 = writableRaster.getMinY()) < raster.getMinY()) {
            n3 = raster.getMinY();
        }
        if ((n2 = writableRaster.getMinX() + writableRaster.getWidth() - 1) > raster.getMinX() + raster.getWidth() - 1) {
            n2 = raster.getMinX() + raster.getWidth() - 1;
        }
        if ((n = writableRaster.getMinY() + writableRaster.getHeight() - 1) > raster.getMinY() + raster.getHeight() - 1) {
            n = raster.getMinY() + raster.getHeight() - 1;
        }
        int n5 = n2 - n4 + 1;
        int n6 = n - n3 + 1;
        int[] nArray = null;
        int n7 = n3;
        while (n7 <= n) {
            nArray = raster.getPixels(n4, n7, n5, 1, nArray);
            writableRaster.setPixels(n4, n7, n5, 1, nArray);
            ++n7;
        }
    }

    public static void copyData(Raster raster, WritableRaster writableRaster) {
        if (GraphicsUtil.is_INT_PACK_Data(raster.getSampleModel(), false) && GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), false)) {
            GraphicsUtil.copyData_INT_PACK(raster, writableRaster);
            return;
        }
        GraphicsUtil.copyData_FALLBACK(raster, writableRaster);
    }

    public static WritableRaster copyRaster(Raster raster) {
        return GraphicsUtil.copyRaster(raster, raster.getMinX(), raster.getMinY());
    }

    public static WritableRaster copyRaster(Raster raster, int n, int n2) {
        WritableRaster writableRaster = Raster.createWritableRaster(raster.getSampleModel(), new Point(0, 0));
        writableRaster = writableRaster.createWritableChild(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY(), raster.getWidth(), raster.getHeight(), n, n2, null);
        DataBuffer dataBuffer = raster.getDataBuffer();
        DataBuffer dataBuffer2 = writableRaster.getDataBuffer();
        if (dataBuffer.getDataType() != dataBuffer2.getDataType()) {
            throw new IllegalArgumentException("New DataBuffer doesn't match original");
        }
        int n3 = dataBuffer.getSize();
        int n4 = dataBuffer.getNumBanks();
        int[] nArray = dataBuffer.getOffsets();
        int n5 = 0;
        while (n5 < n4) {
            switch (dataBuffer.getDataType()) {
                case 0: {
                    DataBuffer dataBuffer3 = (DataBufferByte)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferByte)dataBuffer2;
                    System.arraycopy(((DataBufferByte)dataBuffer3).getData(n5), nArray[n5], ((DataBufferByte)dataBuffer4).getData(n5), nArray[n5], n3);
                }
                case 3: {
                    DataBuffer dataBuffer3 = (DataBufferInt)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferInt)dataBuffer2;
                    System.arraycopy(((DataBufferInt)dataBuffer3).getData(n5), nArray[n5], ((DataBufferInt)dataBuffer4).getData(n5), nArray[n5], n3);
                }
                case 2: {
                    DataBuffer dataBuffer3 = (DataBufferShort)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferShort)dataBuffer2;
                    System.arraycopy(((DataBufferShort)dataBuffer3).getData(n5), nArray[n5], ((DataBufferShort)dataBuffer4).getData(n5), nArray[n5], n3);
                }
                case 1: {
                    DataBuffer dataBuffer3 = (DataBufferUShort)dataBuffer;
                    DataBuffer dataBuffer4 = (DataBufferUShort)dataBuffer2;
                    System.arraycopy(((DataBufferUShort)dataBuffer3).getData(n5), nArray[n5], ((DataBufferUShort)dataBuffer4).getData(n5), nArray[n5], n3);
                }
            }
            ++n5;
        }
        return writableRaster;
    }

    public static WritableRaster makeRasterWritable(Raster raster) {
        return GraphicsUtil.makeRasterWritable(raster, raster.getMinX(), raster.getMinY());
    }

    public static WritableRaster makeRasterWritable(Raster raster, int n, int n2) {
        WritableRaster writableRaster = Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), new Point(0, 0));
        writableRaster = writableRaster.createWritableChild(raster.getMinX() - raster.getSampleModelTranslateX(), raster.getMinY() - raster.getSampleModelTranslateY(), raster.getWidth(), raster.getHeight(), n, n2, null);
        return writableRaster;
    }

    public static ColorModel coerceColorModel(ColorModel colorModel, boolean bl) {
        if (colorModel.isAlphaPremultiplied() == bl) {
            return colorModel;
        }
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(1, 1);
        return colorModel.coerceData(writableRaster, bl);
    }

    public static ColorModel coerceData(WritableRaster writableRaster, ColorModel colorModel, boolean bl) {
        if (!colorModel.hasAlpha()) {
            return colorModel;
        }
        if (colorModel.isAlphaPremultiplied() == bl) {
            return colorModel;
        }
        int[] nArray = null;
        int n = writableRaster.getNumBands();
        if (bl) {
            if (GraphicsUtil.is_BYTE_COMP_Data(writableRaster.getSampleModel())) {
                GraphicsUtil.mult_BYTE_COMP_Data(writableRaster);
            } else if (GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), true)) {
                GraphicsUtil.mult_INT_PACK_Data(writableRaster);
            } else {
                float f = 0.003921569f;
                int n2 = writableRaster.getMinX();
                int n3 = n2 + writableRaster.getWidth();
                int n4 = writableRaster.getMinY();
                int n5 = n4 + writableRaster.getHeight();
                int n6 = n4;
                while (n6 < n5) {
                    int n7 = n2;
                    while (n7 < n3) {
                        int n8 = (nArray = writableRaster.getPixel(n7, n6, nArray))[n - 1];
                        if (n8 >= 0 && n8 < 255) {
                            float f2 = (float)n8 * f;
                            int n9 = 0;
                            while (n9 < n - 1) {
                                nArray[n9] = (int)((float)nArray[n9] * f2 + 0.5f);
                                ++n9;
                            }
                            writableRaster.setPixel(n7, n6, nArray);
                        }
                        ++n7;
                    }
                    ++n6;
                }
            }
        } else if (GraphicsUtil.is_BYTE_COMP_Data(writableRaster.getSampleModel())) {
            GraphicsUtil.divide_BYTE_COMP_Data(writableRaster);
        } else if (GraphicsUtil.is_INT_PACK_Data(writableRaster.getSampleModel(), true)) {
            GraphicsUtil.divide_INT_PACK_Data(writableRaster);
        } else {
            int n10 = writableRaster.getMinX();
            int n11 = n10 + writableRaster.getWidth();
            int n12 = writableRaster.getMinY();
            int n13 = n12 + writableRaster.getHeight();
            int n14 = n12;
            while (n14 < n13) {
                int n15 = n10;
                while (n15 < n11) {
                    int n16 = (nArray = writableRaster.getPixel(n15, n14, nArray))[n - 1];
                    if (n16 > 0 && n16 < 255) {
                        float f = 255.0f / (float)n16;
                        int n17 = 0;
                        while (n17 < n - 1) {
                            nArray[n17] = (int)((float)nArray[n17] * f + 0.5f);
                            ++n17;
                        }
                        writableRaster.setPixel(n15, n14, nArray);
                    }
                    ++n15;
                }
                ++n14;
            }
        }
        return GraphicsUtil.coerceColorModel(colorModel, bl);
    }

    public static void copyData(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Rectangle rectangle = new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        GraphicsUtil.copyData(bufferedImage, rectangle, bufferedImage2, new Point(0, 0));
    }

    public static void copyData(BufferedImage bufferedImage, Rectangle rectangle, BufferedImage bufferedImage2, Point point) {
        boolean bl;
        ColorSpace colorSpace = bufferedImage.getColorModel().getColorSpace();
        ColorSpace colorSpace2 = bufferedImage2.getColorModel().getColorSpace();
        boolean bl2 = bufferedImage.getColorModel().hasAlpha();
        if (!(bl2 != (bl = bufferedImage2.getColorModel().hasAlpha()) || bl2 && bufferedImage.isAlphaPremultiplied() != bufferedImage2.isAlphaPremultiplied())) {
            GraphicsUtil.copyData(bufferedImage.getRaster(), bufferedImage2.getRaster());
            return;
        }
        int[] nArray = null;
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = bufferedImage2.getRaster();
        int n = writableRaster2.getNumBands();
        int n2 = point.x - rectangle.x;
        int n3 = point.y - rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = n5 + rectangle.width - 1;
        int n8 = n6 + rectangle.height - 1;
        if (!bl2) {
            int[] nArray2 = new int[n * n4];
            int n9 = n4 * n - 1;
            while (n9 >= 0) {
                nArray2[n9] = 255;
                n9 -= n;
            }
            int n10 = n6;
            while (n10 <= n8) {
                nArray = writableRaster.getPixels(n5, n10, n4, 1, nArray);
                int n11 = n4 * (n - 1) - 1;
                n9 = n4 * n - 2;
                switch (n) {
                    case 4: {
                        while (n11 >= 0) {
                            nArray2[n9--] = nArray[n11--];
                            nArray2[n9--] = nArray[n11--];
                            nArray2[n9--] = nArray[n11--];
                            --n9;
                        }
                        break;
                    }
                    default: {
                        while (n11 >= 0) {
                            int n12 = 0;
                            while (n12 < n - 1) {
                                nArray2[n9--] = nArray[n11--];
                                ++n12;
                            }
                            --n9;
                        }
                        break block0;
                    }
                }
                writableRaster2.setPixels(n5 + n2, n10 + n3, n4, 1, nArray2);
                ++n10;
            }
        } else if (bl && bufferedImage2.isAlphaPremultiplied()) {
            int n13 = 65793;
            int n14 = 0x800000;
            int n15 = n6;
            while (n15 <= n8) {
                nArray = writableRaster.getPixels(n5, n15, n4, 1, nArray);
                int n16 = n * n4 - 1;
                switch (n) {
                    case 4: {
                        int n17;
                        int n18;
                        while (n16 >= 0) {
                            n18 = nArray[n16];
                            if (n18 == 255) {
                                n16 -= 4;
                                continue;
                            }
                            n17 = n13 * n18;
                            nArray[--n16] = nArray[n16] * n17 + n14 >>> 24;
                            nArray[--n16] = nArray[n16] * n17 + n14 >>> 24;
                            nArray[--n16] = nArray[n16] * n17 + n14 >>> 24;
                            --n16;
                        }
                        break;
                    }
                    default: {
                        int n17;
                        int n18;
                        while (n16 >= 0) {
                            n18 = nArray[n16];
                            if (n18 == 255) {
                                n16 -= n;
                                continue;
                            }
                            --n16;
                            n17 = n13 * n18;
                            int n19 = 0;
                            while (n19 < n - 1) {
                                nArray[n16] = nArray[n16] * n17 + n14 >>> 24;
                                --n16;
                                ++n19;
                            }
                        }
                        break block3;
                    }
                }
                writableRaster2.setPixels(n5 + n2, n15 + n3, n4, 1, nArray);
                ++n15;
            }
        } else if (bl && !bufferedImage2.isAlphaPremultiplied()) {
            int n20 = 0xFF0000;
            int n21 = 32768;
            int n22 = n6;
            while (n22 <= n8) {
                nArray = writableRaster.getPixels(n5, n22, n4, 1, nArray);
                int n23 = n * n4 - 1;
                switch (n) {
                    case 4: {
                        int n24;
                        int n25;
                        while (n23 >= 0) {
                            n25 = nArray[n23];
                            if (n25 <= 0 || n25 >= 255) {
                                n23 -= 4;
                                continue;
                            }
                            n24 = n20 / n25;
                            nArray[--n23] = nArray[n23] * n24 + n21 >>> 16;
                            nArray[--n23] = nArray[n23] * n24 + n21 >>> 16;
                            nArray[--n23] = nArray[n23] * n24 + n21 >>> 16;
                            --n23;
                        }
                        break;
                    }
                    default: {
                        int n24;
                        int n25;
                        while (n23 >= 0) {
                            n25 = nArray[n23];
                            if (n25 <= 0 || n25 >= 255) {
                                n23 -= n;
                                continue;
                            }
                            --n23;
                            n24 = n20 / n25;
                            int n26 = 0;
                            while (n26 < n - 1) {
                                nArray[n23] = nArray[n23] * n24 + n21 >>> 16;
                                --n23;
                                ++n26;
                            }
                        }
                        break block6;
                    }
                }
                writableRaster2.setPixels(n5 + n2, n22 + n3, n4, 1, nArray);
                ++n22;
            }
        } else if (bufferedImage.isAlphaPremultiplied()) {
            int[] nArray3 = new int[n * n4];
            int n27 = 0xFF0000;
            int n28 = 32768;
            int n29 = n6;
            while (n29 <= n8) {
                nArray = writableRaster.getPixels(n5, n29, n4, 1, nArray);
                int n30 = (n + 1) * n4 - 1;
                int n31 = n * n4 - 1;
                while (n30 >= 0) {
                    int n32;
                    int n33 = nArray[n30];
                    --n30;
                    if (n33 > 0) {
                        if (n33 < 255) {
                            int n34 = n27 / n33;
                            n32 = 0;
                            while (n32 < n) {
                                nArray3[n31--] = nArray[n30--] * n34 + n28 >>> 16;
                                ++n32;
                            }
                            continue;
                        }
                        n32 = 0;
                        while (n32 < n) {
                            nArray3[n31--] = nArray[n30--];
                            ++n32;
                        }
                        continue;
                    }
                    n30 -= n;
                    n32 = 0;
                    while (n32 < n) {
                        nArray3[n31--] = 255;
                        ++n32;
                    }
                }
                writableRaster2.setPixels(n5 + n2, n29 + n3, n4, 1, nArray3);
                ++n29;
            }
        } else {
            Rectangle rectangle2 = new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
            int n35 = 0;
            while (n35 < n) {
                GraphicsUtil.copyBand(writableRaster, rectangle, n35, writableRaster2, rectangle2, n35);
                ++n35;
            }
        }
    }

    public static void copyBand(Raster raster, int n, WritableRaster writableRaster, int n2) {
        Rectangle rectangle = raster.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        GraphicsUtil.copyBand(raster, rectangle3, n, writableRaster, rectangle3, n2);
    }

    public static void copyBand(Raster raster, Rectangle rectangle, int n, WritableRaster writableRaster, Rectangle rectangle2, int n2) {
        int n3 = rectangle2.y - rectangle.y;
        int n4 = rectangle2.x - rectangle.x;
        rectangle = rectangle.intersection(raster.getBounds());
        rectangle2 = rectangle2.intersection(writableRaster.getBounds());
        int n5 = rectangle2.width < rectangle.width ? rectangle2.width : rectangle.width;
        int n6 = rectangle2.height < rectangle.height ? rectangle2.height : rectangle.height;
        int n7 = rectangle.x + n4;
        int[] nArray = null;
        int n8 = rectangle.y;
        while (n8 < rectangle.y + n6) {
            nArray = raster.getSamples(rectangle.x, n8, n5, 1, n, nArray);
            writableRaster.setSamples(n7, n8 + n3, n5, 1, n2, nArray);
            ++n8;
        }
    }

    public static boolean is_INT_PACK_Data(SampleModel sampleModel, boolean bl) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        if (nArray.length == 3 ? bl : nArray.length != 4) {
            return false;
        }
        if (nArray[0] != 0xFF0000) {
            return false;
        }
        if (nArray[1] != 65280) {
            return false;
        }
        if (nArray[2] != 255) {
            return false;
        }
        return nArray.length != 4 || nArray[3] == -16777216;
    }

    public static boolean is_BYTE_COMP_Data(SampleModel sampleModel) {
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return false;
        }
        return sampleModel.getDataType() == 0;
    }

    protected static void divide_INT_PACK_Data(WritableRaster writableRaster) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n = writableRaster.getWidth();
        int n2 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n3 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        boolean bl = false;
        int[] nArray = dataBufferInt.getBankData()[0];
        int n4 = 0;
        while (n4 < writableRaster.getHeight()) {
            int n5 = n3 + n4 * n2;
            int n6 = n5 + n;
            while (n5 < n6) {
                int n7 = nArray[n5];
                int n8 = n7 >>> 24;
                if (n8 <= 0) {
                    nArray[n5] = 0xFFFFFF;
                } else if (n8 < 255) {
                    int n9 = 0xFF0000 / n8;
                    nArray[n5] = n8 << 24 | ((n7 & 0xFF0000) >> 16) * n9 & 0xFF0000 | (((n7 & 0xFF00) >> 8) * n9 & 0xFF0000) >> 8 | ((n7 & 0xFF) * n9 & 0xFF0000) >> 16;
                }
                ++n5;
            }
            ++n4;
        }
    }

    protected static void mult_INT_PACK_Data(WritableRaster writableRaster) {
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n = writableRaster.getWidth();
        int n2 = singlePixelPackedSampleModel.getScanlineStride();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int n3 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        boolean bl = false;
        int[] nArray = dataBufferInt.getBankData()[0];
        int n4 = 0;
        while (n4 < writableRaster.getHeight()) {
            int n5 = n3 + n4 * n2;
            int n6 = n5 + n;
            while (n5 < n6) {
                int n7 = nArray[n5];
                int n8 = n7 >>> 24;
                if (n8 >= 0 && n8 < 255) {
                    nArray[n5] = n8 << 24 | (n7 & 0xFF0000) * n8 >> 8 & 0xFF0000 | (n7 & 0xFF00) * n8 >> 8 & 0xFF00 | (n7 & 0xFF) * n8 >> 8 & 0xFF;
                }
                ++n5;
            }
            ++n4;
        }
    }

    protected static void divide_BYTE_COMP_Data(WritableRaster writableRaster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
        int n = writableRaster.getWidth();
        int n2 = componentSampleModel.getScanlineStride();
        int n3 = componentSampleModel.getPixelStride();
        int[] nArray = componentSampleModel.getBandOffsets();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n4 = dataBufferByte.getOffset() + componentSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int n5 = 0;
        int n6 = nArray[nArray.length - 1];
        int n7 = nArray.length - 1;
        byte[] byArray = dataBufferByte.getBankData()[0];
        int n8 = 0;
        while (n8 < writableRaster.getHeight()) {
            int n9 = n4 + n8 * n2;
            int n10 = n9 + n * n3;
            while (n9 < n10) {
                int n11;
                n5 = byArray[n9 + n6] & 0xFF;
                if (n5 == 0) {
                    n11 = 0;
                    while (n11 < n7) {
                        byArray[n9 + nArray[n11]] = -1;
                        ++n11;
                    }
                } else if (n5 < 255) {
                    int n12 = 0xFF0000 / n5;
                    n11 = 0;
                    while (n11 < n7) {
                        int n13 = n9 + nArray[n11];
                        byArray[n13] = (byte)((byArray[n13] & 0xFF) * n12 >>> 16);
                        ++n11;
                    }
                }
                n9 += n3;
            }
            ++n8;
        }
    }

    protected static void mult_BYTE_COMP_Data(WritableRaster writableRaster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
        int n = writableRaster.getWidth();
        int n2 = componentSampleModel.getScanlineStride();
        int n3 = componentSampleModel.getPixelStride();
        int[] nArray = componentSampleModel.getBandOffsets();
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        int n4 = dataBufferByte.getOffset() + componentSampleModel.getOffset(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY());
        int n5 = 0;
        int n6 = nArray[nArray.length - 1];
        int n7 = nArray.length - 1;
        byte[] byArray = dataBufferByte.getBankData()[0];
        int n8 = 0;
        while (n8 < writableRaster.getHeight()) {
            int n9 = n4 + n8 * n2;
            int n10 = n9 + n * n3;
            while (n9 < n10) {
                n5 = byArray[n9 + n6] & 0xFF;
                if (n5 != 255) {
                    int n11 = 0;
                    while (n11 < n7) {
                        int n12 = n9 + nArray[n11];
                        byArray[n12] = (byte)((byArray[n12] & 0xFF) * n5 >> 8);
                        ++n11;
                    }
                }
                n9 += n3;
            }
            ++n8;
        }
    }
}

