/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.swing.Messages;
import org.apache.batik.swing.gvt.AbstractImageZoomInteractor;
import org.apache.batik.swing.gvt.AbstractPanInteractor;
import org.apache.batik.swing.gvt.AbstractResetTransformInteractor;
import org.apache.batik.swing.gvt.AbstractRotateInteractor;
import org.apache.batik.swing.gvt.AbstractZoomInteractor;
import org.apache.batik.swing.gvt.Interactor;
import org.apache.batik.swing.gvt.JGVTComponent;
import org.apache.batik.swing.svg.JSVGComponent;
import org.apache.batik.swing.svg.SVGDocumentLoaderEvent;
import org.apache.batik.swing.svg.SVGUserAgent;
import org.apache.batik.util.XMLConstants;
import org.apache.batik.util.gui.JErrorPane;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class JSVGCanvas
extends JSVGComponent {
    public static final String SCROLL_RIGHT_ACTION = "ScrollRight";
    public static final String SCROLL_LEFT_ACTION = "ScrollLeft";
    public static final String SCROLL_UP_ACTION = "ScrollUp";
    public static final String SCROLL_DOWN_ACTION = "ScrollDown";
    public static final String FAST_SCROLL_RIGHT_ACTION = "FastScrollRight";
    public static final String FAST_SCROLL_LEFT_ACTION = "FastScrollLeft";
    public static final String FAST_SCROLL_UP_ACTION = "FastScrollUp";
    public static final String FAST_SCROLL_DOWN_ACTION = "FastScrollDown";
    public static final String ZOOM_IN_ACTION = "ZoomIn";
    public static final String ZOOM_OUT_ACTION = "ZoomOut";
    public static final String RESET_TRANSFORM_ACTION = "ResetTransform";
    private boolean isZoomInteractorEnabled = true;
    private boolean isImageZoomInteractorEnabled = true;
    private boolean isPanInteractorEnabled = true;
    private boolean isRotateInteractorEnabled = true;
    private boolean isResetTransformInteractorEnabled = true;
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected String uri;
    protected LocationListener locationListener = null;
    protected Interactor zoomInteractor = new AbstractZoomInteractor(){

        public boolean startInteraction(InputEvent inputEvent) {
            int n = inputEvent.getModifiers();
            return inputEvent.getID() == 501 && (n & 0x10) != 0 && (n & 2) != 0;
        }
    };
    protected Interactor imageZoomInteractor = new AbstractImageZoomInteractor(){

        public boolean startInteraction(InputEvent inputEvent) {
            int n = inputEvent.getModifiers();
            return inputEvent.getID() == 501 && (n & 4) != 0 && (n & 1) != 0;
        }
    };
    protected Interactor panInteractor = new AbstractPanInteractor(){

        public boolean startInteraction(InputEvent inputEvent) {
            int n = inputEvent.getModifiers();
            return inputEvent.getID() == 501 && (n & 0x10) != 0 && (n & 1) != 0;
        }
    };
    protected Interactor rotateInteractor = new AbstractRotateInteractor(){

        public boolean startInteraction(InputEvent inputEvent) {
            int n = inputEvent.getModifiers();
            return inputEvent.getID() == 501 && (n & 4) != 0 && (n & 2) != 0;
        }
    };
    protected Interactor resetTransformInteractor = new AbstractResetTransformInteractor(){

        public boolean startInteraction(InputEvent inputEvent) {
            int n = inputEvent.getModifiers();
            return inputEvent.getID() == 500 && (n & 4) != 0 && (n & 1) != 0 && (n & 2) != 0;
        }
    };

    public JSVGCanvas() {
        this(null, true, true);
    }

    public JSVGCanvas(SVGUserAgent sVGUserAgent, boolean bl, boolean bl2) {
        super(sVGUserAgent, bl, bl2);
        this.setPreferredSize(new Dimension(200, 200));
        this.setMinimumSize(new Dimension(100, 100));
        List list = this.getInteractors();
        list.add(this.zoomInteractor);
        list.add(this.imageZoomInteractor);
        list.add(this.panInteractor);
        list.add(this.rotateInteractor);
        list.add(this.resetTransformInteractor);
        this.installActions();
        if (bl) {
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    JSVGCanvas.this.requestFocus();
                }
            });
            this.installKeyboardActions();
        }
    }

    protected void installActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put(SCROLL_RIGHT_ACTION, new ScrollRightAction(10));
        actionMap.put(SCROLL_LEFT_ACTION, new ScrollLeftAction(10));
        actionMap.put(SCROLL_UP_ACTION, new ScrollUpAction(10));
        actionMap.put(SCROLL_DOWN_ACTION, new ScrollDownAction(10));
        actionMap.put(FAST_SCROLL_RIGHT_ACTION, new ScrollRightAction(30));
        actionMap.put(FAST_SCROLL_LEFT_ACTION, new ScrollLeftAction(30));
        actionMap.put(FAST_SCROLL_UP_ACTION, new ScrollUpAction(30));
        actionMap.put(FAST_SCROLL_DOWN_ACTION, new ScrollDownAction(30));
        actionMap.put(ZOOM_IN_ACTION, new ZoomInAction());
        actionMap.put(ZOOM_OUT_ACTION, new ZoomOutAction());
        actionMap.put(RESET_TRANSFORM_ACTION, new ResetTransformAction());
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(39, 0);
        inputMap.put(keyStroke, SCROLL_RIGHT_ACTION);
        keyStroke = KeyStroke.getKeyStroke(37, 0);
        inputMap.put(keyStroke, SCROLL_LEFT_ACTION);
        keyStroke = KeyStroke.getKeyStroke(38, 0);
        inputMap.put(keyStroke, SCROLL_UP_ACTION);
        keyStroke = KeyStroke.getKeyStroke(40, 0);
        inputMap.put(keyStroke, SCROLL_DOWN_ACTION);
        keyStroke = KeyStroke.getKeyStroke(39, 1);
        inputMap.put(keyStroke, FAST_SCROLL_RIGHT_ACTION);
        keyStroke = KeyStroke.getKeyStroke(37, 1);
        inputMap.put(keyStroke, FAST_SCROLL_LEFT_ACTION);
        keyStroke = KeyStroke.getKeyStroke(38, 1);
        inputMap.put(keyStroke, FAST_SCROLL_UP_ACTION);
        keyStroke = KeyStroke.getKeyStroke(40, 1);
        inputMap.put(keyStroke, FAST_SCROLL_DOWN_ACTION);
        keyStroke = KeyStroke.getKeyStroke(73, 2);
        inputMap.put(keyStroke, ZOOM_IN_ACTION);
        keyStroke = KeyStroke.getKeyStroke(79, 2);
        inputMap.put(keyStroke, ZOOM_OUT_ACTION);
        keyStroke = KeyStroke.getKeyStroke(84, 2);
        inputMap.put(keyStroke, RESET_TRANSFORM_ACTION);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public void setEnableZoomInteractor(boolean bl) {
        if (this.isZoomInteractorEnabled != bl) {
            boolean bl2 = this.isZoomInteractorEnabled;
            this.isZoomInteractorEnabled = bl;
            if (this.isZoomInteractorEnabled) {
                this.getInteractors().add(this.zoomInteractor);
            } else {
                this.getInteractors().remove(this.zoomInteractor);
            }
            this.pcs.firePropertyChange("enableZoomInteractor", bl2, bl);
        }
    }

    public boolean getEnableZoomInteractor() {
        return this.isZoomInteractorEnabled;
    }

    public void setEnableImageZoomInteractor(boolean bl) {
        if (this.isImageZoomInteractorEnabled != bl) {
            boolean bl2 = this.isImageZoomInteractorEnabled;
            this.isImageZoomInteractorEnabled = bl;
            if (this.isImageZoomInteractorEnabled) {
                this.getInteractors().add(this.imageZoomInteractor);
            } else {
                this.getInteractors().remove(this.imageZoomInteractor);
            }
            this.pcs.firePropertyChange("enableImageZoomInteractor", bl2, bl);
        }
    }

    public boolean getEnableImageZoomInteractor() {
        return this.isImageZoomInteractorEnabled;
    }

    public void setEnablePanInteractor(boolean bl) {
        if (this.isPanInteractorEnabled != bl) {
            boolean bl2 = this.isPanInteractorEnabled;
            this.isPanInteractorEnabled = bl;
            if (this.isPanInteractorEnabled) {
                this.getInteractors().add(this.panInteractor);
            } else {
                this.getInteractors().remove(this.panInteractor);
            }
            this.pcs.firePropertyChange("enablePanInteractor", bl2, bl);
        }
    }

    public boolean getEnablePanInteractor() {
        return this.isPanInteractorEnabled;
    }

    public void setEnableRotateInteractor(boolean bl) {
        if (this.isRotateInteractorEnabled != bl) {
            boolean bl2 = this.isRotateInteractorEnabled;
            this.isRotateInteractorEnabled = bl;
            if (this.isRotateInteractorEnabled) {
                this.getInteractors().add(this.rotateInteractor);
            } else {
                this.getInteractors().remove(this.rotateInteractor);
            }
            this.pcs.firePropertyChange("enableRotateInteractor", bl2, bl);
        }
    }

    public boolean getEnableRotateInteractor() {
        return this.isRotateInteractorEnabled;
    }

    public void setEnableResetTransformInteractor(boolean bl) {
        if (this.isResetTransformInteractorEnabled != bl) {
            boolean bl2 = this.isResetTransformInteractorEnabled;
            this.isResetTransformInteractorEnabled = bl;
            if (this.isResetTransformInteractorEnabled) {
                this.getInteractors().add(this.resetTransformInteractor);
            } else {
                this.getInteractors().remove(this.resetTransformInteractor);
            }
            this.pcs.firePropertyChange("enableResetTransformInteractor", bl2, bl);
        }
    }

    public boolean getEnableResetTransformInteractor() {
        return this.isResetTransformInteractorEnabled;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String string) {
        String string2 = this.uri;
        this.uri = string;
        this.loadSVGDocument(this.uri);
        this.pcs.firePropertyChange("URI", string2, this.uri);
    }

    protected UserAgent createUserAgent() {
        return new CanvasUserAgent();
    }

    protected JGVTComponent.Listener createListener() {
        return new CanvasSVGListener();
    }

    protected class ToolTipModifier
    implements EventListener {
        protected String toolTip;

        public ToolTipModifier(String string) {
            this.toolTip = string;
        }

        public void handleEvent(Event event) {
            JSVGCanvas.this.setToolTipText(this.toolTip);
            if (this.toolTip != null) {
                MouseEvent mouseEvent = new MouseEvent(JSVGCanvas.this, 504, System.currentTimeMillis(), 0, JSVGCanvas.this.locationListener.getLastX(), JSVGCanvas.this.locationListener.getLastY(), 0, false);
                ToolTipManager.sharedInstance().mouseEntered(mouseEvent);
            }
        }
    }

    protected class LocationListener
    extends MouseMotionAdapter {
        protected int lastX;
        protected int lastY;

        protected LocationListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.lastX = mouseEvent.getX();
            this.lastY = mouseEvent.getY();
        }

        public int getLastX() {
            return this.lastX;
        }

        public int getLastY() {
            return this.lastY;
        }
    }

    protected class CanvasUserAgent
    extends JSVGComponent.BridgeUserAgent
    implements XMLConstants {
        final String TOOLTIP_TITLE_ONLY = "JSVGCanvas.CanvasUserAgent.ToolTip.titleOnly";
        final String TOOLTIP_DESC_ONLY = "JSVGCanvas.CanvasUserAgent.ToolTip.descOnly";
        final String TOOLTIP_TITLE_AND_TEXT = "JSVGCanvas.CanvasUserAgent.ToolTip.titleAndDesc";

        protected CanvasUserAgent() {
            super(JSVGCanvas.this);
        }

        public void handleElement(Element element, Object object) {
            super.handleElement(element, object);
            if (element.getNamespaceURI().equals("http://www.w3.org/2000/svg")) {
                if (element.getLocalName().equals("title")) {
                    if (this.hasPeerWithTag(element, "http://www.w3.org/2000/svg", "desc")) {
                        return;
                    }
                    element.normalize();
                    if (element.getFirstChild() == null) {
                        return;
                    }
                    String string = element.getFirstChild().getNodeValue();
                    if (string == null || string.length() == 0) {
                        return;
                    }
                    string = Messages.formatMessage("JSVGCanvas.CanvasUserAgent.ToolTip.titleOnly", new Object[]{this.toFormattedHTML(string)});
                    this.setToolTip((Element)element.getParentNode(), string);
                } else if (element.getLocalName().equals("desc")) {
                    element.normalize();
                    if (element.getFirstChild() == null) {
                        return;
                    }
                    String string = element.getFirstChild().getNodeValue();
                    if (string == null || string.length() == 0) {
                        return;
                    }
                    Element element2 = this.getPeerWithTag(element, "http://www.w3.org/2000/svg", "title");
                    if (element2 != null) {
                        element2.normalize();
                        string = Messages.formatMessage("JSVGCanvas.CanvasUserAgent.ToolTip.titleAndDesc", new Object[]{this.toFormattedHTML(element2.getFirstChild().getNodeValue()), this.toFormattedHTML(string)});
                    } else {
                        string = Messages.formatMessage("JSVGCanvas.CanvasUserAgent.ToolTip.descOnly", new Object[]{this.toFormattedHTML(string)});
                    }
                    this.setToolTip((Element)element.getParentNode(), string);
                }
            }
        }

        public String toFormattedHTML(String string) {
            StringBuffer stringBuffer = new StringBuffer(string);
            this.replace(stringBuffer, '&', "&amp;");
            this.replace(stringBuffer, '<', "&lt;");
            this.replace(stringBuffer, '>', "&gt;");
            this.replace(stringBuffer, '\"', "&quot;");
            this.replace(stringBuffer, '\'', "&apos;");
            this.replace(stringBuffer, '\n', "<br>");
            return stringBuffer.toString();
        }

        /*
         * Unable to fully structure code
         */
        protected void replace(StringBuffer var1_1, char var2_2, String var3_3) {
            var4_4 = var1_1.toString() + 1;
            var5_5 = var4_4.length();
            if (true) ** GOTO lbl9
            do {
                var1_1.deleteCharAt(var5_5);
                var1_1.insert(var5_5, var3_3);
lbl9:
                // 2 sources

                --var5_5;
            } while ((var5_5 = var4_4.lastIndexOf(var2_2, var5_5)) != -1);
        }

        public Element getPeerWithTag(Element element, String string, String string2) {
            Element element2 = (Element)element.getParentNode();
            if (element2 == null) {
                return null;
            }
            Node node = element2.getFirstChild();
            while (node != null) {
                if (string.equals(node.getNamespaceURI()) && string2.equals(node.getLocalName()) && node.getNodeType() == 1) {
                    return (Element)node;
                }
                node = node.getNextSibling();
            }
            return null;
        }

        public boolean hasPeerWithTag(Element element, String string, String string2) {
            return this.getPeerWithTag(element, string, string2) != null;
        }

        public void setToolTip(Element element, String string) {
            EventTarget eventTarget = (EventTarget)((Object)element);
            element.normalize();
            eventTarget.addEventListener("mouseover", new ToolTipModifier(string), false);
            eventTarget.addEventListener("mouseout", new ToolTipModifier(null), false);
            if (JSVGCanvas.this.locationListener == null) {
                JSVGCanvas.this.locationListener = new LocationListener();
                JSVGCanvas.this.addMouseMotionListener(JSVGCanvas.this.locationListener);
            }
        }

        public void displayError(String string) {
            if (JSVGCanvas.this.svgUserAgent != null) {
                super.displayError(string);
            } else {
                JOptionPane jOptionPane = new JOptionPane(string, 0);
                JDialog jDialog = jOptionPane.createDialog(JSVGCanvas.this, "ERROR");
                jDialog.setModal(false);
                jDialog.show();
            }
        }

        public void displayError(Exception exception) {
            if (JSVGCanvas.this.svgUserAgent != null) {
                super.displayError(exception);
            } else {
                JErrorPane jErrorPane = new JErrorPane((Throwable)exception, 0);
                JDialog jDialog = jErrorPane.createDialog((Component)JSVGCanvas.this, "ERROR");
                jDialog.setModal(false);
                jDialog.show();
            }
        }
    }

    protected class ScrollDownAction
    extends AbstractAction {
        protected int inc;

        public ScrollDownAction(int n) {
            this.inc = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AffineTransform affineTransform = new AffineTransform(JSVGCanvas.this.getRenderingTransform());
            affineTransform.translate(0.0, -this.inc);
            JSVGCanvas.this.setRenderingTransform(affineTransform);
        }
    }

    protected class ScrollUpAction
    extends AbstractAction {
        protected int inc;

        public ScrollUpAction(int n) {
            this.inc = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AffineTransform affineTransform = new AffineTransform(JSVGCanvas.this.getRenderingTransform());
            affineTransform.translate(0.0, this.inc);
            JSVGCanvas.this.setRenderingTransform(affineTransform);
        }
    }

    protected class ScrollLeftAction
    extends AbstractAction {
        protected int inc;

        public ScrollLeftAction(int n) {
            this.inc = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AffineTransform affineTransform = new AffineTransform(JSVGCanvas.this.getRenderingTransform());
            affineTransform.translate(this.inc, 0.0);
            JSVGCanvas.this.setRenderingTransform(affineTransform);
        }
    }

    protected class ScrollRightAction
    extends AbstractAction {
        protected int inc;

        public ScrollRightAction(int n) {
            this.inc = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AffineTransform affineTransform = new AffineTransform(JSVGCanvas.this.getRenderingTransform());
            affineTransform.translate(-this.inc, 0.0);
            JSVGCanvas.this.setRenderingTransform(affineTransform);
        }
    }

    protected class ZoomOutAction
    extends AbstractAction {
        protected ZoomOutAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AffineTransform affineTransform = JSVGCanvas.this.getRenderingTransform();
            if (affineTransform != null) {
                Dimension dimension = JSVGCanvas.this.getSize();
                int n = dimension.width / 2;
                int n2 = dimension.height / 2;
                AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(n, n2);
                affineTransform2.scale(0.5, 0.5);
                affineTransform2.translate(-n, -n2);
                affineTransform2.concatenate(affineTransform);
                JSVGCanvas.this.setRenderingTransform(affineTransform2);
            }
        }
    }

    protected class ZoomInAction
    extends AbstractAction {
        protected ZoomInAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AffineTransform affineTransform = JSVGCanvas.this.getRenderingTransform();
            if (affineTransform != null) {
                Dimension dimension = JSVGCanvas.this.getSize();
                int n = dimension.width / 2;
                int n2 = dimension.height / 2;
                AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(n, n2);
                affineTransform2.scale(2.0, 2.0);
                affineTransform2.translate(-n, -n2);
                affineTransform2.concatenate(affineTransform);
                JSVGCanvas.this.setRenderingTransform(affineTransform2);
            }
        }
    }

    protected class ResetTransformAction
    extends AbstractAction {
        protected ResetTransformAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSVGCanvas.this.setFragmentIdentifier(null);
            JSVGCanvas.this.resetRenderingTransform();
        }
    }

    protected class CanvasSVGListener
    extends JSVGComponent.SVGListener {
        protected CanvasSVGListener() {
            super(JSVGCanvas.this);
        }

        public void documentLoadingStarted(SVGDocumentLoaderEvent sVGDocumentLoaderEvent) {
            JSVGCanvas.this.setToolTipText(null);
        }
    }
}

